#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# SteamWorld Quest
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251124.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='steamworld-quest'
GAME_NAME='SteamWorld Quest: Hand of Gilgamech'

ARCHIVE_BASE_0_NAME='steamworld_quest_hand_of_gilgamech_2_1_31741.sh'
ARCHIVE_BASE_0_MD5='cffa9b745ef4ca37123b5928c37effe0'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='2.1-gog31741'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/steamworld_quest_hand_of_gilgamech'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
Quest'
## TODO: Check that all these paths are provided for the current game.
CONTENT_GAME_DATA_FILES='
icon.bmp
icon.png
Bundle
BundlePC'
CONTENT_DOC_DATA_FILES='
Licenses
readme.txt'

APP_MAIN_EXE='Quest'
APP_MAIN_ICON='icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Force the use of system-provided SDL.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(launcher_tweak_sdl_override)"
PKG_BIN_DEPENDENCIES_LIBRARIES="$(dependencies_list_native_libraries 'PKG_BIN')
ibSDL2-2.0.so.0"
## Prevent a game crash when using the Wayland video backend of SDL.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')"'
# Prevent a game crash when using the Wayland video backend of SDL.
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
