/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.Rect;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Region
implements Shape {
    public int rgnSize = 10;
    public Rect rgnBBox = new Rect();
    public List<Short> rgnData = new Vector<Short>();

    public static Region read(DataInputStream in) throws IOException {
        Region r = new Region();
        r.rgnSize = in.readUnsignedShort();
        r.rgnBBox = Rect.read(in);
        r.rgnData = new Vector<Short>();
        int i = 10;
        while (i < r.rgnSize) {
            r.rgnData.add(in.readShort());
            i += 2;
        }
        return r;
    }

    public Region() {
        this.rgnBBox = new Rect();
        this.rgnData = new Vector<Short>();
    }

    public Region(int x, int y, int width, int height) {
        this.rgnBBox = new Rect(x, y, width, height);
        this.rgnData = new Vector<Short>();
    }

    public void write(DataOutputStream out) throws IOException {
        if (this.rgnData.isEmpty()) {
            this.rgnSize = 10;
            out.writeShort(10);
            this.rgnBBox.write(out);
        } else {
            short s;
            short s2;
            short s3;
            short s4;
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            Iterator<Short> i = this.rgnData.iterator();
            block0: while (i.hasNext()) {
                short row = i.next();
                if (row == Short.MAX_VALUE) break;
                if (row < s4) {
                    s4 = row;
                }
                if (row > s3) {
                    s3 = row;
                }
                while (i.hasNext()) {
                    short col = i.next();
                    if (col == Short.MAX_VALUE) continue block0;
                    if (col < s2) {
                        s2 = col;
                    }
                    if (col <= s) continue;
                    s = col;
                }
            }
            if (s2 < s && s4 < s3) {
                this.rgnSize = 10 + this.rgnData.size() * 2;
                out.writeShort(this.rgnSize);
                this.rgnBBox = new Rect(s2, s4, (int)(s - s2), s3 - s4);
                this.rgnBBox.write(out);
                for (Short s5 : this.rgnData) {
                    out.writeShort(s5.shortValue());
                }
            } else {
                this.rgnSize = 10;
                out.writeShort(10);
                this.rgnBBox = new Rect(this.rgnBBox.left, this.rgnBBox.top, 0, 0);
                this.rgnBBox.write(out);
                this.rgnData.clear();
            }
        }
    }

    public static Region fromAlpha(int x, int y, int width, int height, int[] rgb, int offset, int scanwidth) {
        byte[] tmp = new byte[(width + 1) * (height + 1)];
        int ly = 0;
        int py = offset;
        int ty = 0;
        while (ly < height) {
            int lx = 0;
            int px = py;
            int tx = ty;
            while (lx < width) {
                if (rgb[px] < 0) {
                    int n = tx;
                    tmp[n] = (byte)(tmp[n] ^ 1);
                    int n2 = tx + 1;
                    tmp[n2] = (byte)(tmp[n2] ^ 1);
                    int n3 = tx + width + 1;
                    tmp[n3] = (byte)(tmp[n3] ^ 1);
                    int n4 = tx + width + 2;
                    tmp[n4] = (byte)(tmp[n4] ^ 1);
                }
                ++lx;
                ++px;
                ++tx;
            }
            ++ly;
            py += scanwidth;
            ty += width + 1;
        }
        return Region.fromBits(x, y, width, height, tmp);
    }

    public static Region fromRGB(int x, int y, int width, int height, int[] rgb, int offset, int scanwidth) {
        byte[] tmp = new byte[(width + 1) * (height + 1)];
        int ly = 0;
        int py = offset;
        int ty = 0;
        while (ly < height) {
            int lx = 0;
            int px = py;
            int tx = ty;
            while (lx < width) {
                int b;
                int g;
                int r;
                int k;
                if (rgb[px] < 0 && (k = (30 * (r = rgb[px] >>> 16 & 0xFF) + 59 * (g = rgb[px] >>> 8 & 0xFF) + 11 * (b = rgb[px] & 0xFF)) / 100) < 128) {
                    int n = tx;
                    tmp[n] = (byte)(tmp[n] ^ 1);
                    int n2 = tx + 1;
                    tmp[n2] = (byte)(tmp[n2] ^ 1);
                    int n3 = tx + width + 1;
                    tmp[n3] = (byte)(tmp[n3] ^ 1);
                    int n4 = tx + width + 2;
                    tmp[n4] = (byte)(tmp[n4] ^ 1);
                }
                ++lx;
                ++px;
                ++tx;
            }
            ++ly;
            py += scanwidth;
            ty += width + 1;
        }
        return Region.fromBits(x, y, width, height, tmp);
    }

    public static Region fromShape(Shape s) {
        Rectangle r = s.getBounds();
        byte[] tmp = new byte[(r.width + 1) * (r.height + 1)];
        int ly = 0;
        int sy = r.y;
        int ty = 0;
        while (ly < r.height) {
            int lx = 0;
            int sx = r.x;
            int tx = ty;
            while (lx < r.width) {
                if (s.contains(sx, sy)) {
                    int n = tx;
                    tmp[n] = (byte)(tmp[n] ^ 1);
                    int n2 = tx + 1;
                    tmp[n2] = (byte)(tmp[n2] ^ 1);
                    int n3 = tx + r.width + 1;
                    tmp[n3] = (byte)(tmp[n3] ^ 1);
                    int n4 = tx + r.width + 2;
                    tmp[n4] = (byte)(tmp[n4] ^ 1);
                }
                ++lx;
                ++sx;
                ++tx;
            }
            ++ly;
            ++sy;
            ty += r.width + 1;
        }
        return Region.fromBits(r.x, r.y, r.width, r.height, tmp);
    }

    public static Region fromImage(int x, int y, Image i, ImageObserver obs) {
        int w = i.getWidth(obs);
        int h = i.getHeight(obs);
        if (w < 0 || h < 0) {
            return null;
        }
        BufferedImage bimg = new BufferedImage(w, h, 2);
        Graphics2D bg = bimg.createGraphics();
        if (!bg.drawImage(i, 0, 0, obs)) {
            return null;
        }
        bg.dispose();
        int[] rgb = new int[w * h];
        bimg.getRGB(0, 0, w, h, rgb, 0, w);
        return Region.fromRGB(x, y, w, h, rgb, 0, w);
    }

    private static Region fromBits(int x, int y, int width, int height, byte[] tmp) {
        int minx = x + width;
        int miny = y + height;
        int maxx = x;
        int maxy = y;
        Vector<Short> data = new Vector<Short>();
        int ly = 0;
        int ty = 0;
        while (ly < height + 1) {
            boolean wroteRow = false;
            int lx = 0;
            int tx = ty;
            while (lx < width + 1) {
                if (tmp[tx] != 0) {
                    if (!wroteRow) {
                        data.add((short)(y + ly));
                        wroteRow = true;
                    }
                    data.add((short)(x + lx));
                    if (x + lx < minx) {
                        minx = x + lx;
                    }
                    if (x + lx > maxx) {
                        maxx = x + lx;
                    }
                }
                ++lx;
                ++tx;
            }
            if (wroteRow) {
                data.add((short)Short.MAX_VALUE);
                if (y + ly < miny) {
                    miny = y + ly;
                }
                if (y + ly > maxy) {
                    maxy = y + ly;
                }
            }
            ++ly;
            ty += width + 1;
        }
        data.add((short)Short.MAX_VALUE);
        if (maxx < minx || maxy < miny) {
            minx = maxx = x;
            miny = maxy = y;
            data.clear();
        }
        Region r = new Region();
        r.rgnSize = 10 + data.size() * 2;
        r.rgnBBox = new Rect(minx, miny, maxx - minx, maxy - miny);
        r.rgnData = data;
        return r;
    }

    /*
     * Unable to fully structure code
     */
    public Area toArea() {
        if (this.rgnData.isEmpty()) {
            return new Area(new Rectangle(this.rgnBBox.left, this.rgnBBox.top, this.rgnBBox.right - this.rgnBBox.left, this.rgnBBox.bottom - this.rgnBBox.top));
        }
        a = new Area();
        i = this.rgnData.iterator();
        block0: while (i.hasNext()) {
            row = i.next();
            if (row != 32767) ** GOTO lbl11
            break;
            while ((col = i.next().shortValue()) != 32767) {
                a.exclusiveOr(new Area(new Rectangle(col, row, this.rgnBBox.right - col, this.rgnBBox.bottom - row)));
lbl11:
                // 2 sources

                if (i.hasNext()) continue;
                continue block0;
            }
        }
        return a;
    }

    public BufferedImage toBufferedImage() {
        int w = this.rgnBBox.right - this.rgnBBox.left;
        int h = this.rgnBBox.bottom - this.rgnBBox.top;
        BufferedImage bimg = new BufferedImage(w, h, 2);
        Graphics2D bg = bimg.createGraphics();
        Shape s = AffineTransform.getTranslateInstance(-this.rgnBBox.left, -this.rgnBBox.top).createTransformedShape(this.toArea());
        bg.setPaint(Color.black);
        bg.fill(s);
        bg.dispose();
        return bimg;
    }

    public void toRGB(int x, int y, int width, int height, int[] rgb, int offset, int scanwidth) {
        BufferedImage bimg = this.toBufferedImage();
        bimg.getRGB(x - this.rgnBBox.left, y - this.rgnBBox.top, width, height, rgb, offset, scanwidth);
    }

    public String toString() {
        return "Region[" + this.rgnSize + "," + this.rgnBBox.toString() + "]";
    }

    @Override
    public boolean contains(Point2D p) {
        return this.toArea().contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.toArea().contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.toArea().contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.toArea().contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.toArea().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.toArea().getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.toArea().getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.toArea().getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.toArea().intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.toArea().intersects(x, y, w, h);
    }
}

