struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 1025,
		.content = "Processor\t: AArch64 Processor rev 1 (aarch64)\n"
			   "processor\t: 0\n"
			   "min_vddcx\t: 400000\n"
			   "min_vddmx\t: 490000\n"
			   "BogoMIPS\t: 38.00\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x2\n"
			   "CPU part\t: 0x201\n"
			   "CPU revision\t: 1\n"
			   "\n"
			   "processor\t: 1\n"
			   "min_vddcx\t: 400000\n"
			   "min_vddmx\t: 490000\n"
			   "BogoMIPS\t: 38.00\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x2\n"
			   "CPU part\t: 0x201\n"
			   "CPU revision\t: 1\n"
			   "\n"
			   "processor\t: 2\n"
			   "min_vddcx\t: 400000\n"
			   "min_vddmx\t: 490000\n"
			   "BogoMIPS\t: 38.00\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x2\n"
			   "CPU part\t: 0x205\n"
			   "CPU revision\t: 1\n"
			   "\n"
			   "processor\t: 3\n"
			   "min_vddcx\t: 400000\n"
			   "min_vddmx\t: 490000\n"
			   "BogoMIPS\t: 38.00\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x2\n"
			   "CPU part\t: 0x205\n"
			   "CPU revision\t: 1\n"
			   "\n"
			   "CPU param\t: 267 434 434 633 958 308 436 436 636 1078 \n"
			   "Hardware\t: Qualcomm Technologies, Inc MSM8996pro\n",
	},
	{
		.path = "/system/build.prop",
		.size = 5155,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=NOF26V\n"
			"ro.build.display.id=NOF26V\n"
			"ro.build.version.incremental=3636322\n"
			"ro.build.version.sdk=25\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=7.1.1\n"
			"ro.build.version.security_patch=2017-02-05\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Fri Jan 13 03:24:11 UTC 2017\n"
			"ro.build.date.utc=1484277851\n"
			"ro.build.type=user\n"
			"ro.build.user=android-build\n"
			"ro.build.host=wpix7.hot.corp.google.com\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=marlin-user\n"
			"ro.build.system_root_image=true\n"
			"ro.build.ab_update=true\n"
			"ro.product.model=Pixel XL\n"
			"ro.product.brand=google\n"
			"ro.product.name=marlin\n"
			"ro.product.device=marlin\n"
			"ro.product.board=marlin\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=Google\n"
			"ro.product.locale=en-US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=msm8996\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=marlin\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=marlin-user 7.1.1 NOF26V 3636322 release-keys\n"
			"ro.build.fingerprint=google/marlin/marlin:7.1.1/NOF26V/3636322:user/release-keys\n"
			"ro.build.characteristics=nosdcard\n"
			"# end build properties\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.product.first_api_level=24\n"
			"dalvik.vm.heapgrowthlimit=256m\n"
			"ro.telephony.default_cdma_sub=0\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=512k\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"ro.vendor.extension_library=libqti-perfd-client.so\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"persist.radio.sib16_support=1\n"
			"persist.radio.custom_ecc=1\n"
			"ro.opengles.version=196610\n"
			"ro.hwui.gradient_cache_size=1\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.r_buffer_cache_size=8\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"ro.qc.sdk.audio.fluencetype=fluencepro\n"
			"persist.audio.fluence.voicecall=true\n"
			"persist.audio.fluence.speaker=true\n"
			"persist.audio.fluence.voicecomm=true\n"
			"persist.audio.fluence.voicerec=false\n"
			"af.fast_track_multiplier=1\n"
			"audio_hal.period_size=192\n"
			"persist.camera.gyro.android=4\n"
			"persist.camera.tof.direct=1\n"
			"persist.camera.tnr.preview=1\n"
			"persist.camera.tnr.video=1\n"
			"qcom.bluetooth.soc=rome\n"
			"persist.cne.feature=1\n"
			"persist.radio.data_ltd_sys_ind=1\n"
			"persist.radio.is_wps_enabled=true\n"
			"persist.radio.RATE_ADAPT_ENABLE=1\n"
			"persist.radio.ROTATION_ENABLE=1\n"
			"persist.radio.sw_mbn_update=1\n"
			"persist.radio.videopause.mode=1\n"
			"persist.radio.VT_ENABLE=1\n"
			"persist.radio.VT_HYBRID_ENABLE=1\n"
			"persist.radio.data_con_rprt=true\n"
			"persist.rcs.supported=1\n"
			"rild.libpath=/vendor/lib64/libril-qc-qmi-1.so\n"
			"persist.data.mode=concurrent\n"
			"persist.radio.snapshot_enabled=1\n"
			"persist.radio.snapshot_timer=3\n"
			"persist.data.iwlan.enable=true\n"
			"ro.telephony.default_network=10\n"
			"telephony.lteOnCdmaDevice=1\n"
			"persist.camera.eis.enable=1\n"
			"persist.camera.is_type=4\n"
			"persist.sys.ssr.restart_level=venus,AR6320,slpi,modem,adsp\n"
			"ro.bt.bdaddr_path=/sys/module/bdaddress/parameters/bdaddress\n"
			"ro.cp_system_other_odex=1\n"
			"ro.camera.notify_nfc=1\n"
			"ro.frp.pst=/dev/block/platform/soc/624000.ufshc/by-name/frp\n"
			"sdm.debug.disable_rotator_split=1\n"
			"qdcm.only_pcc_for_trans=1\n"
			"qdcm.diagonal_matrix_mode=1\n"
			"vidc.debug.perf.mode=2\n"
			"ro.crypto.scrypt_params=13:3:1\n"
			"debug.sf.disable_hwc_vds=1\n"
			"audio.adm.buffering.ms=3\n"
			"ro.sf.lcd_density=560\n"
			"ro.config.vc_call_vol_steps=7\n"
			"ro.hwui.texture_cache_size=72\n"
			"ro.hwui.layer_cache_size=48\n"
			"ro.hwui.path_cache_size=32\n"
			"ro.hardware.fingerprint=fpc\n"
			"ro.config.ringtone=Zen.ogg\n"
			"ro.config.notification_sound=Chime.ogg\n"
			"ro.config.alarm_alert=Flow.ogg\n"
			"ro.com.android.dataroaming=false\n"
			"ro.url.legal=http://www.google.com/intl/%s/mobile/android/basic/phone-legal.html\n"
			"ro.url.legal.android_privacy=http://www.google.com/intl/%s/mobile/android/basic/privacy.html\n"
			"ro.com.google.clientidbase=android-google\n"
			"ro.carrier=unknown\n"
			"ro.com.android.wifi-watchlist=GoogleGuest\n"
			"ro.error.receiver.system.apps=com.google.android.gms\n"
			"ro.setupwizard.enterprise_mode=1\n"
			"ro.atrace.core.services=com.google.android.gms,com.google.android.gms.ui,com.google.android.gms.persistent\n"
			"ro.retaildemo.video_path=/data/preloads/demo/retail_demo.mp4\n"
			"ro.com.android.prov_mobiledata=false\n"
			"keyguard.no_require_sim=true\n"
			"drm.service.enabled=true\n"
			"media.mediadrmservice.enable=true\n"
			"ro.setupwizard.rotation_locked=true\n"
			"ro.opa.eligible_device=true\n"
			"ro.facelock.black_timeout=700\n"
			"ro.facelock.det_timeout=2500\n"
			"ro.facelock.rec_timeout=3500\n"
			"ro.facelock.est_max_time=600\n"
			"ro.wallpapers_loc_request_suw=true\n"
			"ro.com.google.ime.theme_id=5\n"
			"ro.storage_manager.enabled=true\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.variant=generic\n"
			"dalvik.vm.isa.arm64.features=default\n"
			"dalvik.vm.isa.arm.variant=krait\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.build.expect.bootloader=8996-012001-1611091517\n"
			"ro.build.expect.baseband=8996-012511-1611190200\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 66,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 31,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 492,
		.content =
			"CPU2:307200=0 384000=0 460800=0 537600=0 614400=0 691200=0 748800=0 825600=0 902400=0 979200=0 1056000=0 1132800=0 1209600=0 1286400=0 1363200=0 1440000=0 1516800=0 1593600=0 1670400=0 1747200=0 1824000=0 1900800=0 1977600=0 2054400=0 2150400=0 \n"
			"CPU3:307200=0 384000=0 460800=0 537600=0 614400=0 691200=0 748800=0 825600=0 902400=0 979200=0 1056000=0 1132800=0 1209600=0 1286400=0 1363200=0 1440000=0 1516800=0 1593600=0 1670400=0 1747200=0 1824000=0 1900800=0 1977600=0 2054400=0 2150400=0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "qcom\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1593600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 135,
		.content =
			"307200 384000 460800 537600 614400 691200 768000 844800 902400 979200 1056000 1132800 1209600 1286400 1363200 1440000 1516800 1593600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 73,
		.content = "interactive conservative ondemand userspace powersave performance sched \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "537600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 6,
		.content = "sched\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 199,
		.content = "307200 253\n"
			   "384000 179\n"
			   "460800 168\n"
			   "537600 144\n"
			   "614400 156\n"
			   "691200 123\n"
			   "768000 121\n"
			   "844800 60\n"
			   "902400 67\n"
			   "979200 111\n"
			   "1056000 60\n"
			   "1132800 196\n"
			   "1209600 59\n"
			   "1286400 68\n"
			   "1363200 70\n"
			   "1440000 65\n"
			   "1516800 45\n"
			   "1593600 1033\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "684\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1593600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 135,
		.content =
			"307200 384000 460800 537600 614400 691200 768000 844800 902400 979200 1056000 1132800 1209600 1286400 1363200 1440000 1516800 1593600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 73,
		.content = "interactive conservative ondemand userspace powersave performance sched \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 6,
		.content = "sched\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 199,
		.content = "307200 363\n"
			   "384000 268\n"
			   "460800 255\n"
			   "537600 169\n"
			   "614400 192\n"
			   "691200 129\n"
			   "768000 126\n"
			   "844800 65\n"
			   "902400 67\n"
			   "979200 111\n"
			   "1056000 60\n"
			   "1132800 196\n"
			   "1209600 59\n"
			   "1286400 68\n"
			   "1363200 70\n"
			   "1440000 65\n"
			   "1516800 45\n"
			   "1593600 1033\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "770\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 4,
		.content = "2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 4,
		.content = "2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 191,
		.content =
			"307200 384000 460800 537600 614400 691200 748800 825600 902400 979200 1056000 1132800 1209600 1286400 1363200 1440000 1516800 1593600 1670400 1747200 1824000 1900800 1977600 2054400 2150400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 73,
		.content = "interactive conservative ondemand userspace powersave performance sched \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 6,
		.content = "sched\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 273,
		.content = "307200 803\n"
			   "384000 39\n"
			   "460800 172\n"
			   "537600 209\n"
			   "614400 104\n"
			   "691200 154\n"
			   "748800 62\n"
			   "825600 66\n"
			   "902400 56\n"
			   "979200 68\n"
			   "1056000 59\n"
			   "1132800 168\n"
			   "1209600 77\n"
			   "1286400 54\n"
			   "1363200 55\n"
			   "1440000 50\n"
			   "1516800 64\n"
			   "1593600 48\n"
			   "1670400 41\n"
			   "1747200 57\n"
			   "1824000 46\n"
			   "1900800 36\n"
			   "1977600 21\n"
			   "2054400 55\n"
			   "2150400 1146\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 4,
		.content = "593\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "2-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "c\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 4,
		.content = "2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 4,
		.content = "2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 191,
		.content =
			"307200 384000 460800 537600 614400 691200 748800 825600 902400 979200 1056000 1132800 1209600 1286400 1363200 1440000 1516800 1593600 1670400 1747200 1824000 1900800 1977600 2054400 2150400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 73,
		.content = "interactive conservative ondemand userspace powersave performance sched \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "537600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 6,
		.content = "sched\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "2150400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "307200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 273,
		.content = "307200 806\n"
			   "384000 40\n"
			   "460800 174\n"
			   "537600 224\n"
			   "614400 110\n"
			   "691200 164\n"
			   "748800 78\n"
			   "825600 68\n"
			   "902400 61\n"
			   "979200 78\n"
			   "1056000 64\n"
			   "1132800 178\n"
			   "1209600 82\n"
			   "1286400 65\n"
			   "1363200 60\n"
			   "1440000 61\n"
			   "1516800 74\n"
			   "1593600 49\n"
			   "1670400 47\n"
			   "1747200 57\n"
			   "1824000 56\n"
			   "1900800 41\n"
			   "1977600 26\n"
			   "2054400 70\n"
			   "2150400 1290\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 4,
		.content = "677\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "2-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 2,
		.content = "c\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 2,
		.content = "8\n",
	},
	{NULL},
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.fast_track_multiplier",
		.value = "1",
	},
	{
		.key = "audio.adm.buffering.ms",
		.value = "3",
	},
	{
		.key = "audio_hal.period_size",
		.value = "192",
	},
	{
		.key = "dalvik.vm.appimageformat",
		.value = "lz4",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "512k",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "krait",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm64.variant",
		.value = "generic",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "dalvik.vm.usejit",
		.value = "true",
	},
	{
		.key = "dalvik.vm.usejitprofiles",
		.value = "true",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.sf.disable_hwc_vds",
		.value = "1",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "8996-012511-1611190200",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Qualcomm RIL 1.0",
	},
	{
		.key = "htc.camera.sensor.front_SN",
		.value = "000000004200AB23",
	},
	{
		.key = "htc.camera.sensor.inf",
		.value = "-210",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.adsprpcd",
		.value = "running",
	},
	{
		.key = "init.svc.audioserver",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.cameraserver",
		.value = "running",
	},
	{
		.key = "init.svc.cnd",
		.value = "running",
	},
	{
		.key = "init.svc.cnss-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.cnss_diag",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.fingerprintd",
		.value = "running",
	},
	{
		.key = "init.svc.flash-nanohub-fw",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.imsdatadaemon",
		.value = "running",
	},
	{
		.key = "init.svc.imsqmidaemon",
		.value = "running",
	},
	{
		.key = "init.svc.init-radio-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.loc_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mediacodec",
		.value = "running",
	},
	{
		.key = "init.svc.mediadrm",
		.value = "running",
	},
	{
		.key = "init.svc.mediaextractor",
		.value = "running",
	},
	{
		.key = "init.svc.msm_irqbalance",
		.value = "running",
	},
	{
		.key = "init.svc.nanohub_slpi",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.per_mgr",
		.value = "running",
	},
	{
		.key = "init.svc.per_proxy",
		.value = "running",
	},
	{
		.key = "init.svc.perfd",
		.value = "running",
	},
	{
		.key = "init.svc.port-bridge",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.ssr_setup",
		.value = "stopped",
	},
	{
		.key = "init.svc.start_hci_filter",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.update_engine",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "media.mediadrmservice.enable",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.lte.ims.data.enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-9c055742859f692",
	},
	{
		.key = "net.lte.ims.data.enabled",
		.value = "true",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.2g_init_rwnd",
		.value = "10",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,524288,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,524288,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "2097152,4194304,8388608,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,2097152,4194304,262144,524288,1048576",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "partition.system.verified",
		.value = "2",
	},
	{
		.key = "partition.vendor.verified",
		.value = "2",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecomm",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "false",
	},
	{
		.key = "persist.camera.debug.logfile",
		.value = "0",
	},
	{
		.key = "persist.camera.eis.enable",
		.value = "1",
	},
	{
		.key = "persist.camera.gyro.android",
		.value = "4",
	},
	{
		.key = "persist.camera.is_type",
		.value = "4",
	},
	{
		.key = "persist.camera.tnr.preview",
		.value = "1",
	},
	{
		.key = "persist.camera.tnr.video",
		.value = "1",
	},
	{
		.key = "persist.camera.tof.direct",
		.value = "1",
	},
	{
		.key = "persist.cne.feature",
		.value = "1",
	},
	{
		.key = "persist.data.iwlan.enable",
		.value = "true",
	},
	{
		.key = "persist.data.mode",
		.value = "concurrent",
	},
	{
		.key = "persist.radio.RATE_ADAPT_ENABLE",
		.value = "1",
	},
	{
		.key = "persist.radio.ROTATION_ENABLE",
		.value = "1",
	},
	{
		.key = "persist.radio.VT_ENABLE",
		.value = "1",
	},
	{
		.key = "persist.radio.VT_HYBRID_ENABLE",
		.value = "1",
	},
	{
		.key = "persist.radio.adb_log_on",
		.value = "0",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.custom_ecc",
		.value = "1",
	},
	{
		.key = "persist.radio.data_con_rprt",
		.value = "true",
	},
	{
		.key = "persist.radio.data_ltd_sys_ind",
		.value = "1",
	},
	{
		.key = "persist.radio.eons.enabled",
		.value = "false",
	},
	{
		.key = "persist.radio.is_wps_enabled",
		.value = "true",
	},
	{
		.key = "persist.radio.ril_payload_on",
		.value = "0",
	},
	{
		.key = "persist.radio.sglte_target",
		.value = "0",
	},
	{
		.key = "persist.radio.sib16_support",
		.value = "1",
	},
	{
		.key = "persist.radio.snapshot_enabled",
		.value = "1",
	},
	{
		.key = "persist.radio.snapshot_timer",
		.value = "3",
	},
	{
		.key = "persist.radio.sw_mbn_loaded",
		.value = "1",
	},
	{
		.key = "persist.radio.sw_mbn_update",
		.value = "1",
	},
	{
		.key = "persist.radio.ver_info",
		.value = "8996-012511-1611190200",
	},
	{
		.key = "persist.radio.videopause.mode",
		.value = "1",
	},
	{
		.key = "persist.rcs.supported",
		.value = "1",
	},
	{
		.key = "persist.sys.cnd.iwlan",
		.value = "1",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.ssr.restart_level",
		.value = "venus,AR6320,slpi,modem,adsp",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/Los_Angeles",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.webview.vmsize",
		.value = "116905264",
	},
	{
		.key = "pm.dexopt.ab-ota",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.bg-dexopt",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.boot",
		.value = "verify-profile",
	},
	{
		.key = "pm.dexopt.core-app",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.first-boot",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.forced-dexopt",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.install",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.nsys-library",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.shared-apk",
		.value = "speed",
	},
	{
		.key = "qcom.bluetooth.soc",
		.value = "rome",
	},
	{
		.key = "qdcm.diagonal_matrix_mode",
		.value = "1",
	},
	{
		.key = "qdcm.only_pcc_for_trans",
		.value = "1",
	},
	{
		.key = "ril.ecclist",
		.value = "911,*911,#911,112,000,08,110,999,118,119",
	},
	{
		.key = "ril.qcril_pre_init_lock_held",
		.value = "0",
	},
	{
		.key = "rild.libpath",
		.value = "/vendor/lib64/libril-qc-qmi-1.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.atrace.core.services",
		.value = "com.google.android.gms,com.google.android.gms.ui,com.google.android.gms.persistent",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.dun",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.6",
	},
	{
		.key = "ro.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8996",
	},
	{
		.key = "ro.boot.authorized_kernel",
		.value = "true",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.bootdevice",
		.value = "624000.ufshc",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "8996-012001-1611091517",
	},
	{
		.key = "ro.boot.bootreason",
		.value = "reboot",
	},
	{
		.key = "ro.boot.cid",
		.value = "11111111",
	},
	{
		.key = "ro.boot.console",
		.value = "ttyHSL0",
	},
	{
		.key = "ro.boot.ddrinfo",
		.value = "00000006",
	},
	{
		.key = "ro.boot.ddrsize",
		.value = "4GB",
	},
	{
		.key = "ro.boot.flash.locked",
		.value = "1",
	},
	{
		.key = "ro.boot.fp_src",
		.value = "1",
	},
	{
		.key = "ro.boot.hardware",
		.value = "marlin",
	},
	{
		.key = "ro.boot.hardware.color",
		.value = "GRA00",
	},
	{
		.key = "ro.boot.hardware.ddr",
		.value = "4096MB,Hynix,LPDDR4",
	},
	{
		.key = "ro.boot.hardware.revision",
		.value = "PVT",
	},
	{
		.key = "ro.boot.hardware.ufs",
		.value = "128GB,Toshiba",
	},
	{
		.key = "ro.boot.htc.hrdump",
		.value = "detected",
	},
	{
		.key = "ro.boot.keymaster",
		.value = "1",
	},
	{
		.key = "ro.boot.msm.hw_ver_id",
		.value = "268824801",
	},
	{
		.key = "ro.boot.oem_unlock_support",
		.value = "1",
	},
	{
		.key = "ro.boot.qf.st",
		.value = "2",
	},
	{
		.key = "ro.boot.ramdump.opt",
		.value = "mem@2g:2g,mem@4g:2g",
	},
	{
		.key = "ro.boot.ramdump_enable",
		.value = "0",
	},
	{
		.key = "ro.boot.serialno",
		.value = "HT74C0200006",
	},
	{
		.key = "ro.boot.slot_suffix",
		.value = "_a",
	},
	{
		.key = "ro.boot.verifiedbootstate",
		.value = "green",
	},
	{
		.key = "ro.boot.veritymode",
		.value = "enforcing",
	},
	{
		.key = "ro.boot.wificountrycode",
		.value = "US",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Fri Jan 13 03:24:11 UTC 2017",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1484277851",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "google/marlin/marlin:7.1.1/NOF26V/3636322:user/release-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "8996-012001-1611091517",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/sys/module/bdaddress/parameters/bdaddress",
	},
	{
		.key = "ro.build.ab_update",
		.value = "true",
	},
	{
		.key = "ro.build.characteristics",
		.value = "nosdcard",
	},
	{
		.key = "ro.build.date",
		.value = "Fri Jan 13 03:24:11 UTC 2017",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1484277851",
	},
	{
		.key = "ro.build.description",
		.value = "marlin-user 7.1.1 NOF26V 3636322 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "NOF26V",
	},
	{
		.key = "ro.build.expect.baseband",
		.value = "8996-012511-1611190200",
	},
	{
		.key = "ro.build.expect.bootloader",
		.value = "8996-012001-1611091517",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "google/marlin/marlin:7.1.1/NOF26V/3636322:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "marlin-user",
	},
	{
		.key = "ro.build.host",
		.value = "wpix7.hot.corp.google.com",
	},
	{
		.key = "ro.build.id",
		.value = "NOF26V",
	},
	{
		.key = "ro.build.product",
		.value = "marlin",
	},
	{
		.key = "ro.build.system_root_image",
		.value = "true",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "android-build",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "3636322",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "7.1.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "25",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-02-05",
	},
	{
		.key = "ro.camera.notify_nfc",
		.value = "1",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.android.prov_mobiledata",
		.value = "false",
	},
	{
		.key = "ro.com.android.wifi-watchlist",
		.value = "GoogleGuest",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-google",
	},
	{
		.key = "ro.com.google.ime.theme_id",
		.value = "5",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Flow.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Chime.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Zen.ogg",
	},
	{
		.key = "ro.config.vc_call_vol_steps",
		.value = "7",
	},
	{
		.key = "ro.cp_system_other_odex",
		.value = "1",
	},
	{
		.key = "ro.crypto.scrypt_params",
		.value = "13:3:1",
	},
	{
		.key = "ro.crypto.state",
		.value = "encrypted",
	},
	{
		.key = "ro.crypto.type",
		.value = "file",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.error.receiver.system.apps",
		.value = "com.google.android.gms",
	},
	{
		.key = "ro.facelock.black_timeout",
		.value = "700",
	},
	{
		.key = "ro.facelock.det_timeout",
		.value = "2500",
	},
	{
		.key = "ro.facelock.est_max_time",
		.value = "600",
	},
	{
		.key = "ro.facelock.rec_timeout",
		.value = "3500",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/platform/soc/624000.ufshc/by-name/frp",
	},
	{
		.key = "ro.hardware",
		.value = "marlin",
	},
	{
		.key = "ro.hardware.fingerprint",
		.value = "fpc",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "1",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "48",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "32",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "8",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "72",
	},
	{
		.key = "ro.min_freq_0",
		.value = "384000",
	},
	{
		.key = "ro.oem_unlock_supported",
		.value = "1",
	},
	{
		.key = "ro.opa.eligible_device",
		.value = "true",
	},
	{
		.key = "ro.opengles.version",
		.value = "196610",
	},
	{
		.key = "ro.product.board",
		.value = "marlin",
	},
	{
		.key = "ro.product.brand",
		.value = "google",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.device",
		.value = "marlin",
	},
	{
		.key = "ro.product.first_api_level",
		.value = "24",
	},
	{
		.key = "ro.product.locale",
		.value = "en-US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "Google",
	},
	{
		.key = "ro.product.model",
		.value = "Pixel XL",
	},
	{
		.key = "ro.product.name",
		.value = "marlin",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "fluencepro",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.retaildemo.video_path",
		.value = "/data/preloads/demo/retail_demo.mp4",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "HT74C0200006",
	},
	{
		.key = "ro.setupwizard.enterprise_mode",
		.value = "1",
	},
	{
		.key = "ro.setupwizard.rotation_locked",
		.value = "true",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "560",
	},
	{
		.key = "ro.storage_manager.enabled",
		.value = "true",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_cdma_sub",
		.value = "0",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "10",
	},
	{
		.key = "ro.url.legal",
		.value = "http://www.google.com/intl/%s/mobile/android/basic/phone-legal.html",
	},
	{
		.key = "ro.url.legal.android_privacy",
		.value = "http://www.google.com/intl/%s/mobile/android/basic/privacy.html",
	},
	{
		.key = "ro.vendor.build.date",
		.value = "Fri Jan 13 03:24:11 UTC 2017",
	},
	{
		.key = "ro.vendor.build.date.utc",
		.value = "1484277851",
	},
	{
		.key = "ro.vendor.build.fingerprint",
		.value = "google/marlin/marlin:7.1.1/NOF26V/3636322:user/release-keys",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "libqti-perfd-client.so",
	},
	{
		.key = "ro.wallpapers_loc_request_suw",
		.value = "true",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "sdm.debug.disable_rotator_split",
		.value = "1",
	},
	{
		.key = "security.perf_harden",
		.value = "1",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "selinux.restorecon_recursive",
		.value = "/data/misc_ce/0",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.ims.QMI_DAEMON_STATUS",
		.value = "1",
	},
	{
		.key = "sys.keymaster.loaded",
		.value = "true",
	},
	{
		.key = "sys.listeners.registered",
		.value = "true",
	},
	{
		.key = "sys.oem_unlock_allowed",
		.value = "0",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "43200",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.configfs",
		.value = "0",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.rps_mask",
		.value = "0",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "1",
	},
	{
		.key = "vidc.debug.perf.mode",
		.value = "2",
	},
	{
		.key = "vold.has_adoptable",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{NULL},
};
#endif /* __ANDROID__ */
