/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest.hpp
 *
 * $Id: unittest.hpp,v 1.12 2005/06/23 09:54:19 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Use-Case: The include-files for building test suites
 * and executing them. 
 *
 * All headers which are necessary to build a unittest are included by
 * this header. Do not use this header in production code, i.e., code
 * which should be tested but which is not the testing code. 
 */
#ifndef DIAGNOSTICS__UNITTEST_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST_HPP__INCLUDE_GUARD

#include <diagnostics/macros/test_front_end.hpp>
#include <diagnostics/unittest/test_case_cstr.hpp>
#include <diagnostics/unittest/test_data.hpp>
#include <diagnostics/unittest/test_exception.hpp>
#include <diagnostics/unittest/stream_test_system_main.hpp>

#endif
// vim:ts=4:sw=4
