typedef enum {
    NONE = 0,
    ADA,
    ASSEMBLY,
    AWK,
    BATCHFILE,
    BIBTEX,
    C,
    CPLUSPLUS,
    CLOJURE,
    CMAKE,
    COFFEESCRIPT,
    CONFIG,
    CSHARP,
    CSS,
    CSV,
    D,
    DART,
    DIFF,
    DOCKER,
    DOT,
    DTERC,
    EMACSLISP,
    GETTEXT,
    GITCOMMIT,
    GITREBASE,
    GLSL,
    GNUPLOT,
    GO,
    GPERF,
    GRADLE,
    GROOVY,
    HASKELL,
    HTML,
    INDENT,
    INI,
    JAVA,
    JAVASCRIPT,
    JSON,
    LEX,
    LISP,
    LUA,
    M4,
    MAIL,
    MAKE,
    MARKDOWN,
    MESON,
    MOONSCRIPT,
    NGINX,
    NIM,
    NINJA,
    NIX,
    OBJECTIVEC,
    PERL,
    PHP,
    PKGCONFIG,
    POSTSCRIPT,
    PROTOBUF,
    PYTHON,
    RACKET,
    ROBOTSTXT,
    ROFF,
    RESTRUCTUREDTEXT,
    RUBY,
    RUST,
    SCALA,
    SCHEME,
    SCSS,
    SED,
    SHELL,
    SQL,
    TCL,
    TEX,
    TEXINFO,
    TEXMFCNF,
    TOML,
    TYPESCRIPT,
    VALA,
    VCARD,
    VERILOG,
    VHDL,
    VIML,
    XML,
    XRESOURCES,
    YACC,
    YAML,
    ZIG,
    NR_BUILTIN_FILETYPES
} FileTypeEnum;

static const char builtin_filetype_names[NR_BUILTIN_FILETYPES][16] = {
    [NONE] = "none",
    [ADA] = "ada",
    [ASSEMBLY] = "asm",
    [AWK] = "awk",
    [BATCHFILE] = "batch",
    [BIBTEX] = "bibtex",
    [C] = "c",
    [CPLUSPLUS] = "c",
    [CLOJURE] = "clojure",
    [CMAKE] = "cmake",
    [COFFEESCRIPT] = "coffeescript",
    [CONFIG] = "config",
    [CSHARP] = "csharp",
    [CSS] = "css",
    [CSV] = "csv",
    [DART] = "dart",
    [D] = "d",
    [DIFF] = "diff",
    [DOCKER] = "docker",
    [DOT] = "dot",
    [DTERC] = "dte",
    [EMACSLISP] = "elisp",
    [GETTEXT] = "gettext",
    [GITCOMMIT] = "gitcommit",
    [GITREBASE] = "gitrebase",
    [GLSL] = "glsl",
    [GNUPLOT] = "gnuplot",
    [GO] = "go",
    [GPERF] = "gperf",
    [GRADLE] = "gradle",
    [GROOVY] = "groovy",
    [HASKELL] = "haskell",
    [HTML] = "html",
    [INDENT] = "indent",
    [INI] = "ini",
    [JAVA] = "java",
    [JAVASCRIPT] = "javascript",
    [JSON] = "json",
    [LEX] = "lex",
    [LISP] = "lisp",
    [LUA] = "lua",
    [M4] = "m4",
    [MAIL] = "mail",
    [MAKE] = "make",
    [MARKDOWN] = "markdown",
    [MESON] = "meson",
    [MOONSCRIPT] = "moonscript",
    [NGINX] = "nginx",
    [NIM] = "nim",
    [NINJA] = "ninja",
    [NIX] = "nix",
    [OBJECTIVEC] = "objc",
    [PERL] = "perl",
    [PHP] = "php",
    [PKGCONFIG] = "pkg-config",
    [POSTSCRIPT] = "postscript",
    [PROTOBUF] = "protobuf",
    [PYTHON] = "python",
    [RACKET] = "racket",
    [RESTRUCTUREDTEXT] = "rst",
    [ROBOTSTXT] = "robotstxt",
    [ROFF] = "roff",
    [RUBY] = "ruby",
    [RUST] = "rust",
    [SCALA] = "scala",
    [SCHEME] = "scheme",
    [SCSS] = "scss",
    [SED] = "sed",
    [SHELL] = "sh",
    [SQL] = "sql",
    [TCL] = "tcl",
    [TEXINFO] = "texinfo",
    [TEXMFCNF] = "texmfcnf",
    [TEX] = "tex",
    [TOML] = "toml",
    [TYPESCRIPT] = "typescript",
    [VALA] = "vala",
    [VCARD] = "vcard",
    [VERILOG] = "verilog",
    [VHDL] = "vhdl",
    [VIML] = "viml",
    [XML] = "xml",
    [XRESOURCES] = "xresources",
    [YACC] = "yacc",
    [YAML] = "yaml",
    [ZIG] = "zig",
};

UNITTEST {
    BUG_ON(strcmp(builtin_filetype_names[0], "none") != 0);
    BUG_ON(strcmp(builtin_filetype_names[1], "ada") != 0);
    for (size_t i = 2; i < ARRAY_COUNT(builtin_filetype_names); i++) {
        const char *const name = builtin_filetype_names[i];
        if (name[0] == '\0') {
            BUG("missing value at builtin_filetype_names[%zu]", i);
        }
        // Ensure fixed-size char arrays are null-terminated
        BUG_ON(memchr(name, '\0', sizeof(builtin_filetype_names[0])) == NULL);
        // Ensure FileTypeEnum values are sorted according to their name
        // string (to allow name -> value lookups via binary search).
        const char *const prev = builtin_filetype_names[i - 1];
        if (memcmp(name, prev, 16) < 0) {
            BUG("Filetype names not in sorted order: %s, %s", prev, name);
        }
    }
}
