
<img class='fullsize' alt='Nuosu SIL - Sample' src='https://software.sil.org/wp/wp-content/uploads/2019/03/silyisample.png' />
<!-- [caption]<em>Nuosu SIL</em>[/caption] -->

<h2 id="about">About</h2>

Nuosu SIL is a single Unicode font for the standardized Yi script used by a large ethnic group in southwestern China. The traditional Yi scripts have been in use for centuries, and have a tremendous number of local variants. The script was standardized in the 1970’s by the Chinese government. In the process of standardization, 820 symbols from the traditional scripts of the Liangshan region were chosen to form a syllabary.

The syllable inventory of a speech variety from Xide County, Sichuan was used as the phonological basis for standardization. For the most part there is one symbol per phonologically-distinct syllable and vice-versa. The direction of writing and reading was standardized as left-to-right. Punctuation symbols were borrowed from Chinese, and a diacritic was incorporated into the system to mark one of the tones.

Nuosu SIL includes a complete set of Yi syllables and radicals as defined in the [Unicode Standard](https://www.unicode.org/), plus a basic set of Latin characters and punctuation. Yi radicals which were added to Unicode 3.2 (U+A4A2..U+A4A3, U+A4B4, U+A4C1, U+A4C5) are also included in the font. Representative samples:

<img class='fullsize' alt='Syllables' src='https://software.sil.org/wp/wp-content/uploads/2019/03/silyisyl.png' />
[caption]<em>Syllables</em>[/caption]

<img class='fullsize' alt='Syllables' src='https://software.sil.org/wp/wp-content/uploads/2019/03/silyirad.png' />
[caption]<em>Radicals</em>[/caption]

### Data Conversion

Compiled and uncompiled TECkit [conversion tables](https://github.com/silnrsi/wsresources/tree/master/langs/i/ii-Yiii/mappings) can be downloaded. **YiIPA** maps data using the Yi syllables for input and outputs IPA. **YiPinyin** maps data using Yi syllables for input and outputs romanized syllables (lower case) with spaces between. These maps can be used with [TECkit](https://software.sil.org/teckit/){.external} and/or [SILConverters](https://software.sil.org/silconverters/).

### Keyboarding

The [SIL Yi keyboard](https://keyman.com/keyboards/sil_yi) is also available for the Yi Syllables (U+A000..U+A48F); however, it does not provide keystrokes for the Yi Radicals (U+A490..U+A4CF)."

<h2 id="downloads">Downloads</h2>

### License

This font is licensed under the [SIL Open Font License (OFL)](https://scripts.sil.org/OFL)

<img class='fullsize' alt='SIL Open Font License (OFL)' src='https://software.sil.org/wp/wp-content/uploads/2019/03/OFL_logo_rect_color.png' />

### Current Version

[sil_download style="table" sort="name" where="info.type == 'font'"]

### Release Notes for v2.300

- Fixed character U+FF02 FULLWIDTH QUOTATION MARK by changing encoding to U+FF1F FULLWIDTH QUESTION MARK, and then redrawing U+FF02 to be a quotation mark.
- New punctuation characters U+3018..U+301B, fullwidth form U+FF0D, and halfwidth forms U+FF61..U+FF65.

This font package is also available in the [SIL software repository for Ubuntu](https://packages.sil.org/). Users can subscribe to this software repository and get current versions and updates automatically.

### Previous Versions

[sil_download style="table" sort="-date" where="info.type == 'prev font'"]

[top]

## Information for Contributors

We welcome contributions to this font project, such as new glyphs, enhanced smart font code, or bug fixes. The best way to begin the process is to file an issue in the Github project ([Nuosu](https://github.com/silnrsi/font-nuosu)) or respond to an existing issue and express your interest. Then we can begin to correspond with you regarding what all might be required and discuss how to best submit your contributions.

To enable us to accept contributions in a way that honors your contribution and respects your copyright while preserving long-term flexibility for open source licensing, you would also need to agree to the SIL International Contributor License Agreement for Font Software (v1.0) prior to sending us your contribution. To read more about this requirement and find out how to submit the required form, please visit the [CLA information page](https://software.sil.org/fontcla).

[top]

<h2 id="support">Support</h2>

As these fonts and utilities are distributed at no cost, we are unable to provide a commercial level of personal technical support. We will, however, try to resolve problems that are reported to us.

Before requesting technical support, please **carefully read all the documentation included with the fonts**. It can be found in the documentation folder.

[top]

<h2 id="contact">Contact</h2>

General troubleshooting information, including frequently asked questions, can be found in the documentation. Additional information is also available on the general [Font Help Guides](https://software.sil.org/fonts/guides/) pages.

### Language Software Community

[prodSupport lscpath='c/silfonts']

If that fails to answer your question, or you have a bug report, feature suggestion, or need help using the software, please contact us using the form below.

[contact-form-7 id="408" title="WSTech Products Contact Form"]

[top]
