/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.shaded.IOUtil;
import org.apache.maven.artifact.ant.shaded.WriterFactory;
import org.apache.maven.artifact.ant.shaded.xml.XmlStreamWriter;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WritePomTask
extends Task {
    private String pomRefId;
    private File file;
    private boolean trim = true;

    public void execute() {
        Pom pom = (Pom)((Object)this.getProject().getReference(this.pomRefId));
        Model model = pom.getModel();
        if (this.trim) {
            this.trimModel(model);
        }
        this.writeModel(model, this.file);
    }

    public void trimModel(Model model) {
        model.setBuild(null);
        model.setReporting(null);
        model.setProperties(null);
        model.setRepositories(null);
        model.setPluginRepositories(null);
        model.setProfiles(null);
        model.setDistributionManagement(null);
        model.setModules(null);
    }

    public void writeModel(Model model, File outputFile) throws BuildException {
        XmlStreamWriter fw = null;
        try {
            fw = WriterFactory.newXmlWriter(outputFile);
            new MavenXpp3Writer().write(fw, model);
        }
        catch (IOException e) {
            throw new BuildException("Error writing temporary pom file: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtil.close(fw);
        }
    }

    public void setPomRefId(String pomRefId) {
        this.pomRefId = pomRefId;
    }

    public String getPomRefId() {
        return this.pomRefId;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean isTrim() {
        return this.trim;
    }
}

