//---------------------------------------------------------------------------
//
// "" for ʳβʳβ
// KawariInlineScript -- split --
//
//      Programed by ȡ/NAKAUE.T
//
//  2002.01.07  Phase 7.3     findpos֥ޥɲ (ȡ)
//                            splitޥɲ(ȡ)
//  2002.03.17  Phase 7.9.0   7.9λͤ˹碌 (NAKAUE.T)
//                            splitʤexprȤޤȤƤ뤫˶줷Τǰư
//                            splitѹ
//  2002.11.20  Phase 8.1.0   splitǤʤʤäƤХ
//                            joinɲ
//  2003.11.17  Phase 8.2.0   split̥ڤʸǤХ
//                            split,join:ڤʸάȥ̥ʸ
//  2005.06.21  Phase 8.2.3   ̤bugfix + ̣˱äƽ (suikyo)
//
//---------------------------------------------------------------------------
#include "config.h"
//---------------------------------------------------------------------------
#include "kis/kis_split.h"
//---------------------------------------------------------------------------
#include <string>
using namespace std;
//---------------------------------------------------------------------------
#include "libkawari/kawari_engine.h"
#include "misc/l10n.h"
//---------------------------------------------------------------------------
// splitμ
class TSplitter {
public:
	// source: ڤФʸ
	// delim:  ڤʸ
	TSplitter(const string &source, const string &delim);

	// ΥȡڤФ
	string Next(void);

	// ޤȡ¸ߤ뤫
	inline bool HasNext(void) { return (pos<max); }

private:
	wstring str;		// ڤФʸ
	wstring cs;		// ڤʸ
	wstring::size_type pos;	// ϳϰ
	wstring::size_type max;	// ڤФʸĹ
};
//---------------------------------------------------------------------------
TSplitter::TSplitter(const string &s, const string &c)
{
	str=ctow(s);
	cs=ctow(c);
	pos=static_cast<wstring::size_type>(0);
	max=str.length();
}
//---------------------------------------------------------------------------
string TSplitter::Next(void)
{
	if (!HasNext())
		return "";

	unsigned int idx;	// Υݥ
	string ret;
	if(cs.length()==0){
		// ڤʸ̵
		ret=wtoc(str.substr(pos, 1));
		pos++;
	}else if((idx=str.find(cs, pos))!=string::npos) {
		// ȯ
		ret=wtoc(str.substr(pos,idx-pos));	// ʸ֤뤳Ȥ⤢
		pos=idx+cs.length();			// ڤʸʬݥ
	} else {
		// 饹
		ret=wtoc(str.substr(pos));		// ʸ֤뤳Ȥ⤢
		pos=max;				// ݥ󥿤ʸǸ
	}

	return ret;
}
//---------------------------------------------------------------------------
string KIS_split::Function(const vector<string>& args){

	if(!AssertArgument(args, 3, 4)) return ("");

	TEntry entry=Engine->CreateEntry(args[1]);
	string delim=(args.size()==3)?"":args[3];

	TSplitter splitter(args[2],delim);
	while(splitter.HasNext())
		entry.Push(Engine->CreateStrWord(splitter.Next()));

	return("");
}
//---------------------------------------------------------------------------
string KIS_join::Function(const vector<string>& args)
{
	if(!AssertArgument(args, 2, 3)) return ("");

	TEntry entry=Engine->GetEntry(args[1]);
	unsigned int size=entry.Size();

	string retstr;
	string sep;
	if(args.size()==2) {
		sep="";
	} else {
		sep=args[2];
	}
	for(unsigned int i=0;i<size;i++) {
		retstr+=Engine->IndexParse(entry,i)+sep;
	}

	return(retstr.substr(0,retstr.length()-sep.length()));
}
//---------------------------------------------------------------------------
