# Compatibility policy for kotlinx.coroutines 

All `kotlinx.coroutines` API comes into five flavors: stable, experimental, obsolete, internal and deprecated.
 * **Deprecated** API is marked with `@Deprecated` and will be removed in `1.0.0` release.  
 * **Internal**  API is marked with `@InternalCoroutinesApi`. It is intended to be used only by `kotlinx.coroutines` machinery and can (will) be broken without a warning. If you are using internal API, please tell us what problem you are trying to solve, so we can provide a stable alternative.
 * **Experimental** API is marked with `ExperimentalCoroutinesApi`. Such API may have (known) design issues or we are unsure about its semantics. 
 Roughly speaking, there is a chance that those declarations will be deprecated in the near future or the semantics of their behavior may change in the way that may break some code. In that case, proper migration aid
 will be provided for next several releases alongside with a stable alternative.
 * **Obsolete** API is marked with `@ObsoleteCoroutinesApi`. This API is known to have some serious issues, so it will be replaced with a better alternative.
   In the sense of migration and deprecation, it is equal to experimental.
 * **Stable** API is public API without any annotations. This API is proven to be stable and it is not going to change. If at some point it will be discovered that such API has unfixable design flaws, 
 it will be gradually deprecated with proper replacement and migration aid, but won't be removed for at least a year.

## Migration to 1.0.0 version with Kotlin 1.3

The main difference between Kotlin 1.2 and 1.3 is that coroutines are now 
stable public API, and thus `kotlinx.coroutines` is leaving its "experimental" status. For that reason, future releases of `kotlinx.coroutines` will be available only for Kotlin 1.3.
Version `1.0.0` (starting with its release candidate build) will have all its deprecated declarations removed and `kotlinx.coroutines.experimental` package will be renamed to `kotlinx.coroutines` without functional changes.
In order to migrate `kotlinx.coroutines` to `1.0.0`, follow these steps:

1. Update `kotlinx.coroutines` to `0.30.2` version.
2. Inspect compiler warnings about deprecated API and migrate it to a proposed alternative. Most of deprecated API has a corresponding   replacement which can be applied from IDEA with quickfix.
3. Update Kotlin version to `1.3.0` and `kotlinx.coroutines` to version `0.30.2-eap13`. Then just get rid of `experimental` suffix in all imports.
4. Update `kotlinx.coroutines` to version `1.0.0` or to the corresponding release candidate of it).
 