/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.pdf;

import de.erichseifert.vectorgraphics2d.pdf.PDFObject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.DeflaterOutputStream;

class Stream
implements PDFObject,
Closeable {
    private final ByteArrayOutputStream data = new ByteArrayOutputStream();
    private final List<Filter> filters;
    private OutputStream filteredData;
    private boolean closed;

    public Stream(Filter ... filterArray) {
        this.filters = new ArrayList<Filter>(filterArray.length);
        for (Filter filter : filterArray) {
            this.filters.add(filter);
        }
        this.filteredData = this.data;
        for (Filter filter : filterArray) {
            if (filter != Filter.FLATE) continue;
            this.filteredData = new DeflaterOutputStream(this.filteredData);
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Unable to write to closed stream.");
        }
        try {
            this.filteredData.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to write to ByteArrayOutputStream", iOException);
        }
    }

    public int getLength() {
        if (!this.isClosed()) {
            throw new IllegalStateException("Unable to determine the length of an open Stream. Close the stream first.");
        }
        return this.data.size();
    }

    public byte[] getContent() {
        if (!this.isClosed()) {
            throw new IllegalStateException("Unable to retrive the content of an open Stream. Close the stream first.");
        }
        return this.data.toByteArray();
    }

    private boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.filteredData.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public static enum Filter {
        FLATE;

    }
}

