# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class CGNSReader(MultiBlockDataSetAlgorithm):
    r"""
    CGNSReader - CGNSReader creates a multi-block dataset and reads
    unstructured grids, and structured meshes from binary files stored in
    CGNS file format, with data stored at the nodes or at the cells.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    CGNSReader is inspired by the vis_it CGNS reader originally written
    by B. Whitlock. CGNSReader relies on the low level CGNS API to
    load data_set and reduce memory footprint.
    
    @warning
      ...
    
    @par Thanks: Thanks to .
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCGNSReader, obj, update, **traits)
    
    cache_connectivity = tvtk_base.false_bool_trait(desc=\
        r"""
        This reader can cache the meshconnectivities if they are time
        invariant. They will be stored with a unique reference to their
        /base/zonename and not be read in the file when doing unsteady
        analysis.
        """
    )

    def _cache_connectivity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCacheConnectivity,
                        self.cache_connectivity_)

    cache_mesh = tvtk_base.false_bool_trait(desc=\
        r"""
        This reader can cache the mesh points if they are time invariant.
        They will be stored with a unique reference to their
        /base/zonename and not be read in the file when doing unsteady
        analysis.
        """
    )

    def _cache_mesh_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCacheMesh,
                        self.cache_mesh_)

    create_each_solution_as_block = tvtk_base.false_bool_trait(desc=\
        r"""
        This option is provided for debugging and should not be used for
        production runs as the output data produced may not be correct.
        When set to true, the read will simply read each solution
        (`flow_solution_t`) node encountered in a zone and create a
        separate block under the block corresponding to the zone in the
        output.
        """
    )

    def _create_each_solution_as_block_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCreateEachSolutionAsBlock,
                        self.create_each_solution_as_block_)

    distribute_blocks = tvtk_base.true_bool_trait(desc=\
        r"""
        This reader can support piece requests by distributing each block
        in each zone across ranks (default). To make the reader disregard
        piece request and read all blocks in the zone, set this to false
        (default is true).
        """
    )

    def _distribute_blocks_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDistributeBlocks,
                        self.distribute_blocks_)

    double_precision_mesh = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _double_precision_mesh_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDoublePrecisionMesh,
                        self.double_precision_mesh_)

    ignore_flow_solution_pointers = tvtk_base.false_bool_trait(desc=\
        r"""
        When set to true (default is false), the reader will simply
        ignore `flow_solution_pointers` since they are either incomplete or
        invalid and instead will rely on flow_solution_t nodes being
        labelled as "...at_step<tsindex>" to locate solution nodes for a
        specific timestep. Note, tsindex starts with 1 (not zero).
        
        When set to false, the reader will still try to confirm that at
        least one valid flow_solution_t node is referred to in
        flow_solution_pointers nodes for the current timestep. If none is
        found, then the reader will print out a warning and act as if
        ignore_flow_solution_pointers was set to true. To avoid this
        warning, one should set ignore_flow_solution_pointers to true.
        """
    )

    def _ignore_flow_solution_pointers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIgnoreFlowSolutionPointers,
                        self.ignore_flow_solution_pointers_)

    load_bnd_patch = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/disable loading of boundary condition patches. Defaults to
        false.
        """
    )

    def _load_bnd_patch_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLoadBndPatch,
                        self.load_bnd_patch_)

    load_mesh = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable/disable loading of zone mesh. Defaults to true. It may be
        turned off to load only boundary patches (when load_bnd_patch if
        ON), for example.
        """
    )

    def _load_mesh_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLoadMesh,
                        self.load_mesh_)

    use3d_vector = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable/disable adding an empty physical dimension to vectors in
        case of 2D solutions.
        """
    )

    def _use3d_vector_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUse3DVector,
                        self.use3d_vector_)

    use_unsteady_pattern = tvtk_base.false_bool_trait(desc=\
        r"""
        When set to true (default is false), the reader will try to
        determine to determine flow_solution_t nodes to read with a
        pattern matching This can be useful for unsteady solutions when
        `flow_solution_pointers` are not reliable
        """
    )

    def _use_unsteady_pattern_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseUnsteadyPattern,
                        self.use_unsteady_pattern_)

    def get_base_array_status(self, *args):
        """
        get_base_array_status(self, name:str) -> int
        C++: int get_base_array_status(const char *name)
        API to select bases to read. These calls simply forward to the
        DataArraySelection instance obtained from
        `get_base_selection()`.
        
        By default, 0-th base is enabled and all others are disabled.
        """
        ret = self._wrap_call(self._vtk_obj.GetBaseArrayStatus, *args)
        return ret

    def set_base_array_status(self, *args):
        """
        set_base_array_status(self, name:str, status:int) -> None
        C++: void set_base_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetBaseArrayStatus, *args)
        return ret

    def get_cell_array_status(self, *args):
        """
        get_cell_array_status(self, name:str) -> int
        C++: int get_cell_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayStatus, *args)
        return ret

    def set_cell_array_status(self, *args):
        """
        set_cell_array_status(self, name:str, status:int) -> None
        C++: void set_cell_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetCellArrayStatus, *args)
        return ret

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    def get_family_array_status(self, *args):
        """
        get_family_array_status(self, name:str) -> int
        C++: int get_family_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetFamilyArrayStatus, *args)
        return ret

    def set_family_array_status(self, *args):
        """
        set_family_array_status(self, name:str, status:int) -> None
        C++: void set_family_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetFamilyArrayStatus, *args)
        return ret

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify file name of CGNS datafile to read
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def get_point_array_status(self, *args):
        """
        get_point_array_status(self, name:str) -> int
        C++: int get_point_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayStatus, *args)
        return ret

    def set_point_array_status(self, *args):
        """
        set_point_array_status(self, name:str, status:int) -> None
        C++: void set_point_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetPointArrayStatus, *args)
        return ret

    def get_base_array_name(self, *args):
        """
        get_base_array_name(self, index:int) -> str
        C++: const char *get_base_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetBaseArrayName, *args)
        return ret

    def _get_base_selection(self):
        return wrap_vtk(self._vtk_obj.GetBaseSelection())
    base_selection = traits.Property(_get_base_selection, desc=\
        r"""
        Returns access to the base selection object.
        """
    )

    def get_cell_array_name(self, *args):
        """
        get_cell_array_name(self, index:int) -> str
        C++: const char *get_cell_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayName, *args)
        return ret

    def get_family_array_name(self, *args):
        """
        get_family_array_name(self, index:int) -> str
        C++: const char *get_family_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetFamilyArrayName, *args)
        return ret

    def _get_family_selection(self):
        return wrap_vtk(self._vtk_obj.GetFamilySelection())
    family_selection = traits.Property(_get_family_selection, desc=\
        r"""
        Returns access to the family selection object.
        """
    )

    def _get_number_of_base_arrays(self):
        return self._vtk_obj.GetNumberOfBaseArrays()
    number_of_base_arrays = traits.Property(_get_number_of_base_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_cell_arrays(self):
        return self._vtk_obj.GetNumberOfCellArrays()
    number_of_cell_arrays = traits.Property(_get_number_of_cell_arrays, desc=\
        r"""
        API to get information of cell arrays and enable/disable loading
        of a particular arrays.
        """
    )

    def _get_number_of_family_arrays(self):
        return self._vtk_obj.GetNumberOfFamilyArrays()
    number_of_family_arrays = traits.Property(_get_number_of_family_arrays, desc=\
        r"""
        API to select families to read. These calls simply forward to the
        DataArraySelection instance obtained from
        `get_family_selection()`.
        """
    )

    def _get_number_of_point_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrays()
    number_of_point_arrays = traits.Property(_get_number_of_point_arrays, desc=\
        r"""
        API to get information of point arrays and enable/disable loading
        of a particular arrays.
        """
    )

    def get_point_array_name(self, *args):
        """
        get_point_array_name(self, index:int) -> str
        C++: const char *get_point_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayName, *args)
        return ret

    def broadcast(self, *args):
        """
        broadcast(self, ctrl:MultiProcessController) -> None
        C++: void broadcast(MultiProcessController *ctrl)
        Sends metadata (that read from the input file, not settings
        modified through this API) from the rank 0 node to all other
        processes in a job.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Broadcast, *my_args)
        return ret

    def can_read_file(self, *args):
        """
        can_read_file(self, filename:str) -> int
        C++: int can_read_file(const char *filename)
        Is the given file name a CGNS file?
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def disable_all_bases(self):
        """
        disable_all_bases(self) -> None
        C++: void disable_all_bases()"""
        ret = self._vtk_obj.DisableAllBases()
        return ret
        

    def disable_all_cell_arrays(self):
        """
        disable_all_cell_arrays(self) -> None
        C++: void disable_all_cell_arrays()"""
        ret = self._vtk_obj.DisableAllCellArrays()
        return ret
        

    def disable_all_families(self):
        """
        disable_all_families(self) -> None
        C++: void disable_all_families()"""
        ret = self._vtk_obj.DisableAllFamilies()
        return ret
        

    def disable_all_point_arrays(self):
        """
        disable_all_point_arrays(self) -> None
        C++: void disable_all_point_arrays()"""
        ret = self._vtk_obj.DisableAllPointArrays()
        return ret
        

    def enable_all_bases(self):
        """
        enable_all_bases(self) -> None
        C++: void enable_all_bases()"""
        ret = self._vtk_obj.EnableAllBases()
        return ret
        

    def enable_all_cell_arrays(self):
        """
        enable_all_cell_arrays(self) -> None
        C++: void enable_all_cell_arrays()"""
        ret = self._vtk_obj.EnableAllCellArrays()
        return ret
        

    def enable_all_families(self):
        """
        enable_all_families(self) -> None
        C++: void enable_all_families()"""
        ret = self._vtk_obj.EnableAllFamilies()
        return ret
        

    def enable_all_point_arrays(self):
        """
        enable_all_point_arrays(self) -> None
        C++: void enable_all_point_arrays()"""
        ret = self._vtk_obj.EnableAllPointArrays()
        return ret
        

    def FAMILY(self):
        """
        family() -> InformationStringKey
        C++: static InformationStringKey *family()
        Key used to put a family name in the meta-data associated with a
        node
        """
        ret = wrap_vtk(self._vtk_obj.FAMILY())
        return ret
        

    _updateable_traits_ = \
    (('cache_connectivity', 'GetCacheConnectivity'), ('cache_mesh',
    'GetCacheMesh'), ('create_each_solution_as_block',
    'GetCreateEachSolutionAsBlock'), ('distribute_blocks',
    'GetDistributeBlocks'), ('double_precision_mesh',
    'GetDoublePrecisionMesh'), ('ignore_flow_solution_pointers',
    'GetIgnoreFlowSolutionPointers'), ('load_bnd_patch',
    'GetLoadBndPatch'), ('load_mesh', 'GetLoadMesh'), ('use3d_vector',
    'GetUse3DVector'), ('use_unsteady_pattern', 'GetUseUnsteadyPattern'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'cache_connectivity', 'cache_mesh',
    'create_each_solution_as_block', 'debug', 'distribute_blocks',
    'double_precision_mesh', 'global_warning_display',
    'ignore_flow_solution_pointers', 'load_bnd_patch', 'load_mesh',
    'release_data_flag', 'use3d_vector', 'use_unsteady_pattern',
    'file_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CGNSReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CGNSReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['cache_connectivity', 'cache_mesh',
            'create_each_solution_as_block', 'distribute_blocks',
            'double_precision_mesh', 'ignore_flow_solution_pointers',
            'load_bnd_patch', 'load_mesh', 'use3d_vector',
            'use_unsteady_pattern'], [], ['file_name']),
            title='Edit CGNSReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CGNSReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

