'use strict'

/**
 * PEM
 * @ignore
 */
const privatePKCS1 = `-----BEGIN RSA PRIVATE KEY-----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-----END RSA PRIVATE KEY-----`
const privatePKCS8 = `-----BEGIN PRIVATE KEY-----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-----END PRIVATE KEY-----`
const publicPKCS1 = `-----BEGIN RSA PUBLIC KEY-----
MIICCgKCAgEAsgkUfSQXuPIoucywnKzuNBZhAqVNI3zwi4rqWu0RYmdUmjVEmkIY
jxbibqz0uKe8WFA28nPfT9ybwOg25RXKMNMoKjJJndKp9pnoiYWUMVGOrDwFuNbN
7xoOzvVWA6Fww8gcLh8vepdyprEfLQhfYADyI9mmMnMm7JAfrloV8DlG4FE60yYC
5xPZnpSoeVknqtk1IPdSnSDz1hBGOqwH9wBWDTcAjwYfgCQbxMSvI3Zs3/8y1KTx
0/4VkqyDqUn6pv+3I+y08OC2XlIy+LCNaDPRMBdY+sm45mlMwF4NpQHzrxgO7LYy
rX/tk12ykWZGNkTsA5Xfb9+phKtUhLt5aw3xdgYRz7dAk7EE9APyjKw0B2NHanNp
jdIAJ3istwdxITPk3N1X5n8d+fumiACIHicm8JvrjTfdcwtwA7C0kAQ+CwAjxsZ5
OBJDfeGHHe6lMvWJhGZouTca/Tx94C6z+xxzunhEM38nabIZ9Cc4LDootX+w+GRG
OXCdQKoz6p+41tmHDnIqqwIifY/z9KgdF1GXMixR0SrLh/HK0GanDfYynM0Hmen/
BucpHFwadlNivFnDGIPWtWl8A5yAnRyjMclYM4S+3+2JlYotNfqMfVFaX9YHFsAW
4KTQlXsOK3KptP5ciPm6relMvPqVDr99F2HVEX5e20Cixo20qMg8HgUCAwEAAQ==
-----END RSA PUBLIC KEY-----`
const publicPKCS8 = `-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAsgkUfSQXuPIoucywnKzu
NBZhAqVNI3zwi4rqWu0RYmdUmjVEmkIYjxbibqz0uKe8WFA28nPfT9ybwOg25RXK
MNMoKjJJndKp9pnoiYWUMVGOrDwFuNbN7xoOzvVWA6Fww8gcLh8vepdyprEfLQhf
YADyI9mmMnMm7JAfrloV8DlG4FE60yYC5xPZnpSoeVknqtk1IPdSnSDz1hBGOqwH
9wBWDTcAjwYfgCQbxMSvI3Zs3/8y1KTx0/4VkqyDqUn6pv+3I+y08OC2XlIy+LCN
aDPRMBdY+sm45mlMwF4NpQHzrxgO7LYyrX/tk12ykWZGNkTsA5Xfb9+phKtUhLt5
aw3xdgYRz7dAk7EE9APyjKw0B2NHanNpjdIAJ3istwdxITPk3N1X5n8d+fumiACI
Hicm8JvrjTfdcwtwA7C0kAQ+CwAjxsZ5OBJDfeGHHe6lMvWJhGZouTca/Tx94C6z
+xxzunhEM38nabIZ9Cc4LDootX+w+GRGOXCdQKoz6p+41tmHDnIqqwIifY/z9Kgd
F1GXMixR0SrLh/HK0GanDfYynM0Hmen/BucpHFwadlNivFnDGIPWtWl8A5yAnRyj
MclYM4S+3+2JlYotNfqMfVFaX9YHFsAW4KTQlXsOK3KptP5ciPm6relMvPqVDr99
F2HVEX5e20Cixo20qMg8HgUCAwEAAQ==
-----END PUBLIC KEY-----`

/**
 * JWK
 * @ignore
 */
const privateJwk = `{
  "kty": "RSA",
  "n": "sgkUfSQXuPIoucywnKzuNBZhAqVNI3zwi4rqWu0RYmdUmjVEmkIYjxbibqz0uKe8WFA28nPfT9ybwOg25RXKMNMoKjJJndKp9pnoiYWUMVGOrDwFuNbN7xoOzvVWA6Fww8gcLh8vepdyprEfLQhfYADyI9mmMnMm7JAfrloV8DlG4FE60yYC5xPZnpSoeVknqtk1IPdSnSDz1hBGOqwH9wBWDTcAjwYfgCQbxMSvI3Zs3_8y1KTx0_4VkqyDqUn6pv-3I-y08OC2XlIy-LCNaDPRMBdY-sm45mlMwF4NpQHzrxgO7LYyrX_tk12ykWZGNkTsA5Xfb9-phKtUhLt5aw3xdgYRz7dAk7EE9APyjKw0B2NHanNpjdIAJ3istwdxITPk3N1X5n8d-fumiACIHicm8JvrjTfdcwtwA7C0kAQ-CwAjxsZ5OBJDfeGHHe6lMvWJhGZouTca_Tx94C6z-xxzunhEM38nabIZ9Cc4LDootX-w-GRGOXCdQKoz6p-41tmHDnIqqwIifY_z9KgdF1GXMixR0SrLh_HK0GanDfYynM0Hmen_BucpHFwadlNivFnDGIPWtWl8A5yAnRyjMclYM4S-3-2JlYotNfqMfVFaX9YHFsAW4KTQlXsOK3KptP5ciPm6relMvPqVDr99F2HVEX5e20Cixo20qMg8HgU",
  "e": "AQAB",
  "d": "P4bf6btsP5EhGRNB3dYS9UEbAo-rU8NsLc62yxUWg-9tD818GjMFgmFfELDkbdNkcHrG8IKKJ3wHk7EIjXvV9tAR3-SrwgX-ocDPaerhMyvv5eNRA2CagPviVtTSCV-c1i9cZtS3412RCovfHPmE1sPfow0xsYTHWdgfhd4dP-egM8CoZdmFZaD-oQhYiVxXvC3fOFEoCGtOto5-EMd73BYhnnuG1oIP0XCQ_AhWmifSt6bfI2Nr6wIZ_olSPaDpMJfEaKw48E6upD9ecsDE5G7A8RETrgE22fiu62FkKwHkSxEhmjN1J9WjF1dytVEyMoErWigrX0cGvRFJikc_DmxNA6cL4vC-KvJBJayC-l7lqvnlwKcTEoJzT_NopNW4obpsOyLPheaEzuLwTVPtS-AfXUEIzN8ges00h_yk8is6KOhNJbRQ-okAcuC1N7tcQObbl00Y5AwJgST_RFM_fTFJ9_INkEljQ4aJD1qwknEmFHsGKu3E3TiddeEs1w3_6lawIqtXZgV_74dQ2Q2mCc58RjI91DgcbLm7vpQLGtlC61UVFv1i45oCYlEkX0cVbPr9f4P51Eb80Ns0SWJlM-Jsv6uowLqu8o0Xs9CFh0b-pYXKGD7AiSGM9KU44xiVFocESqNGl77Cm-mAJykrH-sujgEUDgX0R7Hg6_0zqO0",
  "p": "5sDTrL000ixTi_eR86AdqOHh7qW44ixHRu_NW2OSoFJJ9CxiNDTkw6gqBS3YMx0efv_IBgj0Rt-bi_WjkeEgNxArwcwsfDiK4HjeGU07R5s0r7ytYGNVO-Vx8xBZEdpM_v3gWhAV3XeCjN0MZufKUfOGgGg1kSpd1LPurzL149224clohEzqL8eRCpQY5VZdNWroxNYK9zI4XCeGzm2hnsM9dlPzMgxMpKE5vO_ZX5I6KVRt0OXErQ9ARyyum4RbExx--_yGvi0XOm6PrlGbCIzuSlOEXGO8fe_V5vQQ0QlRYT4p3xVvBpG2eEzlP_L7nfklIC6sx0WC4WhH7Txzyw",
  "q": "xYOuGDi-npxh24IPGUfWirnqhUvULF0w8E4wM17hciDUCnDsFYSEO7WvTJR3wBPUD4Cz0YOOElU2SwmQBfzMGGeYWDAa7OYDeDFraLjHxVR_N-cch9d3LCiwqn33iOETW2twTV6TgCDCKDhXbR29Q7AMRYZ1vDhztwf0vH-UYN_LrcEohh51Q-v5TfdzePVYmQOLdwGe1gxQGOlQL-l6IYicMa9IU6EjaKNb7sce1fb57MuaVrUUEIrCkRkSuJ3Er5egsYWZIjpsVfW_cOY7RLK6C05aj3rfuyJ-ubXvC6MXhMj3Hxk1gAQRk0g7QxBoWSbSaok2wtEOfWegmX6bbw",
  "dp": "AnJzDDbpc30i2a4jbxj4l4zlr3k0b7mWe-sZG2n_6RFWVW-PDwysjGKhJ3LoAwrBAwnFXkMEDChc5uwQ8wAXLl5OiHyY0CxtVJoTiOMnyMedlGuEzyvegIcbYT-AIk9VV7LriSj4gmO9D69cbU7x91KEz6HLR6HSYuoRkuwQbX0xbk2LfTOvnBgasqkFZpE25dUfaM74SMzQijGlHVVOTHe3lCSpxJMa0Pggu58zh-7uDPgnPfrhzhAGV3ri0yVhLd-0fQmdiDDEOUto3Kli4oFUGZevJKeuHQvJEezurLjTkxtsqD_68G_lJntyRu5VusQkn6W_EVHsZGWNtbdZZw",
  "dq": "cCerzfk61Jn8P0cFB9fxDWkwsGw0mNR6G5pqaGEyJzpY7WzdwgIzjCxI1HVh4mHgAsWUVh4bqHFWmRle_OdlhV4d9cWrJGYgBjoZwadbWMP4UWgcnU5OT3bzinxo-QLFmR3S8TwJCbKQTYJgsoc2l575-Oi3Jh_wJTiRUhAn0zKBV7LdLftRnzX5pLokicTXgFuw7-ytouHvAZZKgEpVnYETIGtl6IcRsjNA2r-a1OifVkTu6Nl-AT6p6PaR2N9Ndl_lUaiJIhSGu_EFujgh44qRdiYR6nNdY8fcqduTV8pOaoorOS95X63vxPA5JoXEmwseZHxx6gIH9lHHsiFgZQ",
  "qi": "E97gVqDZB4-aj55Z3E8aStwVLt3ho1ohhvCrwx9Tc8q3eV3je9QI4EQL7pHkvroS0uIkalN-blXPvqXr2gV3e7SBP1Bk5ECtfRW6550l1VOOJeNgo-U8OJapJ4E5rpv5K7Y8JXrGwDaLeIH-XrsjJgrcJ6coYSyFFCfbI3ZKzPO_1upiy1v07u68LpwRRLzlNu0QIEJSEer6--A11g1ilZysXKsrZSvxTNxBl-pypuC9oJIrw8ZmlnMxkNDMhppKlpzdzF-d4vaxVulZK5qo3hnH0FtwgPnSB9O8k38GF-XNymyriG0OUNBH5wMD5tdHf6rWCVEO9fpk1EKLMEUpuw"
}`
const publicJwk = `{
  "kty": "RSA",
  "n": "sgkUfSQXuPIoucywnKzuNBZhAqVNI3zwi4rqWu0RYmdUmjVEmkIYjxbibqz0uKe8WFA28nPfT9ybwOg25RXKMNMoKjJJndKp9pnoiYWUMVGOrDwFuNbN7xoOzvVWA6Fww8gcLh8vepdyprEfLQhfYADyI9mmMnMm7JAfrloV8DlG4FE60yYC5xPZnpSoeVknqtk1IPdSnSDz1hBGOqwH9wBWDTcAjwYfgCQbxMSvI3Zs3_8y1KTx0_4VkqyDqUn6pv-3I-y08OC2XlIy-LCNaDPRMBdY-sm45mlMwF4NpQHzrxgO7LYyrX_tk12ykWZGNkTsA5Xfb9-phKtUhLt5aw3xdgYRz7dAk7EE9APyjKw0B2NHanNpjdIAJ3istwdxITPk3N1X5n8d-fumiACIHicm8JvrjTfdcwtwA7C0kAQ-CwAjxsZ5OBJDfeGHHe6lMvWJhGZouTca_Tx94C6z-xxzunhEM38nabIZ9Cc4LDootX-w-GRGOXCdQKoz6p-41tmHDnIqqwIifY_z9KgdF1GXMixR0SrLh_HK0GanDfYynM0Hmen_BucpHFwadlNivFnDGIPWtWl8A5yAnRyjMclYM4S-3-2JlYotNfqMfVFaX9YHFsAW4KTQlXsOK3KptP5ciPm6relMvPqVDr99F2HVEX5e20Cixo20qMg8HgU",
  "e": "AQAB"
}`

/**
 * Export
 * @ignore
 */
module.exports = {
  privatePKCS1,
  privatePKCS8,
  publicPKCS1,
  publicPKCS8,
  privateJwk,
  publicJwk,
}
