/**
 * @file
 *
 * @author jeffrey.daily@gmail.com
 *
 * Copyright (c) 2015 Battelle Memorial Institute.
 *
 * This file was converted to C code from the raw file found at
 * ftp://ftp.cbi.pku.edu.cn/pub/software/blast/matrices/PAM40, the
 * Center for Bioinformatics, Peking University, China.
 */
#ifndef _PARASAIL_PAM40_H_
#define _PARASAIL_PAM40_H_

#include "parasail.h"
#include "pam_map.h"

#ifdef __cplusplus
extern "C" {
#endif

/* # */
/* # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93] */
/* # */
/* # PAM 40 substitution matrix, scale = ln(2)/2 = 0.346574 */
/* # */
/* # Expected score = -4.27, Entropy = 2.26 bits */
/* # */
/* # Lowest score = -15, Highest score = 13 */
/* # */

static const int parasail_pam40_[] = {
/*        A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
/* A */   6, -6, -3, -3, -6, -3, -2, -1, -6, -4, -5, -6, -4, -7, -1,  0,  0,-12, -7, -2, -3, -2, -3,-15,
/* R */  -6,  8, -5, -9, -7, -1, -8, -8, -1, -5, -8,  1, -3, -8, -3, -2, -5, -1, -9, -7, -6, -3, -5,-15,
/* N */  -3, -5,  7,  2, -9, -3, -1, -2,  1, -4, -6,  0, -7, -8, -5,  0, -1, -7, -4, -7,  6, -2, -3,-15,
/* D */  -3, -9,  2,  7,-12, -2,  3, -3, -3, -6,-11, -4, -9,-13, -7, -3, -4,-13,-10, -7,  6,  2, -5,-15,
/* C */  -6, -7, -9,-12,  9,-12,-12, -8, -7, -5,-13,-12,-12,-11, -7, -2, -7,-14, -3, -5,-11,-12, -8,-15,
/* Q */  -3, -1, -3, -2,-12,  8,  2, -6,  1, -7, -4, -2, -3,-11, -2, -4, -5,-11,-10, -6, -2,  6, -4,-15,
/* E */  -2, -8, -1,  3,-12,  2,  7, -3, -4, -5, -8, -4, -6,-12, -5, -4, -5,-15, -8, -6,  2,  6, -4,-15,
/* G */  -1, -8, -2, -3, -8, -6, -3,  6, -8, -9, -9, -6, -7, -8, -5, -1, -5,-13,-12, -5, -2, -4, -4,-15,
/* H */  -6, -1,  1, -3, -7,  1, -4, -8,  9, -8, -5, -5, -9, -5, -3, -5, -6, -6, -3, -6, -1,  0, -4,-15,
/* I */  -4, -5, -4, -6, -5, -7, -5, -9, -8,  8, -1, -5,  0, -2, -7, -6, -2,-12, -5,  2, -5, -5, -4,-15,
/* L */  -5, -8, -6,-11,-13, -4, -8, -9, -5, -1,  7, -7,  1, -2, -6, -7, -6, -5, -6, -2, -8, -6, -5,-15,
/* K */  -6,  1,  0, -4,-12, -2, -4, -6, -5, -5, -7,  6, -1,-12, -6, -3, -2,-10, -8, -8, -2, -3, -4,-15,
/* M */  -4, -3, -7, -9,-12, -3, -6, -7, -9,  0,  1, -1, 11, -3, -7, -5, -3,-11,-10, -1, -8, -4, -4,-15,
/* F */  -7, -8, -8,-13,-11,-11,-12, -8, -5, -2, -2,-12, -3,  9, -9, -6, -8, -4,  2, -7, -9,-12, -7,-15,
/* P */  -1, -3, -5, -7, -7, -2, -5, -5, -3, -7, -6, -6, -7, -9,  8, -1, -3,-12,-12, -5, -6, -3, -4,-15,
/* S */   0, -2,  0, -3, -2, -4, -4, -1, -5, -6, -7, -3, -5, -6, -1,  6,  1, -4, -6, -5, -1, -4, -2,-15,
/* T */   0, -5, -1, -4, -7, -5, -5, -5, -6, -2, -6, -2, -3, -8, -3,  1,  7,-11, -6, -2, -2, -5, -3,-15,
/* W */ -12, -1, -7,-13,-14,-11,-15,-13, -6,-12, -5,-10,-11, -4,-12, -4,-11, 13, -4,-14, -9,-13, -9,-15,
/* Y */  -7, -9, -4,-10, -3,-10, -8,-12, -3, -5, -6, -8,-10,  2,-12, -6, -6, -4, 10, -6, -6, -8, -7,-15,
/* V */  -2, -7, -7, -7, -5, -6, -6, -5, -6,  2, -2, -8, -1, -7, -5, -5, -2,-14, -6,  7, -7, -6, -4,-15,
/* B */  -3, -6,  6,  6,-11, -2,  2, -2, -1, -5, -8, -2, -8, -9, -6, -1, -2, -9, -6, -7,  6,  1, -4,-15,
/* Z */  -2, -3, -2,  2,-12,  6,  6, -4,  0, -5, -6, -3, -4,-12, -3, -4, -5,-13, -8, -6,  1,  6, -4,-15,
/* X */  -3, -5, -3, -5, -8, -4, -4, -4, -4, -4, -5, -4, -4, -7, -4, -2, -3, -9, -7, -4, -4, -4, -4,-15,
/* * */ -15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,  1
};

static const parasail_matrix_t parasail_pam40 = {
    "pam40",
    parasail_pam40_,
    parasail_pam_map,
    24,
    13,
    -15,
    NULL,
    PARASAIL_MATRIX_TYPE_SQUARE,
    24,
    "ARNDCQEGHILKMFPSTWYVBZX*",
    NULL
};

#ifdef __cplusplus
}
#endif

#endif /* _PARASAIL_PAM40_H_ */

