% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readObjectFile.R
\name{readObjectFile}
\alias{readObjectFile}
\alias{saveObjectFile}
\title{Utilities to read and save the object file}
\usage{
readObjectFile(path)

saveObjectFile(path, type, extra = list())
}
\arguments{
\item{path}{Path to the directory representing an object.}

\item{type}{String specifying the type of the object.}

\item{extra}{Named list containing extra metadata to be written to the OBJECT file in \code{path}.
Names should be unique, and any element named \code{"type"} will be overwritten by \code{type}.}
}
\value{
\code{readObjectFile} returns a named list of metadata for \code{path}.

\code{saveObjectFile} saves \code{metadata} to the OBJECT file inside \code{path}
}
\description{
The OBJECT file inside each directory provides some high-level metadata of the object represented by that directory.
It is guaranteed to have a \code{type} property that specifies the object type;
individual objects may add their own information to this file.
These methods are intended for developers to easily read and load information in the OBJECT file.
}
\examples{
tmp <- tempfile()
dir.create(tmp)
saveObjectFile(tmp, "foo", list(bar=list(version="1.0")))
readObjectFile(tmp)

}
\author{
Aaron Lun
}
