% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/350-extractDrugZagrebIndex.R
\name{extractDrugZagrebIndex}
\alias{extractDrugZagrebIndex}
\title{Descriptor that Calculates the Sum of the Squared Atom Degrees
of All Heavy Atoms}
\usage{
extractDrugZagrebIndex(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{Zagreb}.
}
\description{
Descriptor that Calculates the Sum of the Squared Atom Degrees
of All Heavy Atoms
}
\details{
Zagreb index: the sum of the squares of atom degree over
all heavy atoms \code{i}.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugZagrebIndex(mol)
head(dat)}
}
