% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExplanatoryPCs.R
\name{plotExplanatoryPCs}
\alias{plotExplanatoryPCs}
\title{Plot the explanatory PCs for each variable}
\usage{
plotExplanatoryPCs(
  object,
  nvars_to_plot = 10,
  npcs_to_plot = 50,
  theme_size = 10,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object containing expression values and experimental information. 
Alternatively, a matrix containing the output of \code{\link{getExplanatoryPCs}}.}

\item{nvars_to_plot}{Integer scalar specifying the number of variables with the greatest explanatory power to plot.
This can be set to \code{Inf} to show all variables.}

\item{npcs_to_plot}{Integer scalar specifying the number of PCs to plot.}

\item{theme_size}{numeric scalar providing base font size for ggplot theme.}

\item{...}{Parameters to be passed to \code{\link{getExplanatoryPCs}}.}
}
\value{
A ggplot object.
}
\description{
Plot the explanatory PCs for each variable
}
\details{
A density plot is created for each variable, showing the R-squared for each successive PC (up to \code{npcs_to_plot} PCs).
Only the \code{nvars_to_plot} variables with the largest maximum R-squared across PCs are shown.

If \code{object} is a SingleCellExperiment object, \code{\link{getExplanatoryPCs}} will be called to compute the variance in expression explained by each variable in each gene.
Users may prefer to run \code{\link{getExplanatoryPCs}} manually and pass the resulting matrix as \code{object}, in which case the R-squared values are used directly.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)
example_sce <- runPCA(example_sce)

plotExplanatoryPCs(example_sce)
}
