% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegerstolpePancreasData.R
\name{SegerstolpePancreasData}
\alias{SegerstolpePancreasData}
\title{Obtain the Segerstolpe pancreas data}
\usage{
SegerstolpePancreasData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Download the human pancreas single-cell RNA-seq (scRNA-seq) dataset from Segerstolpe et al. (2016)
}
\details{
Row data contains fields for the gene symbol and RefSeq transcript IDs corresponding to each gene.
The rows of the output object are named with the symbol, but note that these are not unique.

Column metadata were extracted from the \code{Characteristics} fields of the SDRF file for ArrayExpress E-MTAB-5061.
This contains information such as the cell type labels and patient status.

Count data for ERCC spike-ins are stored in the \code{"ERCC"} entry of the \code{\link{altExps}}.
Estimated numbers of spike-in molecules are provided in the \code{\link{rowData}} of this entry. 
Note that these concentrations are incorrect for donor H1, as 100 uL of spike-in mixture were added for this donor, rather than 25 uL for all others.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/segerstolpe-pancreas}.
}
\examples{
sce <- SegerstolpePancreasData()

}
\references{
Segerstolpe A et al. (2016). 
Single-cell transcriptome profiling of human pancreatic islets in health and type 2 diabetes. 
\emph{Cell Metab.} 24(4), 593-607.
}
\author{
Aaron Lun
}
