% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_restoretype.R
\name{data_restoretype}
\alias{data_restoretype}
\title{Restore the type of columns according to a reference data frame}
\usage{
data_restoretype(data, reference = NULL, ...)
}
\arguments{
\item{data}{A data frame for which to restore the column types.}

\item{reference}{A reference data frame from which to find the correct
column types. If \code{NULL}, each column is converted to numeric if it doesn't
generate \code{NA}s. For example, \code{c("1", "2")} can be converted to numeric but not
\code{c("Sepal.Length")}.}

\item{...}{Currently not used.}
}
\value{
A data frame with columns whose types have been restored based on the
reference data frame.
}
\description{
Restore the type of columns according to a reference data frame
}
\examples{
data <- data.frame(
  Sepal.Length = c("1", "3", "2"),
  Species = c("setosa", "versicolor", "setosa"),
  New = c("1", "3", "4")
)

fixed <- data_restoretype(data, reference = iris)
summary(fixed)
}
