% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-lahman.R
\name{lahman}
\alias{lahman}
\alias{lahman_sqlite}
\alias{lahman_postgres}
\alias{lahman_mysql}
\alias{copy_lahman}
\alias{has_lahman}
\alias{lahman_srcs}
\title{Cache and retrieve an \code{src_sqlite} of the Lahman baseball database.}
\usage{
lahman_sqlite(path = NULL)

lahman_postgres(dbname = "lahman", host = "localhost", ...)

lahman_mysql(dbname = "lahman", ...)

copy_lahman(con, ...)

has_lahman(type, ...)

lahman_srcs(..., quiet = NULL)
}
\arguments{
\item{...}{Other arguments passed to \code{src} on first
load. For MySQL and PostgreSQL, the defaults assume you have a local
server with \code{lahman} database already created.
For \code{lahman_srcs()}, character vector of names giving srcs to generate.}

\item{type}{src type.}

\item{quiet}{if \code{TRUE}, suppress messages about databases failing to
connect.}
}
\description{
This creates an interesting database using data from the Lahman baseball
data source, provided by Sean Lahman at
\url{http://www.seanlahman.com/baseball-archive/statistics/}, and
made easily available in R through the \pkg{Lahman} package by
Michael Friendly, Dennis Murphy and Martin Monkman. See the documentation
for that package for documentation of the individual tables.
}
\examples{
# Connect to a local sqlite database, if already created
\donttest{
library(dplyr)

if (has_lahman("sqlite")) {
  lahman_sqlite()
  batting <- tbl(lahman_sqlite(), "Batting")
  batting
}

# Connect to a local postgres database with lahman database, if available
if (has_lahman("postgres")) {
  lahman_postgres()
  batting <- tbl(lahman_postgres(), "Batting")
}
}
}
\keyword{internal}
