% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_gev.R
\name{dist_gev}
\alias{dist_gev}
\title{The Generalized Extreme Value Distribution}
\usage{
dist_gev(location, scale, shape)
}
\arguments{
\item{location}{the location parameter \eqn{\mu} of the GEV distribution.}

\item{scale}{the scale parameter \eqn{\sigma} of the GEV distribution.
Must be strictly positive.}

\item{shape}{the shape parameter \eqn{\xi} of the GEV distribution.
Determines the tail behavior: \eqn{\xi = 0} gives Gumbel,
\eqn{\xi > 0} gives Frechet, \eqn{\xi < 0} gives reverse Weibull.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The GEV distribution is widely used in extreme value theory to model
the distribution of maxima (or minima) of samples. The parametric form
encompasses the Gumbel, Frechet, and reverse Weibull distributions.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_gev.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_gev.html}

In the following, let \eqn{X} be a GEV random variable with parameters
\code{location} = \eqn{\mu}, \code{scale} = \eqn{\sigma}, and \code{shape} = \eqn{\xi}.

\strong{Support}:
\itemize{
\item \eqn{x \in \mathbb{R}} (all real numbers) if \eqn{\xi = 0}
\item \eqn{x \geq \mu - \sigma/\xi} if \eqn{\xi > 0}
\item \eqn{x \leq \mu - \sigma/\xi} if \eqn{\xi < 0}
}

\strong{Mean}:
\deqn{
  E(X) = \begin{cases}
    \mu + \sigma \gamma & \text{if } \xi = 0 \\
    \mu + \sigma \frac{\Gamma(1-\xi) - 1}{\xi} & \text{if } \xi < 1 \\
    \infty & \text{if } \xi \geq 1
  \end{cases}
}{
  E(X) = \mu + \sigma \gamma  (if \xi = 0)
        \mu + \sigma (\Gamma(1-\xi) - 1) / \xi  (if \xi < 1)
        Inf  (if \xi >= 1)
}
where \eqn{\gamma \approx 0.5772} is the Euler-Mascheroni constant and
\eqn{\Gamma(\cdot)} is the gamma function.

\strong{Median}:
\deqn{
  \text{Median}(X) = \begin{cases}
    \mu - \sigma \log(\log 2) & \text{if } \xi = 0 \\
    \mu + \sigma \frac{(\log 2)^{-\xi} - 1}{\xi} & \text{if } \xi \neq 0
  \end{cases}
}{
  Median(X) = \mu - \sigma log(log 2)  (if \xi = 0)
              \mu + \sigma (log(2)^(-\xi) - 1) / \xi  (if \xi != 0)
}

\strong{Variance}:
\deqn{
  \text{Var}(X) = \begin{cases}
    \frac{\pi^2 \sigma^2}{6} & \text{if } \xi = 0 \\
    \frac{\sigma^2}{\xi^2} [\Gamma(1-2\xi) - \Gamma(1-\xi)^2] & \text{if } \xi < 0.5 \\
    \infty & \text{if } \xi \geq 0.5
  \end{cases}
}{
  Var(X) = \pi^2 \sigma^2 / 6  (if \xi = 0)
           \sigma^2 [\Gamma(1-2\xi) - \Gamma(1-\xi)^2] / \xi^2  (if \xi < 0.5)
           Inf  (if \xi >= 0.5)
}

\strong{Probability density function (p.d.f)}:

For \eqn{\xi = 0} (Gumbel):
\deqn{
  f(x) = \frac{1}{\sigma} \exp\left(-\frac{x-\mu}{\sigma}\right)
         \exp\left[-\exp\left(-\frac{x-\mu}{\sigma}\right)\right]
}{
  f(x) = (1/\sigma) exp(-(x-\mu)/\sigma) exp(-exp(-(x-\mu)/\sigma))
}

For \eqn{\xi \neq 0}:
\deqn{
  f(x) = \frac{1}{\sigma} \left[1 + \xi\left(\frac{x-\mu}{\sigma}\right)\right]^{-1/\xi-1}
         \exp\left\{-\left[1 + \xi\left(\frac{x-\mu}{\sigma}\right)\right]^{-1/\xi}\right\}
}{
  f(x) = (1/\sigma) [1 + \xi(x-\mu)/\sigma]^(-1/\xi-1) exp(-[1 + \xi(x-\mu)/\sigma]^(-1/\xi))
}
where \eqn{1 + \xi(x-\mu)/\sigma > 0}.

\strong{Cumulative distribution function (c.d.f)}:

For \eqn{\xi = 0} (Gumbel):
\deqn{
  F(x) = \exp\left[-\exp\left(-\frac{x-\mu}{\sigma}\right)\right]
}{
  F(x) = exp(-exp(-(x-\mu)/\sigma))
}

For \eqn{\xi \neq 0}:
\deqn{
  F(x) = \exp\left\{-\left[1+\xi\left(\frac{x-\mu}{\sigma}\right)\right]^{-1/\xi}\right\}
}{
  F(x) = exp(-[1 + \xi(x-\mu)/\sigma]^(-1/\xi))
}
where \eqn{1 + \xi(x-\mu)/\sigma > 0}.

\strong{Quantile function}:

For \eqn{\xi = 0} (Gumbel):
\deqn{
  Q(p) = \mu - \sigma \log(-\log p)
}{
  Q(p) = \mu - \sigma log(-log p)
}

For \eqn{\xi \neq 0}:
\deqn{
  Q(p) = \mu + \frac{\sigma}{\xi}\left[(-\log p)^{-\xi} - 1\right]
}{
  Q(p) = \mu + \sigma [(-log p)^(-\xi) - 1] / \xi
}
}
\examples{
# Create GEV distributions with different shape parameters

# Gumbel distribution (shape = 0)
gumbel <- dist_gev(location = 0, scale = 1, shape = 0)

# Frechet distribution (shape > 0, heavy-tailed)
frechet <- dist_gev(location = 0, scale = 1, shape = 0.3)

# Reverse Weibull distribution (shape < 0, bounded above)
weibull <- dist_gev(location = 0, scale = 1, shape = -0.2)

dist <- c(gumbel, frechet, weibull)
dist

# Statistical properties
mean(dist)
median(dist)
variance(dist)

# Generate random samples
generate(dist, 10)

# Evaluate density
density(dist, 2)
density(dist, 2, log = TRUE)

# Evaluate cumulative distribution
cdf(dist, 4)

# Calculate quantiles
quantile(dist, 0.95)

}
\references{
Jenkinson, A. F. (1955) The frequency distribution of the annual
maximum (or minimum) of meteorological elements. \emph{Quart. J. R. Met. Soc.},
\bold{81}, 158–171.
}
\seealso{
\code{\link[evd:gev]{evd::dgev()}}
}
