% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memoise.R
\name{timeout}
\alias{timeout}
\title{Return a new number after a given number of seconds}
\usage{
timeout(seconds, current = as.numeric(Sys.time()))
}
\arguments{
\item{seconds}{Number of seconds after which to timeout.}

\item{current}{The current time as a numeric.}
}
\value{
A numeric that will remain constant until the seconds have elapsed.
}
\description{
This function will return a number corresponding to the system time and
remain stable until a given number of seconds have elapsed, after which it
will update to the current time. This makes it useful as a way to timeout
and invalidate a memoised cache after a certain period of time.
}
\examples{
a <- function(n) { runif(n) }
memA <- memoise(a, ~timeout(10))
memA(2)
}
\seealso{
\code{\link{memoise}}
}
