% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective.R
\name{mixobjective}
\alias{mixobjective}
\title{Compute objective optimized by mixsqp.}
\usage{
mixobjective(L, x, w = rep(1, nrow(L)))
}
\arguments{
\item{L}{Matrix specifying the optimization problem to be solved.
In the context of mixture-model fitting, \code{L[j,k]} should be
the value of the kth mixture component density at the jth data
point. \code{L} should be a numeric matrix with at least two
columns, with all entries being non-negative and finite (and not
missing). Further, no column should be entirely zeros. For large
matrices, it is preferrable that the matrix is stored in
double-precision; see \code{\link{storage.mode}}.}

\item{x}{The point at which the objective is evaluated in
\code{mixobjective}; see argument \code{x0} in \code{\link{mixsqp}}
for details.}

\item{w}{An optional numeric vector, with one entry for each row of
\code{L}, specifying the "weights" associated with the rows of
\code{L}. All weights must be finite, non-negative and not
missing. Internally, the weights are normalized to sum to 1,
which does not change the problem, but does change the value of the
objective function reported. By default, all weights are equal.}
}
\value{
The value of the objective at \code{x}. If any entry of
\code{L \%*\% x} is less than or equal to zero, \code{Inf} is
returned.
}
\description{
See \code{\link{mixsqp}} for a full description of the
objective function optimized by the mix-SQP algorithm.
}
\seealso{
\code{\link{mixsqp}}
}
