% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cladePar.R
\name{cladePar}
\alias{cladePar}
\title{Utility function to plot.phylo}
\usage{
cladePar(tree, node, edge.color = "red", tip.color = edge.color,
  edge.width = 1, edge.lty = "solid", x = NULL, plot = FALSE, ...)
}
\arguments{
\item{tree}{an object of class phylo.}

\item{node}{the node which is the common ancestor of the clade.}

\item{edge.color}{see plot.phylo.}

\item{tip.color}{see plot.phylo.}

\item{edge.width}{see plot.phylo.}

\item{edge.lty}{see plot.phylo.}

\item{x}{the result of a previous call to cladeInfo.}

\item{plot}{logical, if TRUE the tree is plotted.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
A list containing the information about the edges and tips.
}
\description{
cladePar can help you coloring (choosing edge width/type) of clades.
}
\examples{

tree <- rtree(10)
plot(tree)
nodelabels()
x <- cladePar(tree, 12)
cladePar(tree, 18, "blue", "blue", x=x, plot=TRUE)

}
\seealso{
\code{\link{plot.phylo}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{plot}
