% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_sided.R
\name{get_qq_band}
\alias{get_qq_band}
\title{Create QQ Plot Testing Band}
\usage{
get_qq_band(
  n,
  obs,
  alpha = 0.05,
  distribution = qnorm,
  dparams = list(),
  ell_params = list(),
  band_method = c("ell", "ks", "pointwise"),
  prob_pts_method = c("best_available", "normal", "uniform", "median")
)
}
\arguments{
\item{n, obs}{either a number of observations (specified by setting \code{n}),
or a numeric vector of observations (specified by setting \code{obs}). One
argument must be specified. If all parameters of \code{distribution}
are known, then the testing band only depends on the number of observations \code{n}.
Thus, providing \code{n} is simpler when all parameters
of \code{distribution} are known and specified via \code{dparams}
(or when using all default parameter choices of \code{distribution} is desired).
If estimating parameters from the data is preferred, \code{obs} should be
specified and estimation will take place as described in the documentation for
argument \code{dparams}.}

\item{alpha}{(optional) desired significance level of the testing band. If \code{method}
is set to \code{"ell"} or \code{"ks"}, then this is the global significance
level of the testing band. If \code{method} is set to \code{"pointwise"}, then
the band is equivalent to simply conducting a level \code{alpha} test on each
order statistic individually. Pointwise bands will generally have much
larger global Type I error than \code{alpha}. Defaults to \code{.05}.}

\item{distribution}{The quantile function for the specified distribution.
Defaults to \code{qnorm}, which is appropriate for testing normality
of the observations in a QQ plot.}

\item{dparams}{(optional)  List of additional arguments for the \code{distribution} function
(e.g. df=1). If \code{obs} is not specified and this argument is left blank,
the default arguments of \code{distribution} are used. If \code{obs} is specified and this argument is left blank,
parameters are estimated from the data (except if \code{distribution} is set to \code{qunif},
in which case no estimation occurs and the default parameters are \code{max = 1} and \code{min = 0}).
For the normal distribution, we estimate the mean as the median and the standard deviation as \eqn{Sn} from the paper by Rousseeuw and Croux 1993
"Alternatives to the Median Absolute Deviation". For all other distributions besides uniform and normal,
the code uses MLE to estimate the parameters. Note that if any parameters of the distribution are specified
in \code{dparams}, parameter estimation will not be performed
on the unspecified parameters, and instead they will take on the default values
set by \code{distribution}.}

\item{ell_params}{(optional) list of optional arguments for \code{get_bounds_two_sided}
(i.e. \code{tol}, \code{max_it}, \code{method}). Only used if \code{method}
is set to \code{"ell"}}

\item{band_method}{(optional) method for creating the testing band. The default,
\code{"ell"} uses the equal local levels method
(see \code{get_bounds_two_sided} for more information). \code{"ks"} uses
the Kolmogorov-Smirnov test. \code{"pointwise"} uses a pointwise band (see
documentation for argument \code{alpha} for more information). \code{"ell"}
is recommended and is the default.}

\item{prob_pts_method}{(optional) method used to get probability points for
use in a QQ plot. The quantile function will be applied to these points to
get the expected values.  When this argument is set to \code{"normal"}
(recommended for a normal QQ plot) \code{ppoints(n)} will be used,  which is what
most other plotting software uses. When this argument is set to \code{"uniform"}
(recommended for a uniform QQ plot) \code{ppoints(n, a=0)}, which are the expected
values of the order statistics of Uniform(0, 1), will be used.  Finally,
 when this argument is set to \code{"median"} (recommended for all other
 distributions) \code{qbeta(.5, c(1:n), c(n:1))} will be used. Under the default
 setting, \code{"best_available"}, the probability points as recommended above will
 be used. Note that \code{"median"} is suitable for all distributions and is
 particularly recommended when alpha is large.}
}
\value{
A list with components
\itemize{
  \item lower_bound - Numeric vector of length \code{n} containing the lower bounds
  for the acceptance regions of the test corresponding to each order statistic.
  These form the lower boundary of the testing band for the QQ-plot.
  \item upper_bound - Numeric vector of length \code{n} containing the upper bounds
  for the acceptance regions of the test corresponding to each order statistic.
  These form the upper boundary of the testing band for the QQ-plot.
  \item expected_value - Numeric vector of length \code{n} containing the
  exact or approximate expectation (or median) of each order statistic, depending on how
  \code{prob_pts_method} is set.
  These are the x-coordinates for both the bounds and the data points
  if used in a qq-plot. Note that
  if adding a band to an already existing plot, it is essential that the same
  x-coordinates be used for the bounds as were used to plot the data. Thus,
  if some other x-coordinates have been used to plot the data those same
  x-coordinates should always be used instead of this vector to plot the bounds.
  \item dparams - List of arguments used to apply \code{distribution} to
  \code{obs} (if observations are provided). If the user provides parameters,
  then these parameters will simply be returned. If parameters are estimated
  from the data, then the estimated parameters will be returned.
}
}
\description{
Flexible interface for creating a testing band for a Quantile-Quantile (QQ)
plot.
}
\examples{

# Get ell level .05 QQ testing band for normal(0, 1) distribution with 100 observations
band <- get_qq_band(n = 100)

# Get ell level .05 QQ testing band for normal distribution with unknown parameters
obs <- rnorm(100)
band <- get_qq_band(obs = obs)

# Get ell level .05 QQ testing band for t(2) distribution with 100 observations
band <- get_qq_band(
  n = 100, distribution = qt, dparams = list(df = 2)
)

}
