% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-indicators.R
\name{useBusyIndicators}
\alias{useBusyIndicators}
\title{Enable/disable busy indication}
\usage{
useBusyIndicators(..., spinners = TRUE, pulse = TRUE, fade = TRUE)
}
\arguments{
\item{...}{Currently ignored.}

\item{spinners}{Whether to show a spinner on each calculating/recalculating
output.}

\item{pulse}{Whether to show a pulsing banner at the top of the page when the
app is busy.}

\item{fade}{Whether to fade recalculating outputs. A value of \code{FALSE} is
equivalent to \code{busyIndicatorOptions(fade_opacity=1)}.}
}
\description{
Busy indicators provide a visual cue to users when the server is busy
calculating outputs or otherwise performing tasks (e.g., producing
downloads). When enabled, a spinner is shown on each
calculating/recalculating output, and a pulsing banner is shown at the top of
the page when the app is otherwise busy. Busy indication is enabled by
default for UI created with \pkg{bslib}, but must be enabled otherwise. To
enable/disable, include the result of this function in anywhere in the app's
UI.
}
\details{
When both \code{spinners} and \code{pulse} are set to \code{TRUE}, the pulse is
automatically disabled when spinner(s) are active. When both \code{spinners} and
\code{pulse} are set to \code{FALSE}, no busy indication is shown (other than the
graying out of recalculating outputs).
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(bslib)

ui <- page_fillable(
  useBusyIndicators(),
  card(
    card_header(
      "A plot",
      input_task_button("simulate", "Simulate"),
      class = "d-flex justify-content-between align-items-center"
    ),
    plotOutput("p"),
  )
)

server <- function(input, output) {
  output$p <- renderPlot({
    input$simulate
    Sys.sleep(4)
    plot(x = rnorm(100), y = rnorm(100))
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=busyIndicatorOptions]{busyIndicatorOptions()}} for customizing the appearance of the busy
indicators.
}
