// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Accessible;
use crate::Align;
use crate::Allocation;
use crate::Buildable;
use crate::ConstraintTarget;
use crate::DirectionType;
use crate::EventController;
use crate::LayoutManager;
use crate::Native;
use crate::Orientation;
use crate::Overflow;
use crate::PickFlags;
use crate::Requisition;
use crate::Root;
use crate::Settings;
use crate::SizeRequestMode;
use crate::Snapshot;
use crate::StateFlags;
use crate::StyleContext;
use crate::TextDirection;
use crate::Tooltip;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkWidget")]
    pub struct Widget(Object<ffi::GtkWidget, ffi::GtkWidgetClass>) @implements Accessible, Buildable, ConstraintTarget;

    match fn {
        type_ => || ffi::gtk_widget_get_type(),
    }
}

impl Widget {
    #[doc(alias = "gtk_widget_get_default_direction")]
    #[doc(alias = "get_default_direction")]
    pub fn default_direction() -> TextDirection {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gtk_widget_get_default_direction()) }
    }

    #[doc(alias = "gtk_widget_set_default_direction")]
    pub fn set_default_direction(dir: TextDirection) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_widget_set_default_direction(dir.into_glib());
        }
    }
}

impl fmt::Display for Widget {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&WidgetExt::widget_name(self))
    }
}

pub const NONE_WIDGET: Option<&Widget> = None;

pub trait WidgetExt: 'static {
    #[doc(alias = "gtk_widget_action_set_enabled")]
    fn action_set_enabled(&self, action_name: &str, enabled: bool);

    #[doc(alias = "gtk_widget_activate")]
    fn activate(&self) -> bool;

    #[doc(alias = "gtk_widget_activate_action_variant")]
    #[doc(alias = "activate_action_variant")]
    fn activate_action(&self, name: &str, args: Option<&glib::Variant>) -> bool;

    #[doc(alias = "gtk_widget_activate_default")]
    fn activate_default(&self);

    #[doc(alias = "gtk_widget_add_controller")]
    fn add_controller(&self, controller: &impl IsA<EventController>);

    #[doc(alias = "gtk_widget_add_css_class")]
    fn add_css_class(&self, css_class: &str);

    #[doc(alias = "gtk_widget_add_mnemonic_label")]
    fn add_mnemonic_label(&self, label: &impl IsA<Widget>);

    #[doc(alias = "gtk_widget_allocate")]
    fn allocate(&self, width: i32, height: i32, baseline: i32, transform: Option<&gsk::Transform>);

    #[doc(alias = "gtk_widget_child_focus")]
    fn child_focus(&self, direction: DirectionType) -> bool;

    #[doc(alias = "gtk_widget_compute_bounds")]
    fn compute_bounds(&self, target: &impl IsA<Widget>) -> Option<graphene::Rect>;

    #[doc(alias = "gtk_widget_compute_expand")]
    fn compute_expand(&self, orientation: Orientation) -> bool;

    #[doc(alias = "gtk_widget_compute_point")]
    fn compute_point(
        &self,
        target: &impl IsA<Widget>,
        point: &graphene::Point,
    ) -> Option<graphene::Point>;

    #[doc(alias = "gtk_widget_compute_transform")]
    fn compute_transform(&self, target: &impl IsA<Widget>) -> Option<graphene::Matrix>;

    #[doc(alias = "gtk_widget_contains")]
    fn contains(&self, x: f64, y: f64) -> bool;

    #[doc(alias = "gtk_widget_create_pango_context")]
    fn create_pango_context(&self) -> pango::Context;

    #[doc(alias = "gtk_widget_create_pango_layout")]
    fn create_pango_layout(&self, text: Option<&str>) -> pango::Layout;

    #[doc(alias = "gtk_drag_check_threshold")]
    fn drag_check_threshold(
        &self,
        start_x: i32,
        start_y: i32,
        current_x: i32,
        current_y: i32,
    ) -> bool;

    #[doc(alias = "gtk_widget_error_bell")]
    fn error_bell(&self);

    #[doc(alias = "gtk_widget_get_allocated_baseline")]
    #[doc(alias = "get_allocated_baseline")]
    fn allocated_baseline(&self) -> i32;

    #[doc(alias = "gtk_widget_get_allocated_height")]
    #[doc(alias = "get_allocated_height")]
    fn allocated_height(&self) -> i32;

    #[doc(alias = "gtk_widget_get_allocated_width")]
    #[doc(alias = "get_allocated_width")]
    fn allocated_width(&self) -> i32;

    #[doc(alias = "gtk_widget_get_allocation")]
    #[doc(alias = "get_allocation")]
    fn allocation(&self) -> Allocation;

    #[doc(alias = "gtk_widget_get_ancestor")]
    #[doc(alias = "get_ancestor")]
    fn ancestor(&self, widget_type: glib::types::Type) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_can_focus")]
    #[doc(alias = "get_can_focus")]
    fn can_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_get_can_target")]
    #[doc(alias = "get_can_target")]
    fn can_target(&self) -> bool;

    #[doc(alias = "gtk_widget_get_child_visible")]
    #[doc(alias = "get_child_visible")]
    fn is_child_visible(&self) -> bool;

    #[doc(alias = "gtk_widget_get_clipboard")]
    #[doc(alias = "get_clipboard")]
    fn clipboard(&self) -> gdk::Clipboard;

    #[doc(alias = "gtk_widget_get_css_classes")]
    #[doc(alias = "get_css_classes")]
    fn css_classes(&self) -> Vec<glib::GString>;

    #[doc(alias = "gtk_widget_get_css_name")]
    #[doc(alias = "get_css_name")]
    fn css_name(&self) -> glib::GString;

    #[doc(alias = "gtk_widget_get_cursor")]
    #[doc(alias = "get_cursor")]
    fn cursor(&self) -> Option<gdk::Cursor>;

    #[doc(alias = "gtk_widget_get_direction")]
    #[doc(alias = "get_direction")]
    fn direction(&self) -> TextDirection;

    #[doc(alias = "gtk_widget_get_display")]
    #[doc(alias = "get_display")]
    fn display(&self) -> gdk::Display;

    #[doc(alias = "gtk_widget_get_first_child")]
    #[doc(alias = "get_first_child")]
    fn first_child(&self) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_focus_child")]
    #[doc(alias = "get_focus_child")]
    fn focus_child(&self) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_focus_on_click")]
    #[doc(alias = "get_focus_on_click")]
    fn gets_focus_on_click(&self) -> bool;

    #[doc(alias = "gtk_widget_get_focusable")]
    #[doc(alias = "get_focusable")]
    fn is_focusable(&self) -> bool;

    #[doc(alias = "gtk_widget_get_font_map")]
    #[doc(alias = "get_font_map")]
    fn font_map(&self) -> Option<pango::FontMap>;

    #[doc(alias = "gtk_widget_get_font_options")]
    #[doc(alias = "get_font_options")]
    fn font_options(&self) -> Option<cairo::FontOptions>;

    #[doc(alias = "gtk_widget_get_frame_clock")]
    #[doc(alias = "get_frame_clock")]
    fn frame_clock(&self) -> Option<gdk::FrameClock>;

    #[doc(alias = "gtk_widget_get_halign")]
    #[doc(alias = "get_halign")]
    fn halign(&self) -> Align;

    #[doc(alias = "gtk_widget_get_has_tooltip")]
    #[doc(alias = "get_has_tooltip")]
    fn has_tooltip(&self) -> bool;

    #[doc(alias = "gtk_widget_get_height")]
    #[doc(alias = "get_height")]
    fn height(&self) -> i32;

    #[doc(alias = "gtk_widget_get_hexpand")]
    #[doc(alias = "get_hexpand")]
    fn hexpands(&self) -> bool;

    #[doc(alias = "gtk_widget_get_hexpand_set")]
    #[doc(alias = "get_hexpand_set")]
    fn is_hexpand_set(&self) -> bool;

    #[doc(alias = "gtk_widget_get_last_child")]
    #[doc(alias = "get_last_child")]
    fn last_child(&self) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_layout_manager")]
    #[doc(alias = "get_layout_manager")]
    fn layout_manager(&self) -> Option<LayoutManager>;

    #[doc(alias = "gtk_widget_get_mapped")]
    #[doc(alias = "get_mapped")]
    fn is_mapped(&self) -> bool;

    #[doc(alias = "gtk_widget_get_margin_bottom")]
    #[doc(alias = "get_margin_bottom")]
    fn margin_bottom(&self) -> i32;

    #[doc(alias = "gtk_widget_get_margin_end")]
    #[doc(alias = "get_margin_end")]
    fn margin_end(&self) -> i32;

    #[doc(alias = "gtk_widget_get_margin_start")]
    #[doc(alias = "get_margin_start")]
    fn margin_start(&self) -> i32;

    #[doc(alias = "gtk_widget_get_margin_top")]
    #[doc(alias = "get_margin_top")]
    fn margin_top(&self) -> i32;

    #[doc(alias = "gtk_widget_get_name")]
    #[doc(alias = "get_name")]
    fn widget_name(&self) -> glib::GString;

    #[doc(alias = "gtk_widget_get_native")]
    #[doc(alias = "get_native")]
    fn native(&self) -> Option<Native>;

    #[doc(alias = "gtk_widget_get_next_sibling")]
    #[doc(alias = "get_next_sibling")]
    fn next_sibling(&self) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_opacity")]
    #[doc(alias = "get_opacity")]
    fn opacity(&self) -> f64;

    #[doc(alias = "gtk_widget_get_overflow")]
    #[doc(alias = "get_overflow")]
    fn overflow(&self) -> Overflow;

    #[doc(alias = "gtk_widget_get_pango_context")]
    #[doc(alias = "get_pango_context")]
    fn pango_context(&self) -> pango::Context;

    #[doc(alias = "gtk_widget_get_parent")]
    #[doc(alias = "get_parent")]
    fn parent(&self) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_preferred_size")]
    #[doc(alias = "get_preferred_size")]
    fn preferred_size(&self) -> (Requisition, Requisition);

    #[doc(alias = "gtk_widget_get_prev_sibling")]
    #[doc(alias = "get_prev_sibling")]
    fn prev_sibling(&self) -> Option<Widget>;

    #[doc(alias = "gtk_widget_get_primary_clipboard")]
    #[doc(alias = "get_primary_clipboard")]
    fn primary_clipboard(&self) -> gdk::Clipboard;

    #[doc(alias = "gtk_widget_get_realized")]
    #[doc(alias = "get_realized")]
    fn is_realized(&self) -> bool;

    #[doc(alias = "gtk_widget_get_receives_default")]
    #[doc(alias = "get_receives_default")]
    fn receives_default(&self) -> bool;

    #[doc(alias = "gtk_widget_get_request_mode")]
    #[doc(alias = "get_request_mode")]
    fn request_mode(&self) -> SizeRequestMode;

    #[doc(alias = "gtk_widget_get_root")]
    #[doc(alias = "get_root")]
    fn root(&self) -> Option<Root>;

    #[doc(alias = "gtk_widget_get_scale_factor")]
    #[doc(alias = "get_scale_factor")]
    fn scale_factor(&self) -> i32;

    #[doc(alias = "gtk_widget_get_sensitive")]
    fn get_sensitive(&self) -> bool;

    #[doc(alias = "gtk_widget_get_settings")]
    #[doc(alias = "get_settings")]
    fn settings(&self) -> Settings;

    #[doc(alias = "gtk_widget_get_size")]
    #[doc(alias = "get_size")]
    fn size(&self, orientation: Orientation) -> i32;

    #[doc(alias = "gtk_widget_get_size_request")]
    #[doc(alias = "get_size_request")]
    fn size_request(&self) -> (i32, i32);

    #[doc(alias = "gtk_widget_get_state_flags")]
    #[doc(alias = "get_state_flags")]
    fn state_flags(&self) -> StateFlags;

    #[doc(alias = "gtk_widget_get_style_context")]
    #[doc(alias = "get_style_context")]
    fn style_context(&self) -> StyleContext;

    #[doc(alias = "gtk_widget_get_template_child")]
    #[doc(alias = "get_template_child")]
    fn template_child(&self, widget_type: glib::types::Type, name: &str) -> Option<glib::Object>;

    #[doc(alias = "gtk_widget_get_tooltip_markup")]
    #[doc(alias = "get_tooltip_markup")]
    fn tooltip_markup(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_widget_get_tooltip_text")]
    #[doc(alias = "get_tooltip_text")]
    fn tooltip_text(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_widget_get_valign")]
    #[doc(alias = "get_valign")]
    fn valign(&self) -> Align;

    #[doc(alias = "gtk_widget_get_vexpand")]
    #[doc(alias = "get_vexpand")]
    fn vexpands(&self) -> bool;

    #[doc(alias = "gtk_widget_get_vexpand_set")]
    #[doc(alias = "get_vexpand_set")]
    fn is_vexpand_set(&self) -> bool;

    #[doc(alias = "gtk_widget_get_visible")]
    fn get_visible(&self) -> bool;

    #[doc(alias = "gtk_widget_get_width")]
    #[doc(alias = "get_width")]
    fn width(&self) -> i32;

    #[doc(alias = "gtk_widget_grab_focus")]
    fn grab_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_has_css_class")]
    fn has_css_class(&self, css_class: &str) -> bool;

    #[doc(alias = "gtk_widget_has_default")]
    fn has_default(&self) -> bool;

    #[doc(alias = "gtk_widget_has_focus")]
    fn has_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_has_visible_focus")]
    fn has_visible_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_hide")]
    fn hide(&self);

    #[doc(alias = "gtk_widget_in_destruction")]
    fn in_destruction(&self) -> bool;

    #[doc(alias = "gtk_widget_init_template")]
    fn init_template(&self);

    #[doc(alias = "gtk_widget_insert_action_group")]
    fn insert_action_group(&self, name: &str, group: Option<&impl IsA<gio::ActionGroup>>);

    #[doc(alias = "gtk_widget_insert_after")]
    fn insert_after(&self, parent: &impl IsA<Widget>, previous_sibling: Option<&impl IsA<Widget>>);

    #[doc(alias = "gtk_widget_insert_before")]
    fn insert_before(&self, parent: &impl IsA<Widget>, next_sibling: Option<&impl IsA<Widget>>);

    #[doc(alias = "gtk_widget_is_ancestor")]
    fn is_ancestor(&self, ancestor: &impl IsA<Widget>) -> bool;

    #[doc(alias = "gtk_widget_is_drawable")]
    fn is_drawable(&self) -> bool;

    #[doc(alias = "gtk_widget_is_focus")]
    fn is_focus(&self) -> bool;

    #[doc(alias = "gtk_widget_is_sensitive")]
    fn is_sensitive(&self) -> bool;

    #[doc(alias = "gtk_widget_is_visible")]
    fn is_visible(&self) -> bool;

    #[doc(alias = "gtk_widget_keynav_failed")]
    fn keynav_failed(&self, direction: DirectionType) -> bool;

    #[doc(alias = "gtk_widget_list_mnemonic_labels")]
    fn list_mnemonic_labels(&self) -> Vec<Widget>;

    #[doc(alias = "gtk_widget_map")]
    fn map(&self);

    #[doc(alias = "gtk_widget_measure")]
    fn measure(&self, orientation: Orientation, for_size: i32) -> (i32, i32, i32, i32);

    #[doc(alias = "gtk_widget_mnemonic_activate")]
    fn mnemonic_activate(&self, group_cycling: bool) -> bool;

    #[doc(alias = "gtk_widget_observe_children")]
    fn observe_children(&self) -> gio::ListModel;

    #[doc(alias = "gtk_widget_observe_controllers")]
    fn observe_controllers(&self) -> gio::ListModel;

    #[doc(alias = "gtk_widget_pick")]
    fn pick(&self, x: f64, y: f64, flags: PickFlags) -> Option<Widget>;

    #[doc(alias = "gtk_widget_queue_allocate")]
    fn queue_allocate(&self);

    #[doc(alias = "gtk_widget_queue_draw")]
    fn queue_draw(&self);

    #[doc(alias = "gtk_widget_queue_resize")]
    fn queue_resize(&self);

    #[doc(alias = "gtk_widget_realize")]
    fn realize(&self);

    #[doc(alias = "gtk_widget_remove_controller")]
    fn remove_controller(&self, controller: &impl IsA<EventController>);

    #[doc(alias = "gtk_widget_remove_css_class")]
    fn remove_css_class(&self, css_class: &str);

    #[doc(alias = "gtk_widget_remove_mnemonic_label")]
    fn remove_mnemonic_label(&self, label: &impl IsA<Widget>);

    #[doc(alias = "gtk_widget_set_can_focus")]
    fn set_can_focus(&self, can_focus: bool);

    #[doc(alias = "gtk_widget_set_can_target")]
    fn set_can_target(&self, can_target: bool);

    #[doc(alias = "gtk_widget_set_child_visible")]
    fn set_child_visible(&self, child_visible: bool);

    #[doc(alias = "gtk_widget_set_css_classes")]
    fn set_css_classes(&self, classes: &[&str]);

    #[doc(alias = "gtk_widget_set_cursor")]
    fn set_cursor(&self, cursor: Option<&gdk::Cursor>);

    #[doc(alias = "gtk_widget_set_cursor_from_name")]
    fn set_cursor_from_name(&self, name: Option<&str>);

    #[doc(alias = "gtk_widget_set_direction")]
    fn set_direction(&self, dir: TextDirection);

    #[doc(alias = "gtk_widget_set_focus_child")]
    fn set_focus_child(&self, child: Option<&impl IsA<Widget>>);

    #[doc(alias = "gtk_widget_set_focus_on_click")]
    fn set_focus_on_click(&self, focus_on_click: bool);

    #[doc(alias = "gtk_widget_set_focusable")]
    fn set_focusable(&self, focusable: bool);

    #[doc(alias = "gtk_widget_set_font_map")]
    fn set_font_map(&self, font_map: Option<&impl IsA<pango::FontMap>>);

    #[doc(alias = "gtk_widget_set_font_options")]
    fn set_font_options(&self, options: Option<&cairo::FontOptions>);

    #[doc(alias = "gtk_widget_set_halign")]
    fn set_halign(&self, align: Align);

    #[doc(alias = "gtk_widget_set_has_tooltip")]
    fn set_has_tooltip(&self, has_tooltip: bool);

    #[doc(alias = "gtk_widget_set_hexpand")]
    fn set_hexpand(&self, expand: bool);

    #[doc(alias = "gtk_widget_set_hexpand_set")]
    fn set_hexpand_set(&self, set: bool);

    #[doc(alias = "gtk_widget_set_layout_manager")]
    fn set_layout_manager(&self, layout_manager: Option<&impl IsA<LayoutManager>>);

    #[doc(alias = "gtk_widget_set_margin_bottom")]
    fn set_margin_bottom(&self, margin: i32);

    #[doc(alias = "gtk_widget_set_margin_end")]
    fn set_margin_end(&self, margin: i32);

    #[doc(alias = "gtk_widget_set_margin_start")]
    fn set_margin_start(&self, margin: i32);

    #[doc(alias = "gtk_widget_set_margin_top")]
    fn set_margin_top(&self, margin: i32);

    #[doc(alias = "gtk_widget_set_name")]
    #[doc(alias = "set_name")]
    fn set_widget_name(&self, name: &str);

    #[doc(alias = "gtk_widget_set_opacity")]
    fn set_opacity(&self, opacity: f64);

    #[doc(alias = "gtk_widget_set_overflow")]
    fn set_overflow(&self, overflow: Overflow);

    #[doc(alias = "gtk_widget_set_parent")]
    fn set_parent(&self, parent: &impl IsA<Widget>);

    #[doc(alias = "gtk_widget_set_receives_default")]
    fn set_receives_default(&self, receives_default: bool);

    #[doc(alias = "gtk_widget_set_sensitive")]
    fn set_sensitive(&self, sensitive: bool);

    #[doc(alias = "gtk_widget_set_size_request")]
    fn set_size_request(&self, width: i32, height: i32);

    #[doc(alias = "gtk_widget_set_state_flags")]
    fn set_state_flags(&self, flags: StateFlags, clear: bool);

    #[doc(alias = "gtk_widget_set_tooltip_markup")]
    fn set_tooltip_markup(&self, markup: Option<&str>);

    #[doc(alias = "gtk_widget_set_tooltip_text")]
    fn set_tooltip_text(&self, text: Option<&str>);

    #[doc(alias = "gtk_widget_set_valign")]
    fn set_valign(&self, align: Align);

    #[doc(alias = "gtk_widget_set_vexpand")]
    fn set_vexpand(&self, expand: bool);

    #[doc(alias = "gtk_widget_set_vexpand_set")]
    fn set_vexpand_set(&self, set: bool);

    #[doc(alias = "gtk_widget_set_visible")]
    fn set_visible(&self, visible: bool);

    #[doc(alias = "gtk_widget_should_layout")]
    fn should_layout(&self) -> bool;

    #[doc(alias = "gtk_widget_show")]
    fn show(&self);

    #[doc(alias = "gtk_widget_size_allocate")]
    fn size_allocate(&self, allocation: &Allocation, baseline: i32);

    #[doc(alias = "gtk_widget_snapshot_child")]
    fn snapshot_child(&self, child: &impl IsA<Widget>, snapshot: &Snapshot);

    #[doc(alias = "gtk_widget_translate_coordinates")]
    fn translate_coordinates(
        &self,
        dest_widget: &impl IsA<Widget>,
        src_x: f64,
        src_y: f64,
    ) -> Option<(f64, f64)>;

    #[doc(alias = "gtk_widget_trigger_tooltip_query")]
    fn trigger_tooltip_query(&self);

    #[doc(alias = "gtk_widget_unmap")]
    fn unmap(&self);

    #[doc(alias = "gtk_widget_unparent")]
    fn unparent(&self);

    #[doc(alias = "gtk_widget_unrealize")]
    fn unrealize(&self);

    #[doc(alias = "gtk_widget_unset_state_flags")]
    fn unset_state_flags(&self, flags: StateFlags);

    #[doc(alias = "height-request")]
    fn height_request(&self) -> i32;

    #[doc(alias = "height-request")]
    fn set_height_request(&self, height_request: i32);

    #[doc(alias = "width-request")]
    fn width_request(&self) -> i32;

    #[doc(alias = "width-request")]
    fn set_width_request(&self, width_request: i32);

    #[doc(alias = "destroy")]
    fn connect_destroy<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "direction-changed")]
    fn connect_direction_changed<F: Fn(&Self, TextDirection) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "hide")]
    fn connect_hide<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "keynav-failed")]
    fn connect_keynav_failed<F: Fn(&Self, DirectionType) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "map")]
    fn connect_map<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mnemonic-activate")]
    fn connect_mnemonic_activate<F: Fn(&Self, bool) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "move-focus")]
    fn connect_move_focus<F: Fn(&Self, DirectionType) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_move_focus(&self, direction: DirectionType);

    #[doc(alias = "query-tooltip")]
    fn connect_query_tooltip<F: Fn(&Self, i32, i32, bool, &Tooltip) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "realize")]
    fn connect_realize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show")]
    fn connect_show<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "state-flags-changed")]
    fn connect_state_flags_changed<F: Fn(&Self, StateFlags) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "unmap")]
    fn connect_unmap<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "unrealize")]
    fn connect_unrealize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "can-focus")]
    fn connect_can_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "can-target")]
    fn connect_can_target_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "css-classes")]
    fn connect_css_classes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor")]
    fn connect_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "focus-on-click")]
    fn connect_focus_on_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "focusable")]
    fn connect_focusable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "halign")]
    fn connect_halign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-default")]
    fn connect_has_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-focus")]
    fn connect_has_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-tooltip")]
    fn connect_has_tooltip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "height-request")]
    fn connect_height_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hexpand")]
    fn connect_hexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hexpand-set")]
    fn connect_hexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "layout-manager")]
    fn connect_layout_manager_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin-bottom")]
    fn connect_margin_bottom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin-end")]
    fn connect_margin_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin-start")]
    fn connect_margin_start_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "margin-top")]
    fn connect_margin_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "name")]
    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "opacity")]
    fn connect_opacity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "overflow")]
    fn connect_overflow_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "parent")]
    fn connect_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "receives-default")]
    fn connect_receives_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "root")]
    fn connect_root_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scale-factor")]
    fn connect_scale_factor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "sensitive")]
    fn connect_sensitive_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tooltip-markup")]
    fn connect_tooltip_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tooltip-text")]
    fn connect_tooltip_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "valign")]
    fn connect_valign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "vexpand")]
    fn connect_vexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "vexpand-set")]
    fn connect_vexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "visible")]
    fn connect_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "width-request")]
    fn connect_width_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Widget>> WidgetExt for O {
    fn action_set_enabled(&self, action_name: &str, enabled: bool) {
        unsafe {
            ffi::gtk_widget_action_set_enabled(
                self.as_ref().to_glib_none().0,
                action_name.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    fn activate(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_activate(self.as_ref().to_glib_none().0)) }
    }

    fn activate_action(&self, name: &str, args: Option<&glib::Variant>) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_activate_action_variant(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                args.to_glib_none().0,
            ))
        }
    }

    fn activate_default(&self) {
        unsafe {
            ffi::gtk_widget_activate_default(self.as_ref().to_glib_none().0);
        }
    }

    fn add_controller(&self, controller: &impl IsA<EventController>) {
        unsafe {
            ffi::gtk_widget_add_controller(
                self.as_ref().to_glib_none().0,
                controller.as_ref().to_glib_full(),
            );
        }
    }

    fn add_css_class(&self, css_class: &str) {
        unsafe {
            ffi::gtk_widget_add_css_class(
                self.as_ref().to_glib_none().0,
                css_class.to_glib_none().0,
            );
        }
    }

    fn add_mnemonic_label(&self, label: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_add_mnemonic_label(
                self.as_ref().to_glib_none().0,
                label.as_ref().to_glib_none().0,
            );
        }
    }

    fn allocate(&self, width: i32, height: i32, baseline: i32, transform: Option<&gsk::Transform>) {
        unsafe {
            ffi::gtk_widget_allocate(
                self.as_ref().to_glib_none().0,
                width,
                height,
                baseline,
                transform.to_glib_full(),
            );
        }
    }

    fn child_focus(&self, direction: DirectionType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_child_focus(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    fn compute_bounds(&self, target: &impl IsA<Widget>) -> Option<graphene::Rect> {
        unsafe {
            let mut out_bounds = graphene::Rect::uninitialized();
            let ret = from_glib(ffi::gtk_widget_compute_bounds(
                self.as_ref().to_glib_none().0,
                target.as_ref().to_glib_none().0,
                out_bounds.to_glib_none_mut().0,
            ));
            if ret {
                Some(out_bounds)
            } else {
                None
            }
        }
    }

    fn compute_expand(&self, orientation: Orientation) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_compute_expand(
                self.as_ref().to_glib_none().0,
                orientation.into_glib(),
            ))
        }
    }

    fn compute_point(
        &self,
        target: &impl IsA<Widget>,
        point: &graphene::Point,
    ) -> Option<graphene::Point> {
        unsafe {
            let mut out_point = graphene::Point::uninitialized();
            let ret = from_glib(ffi::gtk_widget_compute_point(
                self.as_ref().to_glib_none().0,
                target.as_ref().to_glib_none().0,
                point.to_glib_none().0,
                out_point.to_glib_none_mut().0,
            ));
            if ret {
                Some(out_point)
            } else {
                None
            }
        }
    }

    fn compute_transform(&self, target: &impl IsA<Widget>) -> Option<graphene::Matrix> {
        unsafe {
            let mut out_transform = graphene::Matrix::uninitialized();
            let ret = from_glib(ffi::gtk_widget_compute_transform(
                self.as_ref().to_glib_none().0,
                target.as_ref().to_glib_none().0,
                out_transform.to_glib_none_mut().0,
            ));
            if ret {
                Some(out_transform)
            } else {
                None
            }
        }
    }

    fn contains(&self, x: f64, y: f64) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_contains(
                self.as_ref().to_glib_none().0,
                x,
                y,
            ))
        }
    }

    fn create_pango_context(&self) -> pango::Context {
        unsafe {
            from_glib_full(ffi::gtk_widget_create_pango_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn create_pango_layout(&self, text: Option<&str>) -> pango::Layout {
        unsafe {
            from_glib_full(ffi::gtk_widget_create_pango_layout(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
            ))
        }
    }

    fn drag_check_threshold(
        &self,
        start_x: i32,
        start_y: i32,
        current_x: i32,
        current_y: i32,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_drag_check_threshold(
                self.as_ref().to_glib_none().0,
                start_x,
                start_y,
                current_x,
                current_y,
            ))
        }
    }

    fn error_bell(&self) {
        unsafe {
            ffi::gtk_widget_error_bell(self.as_ref().to_glib_none().0);
        }
    }

    fn allocated_baseline(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_baseline(self.as_ref().to_glib_none().0) }
    }

    fn allocated_height(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_height(self.as_ref().to_glib_none().0) }
    }

    fn allocated_width(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_width(self.as_ref().to_glib_none().0) }
    }

    fn allocation(&self) -> Allocation {
        unsafe {
            let mut allocation = Allocation::uninitialized();
            ffi::gtk_widget_get_allocation(
                self.as_ref().to_glib_none().0,
                allocation.to_glib_none_mut().0,
            );
            allocation
        }
    }

    fn ancestor(&self, widget_type: glib::types::Type) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_ancestor(
                self.as_ref().to_glib_none().0,
                widget_type.into_glib(),
            ))
        }
    }

    fn can_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_can_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn can_target(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_can_target(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_child_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_child_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn clipboard(&self) -> gdk::Clipboard {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_clipboard(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn css_classes(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_widget_get_css_classes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn css_name(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_widget_get_css_name(self.as_ref().to_glib_none().0)) }
    }

    fn cursor(&self) -> Option<gdk::Cursor> {
        unsafe { from_glib_none(ffi::gtk_widget_get_cursor(self.as_ref().to_glib_none().0)) }
    }

    fn direction(&self) -> TextDirection {
        unsafe {
            from_glib(ffi::gtk_widget_get_direction(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn display(&self) -> gdk::Display {
        unsafe { from_glib_none(ffi::gtk_widget_get_display(self.as_ref().to_glib_none().0)) }
    }

    fn first_child(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_first_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn focus_child(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_focus_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn gets_focus_on_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_focus_on_click(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_focusable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_focusable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn font_map(&self) -> Option<pango::FontMap> {
        unsafe { from_glib_none(ffi::gtk_widget_get_font_map(self.as_ref().to_glib_none().0)) }
    }

    fn font_options(&self) -> Option<cairo::FontOptions> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_font_options(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn frame_clock(&self) -> Option<gdk::FrameClock> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_frame_clock(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn halign(&self) -> Align {
        unsafe { from_glib(ffi::gtk_widget_get_halign(self.as_ref().to_glib_none().0)) }
    }

    fn has_tooltip(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_has_tooltip(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn height(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_height(self.as_ref().to_glib_none().0) }
    }

    fn hexpands(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_hexpand(self.as_ref().to_glib_none().0)) }
    }

    fn is_hexpand_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_hexpand_set(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn last_child(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_last_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn layout_manager(&self) -> Option<LayoutManager> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_layout_manager(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_mapped(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_mapped(self.as_ref().to_glib_none().0)) }
    }

    fn margin_bottom(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_bottom(self.as_ref().to_glib_none().0) }
    }

    fn margin_end(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_end(self.as_ref().to_glib_none().0) }
    }

    fn margin_start(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_start(self.as_ref().to_glib_none().0) }
    }

    fn margin_top(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_top(self.as_ref().to_glib_none().0) }
    }

    fn widget_name(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_widget_get_name(self.as_ref().to_glib_none().0)) }
    }

    fn native(&self) -> Option<Native> {
        unsafe { from_glib_none(ffi::gtk_widget_get_native(self.as_ref().to_glib_none().0)) }
    }

    fn next_sibling(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_next_sibling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn opacity(&self) -> f64 {
        unsafe { ffi::gtk_widget_get_opacity(self.as_ref().to_glib_none().0) }
    }

    fn overflow(&self) -> Overflow {
        unsafe { from_glib(ffi::gtk_widget_get_overflow(self.as_ref().to_glib_none().0)) }
    }

    fn pango_context(&self) -> pango::Context {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_pango_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn parent(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_widget_get_parent(self.as_ref().to_glib_none().0)) }
    }

    fn preferred_size(&self) -> (Requisition, Requisition) {
        unsafe {
            let mut minimum_size = Requisition::uninitialized();
            let mut natural_size = Requisition::uninitialized();
            ffi::gtk_widget_get_preferred_size(
                self.as_ref().to_glib_none().0,
                minimum_size.to_glib_none_mut().0,
                natural_size.to_glib_none_mut().0,
            );
            (minimum_size, natural_size)
        }
    }

    fn prev_sibling(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_prev_sibling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn primary_clipboard(&self) -> gdk::Clipboard {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_primary_clipboard(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_realized(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_realized(self.as_ref().to_glib_none().0)) }
    }

    fn receives_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_receives_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn request_mode(&self) -> SizeRequestMode {
        unsafe {
            from_glib(ffi::gtk_widget_get_request_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn root(&self) -> Option<Root> {
        unsafe { from_glib_none(ffi::gtk_widget_get_root(self.as_ref().to_glib_none().0)) }
    }

    fn scale_factor(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_scale_factor(self.as_ref().to_glib_none().0) }
    }

    fn get_sensitive(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_sensitive(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn settings(&self) -> Settings {
        unsafe { from_glib_none(ffi::gtk_widget_get_settings(self.as_ref().to_glib_none().0)) }
    }

    fn size(&self, orientation: Orientation) -> i32 {
        unsafe { ffi::gtk_widget_get_size(self.as_ref().to_glib_none().0, orientation.into_glib()) }
    }

    fn size_request(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_size_request(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            let width = width.assume_init();
            let height = height.assume_init();
            (width, height)
        }
    }

    fn state_flags(&self) -> StateFlags {
        unsafe {
            from_glib(ffi::gtk_widget_get_state_flags(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn style_context(&self) -> StyleContext {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_style_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn template_child(&self, widget_type: glib::types::Type, name: &str) -> Option<glib::Object> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_template_child(
                self.as_ref().to_glib_none().0,
                widget_type.into_glib(),
                name.to_glib_none().0,
            ))
        }
    }

    fn tooltip_markup(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_tooltip_markup(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tooltip_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_tooltip_text(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn valign(&self) -> Align {
        unsafe { from_glib(ffi::gtk_widget_get_valign(self.as_ref().to_glib_none().0)) }
    }

    fn vexpands(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_vexpand(self.as_ref().to_glib_none().0)) }
    }

    fn is_vexpand_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_vexpand_set(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_visible(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_visible(self.as_ref().to_glib_none().0)) }
    }

    fn width(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_width(self.as_ref().to_glib_none().0) }
    }

    fn grab_focus(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_grab_focus(self.as_ref().to_glib_none().0)) }
    }

    fn has_css_class(&self, css_class: &str) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_css_class(
                self.as_ref().to_glib_none().0,
                css_class.to_glib_none().0,
            ))
        }
    }

    fn has_default(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_has_default(self.as_ref().to_glib_none().0)) }
    }

    fn has_focus(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_has_focus(self.as_ref().to_glib_none().0)) }
    }

    fn has_visible_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_visible_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hide(&self) {
        unsafe {
            ffi::gtk_widget_hide(self.as_ref().to_glib_none().0);
        }
    }

    fn in_destruction(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_in_destruction(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn init_template(&self) {
        unsafe {
            ffi::gtk_widget_init_template(self.as_ref().to_glib_none().0);
        }
    }

    fn insert_action_group(&self, name: &str, group: Option<&impl IsA<gio::ActionGroup>>) {
        unsafe {
            ffi::gtk_widget_insert_action_group(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                group.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn insert_after(&self, parent: &impl IsA<Widget>, previous_sibling: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_widget_insert_after(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
                previous_sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn insert_before(&self, parent: &impl IsA<Widget>, next_sibling: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_widget_insert_before(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
                next_sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn is_ancestor(&self, ancestor: &impl IsA<Widget>) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_ancestor(
                self.as_ref().to_glib_none().0,
                ancestor.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_drawable(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_drawable(self.as_ref().to_glib_none().0)) }
    }

    fn is_focus(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_focus(self.as_ref().to_glib_none().0)) }
    }

    fn is_sensitive(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_sensitive(self.as_ref().to_glib_none().0)) }
    }

    fn is_visible(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_visible(self.as_ref().to_glib_none().0)) }
    }

    fn keynav_failed(&self, direction: DirectionType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_keynav_failed(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    fn list_mnemonic_labels(&self) -> Vec<Widget> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_widget_list_mnemonic_labels(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn map(&self) {
        unsafe {
            ffi::gtk_widget_map(self.as_ref().to_glib_none().0);
        }
    }

    fn measure(&self, orientation: Orientation, for_size: i32) -> (i32, i32, i32, i32) {
        unsafe {
            let mut minimum = mem::MaybeUninit::uninit();
            let mut natural = mem::MaybeUninit::uninit();
            let mut minimum_baseline = mem::MaybeUninit::uninit();
            let mut natural_baseline = mem::MaybeUninit::uninit();
            ffi::gtk_widget_measure(
                self.as_ref().to_glib_none().0,
                orientation.into_glib(),
                for_size,
                minimum.as_mut_ptr(),
                natural.as_mut_ptr(),
                minimum_baseline.as_mut_ptr(),
                natural_baseline.as_mut_ptr(),
            );
            let minimum = minimum.assume_init();
            let natural = natural.assume_init();
            let minimum_baseline = minimum_baseline.assume_init();
            let natural_baseline = natural_baseline.assume_init();
            (minimum, natural, minimum_baseline, natural_baseline)
        }
    }

    fn mnemonic_activate(&self, group_cycling: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_mnemonic_activate(
                self.as_ref().to_glib_none().0,
                group_cycling.into_glib(),
            ))
        }
    }

    fn observe_children(&self) -> gio::ListModel {
        unsafe {
            from_glib_full(ffi::gtk_widget_observe_children(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn observe_controllers(&self) -> gio::ListModel {
        unsafe {
            from_glib_full(ffi::gtk_widget_observe_controllers(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn pick(&self, x: f64, y: f64, flags: PickFlags) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_pick(
                self.as_ref().to_glib_none().0,
                x,
                y,
                flags.into_glib(),
            ))
        }
    }

    fn queue_allocate(&self) {
        unsafe {
            ffi::gtk_widget_queue_allocate(self.as_ref().to_glib_none().0);
        }
    }

    fn queue_draw(&self) {
        unsafe {
            ffi::gtk_widget_queue_draw(self.as_ref().to_glib_none().0);
        }
    }

    fn queue_resize(&self) {
        unsafe {
            ffi::gtk_widget_queue_resize(self.as_ref().to_glib_none().0);
        }
    }

    fn realize(&self) {
        unsafe {
            ffi::gtk_widget_realize(self.as_ref().to_glib_none().0);
        }
    }

    fn remove_controller(&self, controller: &impl IsA<EventController>) {
        unsafe {
            ffi::gtk_widget_remove_controller(
                self.as_ref().to_glib_none().0,
                controller.as_ref().to_glib_none().0,
            );
        }
    }

    fn remove_css_class(&self, css_class: &str) {
        unsafe {
            ffi::gtk_widget_remove_css_class(
                self.as_ref().to_glib_none().0,
                css_class.to_glib_none().0,
            );
        }
    }

    fn remove_mnemonic_label(&self, label: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_remove_mnemonic_label(
                self.as_ref().to_glib_none().0,
                label.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_can_focus(&self, can_focus: bool) {
        unsafe {
            ffi::gtk_widget_set_can_focus(self.as_ref().to_glib_none().0, can_focus.into_glib());
        }
    }

    fn set_can_target(&self, can_target: bool) {
        unsafe {
            ffi::gtk_widget_set_can_target(self.as_ref().to_glib_none().0, can_target.into_glib());
        }
    }

    fn set_child_visible(&self, child_visible: bool) {
        unsafe {
            ffi::gtk_widget_set_child_visible(
                self.as_ref().to_glib_none().0,
                child_visible.into_glib(),
            );
        }
    }

    fn set_css_classes(&self, classes: &[&str]) {
        unsafe {
            ffi::gtk_widget_set_css_classes(
                self.as_ref().to_glib_none().0,
                classes.to_glib_none().0,
            );
        }
    }

    fn set_cursor(&self, cursor: Option<&gdk::Cursor>) {
        unsafe {
            ffi::gtk_widget_set_cursor(self.as_ref().to_glib_none().0, cursor.to_glib_none().0);
        }
    }

    fn set_cursor_from_name(&self, name: Option<&str>) {
        unsafe {
            ffi::gtk_widget_set_cursor_from_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    fn set_direction(&self, dir: TextDirection) {
        unsafe {
            ffi::gtk_widget_set_direction(self.as_ref().to_glib_none().0, dir.into_glib());
        }
    }

    fn set_focus_child(&self, child: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_widget_set_focus_child(
                self.as_ref().to_glib_none().0,
                child.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_focus_on_click(&self, focus_on_click: bool) {
        unsafe {
            ffi::gtk_widget_set_focus_on_click(
                self.as_ref().to_glib_none().0,
                focus_on_click.into_glib(),
            );
        }
    }

    fn set_focusable(&self, focusable: bool) {
        unsafe {
            ffi::gtk_widget_set_focusable(self.as_ref().to_glib_none().0, focusable.into_glib());
        }
    }

    fn set_font_map(&self, font_map: Option<&impl IsA<pango::FontMap>>) {
        unsafe {
            ffi::gtk_widget_set_font_map(
                self.as_ref().to_glib_none().0,
                font_map.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_font_options(&self, options: Option<&cairo::FontOptions>) {
        unsafe {
            ffi::gtk_widget_set_font_options(
                self.as_ref().to_glib_none().0,
                options.to_glib_none().0,
            );
        }
    }

    fn set_halign(&self, align: Align) {
        unsafe {
            ffi::gtk_widget_set_halign(self.as_ref().to_glib_none().0, align.into_glib());
        }
    }

    fn set_has_tooltip(&self, has_tooltip: bool) {
        unsafe {
            ffi::gtk_widget_set_has_tooltip(
                self.as_ref().to_glib_none().0,
                has_tooltip.into_glib(),
            );
        }
    }

    fn set_hexpand(&self, expand: bool) {
        unsafe {
            ffi::gtk_widget_set_hexpand(self.as_ref().to_glib_none().0, expand.into_glib());
        }
    }

    fn set_hexpand_set(&self, set: bool) {
        unsafe {
            ffi::gtk_widget_set_hexpand_set(self.as_ref().to_glib_none().0, set.into_glib());
        }
    }

    fn set_layout_manager(&self, layout_manager: Option<&impl IsA<LayoutManager>>) {
        unsafe {
            ffi::gtk_widget_set_layout_manager(
                self.as_ref().to_glib_none().0,
                layout_manager.map(|p| p.as_ref()).to_glib_full(),
            );
        }
    }

    fn set_margin_bottom(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_bottom(self.as_ref().to_glib_none().0, margin);
        }
    }

    fn set_margin_end(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_end(self.as_ref().to_glib_none().0, margin);
        }
    }

    fn set_margin_start(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_start(self.as_ref().to_glib_none().0, margin);
        }
    }

    fn set_margin_top(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_top(self.as_ref().to_glib_none().0, margin);
        }
    }

    fn set_widget_name(&self, name: &str) {
        unsafe {
            ffi::gtk_widget_set_name(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn set_opacity(&self, opacity: f64) {
        unsafe {
            ffi::gtk_widget_set_opacity(self.as_ref().to_glib_none().0, opacity);
        }
    }

    fn set_overflow(&self, overflow: Overflow) {
        unsafe {
            ffi::gtk_widget_set_overflow(self.as_ref().to_glib_none().0, overflow.into_glib());
        }
    }

    fn set_parent(&self, parent: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_set_parent(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_receives_default(&self, receives_default: bool) {
        unsafe {
            ffi::gtk_widget_set_receives_default(
                self.as_ref().to_glib_none().0,
                receives_default.into_glib(),
            );
        }
    }

    fn set_sensitive(&self, sensitive: bool) {
        unsafe {
            ffi::gtk_widget_set_sensitive(self.as_ref().to_glib_none().0, sensitive.into_glib());
        }
    }

    fn set_size_request(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_widget_set_size_request(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn set_state_flags(&self, flags: StateFlags, clear: bool) {
        unsafe {
            ffi::gtk_widget_set_state_flags(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                clear.into_glib(),
            );
        }
    }

    fn set_tooltip_markup(&self, markup: Option<&str>) {
        unsafe {
            ffi::gtk_widget_set_tooltip_markup(
                self.as_ref().to_glib_none().0,
                markup.to_glib_none().0,
            );
        }
    }

    fn set_tooltip_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_widget_set_tooltip_text(self.as_ref().to_glib_none().0, text.to_glib_none().0);
        }
    }

    fn set_valign(&self, align: Align) {
        unsafe {
            ffi::gtk_widget_set_valign(self.as_ref().to_glib_none().0, align.into_glib());
        }
    }

    fn set_vexpand(&self, expand: bool) {
        unsafe {
            ffi::gtk_widget_set_vexpand(self.as_ref().to_glib_none().0, expand.into_glib());
        }
    }

    fn set_vexpand_set(&self, set: bool) {
        unsafe {
            ffi::gtk_widget_set_vexpand_set(self.as_ref().to_glib_none().0, set.into_glib());
        }
    }

    fn set_visible(&self, visible: bool) {
        unsafe {
            ffi::gtk_widget_set_visible(self.as_ref().to_glib_none().0, visible.into_glib());
        }
    }

    fn should_layout(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_should_layout(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn show(&self) {
        unsafe {
            ffi::gtk_widget_show(self.as_ref().to_glib_none().0);
        }
    }

    fn size_allocate(&self, allocation: &Allocation, baseline: i32) {
        unsafe {
            ffi::gtk_widget_size_allocate(
                self.as_ref().to_glib_none().0,
                allocation.to_glib_none().0,
                baseline,
            );
        }
    }

    fn snapshot_child(&self, child: &impl IsA<Widget>, snapshot: &Snapshot) {
        unsafe {
            ffi::gtk_widget_snapshot_child(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                snapshot.to_glib_none().0,
            );
        }
    }

    fn translate_coordinates(
        &self,
        dest_widget: &impl IsA<Widget>,
        src_x: f64,
        src_y: f64,
    ) -> Option<(f64, f64)> {
        unsafe {
            let mut dest_x = mem::MaybeUninit::uninit();
            let mut dest_y = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_widget_translate_coordinates(
                self.as_ref().to_glib_none().0,
                dest_widget.as_ref().to_glib_none().0,
                src_x,
                src_y,
                dest_x.as_mut_ptr(),
                dest_y.as_mut_ptr(),
            ));
            let dest_x = dest_x.assume_init();
            let dest_y = dest_y.assume_init();
            if ret {
                Some((dest_x, dest_y))
            } else {
                None
            }
        }
    }

    fn trigger_tooltip_query(&self) {
        unsafe {
            ffi::gtk_widget_trigger_tooltip_query(self.as_ref().to_glib_none().0);
        }
    }

    fn unmap(&self) {
        unsafe {
            ffi::gtk_widget_unmap(self.as_ref().to_glib_none().0);
        }
    }

    fn unparent(&self) {
        unsafe {
            ffi::gtk_widget_unparent(self.as_ref().to_glib_none().0);
        }
    }

    fn unrealize(&self) {
        unsafe {
            ffi::gtk_widget_unrealize(self.as_ref().to_glib_none().0);
        }
    }

    fn unset_state_flags(&self, flags: StateFlags) {
        unsafe {
            ffi::gtk_widget_unset_state_flags(self.as_ref().to_glib_none().0, flags.into_glib());
        }
    }

    fn height_request(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"height-request\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `height-request` getter")
        }
    }

    fn set_height_request(&self, height_request: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"height-request\0".as_ptr() as *const _,
                height_request.to_value().to_glib_none().0,
            );
        }
    }

    fn width_request(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"width-request\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `width-request` getter")
        }
    }

    fn set_width_request(&self, width_request: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"width-request\0".as_ptr() as *const _,
                width_request.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_destroy<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn destroy_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"destroy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    destroy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_direction_changed<F: Fn(&Self, TextDirection) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn direction_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, TextDirection) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            previous_direction: ffi::GtkTextDirection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(previous_direction),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"direction-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    direction_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hide<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn hide_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"hide\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    hide_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_keynav_failed<F: Fn(&Self, DirectionType) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn keynav_failed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, DirectionType) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            direction: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(direction),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"keynav-failed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    keynav_failed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_map<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn map_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"map\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    map_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mnemonic_activate<F: Fn(&Self, bool) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn mnemonic_activate_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, bool) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWidget,
            group_cycling: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(group_cycling),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"mnemonic-activate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    mnemonic_activate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_move_focus<F: Fn(&Self, DirectionType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_focus_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, DirectionType) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            direction: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(direction),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_focus(&self, direction: DirectionType) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("move-focus", &[&direction])
                .unwrap()
        };
    }

    fn connect_query_tooltip<F: Fn(&Self, i32, i32, bool, &Tooltip) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn query_tooltip_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, i32, i32, bool, &Tooltip) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            x: libc::c_int,
            y: libc::c_int,
            keyboard_mode: glib::ffi::gboolean,
            tooltip: *mut ffi::GtkTooltip,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                x,
                y,
                from_glib(keyboard_mode),
                &from_glib_borrow(tooltip),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"query-tooltip\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    query_tooltip_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_realize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn realize_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"realize\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    realize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn show_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"show\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    show_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_state_flags_changed<F: Fn(&Self, StateFlags) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn state_flags_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, StateFlags) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            flags: ffi::GtkStateFlags,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Widget::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(flags),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"state-flags-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    state_flags_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_unmap<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unmap_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unmap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unmap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_unrealize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unrealize_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unrealize\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unrealize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_focus_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_target_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_target_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-target\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_target_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_css_classes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_css_classes_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::css-classes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_css_classes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focus_on_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_on_click_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-on-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_focus_on_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focusable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focusable_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focusable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_focusable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_halign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_halign_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::halign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_halign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_default_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_focus_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_tooltip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_tooltip_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-tooltip\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_tooltip_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_height_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_height_request_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::height-request\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_height_request_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hexpand_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hexpand\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hexpand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hexpand_set_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hexpand-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hexpand_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_layout_manager_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_layout_manager_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::layout-manager\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_layout_manager_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_bottom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_bottom_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin-bottom\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_bottom_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_end_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin-end\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_start_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_start_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin-start\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_start_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_margin_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_top_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin-top\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_top_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_name_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_opacity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_opacity_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::opacity\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_opacity_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_overflow_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overflow_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overflow\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overflow_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_parent_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::parent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_receives_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_receives_default_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::receives-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_receives_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_root_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_root_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::root\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_root_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scale_factor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_factor_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale-factor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_factor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_sensitive_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sensitive_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sensitive\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tooltip_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_markup_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tooltip_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_text_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_valign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_valign_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::valign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_valign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_vexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vexpand_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vexpand\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vexpand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_vexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vexpand_set_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vexpand-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vexpand_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_width_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_request_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width-request\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_width_request_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}
