/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.axis.AxisLog10;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterAutoUnits;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JFrame;

public final class Log10AxisChart {
    public static void main(String[] args) {
        Chart2D chart = new Chart2D();
        chart.setUseAntialiasing(true);
        AxisLog10 axisy = new AxisLog10();
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(100);
        chart.setAxisYLeft(axisy, 0);
        axisy.setFormatter(new LabelFormatterAutoUnits(new LabelFormatterNumber(df)));
        Trace2DSimple trace = new Trace2DSimple();
        chart.addTrace(trace);
        trace.setTracePainter(new TracePainterDisc(4));
        trace.setColor(Color.BLUE);
        trace.setStroke(new BasicStroke(1.0f));
        for (double i = 1.0; i < 10.0; i += 0.1) {
            trace.addPoint(i, Math.pow(10.0, i));
        }
        JFrame frame = new JFrame(Log10AxisChart.class.getName());
        frame.getContentPane().add(new ChartPanel(chart));
        frame.setSize(400, 300);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    private Log10AxisChart() {
    }
}

