//****************************************************************************
//* Copyright (c) 2012 Saint-Petersburg Academic University                   
//* All Rights Reserved                                                       
//* See file LICENSE for details.                                             
//****************************************************************************
#include "resource.h"

namespace SyntenyFinder
{
	namespace
	{
		const std::string d3TemplateBlockNo0[] = 
		{
			std::string("<html>"),
			std::string("	<head>"),
			std::string("        <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\"/>"),
			std::string("        <style type=\"text/css\">"),
			std::string("            body {"),
			std::string("                font: 300 36px \"Helvetica Neue\";"),
			std::string("                height: 640px;"),
			std::string("                margin: 80px 160px 80px 160px;"),
			std::string("                position: relative;"),
			std::string("                width: 960px;"),
			std::string("            }"),
			std::string(""),
			std::string("            a:link, a:visited {"),
			std::string("                color: #777;"),
			std::string("                text-decoration: none;"),
			std::string("            }"),
			std::string(""),
			std::string("            a:hover {"),
			std::string("                color: #666;"),
			std::string("            }"),
			std::string(""),
			std::string("            blockquote {"),
			std::string("                margin: 0;"),
			std::string("            }"),
			std::string(""),
			std::string("            blockquote:before {"),
			std::string("                content: \"вЂњ\";"),
			std::string("                position: absolute;"),
			std::string("                left: -.4em;"),
			std::string("            }"),
			std::string(""),
			std::string("            blockquote:after {"),
			std::string("                content: \"вЂќ\";"),
			std::string("                position: absolute;"),
			std::string("            }"),
			std::string(""),
			std::string("            body > ul {"),
			std::string("                margin: 0;"),
			std::string("                padding: 0;"),
			std::string("            }"),
			std::string(""),
			std::string("            h1 {"),
			std::string("                font-size: 64px;"),
			std::string("            }"),
			std::string(""),
			std::string("            h1, h2, h3 {"),
			std::string("                font-weight: inherit;"),
			std::string("                margin: 0;"),
			std::string("            }"),
			std::string(""),
			std::string("            h2, h3 {"),
			std::string("                text-align: right;"),
			std::string("                font-size: inherit;"),
			std::string("                position: absolute;"),
			std::string("                bottom: 0;"),
			std::string("                right: 0;"),
			std::string("            }"),
			std::string(""),
			std::string("            h2 {"),
			std::string("                font-size: 24px;"),
			std::string("                position: absolute;"),
			std::string("            }"),
			std::string(""),
			std::string("            h3 {"),
			std::string("                bottom: -20px;"),
			std::string("                font-size: 18px;"),
			std::string("            }"),
			std::string(""),
			std::string("            div#legend {"),
			std::string("                font-size:14pt;"),
			std::string("                top:700px;"),
			std::string("                position:absolute;"),
			std::string("            }"),
			std::string(""),
			std::string("            .invert {"),
			std::string("                background: #1f1f1f;"),
			std::string("                color: #dcdccc;"),
			std::string("            }"),
			std::string(""),
			std::string("            .invert h2, .invert h3 {"),
			std::string("                color: #7f9f7f;"),
			std::string("            }"),
			std::string(""),
			std::string("            .string, .regexp {"),
			std::string("                color: #f39;"),
			std::string("            }"),
			std::string(""),
			std::string("            .keyword {"),
			std::string("                color: #00c;"),
			std::string("            }"),
			std::string(""),
			std::string("            .comment {"),
			std::string("                color: #777;"),
			std::string("                font-style: oblique;"),
			std::string("            }"),
			std::string(""),
			std::string("            .number {"),
			std::string("                color: #369;"),
			std::string("            }"),
			std::string(""),
			std::string("            .class, .special {"),
			std::string("                color: #1181B8;"),
			std::string("            }"),
			std::string(""),
			std::string("            body > svg {"),
			std::string("                position: absolute;"),
			std::string("                top: -80px;"),
			std::string("                left: -160px;"),
			std::string("            }"),
			std::string("        </style>"),
			std::string("        <style type=\"text/css\">"),
			std::string(""),
			std::string("            path.arc {"),
			std::string("                cursor: move;"),
			std::string("                fill: #fff;"),
			std::string("            }"),
			std::string(""),
			std::string("            .node {"),
			std::string("                font-size: 9px;"),
			std::string("                font-weight: bold;"),
			std::string("            }"),
			std::string(""),
			std::string("            .node:hover {"),
			std::string("                fill: #1f77b4;"),
			std::string("            }"),
			std::string(""),
			std::string("            .link {"),
			std::string("                fill: none;"),
			std::string("                stroke: #1f77b4;"),
			std::string("                stroke-opacity: .4;"),
			std::string("                pointer-events: none;"),
			std::string("            }"),
			std::string(""),
			std::string("            .link.source, .link.target {"),
			std::string("                stroke-opacity: 1;"),
			std::string("                stroke-width: 2px;"),
			std::string("            }"),
			std::string(""),
			std::string("            .node.target {"),
			std::string("                fill: #d62728 !important;"),
			std::string("            }"),
			std::string(""),
			std::string("            .link.source {"),
			std::string("                stroke: #d62728;"),
			std::string("            }"),
			std::string(""),
			std::string("            .node.source {"),
			std::string("                fill: #2ca02c;"),
			std::string("            }"),
			std::string(""),
			std::string("            .link.target {"),
			std::string("                stroke: #2ca02c;"),
			std::string("            }"),
			std::string(""),
			std::string("        </style>"),
			std::string("	</head>"),
			std::string("    <body>"),
			std::string("    <h2>"),
			std::string("        made by <a href=\"http://bioinf.spbau.ru/sibelia\">SiBELia</a>"),
			std::string("    </h2>"),
			std::string("    <div style=\"position:absolute;bottom:0;font-size:18px;\">tension: <input style=\"position:relative;top:3px;\" type=\"range\" min=\"0\" max=\"100\" value=\"85\"></div>"),
			std::string("    <div id=\"legend\"></div>"),
			std::string("    <script type=\"text/javascript\">"),
			std::string("    (function(){if (!Date.now) Date.now = function() {"),
			std::string("        return +new Date;"),
			std::string("    };"),
			std::string("        try {"),
			std::string("            document.createElement(\"div\").style.setProperty(\"opacity\", 0, \"\");"),
			std::string("        } catch (error) {"),
			std::string("            var d3_style_prototype = CSSStyleDeclaration.prototype,"),
			std::string("                    d3_style_setProperty = d3_style_prototype.setProperty;"),
			std::string("            d3_style_prototype.setProperty = function(name, value, priority) {"),
			std::string("                d3_style_setProperty.call(this, name, value + \"\", priority);"),
			std::string("            };"),
			std::string("        }"),
			std::string("        d3 = {version: \"2.5.0\"}; // semver"),
			std::string("        var d3_array = d3_arraySlice; // conversion for NodeLists"),
			std::string(""),
			std::string("        function d3_arrayCopy(pseudoarray) {"),
			std::string("            var i = -1, n = pseudoarray.length, array = [];"),
			std::string("            while (++i < n) array.push(pseudoarray[i]);"),
			std::string("            return array;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_arraySlice(pseudoarray) {"),
			std::string("            return Array.prototype.slice.call(pseudoarray);"),
			std::string("        }"),
			std::string(""),
			std::string("        try {"),
			std::string("            d3_array(document.documentElement.childNodes)[0].nodeType;"),
			std::string("        } catch(e) {"),
			std::string("            d3_array = d3_arrayCopy;"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_arraySubclass = [].__proto__?"),
			std::string(""),
			std::string("// Until ECMAScript supports array subclassing, prototype injection works well."),
			std::string("                function(array, prototype) {"),
			std::string("                    array.__proto__ = prototype;"),
			std::string("                }:"),
			std::string(""),
			std::string("// And if your browser doesn't support __proto__, we'll use direct extension."),
			std::string("                function(array, prototype) {"),
			std::string("                    for (var property in prototype) array[property] = prototype[property];"),
			std::string("                };"),
			std::string("        function d3_this() {"),
			std::string("            return this;"),
			std::string("        }"),
			std::string("        d3.functor = function(v) {"),
			std::string("            return typeof v === \"function\" ? v : function() { return v; };"),
			std::string("        };"),
			std::string("// A getter-setter method that preserves the appropriate `this` context."),
			std::string("        d3.rebind = function(object, method) {"),
			std::string("            return function() {"),
			std::string("                var x = method.apply(object, arguments);"),
			std::string("                return arguments.length ? object : x;"),
			std::string("            };"),
			std::string("        };"),
			std::string("        d3.ascending = function(a, b) {"),
			std::string("            return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;"),
			std::string("        };"),
			std::string("        d3.descending = function(a, b) {"),
			std::string("            return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;"),
			std::string("        };"),
			std::string("        d3.mean = function(array, f) {"),
			std::string("            var n = array.length,"),
			std::string("                    a,"),
			std::string("                    m = 0,"),
			std::string("                    i = -1,"),
			std::string("                    j = 0;"),
			std::string("            if (arguments.length === 1) {"),
			std::string("                while (++i < n) if (d3_number(a = array[i])) m += (a - m) / ++j;"),
			std::string("            } else {"),
			std::string("                while (++i < n) if (d3_number(a = f.call(array, array[i], i))) m += (a - m) / ++j;"),
			std::string("            }"),
			std::string("            return j ? m : undefined;"),
			std::string("        };"),
			std::string("        d3.median = function(array, f) {"),
			std::string("            if (arguments.length > 1) array = array.map(f);"),
			std::string("            array = array.filter(d3_number);"),
			std::string("            return array.length ? d3.quantile(array.sort(d3.ascending), .5) : undefined;"),
			std::string("        };"),
			std::string("        d3.min = function(array, f) {"),
			std::string("            var i = -1,"),
			std::string("                    n = array.length,"),
			std::string("                    a,"),
			std::string("                    b;"),
			std::string("            if (arguments.length === 1) {"),
			std::string("                while (++i < n && ((a = array[i]) == null || a != a)) a = undefined;"),
			std::string("                while (++i < n) if ((b = array[i]) != null && a > b) a = b;"),
			std::string("            } else {"),
			std::string("                while (++i < n && ((a = f.call(array, array[i], i)) == null || a != a)) a = undefined;"),
			std::string("                while (++i < n) if ((b = f.call(array, array[i], i)) != null && a > b) a = b;"),
			std::string("            }"),
			std::string("            return a;"),
			std::string("        };"),
			std::string("        d3.max = function(array, f) {"),
			std::string("            var i = -1,"),
			std::string("                    n = array.length,"),
			std::string("                    a,"),
			std::string("                    b;"),
			std::string("            if (arguments.length === 1) {"),
			std::string("                while (++i < n && ((a = array[i]) == null || a != a)) a = undefined;"),
			std::string("                while (++i < n) if ((b = array[i]) != null && b > a) a = b;"),
			std::string("            } else {"),
			std::string("                while (++i < n && ((a = f.call(array, array[i], i)) == null || a != a)) a = undefined;"),
			std::string("                while (++i < n) if ((b = f.call(array, array[i], i)) != null && b > a) a = b;"),
			std::string("            }"),
			std::string("            return a;"),
			std::string("        };"),
			std::string("        d3.extent = function(array, f) {"),
			std::string("            var i = -1,"),
			std::string("                    n = array.length,"),
			std::string("                    a,"),
			std::string("                    b,"),
			std::string("                    c;"),
			std::string("            if (arguments.length === 1) {"),
			std::string("                while (++i < n && ((a = c = array[i]) == null || a != a)) a = c = undefined;"),
			std::string("                while (++i < n) if ((b = array[i]) != null) {"),
			std::string("                    if (a > b) a = b;"),
			std::string("                    if (c < b) c = b;"),
			std::string("                }"),
			std::string("            } else {"),
			std::string("                while (++i < n && ((a = c = f.call(array, array[i], i)) == null || a != a)) a = undefined;"),
			std::string("                while (++i < n) if ((b = f.call(array, array[i], i)) != null) {"),
			std::string("                    if (a > b) a = b;"),
			std::string("                    if (c < b) c = b;"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return [a, c];"),
			std::string("        };"),
			std::string("        d3.random = {"),
			std::string("            normal: function(mean, deviation) {"),
			std::string("                if (arguments.length < 2) deviation = 1;"),
			std::string("                if (arguments.length < 1) mean = 0;"),
			std::string("                return function() {"),
			std::string("                    var x, y, r;"),
			std::string("                    do {"),
			std::string("                        x = Math.random() * 2 - 1;"),
			std::string("                        y = Math.random() * 2 - 1;"),
			std::string("                        r = x * x + y * y;"),
			std::string("                    } while (!r || r > 1);"),
			std::string("                    return mean + deviation * x * Math.sqrt(-2 * Math.log(r) / r);"),
			std::string("                };"),
			std::string("            }"),
			std::string("        };"),
			std::string("        function d3_number(x) {"),
			std::string("            return x != null && !isNaN(x);"),
			std::string("        }"),
			std::string("        d3.sum = function(array, f) {"),
			std::string("            var s = 0,"),
			std::string("                    n = array.length,"),
			std::string("                    a,"),
			std::string("                    i = -1;"),
			std::string(""),
			std::string("            if (arguments.length === 1) {"),
			std::string("                while (++i < n) if (!isNaN(a = +array[i])) s += a;"),
			std::string("            } else {"),
			std::string("                while (++i < n) if (!isNaN(a = +f.call(array, array[i], i))) s += a;"),
			std::string("            }"),
			std::string(""),
			std::string("            return s;"),
			std::string("        };"),
			std::string("// R-7 per <http://en.wikipedia.org/wiki/Quantile>"),
			std::string("        d3.quantile = function(values, p) {"),
			std::string("            var H = (values.length - 1) * p + 1,"),
			std::string("                    h = Math.floor(H),"),
			std::string("                    v = values[h - 1],"),
			std::string("                    e = H - h;"),
			std::string("            return e ? v + e * (values[h] - v) : v;"),
			std::string("        };"),
			std::string("        d3.zip = function() {"),
			std::string("            if (!(n = arguments.length)) return [];"),
			std::string("            for (var i = -1, m = d3.min(arguments, d3_zipLength), zips = new Array(m); ++i < m;) {"),
			std::string("                for (var j = -1, n, zip = zips[i] = new Array(n); ++j < n;) {"),
			std::string("                    zip[j] = arguments[j][i];"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return zips;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_zipLength(d) {"),
			std::string("            return d.length;"),
			std::string("        }"),
			std::string("// Locate the insertion point for x in a to maintain sorted order. The"),
			std::string("// arguments lo and hi may be used to specify a subset of the array which should"),
			std::string("// be considered; by default the entire array is used. If x is already present"),
			std::string("// in a, the insertion point will be before (to the left of) any existing"),
			std::string("// entries. The return value is suitable for use as the first argument to"),
			std::string("// `array.splice` assuming that a is already sorted."),
			std::string("//"),
			std::string("// The returned insertion point i partitions the array a into two halves so that"),
			std::string("// all v < x for v in a[lo:i] for the left side and all v >= x for v in a[i:hi]"),
			std::string("// for the right side."),
			std::string("        d3.bisectLeft = function(a, x, lo, hi) {"),
			std::string("            if (arguments.length < 3) lo = 0;"),
			std::string("            if (arguments.length < 4) hi = a.length;"),
			std::string("            while (lo < hi) {"),
			std::string("                var mid = (lo + hi) >> 1;"),
			std::string("                if (a[mid] < x) lo = mid + 1;"),
			std::string("                else hi = mid;"),
			std::string("            }"),
			std::string("            return lo;"),
			std::string("        };"),
			std::string(""),
			std::string("// Similar to bisectLeft, but returns an insertion point which comes after (to"),
			std::string("// the right of) any existing entries of x in a."),
			std::string("//"),
			std::string("// The returned insertion point i partitions the array into two halves so that"),
			std::string("// all v <= x for v in a[lo:i] for the left side and all v > x for v in a[i:hi]"),
			std::string("// for the right side."),
			std::string("        d3.bisect ="),
			std::string("                d3.bisectRight = function(a, x, lo, hi) {"),
			std::string("                    if (arguments.length < 3) lo = 0;"),
			std::string("                    if (arguments.length < 4) hi = a.length;"),
			std::string("                    while (lo < hi) {"),
			std::string("                        var mid = (lo + hi) >> 1;"),
			std::string("                        if (x < a[mid]) hi = mid;"),
			std::string("                        else lo = mid + 1;"),
			std::string("                    }"),
			std::string("                    return lo;"),
			std::string("                };"),
			std::string("        d3.first = function(array, f) {"),
			std::string("            var i = 0,"),
			std::string("                    n = array.length,"),
			std::string("                    a = array[0],"),
			std::string("                    b;"),
			std::string("            if (arguments.length === 1) f = d3.ascending;"),
			std::string("            while (++i < n) {"),
			std::string("                if (f.call(array, a, b = array[i]) > 0) {"),
			std::string("                    a = b;"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return a;"),
			std::string("        };"),
			std::string("        d3.last = function(array, f) {"),
			std::string("            var i = 0,"),
			std::string("                    n = array.length,"),
			std::string("                    a = array[0],"),
			std::string("                    b;"),
			std::string("            if (arguments.length === 1) f = d3.ascending;"),
			std::string("            while (++i < n) {"),
			std::string("                if (f.call(array, a, b = array[i]) <= 0) {"),
			std::string("                    a = b;"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return a;"),
			std::string("        };"),
			std::string("        d3.nest = function() {"),
			std::string("            var nest = {},"),
			std::string("                    keys = [],"),
			std::string("                    sortKeys = [],"),
			std::string("                    sortValues,"),
			std::string("                    rollup;"),
			std::string(""),
			std::string("            function map(array, depth) {"),
			std::string("                if (depth >= keys.length) return rollup"),
			std::string("                        ? rollup.call(nest, array) : (sortValues"),
			std::string("                        ? array.sort(sortValues)"),
			std::string("                        : array);"),
			std::string(""),
			std::string("                var i = -1,"),
			std::string("                        n = array.length,"),
			std::string("                        key = keys[depth++],"),
			std::string("                        keyValue,"),
			std::string("                        object,"),
			std::string("                        o = {};"),
			std::string(""),
			std::string("                while (++i < n) {"),
			std::string("                    if ((keyValue = key(object = array[i])) in o) {"),
			std::string("                        o[keyValue].push(object);"),
			std::string("                    } else {"),
			std::string("                        o[keyValue] = [object];"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                for (keyValue in o) {"),
			std::string("                    o[keyValue] = map(o[keyValue], depth);"),
			std::string("                }"),
			std::string(""),
			std::string("                return o;"),
			std::string("            }"),
			std::string(""),
			std::string("            function entries(map, depth) {"),
			std::string("                if (depth >= keys.length) return map;"),
			std::string(""),
			std::string("                var a = [],"),
			std::string("                        sortKey = sortKeys[depth++],"),
			std::string("                        key;"),
			std::string(""),
			std::string("                for (key in map) {"),
			std::string("                    a.push({key: key, values: entries(map[key], depth)});"),
			std::string("                }"),
			std::string(""),
			std::string("                if (sortKey) a.sort(function(a, b) {"),
			std::string("                    return sortKey(a.key, b.key);"),
			std::string("                });"),
			std::string(""),
			std::string("                return a;"),
			std::string("            }"),
			std::string(""),
			std::string("            nest.map = function(array) {"),
			std::string("                return map(array, 0);"),
			std::string("            };"),
			std::string(""),
			std::string("            nest.entries = function(array) {"),
			std::string("                return entries(map(array, 0), 0);"),
			std::string("            };"),
			std::string(""),
			std::string("            nest.key = function(d) {"),
			std::string("                keys.push(d);"),
			std::string("                return nest;"),
			std::string("            };"),
			std::string(""),
			std::string("            // Specifies the order for the most-recently specified key."),
			std::string("            // Note: only applies to entries. Map keys are unordered!"),
			std::string("            nest.sortKeys = function(order) {"),
			std::string("                sortKeys[keys.length - 1] = order;"),
			std::string("                return nest;"),
			std::string("            };"),
			std::string(""),
			std::string("            // Specifies the order for leaf values."),
			std::string("            // Applies to both maps and entries array."),
			std::string("            nest.sortValues = function(order) {"),
			std::string("                sortValues = order;"),
			std::string("                return nest;"),
			std::string("            };"),
			std::string(""),
			std::string("            nest.rollup = function(f) {"),
			std::string("                rollup = f;"),
			std::string("                return nest;"),
			std::string("            };"),
			std::string(""),
			std::string("            return nest;"),
			std::string("        };"),
			std::string("        d3.keys = function(map) {"),
			std::string("            var keys = [];"),
			std::string("            for (var key in map) keys.push(key);"),
			std::string("            return keys;"),
			std::string("        };"),
			std::string("        d3.values = function(map) {"),
			std::string("            var values = [];"),
			std::string("            for (var key in map) values.push(map[key]);"),
			std::string("            return values;"),
			std::string("        };"),
			std::string("        d3.entries = function(map) {"),
			std::string("            var entries = [];"),
			std::string("            for (var key in map) entries.push({key: key, value: map[key]});"),
			std::string("            return entries;"),
			std::string("        };"),
			std::string("        d3.permute = function(array, indexes) {"),
			std::string("            var permutes = [],"),
			std::string("                    i = -1,"),
			std::string("                    n = indexes.length;"),
			std::string("            while (++i < n) permutes[i] = array[indexes[i]];"),
			std::string("            return permutes;"),
			std::string("        };"),
			std::string("        d3.merge = function(arrays) {"),
			std::string("            return Array.prototype.concat.apply([], arrays);"),
			std::string("        };"),
			std::string("        d3.split = function(array, f) {"),
			std::string("            var arrays = [],"),
			std::string("                    values = [],"),
			std::string("                    value,"),
			std::string("                    i = -1,"),
			std::string("                    n = array.length;"),
			std::string("            if (arguments.length < 2) f = d3_splitter;"),
			std::string("            while (++i < n) {"),
			std::string("                if (f.call(values, value = array[i], i)) {"),
			std::string("                    values = [];"),
			std::string("                } else {"),
			std::string("                    if (!values.length) arrays.push(values);"),
			std::string("                    values.push(value);"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return arrays;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_splitter(d) {"),
			std::string("            return d == null;"),
			std::string("        }"),
			std::string("        function d3_collapse(s) {"),
			std::string("            return s.replace(/(^\\s+)|(\\s+$)/g, \"\").replace(/\\s+/g, \" \");"),
			std::string("        }"),
			std::string("        /**"),
			std::string("         * @param {number} start"),
			std::string("         * @param {number=} stop"),
			std::string("         * @param {number=} step"),
			std::string("         */"),
			std::string("        d3.range = function(start, stop, step) {"),
			std::string("            if (arguments.length < 3) {"),
			std::string("                step = 1;"),
			std::string("                if (arguments.length < 2) {"),
			std::string("                    stop = start;"),
			std::string("                    start = 0;"),
			std::string("                }"),
			std::string("            }"),
			std::string("            if ((stop - start) / step == Infinity) throw new Error(\"infinite range\");"),
			std::string("            var range = [],"),
			std::string("                    i = -1,"),
			std::string("                    j;"),
			std::string("            if (step < 0) while ((j = start + step * ++i) > stop) range.push(j);"),
			std::string("            else while ((j = start + step * ++i) < stop) range.push(j);"),
			std::string("            return range;"),
			std::string("        };"),
			std::string("        d3.requote = function(s) {"),
			std::string("            return s.replace(d3_requote_re, \"\\\\$&\");"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_requote_re = /[\\\\\\^\\$\\*\\+\\?\\|\\[\\]\\(\\)\\.\\{\\}]/g;"),
			std::string("        d3.round = function(x, n) {"),
			std::string("            return n"),
			std::string("                    ? Math.round(x * Math.pow(10, n)) * Math.pow(10, -n)"),
			std::string("                    : Math.round(x);"),
			std::string("        };"),
			std::string("        d3.xhr = function(url, mime, callback) {"),
			std::string("            var req = new XMLHttpRequest;"),
			std::string("            if (arguments.length < 3) callback = mime;"),
			std::string("            else if (mime && req.overrideMimeType) req.overrideMimeType(mime);"),
			std::string("            req.open(\"GET\", url, true);"),
			std::string("            req.onreadystatechange = function() {"),
			std::string("                if (req.readyState === 4) callback(req.status < 300 ? req : null);"),
			std::string("            };"),
			std::string("            req.send(null);"),
			std::string("        };"),
			std::string("        d3.text = function(url, mime, callback) {"),
			std::string("            function ready(req) {"),
			std::string("                callback(req && req.responseText);"),
			std::string("            }"),
			std::string("            if (arguments.length < 3) {"),
			std::string("                callback = mime;"),
			std::string("                mime = null;"),
			std::string("            }"),
			std::string("            d3.xhr(url, mime, ready);"),
			std::string("        };"),
			std::string("        d3.json = function(url, callback) {"),
			std::string("            d3.text(url, \"application/json\", function(text) {"),
			std::string("                callback(text ? JSON.parse(text) : null);"),
			std::string("            });"),
			std::string("        };"),
			std::string("        d3.html = function(url, callback) {"),
			std::string("            d3.text(url, \"text/html\", function(text) {"),
			std::string("                if (text != null) { // Treat empty string as valid HTML."),
			std::string("                    var range = document.createRange();"),
			std::string("                    range.selectNode(document.body);"),
			std::string("                    text = range.createContextualFragment(text);"),
			std::string("                }"),
			std::string("                callback(text);"),
			std::string("            });"),
			std::string("        };"),
			std::string("        d3.xml = function(url, mime, callback) {"),
			std::string("            function ready(req) {"),
			std::string("                callback(req && req.responseXML);"),
			std::string("            }"),
			std::string("            if (arguments.length < 3) {"),
			std::string("                callback = mime;"),
			std::string("                mime = null;"),
			std::string("            }"),
			std::string("            d3.xhr(url, mime, ready);"),
			std::string("        };"),
			std::string("        d3.ns = {"),
			std::string(""),
			std::string("            prefix: {"),
			std::string("                svg: \"http://www.w3.org/2000/svg\","),
			std::string("                xhtml: \"http://www.w3.org/1999/xhtml\","),
			std::string("                xlink: \"http://www.w3.org/1999/xlink\","),
			std::string("                xml: \"http://www.w3.org/XML/1998/namespace\","),
			std::string("                xmlns: \"http://www.w3.org/2000/xmlns/\""),
			std::string("            },"),
			std::string(""),
			std::string("            qualify: function(name) {"),
			std::string("                var i = name.indexOf(\":\");"),
			std::string("                return i < 0 ? name : {"),
			std::string("                    space: d3.ns.prefix[name.substring(0, i)],"),
			std::string("                    local: name.substring(i + 1)"),
			std::string("                };"),
			std::string("            }"),
			std::string(""),
			std::string("        };"),
			std::string("        d3.dispatch = function() {"),
			std::string("            var dispatch = new d3_dispatch(),"),
			std::string("                    i = -1,"),
			std::string("                    n = arguments.length;"),
			std::string("            while (++i < n) dispatch[arguments[i]] = d3_dispatch_event();"),
			std::string("            return dispatch;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_dispatch() {}"),
			std::string(""),
			std::string("        d3_dispatch.prototype.on = function(type, listener) {"),
			std::string("            var i = type.indexOf(\".\"),"),
			std::string("                    name = \"\";"),
			std::string(""),
			std::string("            // Extract optional namespace, e.g., \"click.foo\""),
			std::string("            if (i > 0) {"),
			std::string("                name = type.substring(i + 1);"),
			std::string("                type = type.substring(0, i);"),
			std::string("            }"),
			std::string(""),
			std::string("            this[type].on(name, listener);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_dispatch_event() {"),
			std::string("            var listeners = [],"),
			std::string("                    listenerByName = {};"),
			std::string(""),
			std::string("            function dispatch() {"),
			std::string("                var z = listeners, // defensive reference"),
			std::string("                        i = -1,"),
			std::string("                        n = z.length,"),
			std::string("                        l;"),
			std::string("                while (++i < n) if ((l = z[i])._on) l.apply(this, arguments);"),
			std::string("            }"),
			std::string(""),
			std::string("            dispatch.on = function(name, listener) {"),
			std::string("                var l, i;"),
			std::string(""),
			std::string("                // remove the old listener, if any"),
			std::string("                if (l = listenerByName[name]) {"),
			std::string("                    l._on = false;"),
			std::string("                    listeners = listeners.slice(0, i = listeners.indexOf(l)).concat(listeners.slice(i + 1));"),
			std::string("                    delete listenerByName[name];"),
			std::string("                }"),
			std::string(""),
			std::string("                // add the new listener, if any"),
			std::string("                if (listener) {"),
			std::string("                    listener._on = true;"),
			std::string("                    listeners.push(listener);"),
			std::string("                    listenerByName[name] = listener;"),
			std::string("                }"),
			std::string(""),
			std::string("                return dispatch;"),
			std::string("            };"),
			std::string(""),
			std::string("            return dispatch;"),
			std::string("        };"),
			std::string("// TODO align"),
			std::string("        d3.format = function(specifier) {"),
			std::string("            var match = d3_format_re.exec(specifier),"),
			std::string("                    fill = match[1] || \" \","),
			std::string("                    sign = match[3] || \"\","),
			std::string("                    zfill = match[5],"),
			std::string("                    width = +match[6],"),
			std::string("                    comma = match[7],"),
			std::string("                    precision = match[8],"),
			std::string("                    type = match[9],"),
			std::string("                    scale = 1,"),
			std::string("                    suffix = \"\","),
			std::string("                    integer = false;"),
			std::string(""),
			std::string("            if (precision) precision = +precision.substring(1);"),
			std::string(""),
			std::string("            if (zfill) {"),
			std::string("                fill = \"0\"; // TODO align = \"=\";"),
			std::string("                if (comma) width -= Math.floor((width - 1) / 4);"),
			std::string("            }"),
			std::string(""),
			std::string("            switch (type) {"),
			std::string("                case \"n\": comma = true; type = \"g\"; break;"),
			std::string("                case \"%\": scale = 100; suffix = \"%\"; type = \"f\"; break;"),
			std::string("                case \"p\": scale = 100; suffix = \"%\"; type = \"r\"; break;"),
			std::string("                case \"d\": integer = true; precision = 0; break;"),
			std::string("                case \"s\": scale = -1; type = \"r\"; break;"),
			std::string("            }"),
			std::string(""),
			std::string("            // If no precision is specified for r, fallback to general notation."),
			std::string("            if (type == \"r\" && !precision) type = \"g\";"),
			std::string(""),
			std::string("            type = d3_format_types[type] || d3_format_typeDefault;"),
			std::string(""),
			std::string("            return function(value) {"),
			std::string(""),
			std::string("                // Return the empty string for floats formatted as ints."),
			std::string("                if (integer && (value % 1)) return \"\";"),
			std::string(""),
			std::string("                // Convert negative to positive, and record the sign prefix."),
			std::string("                var negative = (value < 0) && (value = -value) ? \"\\u2212\" : sign;"),
			std::string(""),
			std::string("                // Apply the scale, computing it from the value's exponent for si format."),
			std::string("                if (scale < 0) {"),
			std::string("                    var prefix = d3.formatPrefix(value, precision);"),
			std::string("                    value *= prefix.scale;"),
			std::string("                    suffix = prefix.symbol;"),
			std::string("                } else {"),
			std::string("                    value *= scale;"),
			std::string("                }"),
			std::string(""),
			std::string("                // Convert to the desired precision."),
			std::string("                value = type(value, precision);"),
			std::string(""),
			std::string("                // If the fill character is 0, the sign and group is applied after the fill."),
			std::string("                if (zfill) {"),
			std::string("                    var length = value.length + negative.length;"),
			std::string("                    if (length < width) value = new Array(width - length + 1).join(fill) + value;"),
			std::string("                    if (comma) value = d3_format_group(value);"),
			std::string("                    value = negative + value;"),
			std::string("                }"),
			std::string(""),
			std::string("                // Otherwise (e.g., space-filling), the sign and group is applied before."),
			std::string("                else {"),
			std::string("                    if (comma) value = d3_format_group(value);"),
			std::string("                    value = negative + value;"),
			std::string("                    var length = value.length;"),
			std::string("                    if (length < width) value = new Array(width - length + 1).join(fill) + value;"),
			std::string("                }"),
			std::string(""),
			std::string("                return value + suffix;"),
			std::string("            };"),
			std::string("        };"),
			std::string(""),
			std::string("// [[fill]align][sign][#][0][width][,][.precision][type]"),
			std::string("        var d3_format_re = /(?:([^{])?([<>=^]))?([+\\- ])?(#)?(0)?([0-9]+)?(,)?(\\.[0-9]+)?([a-zA-Z%])?/;"),
			std::string(""),
			std::string("        var d3_format_types = {"),
			std::string("            g: function(x, p) { return x.toPrecision(p); },"),
			std::string("            e: function(x, p) { return x.toExponential(p); },"),
			std::string("            f: function(x, p) { return x.toFixed(p); },"),
			std::string("            r: function(x, p) { return d3.round(x, p = d3_format_precision(x, p)).toFixed(Math.max(0, Math.min(20, p))); }"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_format_precision(x, p) {"),
			std::string("            return p - (x ? 1 + Math.floor(Math.log(x + Math.pow(10, 1 + Math.floor(Math.log(x) / Math.LN10) - p)) / Math.LN10) : 1);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_format_typeDefault(x) {"),
			std::string("            return x + \"\";"),
			std::string("        }"),
			std::string(""),
			std::string("// Apply comma grouping for thousands."),
			std::string("        function d3_format_group(value) {"),
			std::string("            var i = value.lastIndexOf(\".\"),"),
			std::string("                    f = i >= 0 ? value.substring(i) : (i = value.length, \"\"),"),
			std::string("                    t = [];"),
			std::string("            while (i > 0) t.push(value.substring(i -= 3, i + 3));"),
			std::string("            return t.reverse().join(\",\") + f;"),
			std::string("        }"),
			std::string("        var d3_formatPrefixes = [\"y\",\"z\",\"a\",\"f\",\"p\",\"n\",\"Ој\",\"m\",\"\",\"k\",\"M\",\"G\",\"T\",\"P\",\"E\",\"Z\",\"Y\"].map(d3_formatPrefix);"),
			std::string(""),
			std::string("        d3.formatPrefix = function(value, precision) {"),
			std::string("            var i = 0;"),
			std::string("            if (value) {"),
			std::string("                if (value < 0) value *= -1;"),
			std::string("                if (precision) value = d3.round(value, d3_format_precision(value, precision));"),
			std::string("                i = 1 + Math.floor(1e-12 + Math.log(value) / Math.LN10);"),
			std::string("                i = Math.max(-24, Math.min(24, Math.floor((i <= 0 ? i + 1 : i - 1) / 3) * 3));"),
			std::string("            }"),
			std::string("            return d3_formatPrefixes[8 + i / 3];"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_formatPrefix(d, i) {"),
			std::string("            return {"),
			std::string("                scale: Math.pow(10, (8 - i) * 3),"),
			std::string("                symbol: d"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        /*"),
			std::string("         * TERMS OF USE - EASING EQUATIONS"),
			std::string("         *"),
			std::string("         * Open source under the BSD License."),
			std::string("         *"),
			std::string("         * Copyright 2001 Robert Penner"),
			std::string("         * All rights reserved."),
			std::string("         *"),
			std::string("         * Redistribution and use in source and binary forms, with or without"),
			std::string("         * modification, are permitted provided that the following conditions are met:"),
			std::string("         *"),
			std::string("         * - Redistributions of source code must retain the above copyright notice, this"),
			std::string("         *   list of conditions and the following disclaimer."),
			std::string("         *"),
			std::string("         * - Redistributions in binary form must reproduce the above copyright notice,"),
			std::string("         *   this list of conditions and the following disclaimer in the documentation"),
			std::string("         *   and/or other materials provided with the distribution."),
			std::string("         *"),
			std::string("         * - Neither the name of the author nor the names of contributors may be used to"),
			std::string("         *   endorse or promote products derived from this software without specific"),
			std::string("         *   prior written permission."),
			std::string("         *"),
			std::string("         * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\""),
			std::string("         * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE"),
			std::string("         * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE"),
			std::string("         * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE"),
			std::string("         * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR"),
			std::string("         * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF"),
			std::string("         * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS"),
			std::string("         * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN"),
			std::string("         * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)"),
			std::string("         * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE"),
			std::string("         * POSSIBILITY OF SUCH DAMAGE."),
			std::string("         */"),
			std::string(""),
			std::string("        var d3_ease_quad = d3_ease_poly(2),"),
			std::string("                d3_ease_cubic = d3_ease_poly(3);"),
			std::string(""),
			std::string("        var d3_ease = {"),
			std::string("            linear: function() { return d3_ease_linear; },"),
			std::string("            poly: d3_ease_poly,"),
			std::string("            quad: function() { return d3_ease_quad; },"),
			std::string("            cubic: function() { return d3_ease_cubic; },"),
			std::string("            sin: function() { return d3_ease_sin; },"),
			std::string("            exp: function() { return d3_ease_exp; },"),
			std::string("            circle: function() { return d3_ease_circle; },"),
			std::string("            elastic: d3_ease_elastic,"),
			std::string("            back: d3_ease_back,"),
			std::string("            bounce: function() { return d3_ease_bounce; }"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_ease_mode = {"),
			std::string("            \"in\": function(f) { return f; },"),
			std::string("            \"out\": d3_ease_reverse,"),
			std::string("            \"in-out\": d3_ease_reflect,"),
			std::string("            \"out-in\": function(f) { return d3_ease_reflect(d3_ease_reverse(f)); }"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.ease = function(name) {"),
			std::string("            var i = name.indexOf(\"-\"),"),
			std::string("                    t = i >= 0 ? name.substring(0, i) : name,"),
			std::string("                    m = i >= 0 ? name.substring(i + 1) : \"in\";"),
			std::string("            return d3_ease_clamp(d3_ease_mode[m](d3_ease[t].apply(null, Array.prototype.slice.call(arguments, 1))));"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_ease_clamp(f) {"),
			std::string("            return function(t) {"),
			std::string("                return t <= 0 ? 0 : t >= 1 ? 1 : f(t);"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_reverse(f) {"),
			std::string("            return function(t) {"),
			std::string("                return 1 - f(1 - t);"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_reflect(f) {"),
			std::string("            return function(t) {"),
			std::string("                return .5 * (t < .5 ? f(2 * t) : (2 - f(2 - 2 * t)));"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_linear(t) {"),
			std::string("            return t;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_poly(e) {"),
			std::string("            return function(t) {"),
			std::string("                return Math.pow(t, e);"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_sin(t) {"),
			std::string("            return 1 - Math.cos(t * Math.PI / 2);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_exp(t) {"),
			std::string("            return Math.pow(2, 10 * (t - 1));"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_circle(t) {"),
			std::string("            return 1 - Math.sqrt(1 - t * t);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_elastic(a, p) {"),
			std::string("            var s;"),
			std::string("            if (arguments.length < 2) p = 0.45;"),
			std::string("            if (arguments.length < 1) { a = 1; s = p / 4; }"),
			std::string("            else s = p / (2 * Math.PI) * Math.asin(1 / a);"),
			std::string("            return function(t) {"),
			std::string("                return 1 + a * Math.pow(2, 10 * -t) * Math.sin((t - s) * 2 * Math.PI / p);"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_back(s) {"),
			std::string("            if (!s) s = 1.70158;"),
			std::string("            return function(t) {"),
			std::string("                return t * t * ((s + 1) * t - s);"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_ease_bounce(t) {"),
			std::string("            return t < 1 / 2.75 ? 7.5625 * t * t"),
			std::string("                    : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + .75"),
			std::string("                    : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + .9375"),
			std::string("                    : 7.5625 * (t -= 2.625 / 2.75) * t + .984375;"),
			std::string("        }"),
			std::string("        d3.event = null;"),
			std::string(""),
			std::string("        function d3_eventCancel() {"),
			std::string("            d3.event.stopPropagation();"),
			std::string("            d3.event.preventDefault();"),
			std::string("        }"),
			std::string("        d3.interpolate = function(a, b) {"),
			std::string("            var i = d3.interpolators.length, f;"),
			std::string("            while (--i >= 0 && !(f = d3.interpolators[i](a, b)));"),
			std::string("            return f;"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.interpolateNumber = function(a, b) {"),
			std::string("            b -= a;"),
			std::string("            return function(t) { return a + b * t; };"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.interpolateRound = function(a, b) {"),
			std::string("            b -= a;"),
			std::string("            return function(t) { return Math.round(a + b * t); };"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.interpolateString = function(a, b) {"),
			std::string("            var m, // current match"),
			std::string("                    i, // current index"),
			std::string("                    j, // current index (for coallescing)"),
			std::string("                    s0 = 0, // start index of current string prefix"),
			std::string("                    s1 = 0, // end index of current string prefix"),
			std::string("                    s = [], // string constants and placeholders"),
			std::string("                    q = [], // number interpolators"),
			std::string("                    n, // q.length"),
			std::string("                    o;"),
			std::string(""),
			std::string("            // Reset our regular expression!"),
			std::string("            d3_interpolate_number.lastIndex = 0;"),
			std::string(""),
			std::string("            // Find all numbers in b."),
			std::string("            for (i = 0; m = d3_interpolate_number.exec(b); ++i) {"),
			std::string("                if (m.index) s.push(b.substring(s0, s1 = m.index));"),
			std::string("                q.push({i: s.length, x: m[0]});"),
			std::string("                s.push(null);"),
			std::string("                s0 = d3_interpolate_number.lastIndex;"),
			std::string("            }"),
			std::string("            if (s0 < b.length) s.push(b.substring(s0));"),
			std::string(""),
			std::string("            // Find all numbers in a."),
			std::string("            for (i = 0, n = q.length; (m = d3_interpolate_number.exec(a)) && i < n; ++i) {"),
			std::string("                o = q[i];"),
			std::string("                if (o.x == m[0]) { // The numbers match, so coallesce."),
			std::string("                    if (o.i) {"),
			std::string("                        if (s[o.i + 1] == null) { // This match is followed by another number."),
			std::string("                            s[o.i - 1] += o.x;"),
			std::string("                            s.splice(o.i, 1);"),
			std::string("                            for (j = i + 1; j < n; ++j) q[j].i--;"),
			std::string("                        } else { // This match is followed by a string, so coallesce twice."),
			std::string("                            s[o.i - 1] += o.x + s[o.i + 1];"),
			std::string("                            s.splice(o.i, 2);"),
			std::string("                            for (j = i + 1; j < n; ++j) q[j].i -= 2;"),
			std::string("                        }"),
			std::string("                    } else {"),
			std::string("                        if (s[o.i + 1] == null) { // This match is followed by another number."),
			std::string("                            s[o.i] = o.x;"),
			std::string("                        } else { // This match is followed by a string, so coallesce twice."),
			std::string("                            s[o.i] = o.x + s[o.i + 1];"),
			std::string("                            s.splice(o.i + 1, 1);"),
			std::string("                            for (j = i + 1; j < n; ++j) q[j].i--;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                    q.splice(i, 1);"),
			std::string("                    n--;"),
			std::string("                    i--;"),
			std::string("                } else {"),
			std::string("                    o.x = d3.interpolateNumber(parseFloat(m[0]), parseFloat(o.x));"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            // Remove any numbers in b not found in a."),
			std::string("            while (i < n) {"),
			std::string("                o = q.pop();"),
			std::string("                if (s[o.i + 1] == null) { // This match is followed by another number."),
		};

		const std::string d3TemplateBlockNo1[] = 
		{
			std::string("                    s[o.i] = o.x;"),
			std::string("                } else { // This match is followed by a string, so coallesce twice."),
			std::string("                    s[o.i] = o.x + s[o.i + 1];"),
			std::string("                    s.splice(o.i + 1, 1);"),
			std::string("                }"),
			std::string("                n--;"),
			std::string("            }"),
			std::string(""),
			std::string("            // Special optimization for only a single match."),
			std::string("            if (s.length === 1) {"),
			std::string("                return s[0] == null ? q[0].x : function() { return b; };"),
			std::string("            }"),
			std::string(""),
			std::string("            // Otherwise, interpolate each of the numbers and rejoin the string."),
			std::string("            return function(t) {"),
			std::string("                for (i = 0; i < n; ++i) s[(o = q[i]).i] = o.x(t);"),
			std::string("                return s.join(\"\");"),
			std::string("            };"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.interpolateTransform = function(a, b) {"),
			std::string("            return d3.interpolateString(d3.transform(a) + \"\", d3.transform(b) + \"\");"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.interpolateRgb = function(a, b) {"),
			std::string("            a = d3.rgb(a);"),
			std::string("            b = d3.rgb(b);"),
			std::string("            var ar = a.r,"),
			std::string("                    ag = a.g,"),
			std::string("                    ab = a.b,"),
			std::string("                    br = b.r - ar,"),
			std::string("                    bg = b.g - ag,"),
			std::string("                    bb = b.b - ab;"),
			std::string("            return function(t) {"),
			std::string("                return \"#\""),
			std::string("                        + d3_rgb_hex(Math.round(ar + br * t))"),
			std::string("                        + d3_rgb_hex(Math.round(ag + bg * t))"),
			std::string("                        + d3_rgb_hex(Math.round(ab + bb * t));"),
			std::string("            };"),
			std::string("        };"),
			std::string(""),
			std::string("// interpolates HSL space, but outputs RGB string (for compatibility)"),
			std::string("        d3.interpolateHsl = function(a, b) {"),
			std::string("            a = d3.hsl(a);"),
			std::string("            b = d3.hsl(b);"),
			std::string("            var h0 = a.h,"),
			std::string("                    s0 = a.s,"),
			std::string("                    l0 = a.l,"),
			std::string("                    h1 = b.h - h0,"),
			std::string("                    s1 = b.s - s0,"),
			std::string("                    l1 = b.l - l0;"),
			std::string("            return function(t) {"),
			std::string("                return d3_hsl_rgb(h0 + h1 * t, s0 + s1 * t, l0 + l1 * t).toString();"),
			std::string("            };"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.interpolateArray = function(a, b) {"),
			std::string("            var x = [],"),
			std::string("                    c = [],"),
			std::string("                    na = a.length,"),
			std::string("                    nb = b.length,"),
			std::string("                    n0 = Math.min(a.length, b.length),"),
			std::string("                    i;"),
			std::string("            for (i = 0; i < n0; ++i) x.push(d3.interpolate(a[i], b[i]));"),
			std::string("            for (; i < na; ++i) c[i] = a[i];"),
			std::string("            for (; i < nb; ++i) c[i] = b[i];"),
			std::string("            return function(t) {"),
			std::string("                for (i = 0; i < n0; ++i) c[i] = x[i](t);"),
			std::string("                return c;"),
			std::string("            };"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.interpolateObject = function(a, b) {"),
			std::string("            var i = {},"),
			std::string("                    c = {},"),
			std::string("                    k;"),
			std::string("            for (k in a) {"),
			std::string("                if (k in b) {"),
			std::string("                    i[k] = d3_interpolateByName(k)(a[k], b[k]);"),
			std::string("                } else {"),
			std::string("                    c[k] = a[k];"),
			std::string("                }"),
			std::string("            }"),
			std::string("            for (k in b) {"),
			std::string("                if (!(k in a)) {"),
			std::string("                    c[k] = b[k];"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return function(t) {"),
			std::string("                for (k in i) c[k] = i[k](t);"),
			std::string("                return c;"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_interpolate_number = /[-+]?(?:\\d*\\.?\\d+)(?:[eE][-+]?\\d+)?/g;"),
			std::string(""),
			std::string("        function d3_interpolateByName(n) {"),
			std::string("            return n == \"transform\""),
			std::string("                    ? d3.interpolateTransform"),
			std::string("                    : d3.interpolate;"),
			std::string("        }"),
			std::string(""),
			std::string("        d3.interpolators = ["),
			std::string("            d3.interpolateObject,"),
			std::string("            function(a, b) { return (b instanceof Array) && d3.interpolateArray(a, b); },"),
			std::string("            function(a, b) { return (typeof b === \"string\") && d3.interpolateString(a + \"\", b); },"),
			std::string("            function(a, b) { return (typeof b === \"string\" ? b in d3_rgb_names || /^(#|rgb\\(|hsl\\()/.test(b) : b instanceof d3_Rgb || b instanceof d3_Hsl) && d3.interpolateRgb(a + \"\", b); },"),
			std::string("            function(a, b) { return (typeof b === \"number\") && d3.interpolateNumber(+a, b); }"),
			std::string("        ];"),
			std::string("        function d3_uninterpolateNumber(a, b) {"),
			std::string("            b = b - (a = +a) ? 1 / (b - a) : 0;"),
			std::string("            return function(x) { return (x - a) * b; };"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_uninterpolateClamp(a, b) {"),
			std::string("            b = b - (a = +a) ? 1 / (b - a) : 0;"),
			std::string("            return function(x) { return Math.max(0, Math.min(1, (x - a) * b)); };"),
			std::string("        }"),
			std::string("        d3.rgb = function(r, g, b) {"),
			std::string("            return arguments.length === 1"),
			std::string("                    ? (r instanceof d3_Rgb ? d3_rgb(r.r, r.g, r.b)"),
			std::string("                    : d3_rgb_parse(\"\" + r, d3_rgb, d3_hsl_rgb))"),
			std::string("                    : d3_rgb(~~r, ~~g, ~~b);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_rgb(r, g, b) {"),
			std::string("            return new d3_Rgb(r, g, b);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_Rgb(r, g, b) {"),
			std::string("            this.r = r;"),
			std::string("            this.g = g;"),
			std::string("            this.b = b;"),
			std::string("        }"),
			std::string(""),
			std::string("        d3_Rgb.prototype.brighter = function(k) {"),
			std::string("            k = Math.pow(0.7, arguments.length ? k : 1);"),
			std::string("            var r = this.r,"),
			std::string("                    g = this.g,"),
			std::string("                    b = this.b,"),
			std::string("                    i = 30;"),
			std::string("            if (!r && !g && !b) return d3_rgb(i, i, i);"),
			std::string("            if (r && r < i) r = i;"),
			std::string("            if (g && g < i) g = i;"),
			std::string("            if (b && b < i) b = i;"),
			std::string("            return d3_rgb("),
			std::string("                    Math.min(255, Math.floor(r / k)),"),
			std::string("                    Math.min(255, Math.floor(g / k)),"),
			std::string("                    Math.min(255, Math.floor(b / k)));"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_Rgb.prototype.darker = function(k) {"),
			std::string("            k = Math.pow(0.7, arguments.length ? k : 1);"),
			std::string("            return d3_rgb("),
			std::string("                    Math.floor(k * this.r),"),
			std::string("                    Math.floor(k * this.g),"),
			std::string("                    Math.floor(k * this.b));"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_Rgb.prototype.hsl = function() {"),
			std::string("            return d3_rgb_hsl(this.r, this.g, this.b);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_Rgb.prototype.toString = function() {"),
			std::string("            return \"#\" + d3_rgb_hex(this.r) + d3_rgb_hex(this.g) + d3_rgb_hex(this.b);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_rgb_hex(v) {"),
			std::string("            return v < 0x10"),
			std::string("                    ? \"0\" + Math.max(0, v).toString(16)"),
			std::string("                    : Math.min(255, v).toString(16);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_rgb_parse(format, rgb, hsl) {"),
			std::string("            var r = 0, // red channel; int in [0, 255]"),
			std::string("                    g = 0, // green channel; int in [0, 255]"),
			std::string("                    b = 0, // blue channel; int in [0, 255]"),
			std::string("                    m1, // CSS color specification match"),
			std::string("                    m2, // CSS color specification type (e.g., rgb)"),
			std::string("                    name;"),
			std::string(""),
			std::string("            /* Handle hsl, rgb. */"),
			std::string("            m1 = /([a-z]+)\\((.*)\\)/i.exec(format);"),
			std::string("            if (m1) {"),
			std::string("                m2 = m1[2].split(\",\");"),
			std::string("                switch (m1[1]) {"),
			std::string("                    case \"hsl\": {"),
			std::string("                        return hsl("),
			std::string("                                parseFloat(m2[0]), // degrees"),
			std::string("                                parseFloat(m2[1]) / 100, // percentage"),
			std::string("                                parseFloat(m2[2]) / 100 // percentage"),
			std::string("                        );"),
			std::string("                    }"),
			std::string("                    case \"rgb\": {"),
			std::string("                        return rgb("),
			std::string("                                d3_rgb_parseNumber(m2[0]),"),
			std::string("                                d3_rgb_parseNumber(m2[1]),"),
			std::string("                                d3_rgb_parseNumber(m2[2])"),
			std::string("                        );"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            /* Named colors. */"),
			std::string("            if (name = d3_rgb_names[format]) return rgb(name.r, name.g, name.b);"),
			std::string(""),
			std::string("            /* Hexadecimal colors: #rgb and #rrggbb. */"),
			std::string("            if (format != null && format.charAt(0) === \"#\") {"),
			std::string("                if (format.length === 4) {"),
			std::string("                    r = format.charAt(1); r += r;"),
			std::string("                    g = format.charAt(2); g += g;"),
			std::string("                    b = format.charAt(3); b += b;"),
			std::string("                } else if (format.length === 7) {"),
			std::string("                    r = format.substring(1, 3);"),
			std::string("                    g = format.substring(3, 5);"),
			std::string("                    b = format.substring(5, 7);"),
			std::string("                }"),
			std::string("                r = parseInt(r, 16);"),
			std::string("                g = parseInt(g, 16);"),
			std::string("                b = parseInt(b, 16);"),
			std::string("            }"),
			std::string(""),
			std::string("            return rgb(r, g, b);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_rgb_hsl(r, g, b) {"),
			std::string("            var min = Math.min(r /= 255, g /= 255, b /= 255),"),
			std::string("                    max = Math.max(r, g, b),"),
			std::string("                    d = max - min,"),
			std::string("                    h,"),
			std::string("                    s,"),
			std::string("                    l = (max + min) / 2;"),
			std::string("            if (d) {"),
			std::string("                s = l < .5 ? d / (max + min) : d / (2 - max - min);"),
			std::string("                if (r == max) h = (g - b) / d + (g < b ? 6 : 0);"),
			std::string("                else if (g == max) h = (b - r) / d + 2;"),
			std::string("                else h = (r - g) / d + 4;"),
			std::string("                h *= 60;"),
			std::string("            } else {"),
			std::string("                s = h = 0;"),
			std::string("            }"),
			std::string("            return d3_hsl(h, s, l);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_rgb_parseNumber(c) { // either integer or percentage"),
			std::string("            var f = parseFloat(c);"),
			std::string("            return c.charAt(c.length - 1) === \"%\" ? Math.round(f * 2.55) : f;"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_rgb_names = {"),
			std::string("            aliceblue: \"#f0f8ff\","),
			std::string("            antiquewhite: \"#faebd7\","),
			std::string("            aqua: \"#00ffff\","),
			std::string("            aquamarine: \"#7fffd4\","),
			std::string("            azure: \"#f0ffff\","),
			std::string("            beige: \"#f5f5dc\","),
			std::string("            bisque: \"#ffe4c4\","),
			std::string("            black: \"#000000\","),
			std::string("            blanchedalmond: \"#ffebcd\","),
			std::string("            blue: \"#0000ff\","),
			std::string("            blueviolet: \"#8a2be2\","),
			std::string("            brown: \"#a52a2a\","),
			std::string("            burlywood: \"#deb887\","),
			std::string("            cadetblue: \"#5f9ea0\","),
			std::string("            chartreuse: \"#7fff00\","),
			std::string("            chocolate: \"#d2691e\","),
			std::string("            coral: \"#ff7f50\","),
			std::string("            cornflowerblue: \"#6495ed\","),
			std::string("            cornsilk: \"#fff8dc\","),
			std::string("            crimson: \"#dc143c\","),
			std::string("            cyan: \"#00ffff\","),
			std::string("            darkblue: \"#00008b\","),
			std::string("            darkcyan: \"#008b8b\","),
			std::string("            darkgoldenrod: \"#b8860b\","),
			std::string("            darkgray: \"#a9a9a9\","),
			std::string("            darkgreen: \"#006400\","),
			std::string("            darkgrey: \"#a9a9a9\","),
			std::string("            darkkhaki: \"#bdb76b\","),
			std::string("            darkmagenta: \"#8b008b\","),
			std::string("            darkolivegreen: \"#556b2f\","),
			std::string("            darkorange: \"#ff8c00\","),
			std::string("            darkorchid: \"#9932cc\","),
			std::string("            darkred: \"#8b0000\","),
			std::string("            darksalmon: \"#e9967a\","),
			std::string("            darkseagreen: \"#8fbc8f\","),
			std::string("            darkslateblue: \"#483d8b\","),
			std::string("            darkslategray: \"#2f4f4f\","),
			std::string("            darkslategrey: \"#2f4f4f\","),
			std::string("            darkturquoise: \"#00ced1\","),
			std::string("            darkviolet: \"#9400d3\","),
			std::string("            deeppink: \"#ff1493\","),
			std::string("            deepskyblue: \"#00bfff\","),
			std::string("            dimgray: \"#696969\","),
			std::string("            dimgrey: \"#696969\","),
			std::string("            dodgerblue: \"#1e90ff\","),
			std::string("            firebrick: \"#b22222\","),
			std::string("            floralwhite: \"#fffaf0\","),
			std::string("            forestgreen: \"#228b22\","),
			std::string("            fuchsia: \"#ff00ff\","),
			std::string("            gainsboro: \"#dcdcdc\","),
			std::string("            ghostwhite: \"#f8f8ff\","),
			std::string("            gold: \"#ffd700\","),
			std::string("            goldenrod: \"#daa520\","),
			std::string("            gray: \"#808080\","),
			std::string("            green: \"#008000\","),
			std::string("            greenyellow: \"#adff2f\","),
			std::string("            grey: \"#808080\","),
			std::string("            honeydew: \"#f0fff0\","),
			std::string("            hotpink: \"#ff69b4\","),
			std::string("            indianred: \"#cd5c5c\","),
			std::string("            indigo: \"#4b0082\","),
			std::string("            ivory: \"#fffff0\","),
			std::string("            khaki: \"#f0e68c\","),
			std::string("            lavender: \"#e6e6fa\","),
			std::string("            lavenderblush: \"#fff0f5\","),
			std::string("            lawngreen: \"#7cfc00\","),
			std::string("            lemonchiffon: \"#fffacd\","),
			std::string("            lightblue: \"#add8e6\","),
			std::string("            lightcoral: \"#f08080\","),
			std::string("            lightcyan: \"#e0ffff\","),
			std::string("            lightgoldenrodyellow: \"#fafad2\","),
			std::string("            lightgray: \"#d3d3d3\","),
			std::string("            lightgreen: \"#90ee90\","),
			std::string("            lightgrey: \"#d3d3d3\","),
			std::string("            lightpink: \"#ffb6c1\","),
			std::string("            lightsalmon: \"#ffa07a\","),
			std::string("            lightseagreen: \"#20b2aa\","),
			std::string("            lightskyblue: \"#87cefa\","),
			std::string("            lightslategray: \"#778899\","),
			std::string("            lightslategrey: \"#778899\","),
			std::string("            lightsteelblue: \"#b0c4de\","),
			std::string("            lightyellow: \"#ffffe0\","),
			std::string("            lime: \"#00ff00\","),
			std::string("            limegreen: \"#32cd32\","),
			std::string("            linen: \"#faf0e6\","),
			std::string("            magenta: \"#ff00ff\","),
			std::string("            maroon: \"#800000\","),
			std::string("            mediumaquamarine: \"#66cdaa\","),
			std::string("            mediumblue: \"#0000cd\","),
			std::string("            mediumorchid: \"#ba55d3\","),
			std::string("            mediumpurple: \"#9370db\","),
			std::string("            mediumseagreen: \"#3cb371\","),
			std::string("            mediumslateblue: \"#7b68ee\","),
			std::string("            mediumspringgreen: \"#00fa9a\","),
			std::string("            mediumturquoise: \"#48d1cc\","),
			std::string("            mediumvioletred: \"#c71585\","),
			std::string("            midnightblue: \"#191970\","),
			std::string("            mintcream: \"#f5fffa\","),
			std::string("            mistyrose: \"#ffe4e1\","),
			std::string("            moccasin: \"#ffe4b5\","),
			std::string("            navajowhite: \"#ffdead\","),
			std::string("            navy: \"#000080\","),
			std::string("            oldlace: \"#fdf5e6\","),
			std::string("            olive: \"#808000\","),
			std::string("            olivedrab: \"#6b8e23\","),
			std::string("            orange: \"#ffa500\","),
			std::string("            orangered: \"#ff4500\","),
			std::string("            orchid: \"#da70d6\","),
			std::string("            palegoldenrod: \"#eee8aa\","),
			std::string("            palegreen: \"#98fb98\","),
			std::string("            paleturquoise: \"#afeeee\","),
			std::string("            palevioletred: \"#db7093\","),
			std::string("            papayawhip: \"#ffefd5\","),
			std::string("            peachpuff: \"#ffdab9\","),
			std::string("            peru: \"#cd853f\","),
			std::string("            pink: \"#ffc0cb\","),
			std::string("            plum: \"#dda0dd\","),
			std::string("            powderblue: \"#b0e0e6\","),
			std::string("            purple: \"#800080\","),
			std::string("            red: \"#ff0000\","),
			std::string("            rosybrown: \"#bc8f8f\","),
			std::string("            royalblue: \"#4169e1\","),
			std::string("            saddlebrown: \"#8b4513\","),
			std::string("            salmon: \"#fa8072\","),
			std::string("            sandybrown: \"#f4a460\","),
			std::string("            seagreen: \"#2e8b57\","),
			std::string("            seashell: \"#fff5ee\","),
			std::string("            sienna: \"#a0522d\","),
			std::string("            silver: \"#c0c0c0\","),
			std::string("            skyblue: \"#87ceeb\","),
			std::string("            slateblue: \"#6a5acd\","),
			std::string("            slategray: \"#708090\","),
			std::string("            slategrey: \"#708090\","),
			std::string("            snow: \"#fffafa\","),
			std::string("            springgreen: \"#00ff7f\","),
			std::string("            steelblue: \"#4682b4\","),
			std::string("            tan: \"#d2b48c\","),
			std::string("            teal: \"#008080\","),
			std::string("            thistle: \"#d8bfd8\","),
			std::string("            tomato: \"#ff6347\","),
			std::string("            turquoise: \"#40e0d0\","),
			std::string("            violet: \"#ee82ee\","),
			std::string("            wheat: \"#f5deb3\","),
			std::string("            white: \"#ffffff\","),
			std::string("            whitesmoke: \"#f5f5f5\","),
			std::string("            yellow: \"#ffff00\","),
			std::string("            yellowgreen: \"#9acd32\""),
			std::string("        };"),
			std::string(""),
			std::string("        for (var d3_rgb_name in d3_rgb_names) {"),
			std::string("            d3_rgb_names[d3_rgb_name] = d3_rgb_parse("),
			std::string("                    d3_rgb_names[d3_rgb_name],"),
			std::string("                    d3_rgb,"),
			std::string("                    d3_hsl_rgb);"),
			std::string("        }"),
			std::string("        d3.hsl = function(h, s, l) {"),
			std::string("            return arguments.length === 1"),
			std::string("                    ? (h instanceof d3_Hsl ? d3_hsl(h.h, h.s, h.l)"),
			std::string("                    : d3_rgb_parse(\"\" + h, d3_rgb_hsl, d3_hsl))"),
			std::string("                    : d3_hsl(+h, +s, +l);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_hsl(h, s, l) {"),
			std::string("            return new d3_Hsl(h, s, l);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_Hsl(h, s, l) {"),
			std::string("            this.h = h;"),
			std::string("            this.s = s;"),
			std::string("            this.l = l;"),
			std::string("        }"),
			std::string(""),
			std::string("        d3_Hsl.prototype.brighter = function(k) {"),
			std::string("            k = Math.pow(0.7, arguments.length ? k : 1);"),
			std::string("            return d3_hsl(this.h, this.s, this.l / k);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_Hsl.prototype.darker = function(k) {"),
			std::string("            k = Math.pow(0.7, arguments.length ? k : 1);"),
			std::string("            return d3_hsl(this.h, this.s, k * this.l);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_Hsl.prototype.rgb = function() {"),
			std::string("            return d3_hsl_rgb(this.h, this.s, this.l);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_Hsl.prototype.toString = function() {"),
			std::string("            return this.rgb().toString();"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_hsl_rgb(h, s, l) {"),
			std::string("            var m1,"),
			std::string("                    m2;"),
			std::string(""),
			std::string("            /* Some simple corrections for h, s and l. */"),
			std::string("            h = h % 360; if (h < 0) h += 360;"),
			std::string("            s = s < 0 ? 0 : s > 1 ? 1 : s;"),
			std::string("            l = l < 0 ? 0 : l > 1 ? 1 : l;"),
			std::string(""),
			std::string("            /* From FvD 13.37, CSS Color Module Level 3 */"),
			std::string("            m2 = l <= .5 ? l * (1 + s) : l + s - l * s;"),
			std::string("            m1 = 2 * l - m2;"),
			std::string(""),
			std::string("            function v(h) {"),
			std::string("                if (h > 360) h -= 360;"),
			std::string("                else if (h < 0) h += 360;"),
			std::string("                if (h < 60) return m1 + (m2 - m1) * h / 60;"),
			std::string("                if (h < 180) return m2;"),
			std::string("                if (h < 240) return m1 + (m2 - m1) * (240 - h) / 60;"),
			std::string("                return m1;"),
			std::string("            }"),
			std::string(""),
			std::string("            function vv(h) {"),
			std::string("                return Math.round(v(h) * 255);"),
			std::string("            }"),
			std::string(""),
			std::string("            return d3_rgb(vv(h + 120), vv(h), vv(h - 120));"),
			std::string("        }"),
			std::string("        function d3_selection(groups) {"),
			std::string("            d3_arraySubclass(groups, d3_selectionPrototype);"),
			std::string("            return groups;"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_select = function(s, n) { return n.querySelector(s); },"),
			std::string("                d3_selectAll = function(s, n) { return n.querySelectorAll(s); };"),
			std::string(""),
			std::string("// Prefer Sizzle, if available."),
			std::string("        if (typeof Sizzle === \"function\") {"),
			std::string("            d3_select = function(s, n) { return Sizzle(s, n)[0]; };"),
			std::string("            d3_selectAll = function(s, n) { return Sizzle.uniqueSort(Sizzle(s, n)); };"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_selectionPrototype = [];"),
			std::string(""),
			std::string("        d3.selection = function() {"),
			std::string("            return d3_selectionRoot;"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.selection.prototype = d3_selectionPrototype;"),
			std::string("        d3_selectionPrototype.select = function(selector) {"),
			std::string("            var subgroups = [],"),
			std::string("                    subgroup,"),
			std::string("                    subnode,"),
			std::string("                    group,"),
			std::string("                    node;"),
			std::string(""),
			std::string("            if (typeof selector !== \"function\") selector = d3_selection_selector(selector);"),
			std::string(""),
			std::string("            for (var j = -1, m = this.length; ++j < m;) {"),
			std::string("                subgroups.push(subgroup = []);"),
			std::string("                subgroup.parentNode = (group = this[j]).parentNode;"),
			std::string("                for (var i = -1, n = group.length; ++i < n;) {"),
			std::string("                    if (node = group[i]) {"),
			std::string("                        subgroup.push(subnode = selector.call(node, node.__data__, i));"),
			std::string("                        if (subnode && \"__data__\" in node) subnode.__data__ = node.__data__;"),
			std::string("                    } else {"),
			std::string("                        subgroup.push(null);"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            return d3_selection(subgroups);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_selection_selector(selector) {"),
			std::string("            return function() {"),
			std::string("                return d3_select(selector, this);"),
			std::string("            };"),
			std::string("        }"),
			std::string("        d3_selectionPrototype.selectAll = function(selector) {"),
			std::string("            var subgroups = [],"),
			std::string("                    subgroup,"),
			std::string("                    node;"),
			std::string(""),
			std::string("            if (typeof selector !== \"function\") selector = d3_selection_selectorAll(selector);"),
			std::string(""),
			std::string("            for (var j = -1, m = this.length; ++j < m;) {"),
			std::string("                for (var group = this[j], i = -1, n = group.length; ++i < n;) {"),
			std::string("                    if (node = group[i]) {"),
			std::string("                        subgroups.push(subgroup = d3_array(selector.call(node, node.__data__, i)));"),
			std::string("                        subgroup.parentNode = node;"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            return d3_selection(subgroups);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_selection_selectorAll(selector) {"),
			std::string("            return function() {"),
			std::string("                return d3_selectAll(selector, this);"),
			std::string("            };"),
			std::string("        }"),
			std::string("        d3_selectionPrototype.attr = function(name, value) {"),
			std::string("            name = d3.ns.qualify(name);"),
			std::string(""),
			std::string("            // If no value is specified, return the first value."),
			std::string("            if (arguments.length < 2) {"),
			std::string("                var node = this.node();"),
			std::string("                return name.local"),
			std::string("                        ? node.getAttributeNS(name.space, name.local)"),
			std::string("                        : node.getAttribute(name);"),
			std::string("            }"),
			std::string(""),
			std::string("            function attrNull() {"),
			std::string("                this.removeAttribute(name);"),
			std::string("            }"),
			std::string(""),
			std::string("            function attrNullNS() {"),
			std::string("                this.removeAttributeNS(name.space, name.local);"),
			std::string("            }"),
			std::string(""),
			std::string("            function attrConstant() {"),
			std::string("                this.setAttribute(name, value);"),
			std::string("            }"),
			std::string(""),
			std::string("            function attrConstantNS() {"),
			std::string("                this.setAttributeNS(name.space, name.local, value);"),
			std::string("            }"),
			std::string(""),
			std::string("            function attrFunction() {"),
			std::string("                var x = value.apply(this, arguments);"),
			std::string("                if (x == null) this.removeAttribute(name);"),
			std::string("                else this.setAttribute(name, x);"),
			std::string("            }"),
			std::string(""),
			std::string("            function attrFunctionNS() {"),
			std::string("                var x = value.apply(this, arguments);"),
			std::string("                if (x == null) this.removeAttributeNS(name.space, name.local);"),
			std::string("                else this.setAttributeNS(name.space, name.local, x);"),
			std::string("            }"),
			std::string(""),
			std::string("            return this.each(value == null"),
			std::string("                    ? (name.local ? attrNullNS : attrNull) : (typeof value === \"function\""),
			std::string("                    ? (name.local ? attrFunctionNS : attrFunction)"),
			std::string("                    : (name.local ? attrConstantNS : attrConstant)));"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.classed = function(name, value) {"),
			std::string("            var names = name.split(d3_selection_classedWhitespace),"),
			std::string("                    n = names.length,"),
			std::string("                    i = -1;"),
			std::string("            if (arguments.length > 1) {"),
			std::string("                while (++i < n) d3_selection_classed.call(this, names[i], value);"),
			std::string("                return this;"),
			std::string("            } else {"),
			std::string("                while (++i < n) if (!d3_selection_classed.call(this, names[i])) return false;"),
			std::string("                return true;"),
			std::string("            }"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_selection_classedWhitespace = /\\s+/g;"),
			std::string(""),
			std::string("        function d3_selection_classed(name, value) {"),
			std::string("            var re = new RegExp(\"(^|\\\\s+)\" + d3.requote(name) + \"(\\\\s+|$)\", \"g\");"),
			std::string(""),
			std::string("            // If no value is specified, return the first value."),
			std::string("            if (arguments.length < 2) {"),
			std::string("                var node = this.node();"),
			std::string("                if (c = node.classList) return c.contains(name);"),
			std::string("                var c = node.className;"),
			std::string("                re.lastIndex = 0;"),
			std::string("                return re.test(c.baseVal != null ? c.baseVal : c);"),
			std::string("            }"),
			std::string(""),
			std::string("            function classedAdd() {"),
			std::string("                if (c = this.classList) return c.add(name);"),
			std::string("                var c = this.className,"),
			std::string("                        cb = c.baseVal != null,"),
			std::string("                        cv = cb ? c.baseVal : c;"),
			std::string("                re.lastIndex = 0;"),
			std::string("                if (!re.test(cv)) {"),
			std::string("                    cv = d3_collapse(cv + \" \" + name);"),
			std::string("                    if (cb) c.baseVal = cv;"),
			std::string("                    else this.className = cv;"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            function classedRemove() {"),
			std::string("                if (c = this.classList) return c.remove(name);"),
			std::string("                var c = this.className,"),
			std::string("                        cb = c.baseVal != null,"),
			std::string("                        cv = cb ? c.baseVal : c;"),
			std::string("                cv = d3_collapse(cv.replace(re, \" \"));"),
			std::string("                if (cb) c.baseVal = cv;"),
			std::string("                else this.className = cv;"),
			std::string("            }"),
			std::string(""),
			std::string("            function classedFunction() {"),
			std::string("                (value.apply(this, arguments)"),
			std::string("                        ? classedAdd"),
			std::string("                        : classedRemove).call(this);"),
			std::string("            }"),
			std::string(""),
			std::string("            return this.each(typeof value === \"function\""),
			std::string("                    ? classedFunction : value"),
			std::string("                    ? classedAdd"),
			std::string("                    : classedRemove);"),
			std::string("        }"),
			std::string("        d3_selectionPrototype.style = function(name, value, priority) {"),
			std::string("            if (arguments.length < 3) priority = \"\";"),
			std::string(""),
			std::string("            // If no value is specified, return the first value."),
			std::string("            if (arguments.length < 2) return window"),
			std::string("                    .getComputedStyle(this.node(), null)"),
			std::string("                    .getPropertyValue(name);"),
			std::string(""),
			std::string("            function styleNull() {"),
			std::string("                this.style.removeProperty(name);"),
			std::string("            }"),
			std::string(""),
			std::string("            function styleConstant() {"),
			std::string("                this.style.setProperty(name, value, priority);"),
			std::string("            }"),
			std::string(""),
			std::string("            function styleFunction() {"),
			std::string("                var x = value.apply(this, arguments);"),
			std::string("                if (x == null) this.style.removeProperty(name);"),
			std::string("                else this.style.setProperty(name, x, priority);"),
			std::string("            }"),
			std::string(""),
			std::string("            return this.each(value == null"),
			std::string("                    ? styleNull : (typeof value === \"function\""),
			std::string("                    ? styleFunction : styleConstant));"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.property = function(name, value) {"),
			std::string(""),
			std::string("            // If no value is specified, return the first value."),
			std::string("            if (arguments.length < 2) return this.node()[name];"),
			std::string(""),
			std::string("            function propertyNull() {"),
			std::string("                delete this[name];"),
			std::string("            }"),
			std::string(""),
			std::string("            function propertyConstant() {"),
			std::string("                this[name] = value;"),
			std::string("            }"),
			std::string(""),
			std::string("            function propertyFunction() {"),
			std::string("                var x = value.apply(this, arguments);"),
			std::string("                if (x == null) delete this[name];"),
			std::string("                else this[name] = x;"),
			std::string("            }"),
			std::string(""),
			std::string("            return this.each(value == null"),
			std::string("                    ? propertyNull : (typeof value === \"function\""),
			std::string("                    ? propertyFunction : propertyConstant));"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.text = function(value) {"),
			std::string("            return arguments.length < 1 ? this.node().textContent"),
			std::string("                    : (this.each(typeof value === \"function\""),
			std::string("                    ? function() { this.textContent = value.apply(this, arguments); }"),
			std::string("                    : function() { this.textContent = value; }));"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.html = function(value) {"),
			std::string("            return arguments.length < 1 ? this.node().innerHTML"),
			std::string("                    : (this.each(typeof value === \"function\""),
			std::string("                    ? function() { this.innerHTML = value.apply(this, arguments); }"),
			std::string("                    : function() { this.innerHTML = value; }));"),
			std::string("        };"),
			std::string("// TODO append(node)?"),
			std::string("// TODO append(function)?"),
			std::string("        d3_selectionPrototype.append = function(name) {"),
			std::string("            name = d3.ns.qualify(name);"),
			std::string(""),
			std::string("            function append() {"),
			std::string("                return this.appendChild(document.createElement(name));"),
			std::string("            }"),
			std::string(""),
			std::string("            function appendNS() {"),
			std::string("                return this.appendChild(document.createElementNS(name.space, name.local));"),
			std::string("            }"),
			std::string(""),
			std::string("            return this.select(name.local ? appendNS : append);"),
			std::string("        };"),
			std::string("// TODO insert(node, function)?"),
			std::string("// TODO insert(function, string)?"),
			std::string("// TODO insert(function, function)?"),
			std::string("        d3_selectionPrototype.insert = function(name, before) {"),
			std::string("            name = d3.ns.qualify(name);"),
			std::string(""),
			std::string("            function insert() {"),
			std::string("                return this.insertBefore("),
			std::string("                        document.createElement(name),"),
			std::string("                        d3_select(before, this));"),
			std::string("            }"),
			std::string(""),
			std::string("            function insertNS() {"),
			std::string("                return this.insertBefore("),
			std::string("                        document.createElementNS(name.space, name.local),"),
			std::string("                        d3_select(before, this));"),
			std::string("            }"),
			std::string(""),
			std::string("            return this.select(name.local ? insertNS : insert);"),
			std::string("        };"),
			std::string("// TODO remove(selector)?"),
			std::string("// TODO remove(node)?"),
			std::string("// TODO remove(function)?"),
			std::string("        d3_selectionPrototype.remove = function() {"),
			std::string("            return this.each(function() {"),
			std::string("                var parent = this.parentNode;"),
			std::string("                if (parent) parent.removeChild(this);"),
			std::string("            });"),
			std::string("        };"),
			std::string("// TODO data(null) for clearing data?"),
			std::string("        d3_selectionPrototype.data = function(data, join) {"),
			std::string("            var enter = [],"),
			std::string("                    update = [],"),
			std::string("                    exit = [];"),
			std::string(""),
			std::string("            function bind(group, groupData) {"),
			std::string("                var i,"),
			std::string("                        n = group.length,"),
			std::string("                        m = groupData.length,"),
			std::string("                        n0 = Math.min(n, m),"),
			std::string("                        n1 = Math.max(n, m),"),
			std::string("                        updateNodes = [],"),
			std::string("                        enterNodes = [],"),
			std::string("                        exitNodes = [],"),
			std::string("                        node,"),
			std::string("                        nodeData;"),
			std::string(""),
			std::string("                if (join) {"),
			std::string("                    var nodeByKey = {},"),
			std::string("                            keys = [],"),
			std::string("                            key,"),
			std::string("                            j = groupData.length;"),
			std::string(""),
			std::string("                    for (i = -1; ++i < n;) {"),
			std::string("                        key = join.call(node = group[i], node.__data__, i);"),
			std::string("                        if (key in nodeByKey) {"),
			std::string("                            exitNodes[j++] = node; // duplicate key"),
			std::string("                        } else {"),
			std::string("                            nodeByKey[key] = node;"),
			std::string("                        }"),
			std::string("                        keys.push(key);"),
			std::string("                    }"),
			std::string(""),
			std::string("                    for (i = -1; ++i < m;) {"),
			std::string("                        node = nodeByKey[key = join.call(groupData, nodeData = groupData[i], i)];"),
			std::string("                        if (node) {"),
			std::string("                            node.__data__ = nodeData;"),
			std::string("                            updateNodes[i] = node;"),
			std::string("                            enterNodes[i] = exitNodes[i] = null;"),
			std::string("                        } else {"),
			std::string("                            enterNodes[i] = d3_selection_dataNode(nodeData);"),
			std::string("                            updateNodes[i] = exitNodes[i] = null;"),
			std::string("                        }"),
			std::string("                        delete nodeByKey[key];"),
			std::string("                    }"),
			std::string(""),
			std::string("                    for (i = -1; ++i < n;) {"),
			std::string("                        if (keys[i] in nodeByKey) {"),
			std::string("                            exitNodes[i] = group[i];"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                } else {"),
			std::string("                    for (i = -1; ++i < n0;) {"),
			std::string("                        node = group[i];"),
			std::string("                        nodeData = groupData[i];"),
			std::string("                        if (node) {"),
			std::string("                            node.__data__ = nodeData;"),
			std::string("                            updateNodes[i] = node;"),
			std::string("                            enterNodes[i] = exitNodes[i] = null;"),
			std::string("                        } else {"),
			std::string("                            enterNodes[i] = d3_selection_dataNode(nodeData);"),
			std::string("                            updateNodes[i] = exitNodes[i] = null;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                    for (; i < m; ++i) {"),
			std::string("                        enterNodes[i] = d3_selection_dataNode(groupData[i]);"),
			std::string("                        updateNodes[i] = exitNodes[i] = null;"),
			std::string("                    }"),
			std::string("                    for (; i < n1; ++i) {"),
			std::string("                        exitNodes[i] = group[i];"),
			std::string("                        enterNodes[i] = updateNodes[i] = null;"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                enterNodes.update"),
			std::string("                        = updateNodes;"),
			std::string(""),
			std::string("                enterNodes.parentNode"),
			std::string("                        = updateNodes.parentNode"),
			std::string("                        = exitNodes.parentNode"),
			std::string("                        = group.parentNode;"),
			std::string(""),
			std::string("                enter.push(enterNodes);"),
			std::string("                update.push(updateNodes);"),
			std::string("                exit.push(exitNodes);"),
			std::string("            }"),
			std::string(""),
			std::string("            var i = -1,"),
			std::string("                    n = this.length,"),
			std::string("                    group;"),
			std::string("            if (typeof data === \"function\") {"),
			std::string("                while (++i < n) {"),
			std::string("                    bind(group = this[i], data.call(group, group.parentNode.__data__, i));"),
			std::string("                }"),
			std::string("            } else {"),
			std::string("                while (++i < n) {"),
			std::string("                    bind(group = this[i], data);"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            var selection = d3_selection(update);"),
			std::string("            selection.enter = function() { return d3_selection_enter(enter); };"),
			std::string("            selection.exit = function() { return d3_selection(exit); };"),
			std::string("            return selection;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_selection_dataNode(data) {"),
			std::string("            return {__data__: data};"),
			std::string("        }"),
			std::string("// TODO preserve null elements to maintain index?"),
			std::string("        d3_selectionPrototype.filter = function(filter) {"),
			std::string("            var subgroups = [],"),
			std::string("                    subgroup,"),
			std::string("                    group,"),
			std::string("                    node;"),
			std::string(""),
			std::string("            for (var j = 0, m = this.length; j < m; j++) {"),
			std::string("                subgroups.push(subgroup = []);"),
			std::string("                subgroup.parentNode = (group = this[j]).parentNode;"),
			std::string("                for (var i = 0, n = group.length; i < n; i++) {"),
			std::string("                    if ((node = group[i]) && filter.call(node, node.__data__, i)) {"),
			std::string("                        subgroup.push(node);"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            return d3_selection(subgroups);"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.map = function(map) {"),
			std::string("            return this.each(function() {"),
			std::string("                this.__data__ = map.apply(this, arguments);"),
			std::string("            });"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.sort = function(comparator) {"),
			std::string("            comparator = d3_selection_sortComparator.apply(this, arguments);"),
			std::string("            for (var j = 0, m = this.length; j < m; j++) {"),
			std::string("                for (var group = this[j].sort(comparator), i = 1, n = group.length, prev = group[0]; i < n; i++) {"),
			std::string("                    var node = group[i];"),
			std::string("                    if (node) {"),
			std::string("                        if (prev) prev.parentNode.insertBefore(node, prev.nextSibling);"),
			std::string("                        prev = node;"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return this;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_selection_sortComparator(comparator) {"),
			std::string("            if (!arguments.length) comparator = d3.ascending;"),
			std::string("            return function(a, b) {"),
			std::string("                return comparator(a && a.__data__, b && b.__data__);"),
			std::string("            };"),
			std::string("        }"),
			std::string("// type can be namespaced, e.g., \"click.foo\""),
			std::string("// listener can be null for removal"),
			std::string("        d3_selectionPrototype.on = function(type, listener, capture) {"),
			std::string("            if (arguments.length < 3) capture = false;"),
			std::string(""),
			std::string("            // parse the type specifier"),
			std::string("            var name = \"__on\" + type, i = type.indexOf(\".\");"),
			std::string("            if (i > 0) type = type.substring(0, i);"),
			std::string(""),
			std::string("            // if called with only one argument, return the current listener"),
			std::string("            if (arguments.length < 2) return (i = this.node()[name]) && i._;"),
			std::string(""),
			std::string("            // remove the old event listener, and add the new event listener"),
			std::string("            return this.each(function(d, i) {"),
			std::string("                var node = this;"),
			std::string(""),
			std::string("                if (node[name]) node.removeEventListener(type, node[name], capture);"),
			std::string("                if (listener) node.addEventListener(type, node[name] = l, capture);"),
			std::string(""),
			std::string("                // wrapped event listener that preserves i"),
			std::string("                function l(e) {"),
			std::string("                    var o = d3.event; // Events can be reentrant (e.g., focus)."),
			std::string("                    d3.event = e;"),
			std::string("                    try {"),
			std::string("                        listener.call(node, node.__data__, i);"),
			std::string("                    } finally {"),
			std::string("                        d3.event = o;"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                // stash the unwrapped listener for retrieval"),
			std::string("                l._ = listener;"),
			std::string("            });"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.each = function(callback) {"),
			std::string("            for (var j = -1, m = this.length; ++j < m;) {"),
			std::string("                for (var group = this[j], i = -1, n = group.length; ++i < n;) {"),
			std::string("                    var node = group[i];"),
			std::string("                    if (node) callback.call(node, node.__data__, i, j);"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return this;"),
			std::string("        };"),
			std::string("//"),
			std::string("// Note: assigning to the arguments array simultaneously changes the value of"),
			std::string("// the corresponding argument!"),
			std::string("//"),
			std::string("// TODO The `this` argument probably shouldn't be the first argument to the"),
			std::string("// callback, anyway, since it's redundant. However, that will require a major"),
			std::string("// version bump due to backwards compatibility, so I'm not changing it right"),
			std::string("// away."),
			std::string("//"),
			std::string("        d3_selectionPrototype.call = function(callback) {"),
			std::string("            callback.apply(this, (arguments[0] = this, arguments));"),
			std::string("            return this;"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.empty = function() {"),
			std::string("            return !this.node();"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.node = function(callback) {"),
			std::string("            for (var j = 0, m = this.length; j < m; j++) {"),
			std::string("                for (var group = this[j], i = 0, n = group.length; i < n; i++) {"),
			std::string("                    var node = group[i];"),
			std::string("                    if (node) return node;"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return null;"),
			std::string("        };"),
			std::string("        d3_selectionPrototype.transition = function() {"),
			std::string("            var subgroups = [],"),
			std::string("                    subgroup,"),
			std::string("                    node;"),
			std::string(""),
			std::string("            for (var j = -1, m = this.length; ++j < m;) {"),
			std::string("                subgroups.push(subgroup = []);"),
			std::string("                for (var group = this[j], i = -1, n = group.length; ++i < n;) {"),
			std::string("                    subgroup.push((node = group[i]) ? {node: node, delay: 0, duration: 250} : null);"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            return d3_transition(subgroups, d3_transitionInheritId || ++d3_transitionId, Date.now());"),
			std::string("        };"),
			std::string("        var d3_selectionRoot = d3_selection([[document]]);"),
			std::string(""),
			std::string("        d3_selectionRoot[0].parentNode = document.documentElement;"),
			std::string(""),
			std::string("// TODO fast singleton implementation!"),
			std::string("// TODO select(function)"),
			std::string("        d3.select = function(selector) {"),
			std::string("            return typeof selector === \"string\""),
			std::string("                    ? d3_selectionRoot.select(selector)"),
			std::string("                    : d3_selection([[selector]]); // assume node"),
			std::string("        };"),
			std::string(""),
			std::string("// TODO selectAll(function)"),
			std::string("        d3.selectAll = function(selector) {"),
			std::string("            return typeof selector === \"string\""),
			std::string("                    ? d3_selectionRoot.selectAll(selector)"),
			std::string("                    : d3_selection([d3_array(selector)]); // assume node[]"),
			std::string("        };"),
			std::string("        function d3_selection_enter(selection) {"),
			std::string("            d3_arraySubclass(selection, d3_selection_enterPrototype);"),
			std::string("            return selection;"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_selection_enterPrototype = [];"),
			std::string(""),
			std::string("        d3_selection_enterPrototype.append = d3_selectionPrototype.append;"),
			std::string("        d3_selection_enterPrototype.insert = d3_selectionPrototype.insert;"),
			std::string("        d3_selection_enterPrototype.empty = d3_selectionPrototype.empty;"),
			std::string("        d3_selection_enterPrototype.node = d3_selectionPrototype.node;"),
			std::string("        d3_selection_enterPrototype.select = function(selector) {"),
			std::string("            var subgroups = [],"),
			std::string("                    subgroup,"),
			std::string("                    subnode,"),
			std::string("                    upgroup,"),
			std::string("                    group,"),
		};

		const std::string d3TemplateBlockNo2[] = 
		{
			std::string("                    node;"),
			std::string(""),
			std::string("            for (var j = -1, m = this.length; ++j < m;) {"),
			std::string("                upgroup = (group = this[j]).update;"),
			std::string("                subgroups.push(subgroup = []);"),
			std::string("                subgroup.parentNode = group.parentNode;"),
			std::string("                for (var i = -1, n = group.length; ++i < n;) {"),
			std::string("                    if (node = group[i]) {"),
			std::string("                        subgroup.push(upgroup[i] = subnode = selector.call(group.parentNode, node.__data__, i));"),
			std::string("                        subnode.__data__ = node.__data__;"),
			std::string("                    } else {"),
			std::string("                        subgroup.push(null);"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            return d3_selection(subgroups);"),
			std::string("        };"),
			std::string("        function d3_transition(groups, id, time) {"),
			std::string("            d3_arraySubclass(groups, d3_transitionPrototype);"),
			std::string(""),
			std::string("            var tweens = {},"),
			std::string("                    event = d3.dispatch(\"start\", \"end\"),"),
			std::string("                    ease = d3_transitionEase;"),
			std::string(""),
			std::string("            groups.id = id;"),
			std::string(""),
			std::string("            groups.time = time;"),
			std::string(""),
			std::string("            groups.tween = function(name, tween) {"),
			std::string("                if (arguments.length < 2) return tweens[name];"),
			std::string("                if (tween == null) delete tweens[name];"),
			std::string("                else tweens[name] = tween;"),
			std::string("                return groups;"),
			std::string("            };"),
			std::string(""),
			std::string("            groups.ease = function(value) {"),
			std::string("                if (!arguments.length) return ease;"),
			std::string("                ease = typeof value === \"function\" ? value : d3.ease.apply(d3, arguments);"),
			std::string("                return groups;"),
			std::string("            };"),
			std::string(""),
			std::string("            groups.each = function(type, listener) {"),
			std::string("                if (arguments.length < 2) return d3_transition_each.call(groups, type);"),
			std::string("                event.on(type, listener);"),
			std::string("                return groups;"),
			std::string("            };"),
			std::string(""),
			std::string("            d3.timer(function(elapsed) {"),
			std::string("                groups.each(function(d, i, j) {"),
			std::string("                    var tweened = [],"),
			std::string("                            node = this,"),
			std::string("                            delay = groups[j][i].delay,"),
			std::string("                            duration = groups[j][i].duration,"),
			std::string("                            lock = node.__transition__ || (node.__transition__ = {active: 0, count: 0});"),
			std::string(""),
			std::string("                    ++lock.count;"),
			std::string(""),
			std::string("                    delay <= elapsed ? start(elapsed) : d3.timer(start, delay, time);"),
			std::string(""),
			std::string("                    function start(elapsed) {"),
			std::string("                        if (lock.active > id) return stop();"),
			std::string("                        lock.active = id;"),
			std::string(""),
			std::string("                        for (var tween in tweens) {"),
			std::string("                            if (tween = tweens[tween].call(node, d, i)) {"),
			std::string("                                tweened.push(tween);"),
			std::string("                            }"),
			std::string("                        }"),
			std::string(""),
			std::string("                        event.start.call(node, d, i);"),
			std::string("                        if (!tick(elapsed)) d3.timer(tick, 0, time);"),
			std::string("                        return 1;"),
			std::string("                    }"),
			std::string(""),
			std::string("                    function tick(elapsed) {"),
			std::string("                        if (lock.active !== id) return stop();"),
			std::string(""),
			std::string("                        var t = (elapsed - delay) / duration,"),
			std::string("                                e = ease(t),"),
			std::string("                                n = tweened.length;"),
			std::string(""),
			std::string("                        while (n > 0) {"),
			std::string("                            tweened[--n].call(node, e);"),
			std::string("                        }"),
			std::string(""),
			std::string("                        if (t >= 1) {"),
			std::string("                            stop();"),
			std::string("                            d3_transitionInheritId = id;"),
			std::string("                            event.end.call(node, d, i);"),
			std::string("                            d3_transitionInheritId = 0;"),
			std::string("                            return 1;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string(""),
			std::string("                    function stop() {"),
			std::string("                        if (!--lock.count) delete node.__transition__;"),
			std::string("                        return 1;"),
			std::string("                    }"),
			std::string("                });"),
			std::string("                return 1;"),
			std::string("            }, 0, time);"),
			std::string(""),
			std::string("            return groups;"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_transitionRemove = {};"),
			std::string(""),
			std::string("        function d3_transitionNull(d, i, a) {"),
			std::string("            return a != \"\" && d3_transitionRemove;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_transitionTween(name, b) {"),
			std::string("            var interpolate = d3_interpolateByName(name);"),
			std::string(""),
			std::string("            function transitionFunction(d, i, a) {"),
			std::string("                var v = b.call(this, d, i);"),
			std::string("                return v == null"),
			std::string("                        ? a != \"\" && d3_transitionRemove"),
			std::string("                        : a != v && interpolate(a, v);"),
			std::string("            }"),
			std::string(""),
			std::string("            function transitionString(d, i, a) {"),
			std::string("                return a != b && interpolate(a, b);"),
			std::string("            }"),
			std::string(""),
			std::string("            return typeof b === \"function\" ? transitionFunction"),
			std::string("                    : b == null ? d3_transitionNull"),
			std::string("                    : (b += \"\", transitionString);"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_transitionPrototype = [],"),
			std::string("                d3_transitionId = 0,"),
			std::string("                d3_transitionInheritId = 0,"),
			std::string("                d3_transitionEase = d3.ease(\"cubic-in-out\");"),
			std::string(""),
			std::string("        d3_transitionPrototype.call = d3_selectionPrototype.call;"),
			std::string(""),
			std::string("        d3.transition = function() {"),
			std::string("            return d3_selectionRoot.transition();"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.transition.prototype = d3_transitionPrototype;"),
			std::string("        d3_transitionPrototype.select = function(selector) {"),
			std::string("            var subgroups = [],"),
			std::string("                    subgroup,"),
			std::string("                    subnode,"),
			std::string("                    node;"),
			std::string(""),
			std::string("            if (typeof selector !== \"function\") selector = d3_selection_selector(selector);"),
			std::string(""),
			std::string("            for (var j = -1, m = this.length; ++j < m;) {"),
			std::string("                subgroups.push(subgroup = []);"),
			std::string("                for (var group = this[j], i = -1, n = group.length; ++i < n;) {"),
			std::string("                    if ((node = group[i]) && (subnode = selector.call(node.node, node.node.__data__, i))) {"),
			std::string("                        if (\"__data__\" in node.node) subnode.__data__ = node.node.__data__;"),
			std::string("                        subgroup.push({node: subnode, delay: node.delay, duration: node.duration});"),
			std::string("                    } else {"),
			std::string("                        subgroup.push(null);"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            return d3_transition(subgroups, this.id, this.time).ease(this.ease());"),
			std::string("        };"),
			std::string("        d3_transitionPrototype.selectAll = function(selector) {"),
			std::string("            var subgroups = [],"),
			std::string("                    subgroup,"),
			std::string("                    subnodes,"),
			std::string("                    node;"),
			std::string(""),
			std::string("            if (typeof selector !== \"function\") selector = d3_selection_selectorAll(selector);"),
			std::string(""),
			std::string("            for (var j = -1, m = this.length; ++j < m;) {"),
			std::string("                for (var group = this[j], i = -1, n = group.length; ++i < n;) {"),
			std::string("                    if (node = group[i]) {"),
			std::string("                        subnodes = selector.call(node.node, node.node.__data__, i);"),
			std::string("                        subgroups.push(subgroup = []);"),
			std::string("                        for (var k = -1, o = subnodes.length; ++k < o;) {"),
			std::string("                            subgroup.push({node: subnodes[k], delay: node.delay, duration: node.duration});"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            return d3_transition(subgroups, this.id, this.time).ease(this.ease());"),
			std::string("        };"),
			std::string("        d3_transitionPrototype.attr = function(name, value) {"),
			std::string("            return this.attrTween(name, d3_transitionTween(name, value));"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_transitionPrototype.attrTween = function(nameNS, tween) {"),
			std::string("            var name = d3.ns.qualify(nameNS);"),
			std::string(""),
			std::string("            function attrTween(d, i) {"),
			std::string("                var f = tween.call(this, d, i, this.getAttribute(name));"),
			std::string("                return f === d3_transitionRemove"),
			std::string("                        ? (this.removeAttribute(name), null)"),
			std::string("                        : f && function(t) { this.setAttribute(name, f(t)); };"),
			std::string("            }"),
			std::string(""),
			std::string("            function attrTweenNS(d, i) {"),
			std::string("                var f = tween.call(this, d, i, this.getAttributeNS(name.space, name.local));"),
			std::string("                return f === d3_transitionRemove"),
			std::string("                        ? (this.removeAttributeNS(name.space, name.local), null)"),
			std::string("                        : f && function(t) { this.setAttributeNS(name.space, name.local, f(t)); };"),
			std::string("            }"),
			std::string(""),
			std::string("            return this.tween(\"attr.\" + nameNS, name.local ? attrTweenNS : attrTween);"),
			std::string("        };"),
			std::string("        d3_transitionPrototype.style = function(name, value, priority) {"),
			std::string("            if (arguments.length < 3) priority = \"\";"),
			std::string("            return this.styleTween(name, d3_transitionTween(name, value), priority);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_transitionPrototype.styleTween = function(name, tween, priority) {"),
			std::string("            if (arguments.length < 3) priority = \"\";"),
			std::string("            return this.tween(\"style.\" + name, function(d, i) {"),
			std::string("                var f = tween.call(this, d, i, window.getComputedStyle(this, null).getPropertyValue(name));"),
			std::string("                return f === d3_transitionRemove"),
			std::string("                        ? (this.style.removeProperty(name), null)"),
			std::string("                        : f && function(t) { this.style.setProperty(name, f(t), priority); };"),
			std::string("            });"),
			std::string("        };"),
			std::string("        d3_transitionPrototype.text = function(value) {"),
			std::string("            return this.tween(\"text\", function(d, i) {"),
			std::string("                this.textContent = typeof value === \"function\""),
			std::string("                        ? value.call(this, d, i)"),
			std::string("                        : value;"),
			std::string("            });"),
			std::string("        };"),
			std::string("        d3_transitionPrototype.remove = function() {"),
			std::string("            return this.each(\"end\", function() {"),
			std::string("                var p;"),
			std::string("                if (!this.__transition__ && (p = this.parentNode)) p.removeChild(this);"),
			std::string("            });"),
			std::string("        };"),
			std::string("        d3_transitionPrototype.delay = function(value) {"),
			std::string("            var groups = this;"),
			std::string("            return groups.each(typeof value === \"function\""),
			std::string("                    ? function(d, i, j) { groups[j][i].delay = +value.apply(this, arguments); }"),
			std::string("                    : (value = +value, function(d, i, j) { groups[j][i].delay = value; }));"),
			std::string("        };"),
			std::string("        d3_transitionPrototype.duration = function(value) {"),
			std::string("            var groups = this;"),
			std::string("            return groups.each(typeof value === \"function\""),
			std::string("                    ? function(d, i, j) { groups[j][i].duration = +value.apply(this, arguments); }"),
			std::string("                    : (value = +value, function(d, i, j) { groups[j][i].duration = value; }));"),
			std::string("        };"),
			std::string("        function d3_transition_each(callback) {"),
			std::string("            for (var j = 0, m = this.length; j < m; j++) {"),
			std::string("                for (var group = this[j], i = 0, n = group.length; i < n; i++) {"),
			std::string("                    var node = group[i];"),
			std::string("                    if (node) callback.call(node = node.node, node.__data__, i, j);"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return this;"),
			std::string("        }"),
			std::string("        d3_transitionPrototype.transition = function() {"),
			std::string("            return this.select(d3_this);"),
			std::string("        };"),
			std::string("        var d3_timer_queue = null,"),
			std::string("                d3_timer_interval, // is an interval (or frame) active?"),
			std::string("                d3_timer_timeout; // is a timeout active?"),
			std::string(""),
			std::string("// The timer will continue to fire until callback returns true."),
			std::string("        d3.timer = function(callback, delay, then) {"),
			std::string("            var found = false,"),
			std::string("                    t0,"),
			std::string("                    t1 = d3_timer_queue;"),
			std::string(""),
			std::string("            if (arguments.length < 3) {"),
			std::string("                if (arguments.length < 2) delay = 0;"),
			std::string("                else if (!isFinite(delay)) return;"),
			std::string("                then = Date.now();"),
			std::string("            }"),
			std::string(""),
			std::string("            // See if the callback's already in the queue."),
			std::string("            while (t1) {"),
			std::string("                if (t1.callback === callback) {"),
			std::string("                    t1.then = then;"),
			std::string("                    t1.delay = delay;"),
			std::string("                    found = true;"),
			std::string("                    break;"),
			std::string("                }"),
			std::string("                t0 = t1;"),
			std::string("                t1 = t1.next;"),
			std::string("            }"),
			std::string(""),
			std::string("            // Otherwise, add the callback to the queue."),
			std::string("            if (!found) d3_timer_queue = {"),
			std::string("                callback: callback,"),
			std::string("                then: then,"),
			std::string("                delay: delay,"),
			std::string("                next: d3_timer_queue"),
			std::string("            };"),
			std::string(""),
			std::string("            // Start animatin'!"),
			std::string("            if (!d3_timer_interval) {"),
			std::string("                d3_timer_timeout = clearTimeout(d3_timer_timeout);"),
			std::string("                d3_timer_interval = 1;"),
			std::string("                d3_timer_frame(d3_timer_step);"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_timer_step() {"),
			std::string("            var elapsed,"),
			std::string("                    now = Date.now(),"),
			std::string("                    t1 = d3_timer_queue;"),
			std::string(""),
			std::string("            while (t1) {"),
			std::string("                elapsed = now - t1.then;"),
			std::string("                if (elapsed >= t1.delay) t1.flush = t1.callback(elapsed);"),
			std::string("                t1 = t1.next;"),
			std::string("            }"),
			std::string(""),
			std::string("            var delay = d3_timer_flush() - now;"),
			std::string("            if (delay > 24) {"),
			std::string("                if (isFinite(delay)) {"),
			std::string("                    clearTimeout(d3_timer_timeout);"),
			std::string("                    d3_timer_timeout = setTimeout(d3_timer_step, delay);"),
			std::string("                }"),
			std::string("                d3_timer_interval = 0;"),
			std::string("            } else {"),
			std::string("                d3_timer_interval = 1;"),
			std::string("                d3_timer_frame(d3_timer_step);"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        d3.timer.flush = function() {"),
			std::string("            var elapsed,"),
			std::string("                    now = Date.now(),"),
			std::string("                    t1 = d3_timer_queue;"),
			std::string(""),
			std::string("            while (t1) {"),
			std::string("                elapsed = now - t1.then;"),
			std::string("                if (!t1.delay) t1.flush = t1.callback(elapsed);"),
			std::string("                t1 = t1.next;"),
			std::string("            }"),
			std::string(""),
			std::string("            d3_timer_flush();"),
			std::string("        };"),
			std::string(""),
			std::string("// Flush after callbacks, to avoid concurrent queue modification."),
			std::string("        function d3_timer_flush() {"),
			std::string("            var t0 = null,"),
			std::string("                    t1 = d3_timer_queue,"),
			std::string("                    then = Infinity;"),
			std::string("            while (t1) {"),
			std::string("                if (t1.flush) {"),
			std::string("                    t1 = t0 ? t0.next = t1.next : d3_timer_queue = t1.next;"),
			std::string("                } else {"),
			std::string("                    then = Math.min(then, t1.then + t1.delay);"),
			std::string("                    t1 = (t0 = t1).next;"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return then;"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_timer_frame = window.requestAnimationFrame"),
			std::string("                || window.webkitRequestAnimationFrame"),
			std::string("                || window.mozRequestAnimationFrame"),
			std::string("                || window.oRequestAnimationFrame"),
			std::string("                || window.msRequestAnimationFrame"),
			std::string("                || function(callback) { setTimeout(callback, 17); };"),
			std::string("        d3.transform = function(string) {"),
			std::string("            d3_transformG.setAttribute(\"transform\", string);"),
			std::string("            return new d3_transform(d3_transformG.transform.baseVal.consolidate().matrix);"),
			std::string("        };"),
			std::string(""),
			std::string("// Compute x-scale and normalize the first row."),
			std::string("// Compute shear and make second row orthogonal to first."),
			std::string("// Compute y-scale and normalize the second row."),
			std::string("// Finally, compute the rotation."),
			std::string("        function d3_transform(m) {"),
			std::string("            var r0 = [m.a, m.b],"),
			std::string("                    r1 = [m.c, m.d],"),
			std::string("                    kx = d3_transformNormalize(r0),"),
			std::string("                    kz = d3_transformDot(r0, r1),"),
			std::string("                    ky = d3_transformNormalize(d3_transformCombine(r1, r0, -kz));"),
			std::string("            this.translate = [m.e, m.f];"),
			std::string("            this.rotate = Math.atan2(m.b, m.a) * d3_transformDegrees;"),
			std::string("            this.scale = [kx, ky || 0];"),
			std::string("            this.skew = ky ? kz / ky * d3_transformDegrees : 0;"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_transform.prototype.toString = function() {"),
			std::string("            return \"translate(\" + this.translate"),
			std::string("                    + \")rotate(\" + this.rotate"),
			std::string("                    + \")skewX(\" + this.skew"),
			std::string("                    + \")scale(\" + this.scale"),
			std::string("                    + \")\";"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_transformDot(a, b) {"),
			std::string("            return a[0] * b[0] + a[1] * b[1];"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_transformNormalize(a) {"),
			std::string("            var k = Math.sqrt(d3_transformDot(a, a));"),
			std::string("            a[0] /= k;"),
			std::string("            a[1] /= k;"),
			std::string("            return k;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_transformCombine(a, b, k) {"),
			std::string("            a[0] += k * b[0];"),
			std::string("            a[1] += k * b[1];"),
			std::string("            return a;"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_transformG = document.createElementNS(d3.ns.prefix.svg, \"g\"),"),
			std::string("                d3_transformDegrees = 180 / Math.PI;"),
			std::string("        function d3_noop() {}"),
			std::string("        d3.scale = {};"),
			std::string(""),
			std::string("        function d3_scaleExtent(domain) {"),
			std::string("            var start = domain[0], stop = domain[domain.length - 1];"),
			std::string("            return start < stop ? [start, stop] : [stop, start];"),
			std::string("        }"),
			std::string("        function d3_scale_nice(domain, nice) {"),
			std::string("            var i0 = 0,"),
			std::string("                    i1 = domain.length - 1,"),
			std::string("                    x0 = domain[i0],"),
			std::string("                    x1 = domain[i1],"),
			std::string("                    dx;"),
			std::string(""),
			std::string("            if (x1 < x0) {"),
			std::string("                dx = i0; i0 = i1; i1 = dx;"),
			std::string("                dx = x0; x0 = x1; x1 = dx;"),
			std::string("            }"),
			std::string(""),
			std::string("            if (dx = x1 - x0) {"),
			std::string("                nice = nice(dx);"),
			std::string("                domain[i0] = nice.floor(x0);"),
			std::string("                domain[i1] = nice.ceil(x1);"),
			std::string("            }"),
			std::string(""),
			std::string("            return domain;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_scale_niceDefault() {"),
			std::string("            return Math;"),
			std::string("        }"),
			std::string("        d3.scale.linear = function() {"),
			std::string("            return d3_scale_linear([0, 1], [0, 1], d3.interpolate, false);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_scale_linear(domain, range, interpolate, clamp) {"),
			std::string("            var output,"),
			std::string("                    input;"),
			std::string(""),
			std::string("            function rescale() {"),
			std::string("                var linear = domain.length == 2 ? d3_scale_bilinear : d3_scale_polylinear,"),
			std::string("                        uninterpolate = clamp ? d3_uninterpolateClamp : d3_uninterpolateNumber;"),
			std::string("                output = linear(domain, range, uninterpolate, interpolate);"),
			std::string("                input = linear(range, domain, uninterpolate, d3.interpolate);"),
			std::string("                return scale;"),
			std::string("            }"),
			std::string(""),
			std::string("            function scale(x) {"),
			std::string("                return output(x);"),
			std::string("            }"),
			std::string(""),
			std::string("            // Note: requires range is coercible to number!"),
			std::string("            scale.invert = function(y) {"),
			std::string("                return input(y);"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.domain = function(x) {"),
			std::string("                if (!arguments.length) return domain;"),
			std::string("                domain = x.map(Number);"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.range = function(x) {"),
			std::string("                if (!arguments.length) return range;"),
			std::string("                range = x;"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.rangeRound = function(x) {"),
			std::string("                return scale.range(x).interpolate(d3.interpolateRound);"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.clamp = function(x) {"),
			std::string("                if (!arguments.length) return clamp;"),
			std::string("                clamp = x;"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.interpolate = function(x) {"),
			std::string("                if (!arguments.length) return interpolate;"),
			std::string("                interpolate = x;"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.ticks = function(m) {"),
			std::string("                return d3_scale_linearTicks(domain, m);"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.tickFormat = function(m) {"),
			std::string("                return d3_scale_linearTickFormat(domain, m);"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.nice = function() {"),
			std::string("                d3_scale_nice(domain, d3_scale_linearNice);"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.copy = function() {"),
			std::string("                return d3_scale_linear(domain, range, interpolate, clamp);"),
			std::string("            };"),
			std::string(""),
			std::string("            return rescale();"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_scale_linearRebind(scale, linear) {"),
			std::string("            scale.range = d3.rebind(scale, linear.range);"),
			std::string("            scale.rangeRound = d3.rebind(scale, linear.rangeRound);"),
			std::string("            scale.interpolate = d3.rebind(scale, linear.interpolate);"),
			std::string("            scale.clamp = d3.rebind(scale, linear.clamp);"),
			std::string("            return scale;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_scale_linearNice(dx) {"),
			std::string("            dx = Math.pow(10, Math.round(Math.log(dx) / Math.LN10) - 1);"),
			std::string("            return {"),
			std::string("                floor: function(x) { return Math.floor(x / dx) * dx; },"),
			std::string("                ceil: function(x) { return Math.ceil(x / dx) * dx; }"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("// TODO Dates? Ugh."),
			std::string("        function d3_scale_linearTickRange(domain, m) {"),
			std::string("            var extent = d3_scaleExtent(domain),"),
			std::string("                    span = extent[1] - extent[0],"),
			std::string("                    step = Math.pow(10, Math.floor(Math.log(span / m) / Math.LN10)),"),
			std::string("                    err = m / span * step;"),
			std::string(""),
			std::string("            // Filter ticks to get closer to the desired count."),
			std::string("            if (err <= .15) step *= 10;"),
			std::string("            else if (err <= .35) step *= 5;"),
			std::string("            else if (err <= .75) step *= 2;"),
			std::string(""),
			std::string("            // Round start and stop values to step interval."),
			std::string("            extent[0] = Math.ceil(extent[0] / step) * step;"),
			std::string("            extent[1] = Math.floor(extent[1] / step) * step + step * .5; // inclusive"),
			std::string("            extent[2] = step;"),
			std::string("            return extent;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_scale_linearTicks(domain, m) {"),
			std::string("            return d3.range.apply(d3, d3_scale_linearTickRange(domain, m));"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_scale_linearTickFormat(domain, m) {"),
			std::string("            return d3.format(\",.\" + Math.max(0, -Math.floor(Math.log(d3_scale_linearTickRange(domain, m)[2]) / Math.LN10 + .01)) + \"f\");"),
			std::string("        }"),
			std::string("        function d3_scale_bilinear(domain, range, uninterpolate, interpolate) {"),
			std::string("            var u = uninterpolate(domain[0], domain[1]),"),
			std::string("                    i = interpolate(range[0], range[1]);"),
			std::string("            return function(x) {"),
			std::string("                return i(u(x));"),
			std::string("            };"),
			std::string("        }"),
			std::string("        function d3_scale_polylinear(domain, range, uninterpolate, interpolate) {"),
			std::string("            var u = [],"),
			std::string("                    i = [],"),
			std::string("                    j = 0,"),
			std::string("                    n = domain.length;"),
			std::string(""),
			std::string("            while (++j < n) {"),
			std::string("                u.push(uninterpolate(domain[j - 1], domain[j]));"),
			std::string("                i.push(interpolate(range[j - 1], range[j]));"),
			std::string("            }"),
			std::string(""),
			std::string("            return function(x) {"),
			std::string("                var j = d3.bisect(domain, x, 1, domain.length - 1) - 1;"),
			std::string("                return i[j](u[j](x));"),
			std::string("            };"),
			std::string("        }"),
			std::string("        d3.scale.log = function() {"),
			std::string("            return d3_scale_log(d3.scale.linear(), d3_scale_logp);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_scale_log(linear, log) {"),
			std::string("            var pow = log.pow;"),
			std::string(""),
			std::string("            function scale(x) {"),
			std::string("                return linear(log(x));"),
			std::string("            }"),
			std::string(""),
			std::string("            scale.invert = function(x) {"),
			std::string("                return pow(linear.invert(x));"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.domain = function(x) {"),
			std::string("                if (!arguments.length) return linear.domain().map(pow);"),
			std::string("                log = x[0] < 0 ? d3_scale_logn : d3_scale_logp;"),
			std::string("                pow = log.pow;"),
			std::string("                linear.domain(x.map(log));"),
			std::string("                return scale;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.nice = function() {"),
			std::string("                linear.domain(d3_scale_nice(linear.domain(), d3_scale_niceDefault));"),
			std::string("                return scale;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.ticks = function() {"),
			std::string("                var extent = d3_scaleExtent(linear.domain()),"),
			std::string("                        ticks = [];"),
			std::string("                if (extent.every(isFinite)) {"),
			std::string("                    var i = Math.floor(extent[0]),"),
			std::string("                            j = Math.ceil(extent[1]),"),
			std::string("                            u = pow(extent[0]),"),
			std::string("                            v = pow(extent[1]);"),
			std::string("                    if (log === d3_scale_logn) {"),
			std::string("                        ticks.push(pow(i));"),
			std::string("                        for (; i++ < j;) for (var k = 9; k > 0; k--) ticks.push(pow(i) * k);"),
			std::string("                    } else {"),
			std::string("                        for (; i < j; i++) for (var k = 1; k < 10; k++) ticks.push(pow(i) * k);"),
			std::string("                        ticks.push(pow(i));"),
			std::string("                    }"),
			std::string("                    for (i = 0; ticks[i] < u; i++) {} // strip small values"),
			std::string("                    for (j = ticks.length; ticks[j - 1] > v; j--) {} // strip big values"),
			std::string("                    ticks = ticks.slice(i, j);"),
			std::string("                }"),
			std::string("                return ticks;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.tickFormat = function(n, format) {"),
			std::string("                if (arguments.length < 2) format = d3_scale_logFormat;"),
			std::string("                if (arguments.length < 1) return format;"),
			std::string("                var k = n / scale.ticks().length,"),
			std::string("                        f = log === d3_scale_logn ? (e = -1e-15, Math.floor) : (e = 1e-15, Math.ceil),"),
			std::string("                        e;"),
			std::string("                return function(d) {"),
			std::string("                    return d / pow(f(log(d) + e)) < k ? format(d) : \"\";"),
			std::string("                };"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.copy = function() {"),
			std::string("                return d3_scale_log(linear.copy(), log);"),
			std::string("            };"),
			std::string(""),
			std::string("            return d3_scale_linearRebind(scale, linear);"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_scale_logFormat = d3.format(\".0e\");"),
			std::string(""),
			std::string("        function d3_scale_logp(x) {"),
			std::string("            return Math.log(x) / Math.LN10;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_scale_logn(x) {"),
			std::string("            return -Math.log(-x) / Math.LN10;"),
			std::string("        }"),
			std::string(""),
			std::string("        d3_scale_logp.pow = function(x) {"),
			std::string("            return Math.pow(10, x);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3_scale_logn.pow = function(x) {"),
			std::string("            return -Math.pow(10, -x);"),
			std::string("        };"),
			std::string("        d3.scale.pow = function() {"),
			std::string("            return d3_scale_pow(d3.scale.linear(), 1);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_scale_pow(linear, exponent) {"),
			std::string("            var powp = d3_scale_powPow(exponent),"),
			std::string("                    powb = d3_scale_powPow(1 / exponent);"),
			std::string(""),
			std::string("            function scale(x) {"),
			std::string("                return linear(powp(x));"),
			std::string("            }"),
			std::string(""),
			std::string("            scale.invert = function(x) {"),
			std::string("                return powb(linear.invert(x));"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.domain = function(x) {"),
			std::string("                if (!arguments.length) return linear.domain().map(powb);"),
			std::string("                linear.domain(x.map(powp));"),
			std::string("                return scale;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.ticks = function(m) {"),
			std::string("                return d3_scale_linearTicks(scale.domain(), m);"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.tickFormat = function(m) {"),
			std::string("                return d3_scale_linearTickFormat(scale.domain(), m);"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.nice = function() {"),
			std::string("                return scale.domain(d3_scale_nice(scale.domain(), d3_scale_linearNice));"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.exponent = function(x) {"),
			std::string("                if (!arguments.length) return exponent;"),
			std::string("                var domain = scale.domain();"),
			std::string("                powp = d3_scale_powPow(exponent = x);"),
			std::string("                powb = d3_scale_powPow(1 / exponent);"),
			std::string("                return scale.domain(domain);"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.copy = function() {"),
			std::string("                return d3_scale_pow(linear.copy(), exponent);"),
			std::string("            };"),
			std::string(""),
			std::string("            return d3_scale_linearRebind(scale, linear);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_scale_powPow(e) {"),
			std::string("            return function(x) {"),
			std::string("                return x < 0 ? -Math.pow(-x, e) : Math.pow(x, e);"),
			std::string("            };"),
			std::string("        }"),
			std::string("        d3.scale.sqrt = function() {"),
			std::string("            return d3.scale.pow().exponent(.5);"),
			std::string("        };"),
			std::string("        d3.scale.ordinal = function() {"),
			std::string("            return d3_scale_ordinal([], {t: \"range\", x: []});"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_scale_ordinal(domain, ranger) {"),
			std::string("            var index,"),
			std::string("                    range,"),
			std::string("                    rangeBand;"),
			std::string(""),
			std::string("            function scale(x) {"),
			std::string("                return range[((d3[x] || (d3[x] = domain.push(x))) - 1) % range.length];"),
			std::string("            }"),
			std::string(""),
			std::string("            function steps(start, step) {"),
			std::string("                return d3.range(domain.length).map(function(i) { return start + step * i; });"),
			std::string("            }"),
			std::string(""),
			std::string("            scale.domain = function(x) {"),
			std::string("                if (!arguments.length) return domain;"),
			std::string("                domain = [];"),
			std::string("                d3 = {};"),
			std::string("                var i = -1, n = x.length, xi;"),
			std::string("                while (++i < n) if (!d3[xi = x[i]]) d3[xi] = domain.push(xi);"),
			std::string("                return scale[ranger.t](ranger.x, ranger.p);"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.range = function(x) {"),
			std::string("                if (!arguments.length) return range;"),
			std::string("                range = x;"),
			std::string("                rangeBand = 0;"),
			std::string("                ranger = {t: \"range\", x: x};"),
			std::string("                return scale;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.rangePoints = function(x, padding) {"),
			std::string("                if (arguments.length < 2) padding = 0;"),
			std::string("                var start = x[0],"),
			std::string("                        stop = x[1],"),
			std::string("                        step = (stop - start) / (domain.length - 1 + padding);"),
			std::string("                range = steps(domain.length < 2 ? (start + stop) / 2 : start + step * padding / 2, step);"),
			std::string("                rangeBand = 0;"),
			std::string("                ranger = {t: \"rangePoints\", x: x, p: padding};"),
			std::string("                return scale;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.rangeBands = function(x, padding) {"),
			std::string("                if (arguments.length < 2) padding = 0;"),
			std::string("                var start = x[0],"),
			std::string("                        stop = x[1],"),
			std::string("                        step = (stop - start) / (domain.length + padding);"),
			std::string("                range = steps(start + step * padding, step);"),
			std::string("                rangeBand = step * (1 - padding);"),
			std::string("                ranger = {t: \"rangeBands\", x: x, p: padding};"),
			std::string("                return scale;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.rangeRoundBands = function(x, padding) {"),
			std::string("                if (arguments.length < 2) padding = 0;"),
			std::string("                var start = x[0],"),
			std::string("                        stop = x[1],"),
			std::string("                        step = Math.floor((stop - start) / (domain.length + padding));"),
			std::string("                range = steps(start + Math.round((stop - start - (domain.length - padding) * step) / 2), step);"),
			std::string("                rangeBand = Math.round(step * (1 - padding));"),
			std::string("                ranger = {t: \"rangeRoundBands\", x: x, p: padding};"),
			std::string("                return scale;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.rangeBand = function() {"),
			std::string("                return rangeBand;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.copy = function() {"),
			std::string("                return d3_scale_ordinal(domain, ranger);"),
			std::string("            };"),
			std::string(""),
			std::string("            return scale.domain(domain);"),
			std::string("        };"),
			std::string("        /*"),
			std::string("         * This product includes color specifications and designs developed by Cynthia"),
			std::string("         * Brewer (http://colorbrewer.org/). See lib/colorbrewer for more information."),
			std::string("         */"),
			std::string(""),
			std::string("        d3.scale.category10 = function() {"),
			std::string("            return d3.scale.ordinal().range(d3_category10);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.scale.category20 = function() {"),
			std::string("            return d3.scale.ordinal().range(d3_category20);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.scale.category20b = function() {"),
			std::string("            return d3.scale.ordinal().range(d3_category20b);"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.scale.category20c = function() {"),
			std::string("            return d3.scale.ordinal().range(d3_category20c);"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_category10 = ["),
			std::string("            \"#1f77b4\", \"#ff7f0e\", \"#2ca02c\", \"#d62728\", \"#9467bd\","),
			std::string("            \"#8c564b\", \"#e377c2\", \"#7f7f7f\", \"#bcbd22\", \"#17becf\""),
			std::string("        ];"),
			std::string(""),
			std::string("        var d3_category20 = ["),
			std::string("            \"#1f77b4\", \"#aec7e8\","),
			std::string("            \"#ff7f0e\", \"#ffbb78\","),
			std::string("            \"#2ca02c\", \"#98df8a\","),
			std::string("            \"#d62728\", \"#ff9896\","),
			std::string("            \"#9467bd\", \"#c5b0d5\","),
			std::string("            \"#8c564b\", \"#c49c94\","),
			std::string("            \"#e377c2\", \"#f7b6d2\","),
			std::string("            \"#7f7f7f\", \"#c7c7c7\","),
			std::string("            \"#bcbd22\", \"#dbdb8d\","),
			std::string("            \"#17becf\", \"#9edae5\""),
			std::string("        ];"),
			std::string(""),
			std::string("        var d3_category20b = ["),
			std::string("            \"#393b79\", \"#5254a3\", \"#6b6ecf\", \"#9c9ede\","),
			std::string("            \"#637939\", \"#8ca252\", \"#b5cf6b\", \"#cedb9c\","),
			std::string("            \"#8c6d31\", \"#bd9e39\", \"#e7ba52\", \"#e7cb94\","),
			std::string("            \"#843c39\", \"#ad494a\", \"#d6616b\", \"#e7969c\","),
			std::string("            \"#7b4173\", \"#a55194\", \"#ce6dbd\", \"#de9ed6\""),
			std::string("        ];"),
			std::string(""),
			std::string("        var d3_category20c = ["),
			std::string("            \"#3182bd\", \"#6baed6\", \"#9ecae1\", \"#c6dbef\","),
			std::string("            \"#e6550d\", \"#fd8d3c\", \"#fdae6b\", \"#fdd0a2\","),
			std::string("            \"#31a354\", \"#74c476\", \"#a1d99b\", \"#c7e9c0\","),
			std::string("            \"#756bb1\", \"#9e9ac8\", \"#bcbddc\", \"#dadaeb\","),
			std::string("            \"#636363\", \"#969696\", \"#bdbdbd\", \"#d9d9d9\""),
			std::string("        ];"),
			std::string("        d3.scale.quantile = function() {"),
			std::string("            return d3_scale_quantile([], []);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_scale_quantile(domain, range) {"),
			std::string("            var thresholds;"),
			std::string(""),
			std::string("            function rescale() {"),
			std::string("                var k = 0,"),
			std::string("                        n = domain.length,"),
			std::string("                        q = range.length;"),
			std::string("                thresholds = [];"),
			std::string("                while (++k < q) thresholds[k - 1] = d3.quantile(domain, k / q);"),
			std::string("                return scale;"),
			std::string("            }"),
			std::string(""),
			std::string("            function scale(x) {"),
			std::string("                if (isNaN(x = +x)) return NaN;"),
			std::string("                return range[d3.bisect(thresholds, x)];"),
			std::string("            }"),
			std::string(""),
			std::string("            scale.domain = function(x) {"),
			std::string("                if (!arguments.length) return domain;"),
			std::string("                domain = x.filter(function(d) { return !isNaN(d); }).sort(d3.ascending);"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.range = function(x) {"),
			std::string("                if (!arguments.length) return range;"),
			std::string("                range = x;"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.quantiles = function() {"),
			std::string("                return thresholds;"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.copy = function() {"),
			std::string("                return d3_scale_quantile(domain, range); // copy on write!"),
			std::string("            };"),
			std::string(""),
			std::string("            return rescale();"),
			std::string("        };"),
			std::string("        d3.scale.quantize = function() {"),
			std::string("            return d3_scale_quantize(0, 1, [0, 1]);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_scale_quantize(x0, x1, range) {"),
			std::string("            var kx, i;"),
			std::string(""),
			std::string("            function scale(x) {"),
			std::string("                return range[Math.max(0, Math.min(i, Math.floor(kx * (x - x0))))];"),
			std::string("            }"),
			std::string(""),
			std::string("            function rescale() {"),
			std::string("                kx = range.length / (x1 - x0);"),
			std::string("                i = range.length - 1;"),
			std::string("                return scale;"),
			std::string("            }"),
			std::string(""),
			std::string("            scale.domain = function(x) {"),
			std::string("                if (!arguments.length) return [x0, x1];"),
			std::string("                x0 = +x[0];"),
			std::string("                x1 = +x[x.length - 1];"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.range = function(x) {"),
			std::string("                if (!arguments.length) return range;"),
			std::string("                range = x;"),
			std::string("                return rescale();"),
			std::string("            };"),
			std::string(""),
			std::string("            scale.copy = function() {"),
			std::string("                return d3_scale_quantize(x0, x1, range); // copy on write"),
			std::string("            };"),
			std::string(""),
			std::string("            return rescale();"),
			std::string("        };"),
			std::string("        d3.svg = {};"),
			std::string("        d3.svg.arc = function() {"),
			std::string("            var innerRadius = d3_svg_arcInnerRadius,"),
			std::string("                    outerRadius = d3_svg_arcOuterRadius,"),
			std::string("                    startAngle = d3_svg_arcStartAngle,"),
			std::string("                    endAngle = d3_svg_arcEndAngle;"),
			std::string(""),
			std::string("            function arc() {"),
			std::string("                var r0 = innerRadius.apply(this, arguments),"),
			std::string("                        r1 = outerRadius.apply(this, arguments),"),
			std::string("                        a0 = startAngle.apply(this, arguments) + d3_svg_arcOffset,"),
			std::string("                        a1 = endAngle.apply(this, arguments) + d3_svg_arcOffset,"),
			std::string("                        da = (a1 < a0 && (da = a0, a0 = a1, a1 = da), a1 - a0),"),
			std::string("                        df = da < Math.PI ? \"0\" : \"1\","),
			std::string("                        c0 = Math.cos(a0),"),
			std::string("                        s0 = Math.sin(a0),"),
			std::string("                        c1 = Math.cos(a1),"),
			std::string("                        s1 = Math.sin(a1);"),
			std::string("                return da >= d3_svg_arcMax"),
			std::string("                        ? (r0"),
			std::string("                        ? \"M0,\" + r1"),
			std::string("                        + \"A\" + r1 + \",\" + r1 + \" 0 1,1 0,\" + (-r1)"),
			std::string("                        + \"A\" + r1 + \",\" + r1 + \" 0 1,1 0,\" + r1"),
			std::string("                        + \"M0,\" + r0"),
			std::string("                        + \"A\" + r0 + \",\" + r0 + \" 0 1,0 0,\" + (-r0)"),
			std::string("                        + \"A\" + r0 + \",\" + r0 + \" 0 1,0 0,\" + r0"),
			std::string("                        + \"Z\""),
			std::string("                        : \"M0,\" + r1"),
			std::string("                        + \"A\" + r1 + \",\" + r1 + \" 0 1,1 0,\" + (-r1)"),
			std::string("                        + \"A\" + r1 + \",\" + r1 + \" 0 1,1 0,\" + r1"),
			std::string("                        + \"Z\")"),
			std::string("                        : (r0"),
			std::string("                        ? \"M\" + r1 * c0 + \",\" + r1 * s0"),
			std::string("                        + \"A\" + r1 + \",\" + r1 + \" 0 \" + df + \",1 \" + r1 * c1 + \",\" + r1 * s1"),
			std::string("                        + \"L\" + r0 * c1 + \",\" + r0 * s1"),
			std::string("                        + \"A\" + r0 + \",\" + r0 + \" 0 \" + df + \",0 \" + r0 * c0 + \",\" + r0 * s0"),
			std::string("                        + \"Z\""),
			std::string("                        : \"M\" + r1 * c0 + \",\" + r1 * s0"),
			std::string("                        + \"A\" + r1 + \",\" + r1 + \" 0 \" + df + \",1 \" + r1 * c1 + \",\" + r1 * s1"),
			std::string("                        + \"L0,0\""),
			std::string("                        + \"Z\");"),
			std::string("            }"),
			std::string(""),
			std::string("            arc.innerRadius = function(v) {"),
			std::string("                if (!arguments.length) return innerRadius;"),
			std::string("                innerRadius = d3.functor(v);"),
			std::string("                return arc;"),
			std::string("            };"),
			std::string(""),
			std::string("            arc.outerRadius = function(v) {"),
			std::string("                if (!arguments.length) return outerRadius;"),
			std::string("                outerRadius = d3.functor(v);"),
			std::string("                return arc;"),
			std::string("            };"),
			std::string(""),
			std::string("            arc.startAngle = function(v) {"),
			std::string("                if (!arguments.length) return startAngle;"),
			std::string("                startAngle = d3.functor(v);"),
			std::string("                return arc;"),
			std::string("            };"),
			std::string(""),
			std::string("            arc.endAngle = function(v) {"),
			std::string("                if (!arguments.length) return endAngle;"),
			std::string("                endAngle = d3.functor(v);"),
			std::string("                return arc;"),
			std::string("            };"),
			std::string(""),
			std::string("            arc.centroid = function() {"),
			std::string("                var r = (innerRadius.apply(this, arguments)"),
			std::string("                                + outerRadius.apply(this, arguments)) / 2,"),
			std::string("                        a = (startAngle.apply(this, arguments)"),
			std::string("                                + endAngle.apply(this, arguments)) / 2 + d3_svg_arcOffset;"),
			std::string("                return [Math.cos(a) * r, Math.sin(a) * r];"),
			std::string("            };"),
			std::string(""),
			std::string("            return arc;"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_svg_arcOffset = -Math.PI / 2,"),
			std::string("                d3_svg_arcMax = 2 * Math.PI - 1e-6;"),
			std::string(""),
			std::string("        function d3_svg_arcInnerRadius(d) {"),
			std::string("            return d.innerRadius;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_arcOuterRadius(d) {"),
			std::string("            return d.outerRadius;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_arcStartAngle(d) {"),
		};

		const std::string d3TemplateBlockNo3[] = 
		{
			std::string("            return d.startAngle;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_arcEndAngle(d) {"),
			std::string("            return d.endAngle;"),
			std::string("        }"),
			std::string("        function d3_svg_line(projection) {"),
			std::string("            var x = d3_svg_lineX,"),
			std::string("                    y = d3_svg_lineY,"),
			std::string("                    interpolate = \"linear\","),
			std::string("                    interpolator = d3_svg_lineInterpolators[interpolate],"),
			std::string("                    tension = .7;"),
			std::string(""),
			std::string("            function line(d) {"),
			std::string("                return d.length < 1 ? null : \"M\" + interpolator(projection(d3_svg_linePoints(this, d, x, y)), tension);"),
			std::string("            }"),
			std::string(""),
			std::string("            line.x = function(v) {"),
			std::string("                if (!arguments.length) return x;"),
			std::string("                x = v;"),
			std::string("                return line;"),
			std::string("            };"),
			std::string(""),
			std::string("            line.y = function(v) {"),
			std::string("                if (!arguments.length) return y;"),
			std::string("                y = v;"),
			std::string("                return line;"),
			std::string("            };"),
			std::string(""),
			std::string("            line.interpolate = function(v) {"),
			std::string("                if (!arguments.length) return interpolate;"),
			std::string("                interpolator = d3_svg_lineInterpolators[interpolate = v];"),
			std::string("                return line;"),
			std::string("            };"),
			std::string(""),
			std::string("            line.tension = function(v) {"),
			std::string("                if (!arguments.length) return tension;"),
			std::string("                tension = v;"),
			std::string("                return line;"),
			std::string("            };"),
			std::string(""),
			std::string("            return line;"),
			std::string("        }"),
			std::string(""),
			std::string("        d3.svg.line = function() {"),
			std::string("            return d3_svg_line(Object);"),
			std::string("        };"),
			std::string(""),
			std::string("// Converts the specified array of data into an array of points"),
			std::string("// (x-y tuples), by evaluating the specified `x` and `y` functions on each"),
			std::string("// data point. The `this` context of the evaluated functions is the specified"),
			std::string("// \"self\" object; each function is passed the current datum and index."),
			std::string("        function d3_svg_linePoints(self, d, x, y) {"),
			std::string("            var points = [],"),
			std::string("                    i = -1,"),
			std::string("                    n = d.length,"),
			std::string("                    fx = typeof x === \"function\","),
			std::string("                    fy = typeof y === \"function\","),
			std::string("                    value;"),
			std::string("            if (fx && fy) {"),
			std::string("                while (++i < n) points.push(["),
			std::string("                    x.call(self, value = d[i], i),"),
			std::string("                    y.call(self, value, i)"),
			std::string("                ]);"),
			std::string("            } else if (fx) {"),
			std::string("                while (++i < n) points.push([x.call(self, d[i], i), y]);"),
			std::string("            } else if (fy) {"),
			std::string("                while (++i < n) points.push([x, y.call(self, d[i], i)]);"),
			std::string("            } else {"),
			std::string("                while (++i < n) points.push([x, y]);"),
			std::string("            }"),
			std::string("            return points;"),
			std::string("        }"),
			std::string(""),
			std::string("// The default `x` property, which references d[0]."),
			std::string("        function d3_svg_lineX(d) {"),
			std::string("            return d[0];"),
			std::string("        }"),
			std::string(""),
			std::string("// The default `y` property, which references d[1]."),
			std::string("        function d3_svg_lineY(d) {"),
			std::string("            return d[1];"),
			std::string("        }"),
			std::string(""),
			std::string("// The various interpolators supported by the `line` class."),
			std::string("        var d3_svg_lineInterpolators = {"),
			std::string("            \"linear\": d3_svg_lineLinear,"),
			std::string("            \"step-before\": d3_svg_lineStepBefore,"),
			std::string("            \"step-after\": d3_svg_lineStepAfter,"),
			std::string("            \"basis\": d3_svg_lineBasis,"),
			std::string("            \"basis-open\": d3_svg_lineBasisOpen,"),
			std::string("            \"basis-closed\": d3_svg_lineBasisClosed,"),
			std::string("            \"bundle\": d3_svg_lineBundle,"),
			std::string("            \"cardinal\": d3_svg_lineCardinal,"),
			std::string("            \"cardinal-open\": d3_svg_lineCardinalOpen,"),
			std::string("            \"cardinal-closed\": d3_svg_lineCardinalClosed,"),
			std::string("            \"monotone\": d3_svg_lineMonotone"),
			std::string("        };"),
			std::string(""),
			std::string("// Linear interpolation; generates \"L\" commands."),
			std::string("        function d3_svg_lineLinear(points) {"),
			std::string("            var i = 0,"),
			std::string("                    n = points.length,"),
			std::string("                    p = points[0],"),
			std::string("                    path = [p[0], \",\", p[1]];"),
			std::string("            while (++i < n) path.push(\"L\", (p = points[i])[0], \",\", p[1]);"),
			std::string("            return path.join(\"\");"),
			std::string("        }"),
			std::string(""),
			std::string("// Step interpolation; generates \"H\" and \"V\" commands."),
			std::string("        function d3_svg_lineStepBefore(points) {"),
			std::string("            var i = 0,"),
			std::string("                    n = points.length,"),
			std::string("                    p = points[0],"),
			std::string("                    path = [p[0], \",\", p[1]];"),
			std::string("            while (++i < n) path.push(\"V\", (p = points[i])[1], \"H\", p[0]);"),
			std::string("            return path.join(\"\");"),
			std::string("        }"),
			std::string(""),
			std::string("// Step interpolation; generates \"H\" and \"V\" commands."),
			std::string("        function d3_svg_lineStepAfter(points) {"),
			std::string("            var i = 0,"),
			std::string("                    n = points.length,"),
			std::string("                    p = points[0],"),
			std::string("                    path = [p[0], \",\", p[1]];"),
			std::string("            while (++i < n) path.push(\"H\", (p = points[i])[0], \"V\", p[1]);"),
			std::string("            return path.join(\"\");"),
			std::string("        }"),
			std::string(""),
			std::string("// Open cardinal spline interpolation; generates \"C\" commands."),
			std::string("        function d3_svg_lineCardinalOpen(points, tension) {"),
			std::string("            return points.length < 4"),
			std::string("                    ? d3_svg_lineLinear(points)"),
			std::string("                    : points[1] + d3_svg_lineHermite(points.slice(1, points.length - 1),"),
			std::string("                    d3_svg_lineCardinalTangents(points, tension));"),
			std::string("        }"),
			std::string(""),
			std::string("// Closed cardinal spline interpolation; generates \"C\" commands."),
			std::string("        function d3_svg_lineCardinalClosed(points, tension) {"),
			std::string("            return points.length < 3"),
			std::string("                    ? d3_svg_lineLinear(points)"),
			std::string("                    : points[0] + d3_svg_lineHermite((points.push(points[0]), points),"),
			std::string("                    d3_svg_lineCardinalTangents([points[points.length - 2]]"),
			std::string("                            .concat(points, [points[1]]), tension));"),
			std::string("        }"),
			std::string(""),
			std::string("// Cardinal spline interpolation; generates \"C\" commands."),
			std::string("        function d3_svg_lineCardinal(points, tension, closed) {"),
			std::string("            return points.length < 3"),
			std::string("                    ? d3_svg_lineLinear(points)"),
			std::string("                    : points[0] + d3_svg_lineHermite(points,"),
			std::string("                    d3_svg_lineCardinalTangents(points, tension));"),
			std::string("        }"),
			std::string(""),
			std::string("// Hermite spline construction; generates \"C\" commands."),
			std::string("        function d3_svg_lineHermite(points, tangents) {"),
			std::string("            if (tangents.length < 1"),
			std::string("                    || (points.length != tangents.length"),
			std::string("                    && points.length != tangents.length + 2)) {"),
			std::string("                return d3_svg_lineLinear(points);"),
			std::string("            }"),
			std::string(""),
			std::string("            var quad = points.length != tangents.length,"),
			std::string("                    path = \"\","),
			std::string("                    p0 = points[0],"),
			std::string("                    p = points[1],"),
			std::string("                    t0 = tangents[0],"),
			std::string("                    t = t0,"),
			std::string("                    pi = 1;"),
			std::string(""),
			std::string("            if (quad) {"),
			std::string("                path += \"Q\" + (p[0] - t0[0] * 2 / 3) + \",\" + (p[1] - t0[1] * 2 / 3)"),
			std::string("                        + \",\" + p[0] + \",\" + p[1];"),
			std::string("                p0 = points[1];"),
			std::string("                pi = 2;"),
			std::string("            }"),
			std::string(""),
			std::string("            if (tangents.length > 1) {"),
			std::string("                t = tangents[1];"),
			std::string("                p = points[pi];"),
			std::string("                pi++;"),
			std::string("                path += \"C\" + (p0[0] + t0[0]) + \",\" + (p0[1] + t0[1])"),
			std::string("                        + \",\" + (p[0] - t[0]) + \",\" + (p[1] - t[1])"),
			std::string("                        + \",\" + p[0] + \",\" + p[1];"),
			std::string("                for (var i = 2; i < tangents.length; i++, pi++) {"),
			std::string("                    p = points[pi];"),
			std::string("                    t = tangents[i];"),
			std::string("                    path += \"S\" + (p[0] - t[0]) + \",\" + (p[1] - t[1])"),
			std::string("                            + \",\" + p[0] + \",\" + p[1];"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            if (quad) {"),
			std::string("                var lp = points[pi];"),
			std::string("                path += \"Q\" + (p[0] + t[0] * 2 / 3) + \",\" + (p[1] + t[1] * 2 / 3)"),
			std::string("                        + \",\" + lp[0] + \",\" + lp[1];"),
			std::string("            }"),
			std::string(""),
			std::string("            return path;"),
			std::string("        }"),
			std::string(""),
			std::string("// Generates tangents for a cardinal spline."),
			std::string("        function d3_svg_lineCardinalTangents(points, tension) {"),
			std::string("            var tangents = [],"),
			std::string("                    a = (1 - tension) / 2,"),
			std::string("                    p0,"),
			std::string("                    p1 = points[0],"),
			std::string("                    p2 = points[1],"),
			std::string("                    i = 1,"),
			std::string("                    n = points.length;"),
			std::string("            while (++i < n) {"),
			std::string("                p0 = p1;"),
			std::string("                p1 = p2;"),
			std::string("                p2 = points[i];"),
			std::string("                tangents.push([a * (p2[0] - p0[0]), a * (p2[1] - p0[1])]);"),
			std::string("            }"),
			std::string("            return tangents;"),
			std::string("        }"),
			std::string(""),
			std::string("// B-spline interpolation; generates \"C\" commands."),
			std::string("        function d3_svg_lineBasis(points) {"),
			std::string("            if (points.length < 3) return d3_svg_lineLinear(points);"),
			std::string("            var i = 1,"),
			std::string("                    n = points.length,"),
			std::string("                    pi = points[0],"),
			std::string("                    x0 = pi[0],"),
			std::string("                    y0 = pi[1],"),
			std::string("                    px = [x0, x0, x0, (pi = points[1])[0]],"),
			std::string("                    py = [y0, y0, y0, pi[1]],"),
			std::string("                    path = [x0, \",\", y0];"),
			std::string("            d3_svg_lineBasisBezier(path, px, py);"),
			std::string("            while (++i < n) {"),
			std::string("                pi = points[i];"),
			std::string("                px.shift(); px.push(pi[0]);"),
			std::string("                py.shift(); py.push(pi[1]);"),
			std::string("                d3_svg_lineBasisBezier(path, px, py);"),
			std::string("            }"),
			std::string("            i = -1;"),
			std::string("            while (++i < 2) {"),
			std::string("                px.shift(); px.push(pi[0]);"),
			std::string("                py.shift(); py.push(pi[1]);"),
			std::string("                d3_svg_lineBasisBezier(path, px, py);"),
			std::string("            }"),
			std::string("            return path.join(\"\");"),
			std::string("        }"),
			std::string(""),
			std::string("// Open B-spline interpolation; generates \"C\" commands."),
			std::string("        function d3_svg_lineBasisOpen(points) {"),
			std::string("            if (points.length < 4) return d3_svg_lineLinear(points);"),
			std::string("            var path = [],"),
			std::string("                    i = -1,"),
			std::string("                    n = points.length,"),
			std::string("                    pi,"),
			std::string("                    px = [0],"),
			std::string("                    py = [0];"),
			std::string("            while (++i < 3) {"),
			std::string("                pi = points[i];"),
			std::string("                px.push(pi[0]);"),
			std::string("                py.push(pi[1]);"),
			std::string("            }"),
			std::string("            path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3, px)"),
			std::string("                    + \",\" + d3_svg_lineDot4(d3_svg_lineBasisBezier3, py));"),
			std::string("            --i; while (++i < n) {"),
			std::string("                pi = points[i];"),
			std::string("                px.shift(); px.push(pi[0]);"),
			std::string("                py.shift(); py.push(pi[1]);"),
			std::string("                d3_svg_lineBasisBezier(path, px, py);"),
			std::string("            }"),
			std::string("            return path.join(\"\");"),
			std::string("        }"),
			std::string(""),
			std::string("// Closed B-spline interpolation; generates \"C\" commands."),
			std::string("        function d3_svg_lineBasisClosed(points) {"),
			std::string("            var path,"),
			std::string("                    i = -1,"),
			std::string("                    n = points.length,"),
			std::string("                    m = n + 4,"),
			std::string("                    pi,"),
			std::string("                    px = [],"),
			std::string("                    py = [];"),
			std::string("            while (++i < 4) {"),
			std::string("                pi = points[i % n];"),
			std::string("                px.push(pi[0]);"),
			std::string("                py.push(pi[1]);"),
			std::string("            }"),
			std::string("            path = ["),
			std::string("                d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), \",\","),
			std::string("                d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)"),
			std::string("            ];"),
			std::string("            --i; while (++i < m) {"),
			std::string("                pi = points[i % n];"),
			std::string("                px.shift(); px.push(pi[0]);"),
			std::string("                py.shift(); py.push(pi[1]);"),
			std::string("                d3_svg_lineBasisBezier(path, px, py);"),
			std::string("            }"),
			std::string("            return path.join(\"\");"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_lineBundle(points, tension) {"),
			std::string("            var n = points.length - 1,"),
			std::string("                    x0 = points[0][0],"),
			std::string("                    y0 = points[0][1],"),
			std::string("                    dx = points[n][0] - x0,"),
			std::string("                    dy = points[n][1] - y0,"),
			std::string("                    i = -1,"),
			std::string("                    p,"),
			std::string("                    t;"),
			std::string("            while (++i <= n) {"),
			std::string("                p = points[i];"),
			std::string("                t = i / n;"),
			std::string("                p[0] = tension * p[0] + (1 - tension) * (x0 + t * dx);"),
			std::string("                p[1] = tension * p[1] + (1 - tension) * (y0 + t * dy);"),
			std::string("            }"),
			std::string("            return d3_svg_lineBasis(points);"),
			std::string("        }"),
			std::string(""),
			std::string("// Returns the dot product of the given four-element vectors."),
			std::string("        function d3_svg_lineDot4(a, b) {"),
			std::string("            return a[0] * b[0] + a[1] * b[1] + a[2] * b[2] + a[3] * b[3];"),
			std::string("        }"),
			std::string(""),
			std::string("// Matrix to transform basis (b-spline) control points to bezier"),
			std::string("// control points. Derived from FvD 11.2.8."),
			std::string("        var d3_svg_lineBasisBezier1 = [0, 2/3, 1/3, 0],"),
			std::string("                d3_svg_lineBasisBezier2 = [0, 1/3, 2/3, 0],"),
			std::string("                d3_svg_lineBasisBezier3 = [0, 1/6, 2/3, 1/6];"),
			std::string(""),
			std::string("// Pushes a \"C\" BГ©zier curve onto the specified path array, given the"),
			std::string("// two specified four-element arrays which define the control points."),
			std::string("        function d3_svg_lineBasisBezier(path, x, y) {"),
			std::string("            path.push("),
			std::string("                    \"C\", d3_svg_lineDot4(d3_svg_lineBasisBezier1, x),"),
			std::string("                    \",\", d3_svg_lineDot4(d3_svg_lineBasisBezier1, y),"),
			std::string("                    \",\", d3_svg_lineDot4(d3_svg_lineBasisBezier2, x),"),
			std::string("                    \",\", d3_svg_lineDot4(d3_svg_lineBasisBezier2, y),"),
			std::string("                    \",\", d3_svg_lineDot4(d3_svg_lineBasisBezier3, x),"),
			std::string("                    \",\", d3_svg_lineDot4(d3_svg_lineBasisBezier3, y));"),
			std::string("        }"),
			std::string(""),
			std::string("// Computes the slope from points p0 to p1."),
			std::string("        function d3_svg_lineSlope(p0, p1) {"),
			std::string("            return (p1[1] - p0[1]) / (p1[0] - p0[0]);"),
			std::string("        }"),
			std::string(""),
			std::string("// Compute three-point differences for the given points."),
			std::string("// http://en.wikipedia.org/wiki/Cubic_Hermite_spline#Finite_difference"),
			std::string("        function d3_svg_lineFiniteDifferences(points) {"),
			std::string("            var i = 0,"),
			std::string("                    j = points.length - 1,"),
			std::string("                    m = [],"),
			std::string("                    p0 = points[0],"),
			std::string("                    p1 = points[1],"),
			std::string("                    d = m[0] = d3_svg_lineSlope(p0, p1);"),
			std::string("            while (++i < j) {"),
			std::string("                m[i] = d + (d = d3_svg_lineSlope(p0 = p1, p1 = points[i + 1]));"),
			std::string("            }"),
			std::string("            m[i] = d;"),
			std::string("            return m;"),
			std::string("        }"),
			std::string(""),
			std::string("// Interpolates the given points using Fritsch-Carlson Monotone cubic Hermite"),
			std::string("// interpolation. Returns an array of tangent vectors. For details, see"),
			std::string("// http://en.wikipedia.org/wiki/Monotone_cubic_interpolation"),
			std::string("        function d3_svg_lineMonotoneTangents(points) {"),
			std::string("            var tangents = [],"),
			std::string("                    d,"),
			std::string("                    a,"),
			std::string("                    b,"),
			std::string("                    s,"),
			std::string("                    m = d3_svg_lineFiniteDifferences(points),"),
			std::string("                    i = -1,"),
			std::string("                    j = points.length - 1;"),
			std::string(""),
			std::string("            // The first two steps are done by computing finite-differences:"),
			std::string("            // 1. Compute the slopes of the secant lines between successive points."),
			std::string("            // 2. Initialize the tangents at every point as the average of the secants."),
			std::string(""),
			std::string("            // Then, for each segmentвЂ¦"),
			std::string("            while (++i < j) {"),
			std::string("                d = d3_svg_lineSlope(points[i], points[i + 1]);"),
			std::string(""),
			std::string("                // 3. If two successive yk = y{k + 1} are equal (i.e., d is zero), then set"),
			std::string("                // mk = m{k + 1} = 0 as the spline connecting these points must be flat to"),
			std::string("                // preserve monotonicity. Ignore step 4 and 5 for those k."),
			std::string(""),
			std::string("                if (Math.abs(d) < 1e-6) {"),
			std::string("                    m[i] = m[i + 1] = 0;"),
			std::string("                } else {"),
			std::string("                    // 4. Let ak = mk / dk and bk = m{k + 1} / dk."),
			std::string("                    a = m[i] / d;"),
			std::string("                    b = m[i + 1] / d;"),
			std::string(""),
			std::string("                    // 5. Prevent overshoot and ensure monotonicity by restricting the"),
			std::string("                    // magnitude of vector <ak, bk> to a circle of radius 3."),
			std::string("                    s = a * a + b * b;"),
			std::string("                    if (s > 9) {"),
			std::string("                        s = d * 3 / Math.sqrt(s);"),
			std::string("                        m[i] = s * a;"),
			std::string("                        m[i + 1] = s * b;"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            // Compute the normalized tangent vector from the slopes. Note that if x is"),
			std::string("            // not monotonic, it's possible that the slope will be infinite, so we protect"),
			std::string("            // against NaN by setting the coordinate to zero."),
			std::string("            i = -1; while (++i <= j) {"),
			std::string("                s = (points[Math.min(j, i + 1)][0] - points[Math.max(0, i - 1)][0])"),
			std::string("                        / (6 * (1 + m[i] * m[i]));"),
			std::string("                tangents.push([s || 0, m[i] * s || 0]);"),
			std::string("            }"),
			std::string(""),
			std::string("            return tangents;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_lineMonotone(points) {"),
			std::string("            return points.length < 3"),
			std::string("                    ? d3_svg_lineLinear(points)"),
			std::string("                    : points[0] +"),
			std::string("                    d3_svg_lineHermite(points, d3_svg_lineMonotoneTangents(points));"),
			std::string("        }"),
			std::string("        d3.svg.line.radial = function() {"),
			std::string("            var line = d3_svg_line(d3_svg_lineRadial);"),
			std::string("            line.radius = line.x, delete line.x;"),
			std::string("            line.angle = line.y, delete line.y;"),
			std::string("            return line;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_svg_lineRadial(points) {"),
			std::string("            var point,"),
			std::string("                    i = -1,"),
			std::string("                    n = points.length,"),
			std::string("                    r,"),
			std::string("                    a;"),
			std::string("            while (++i < n) {"),
			std::string("                point = points[i];"),
			std::string("                r = point[0];"),
			std::string("                a = point[1] + d3_svg_arcOffset;"),
			std::string("                point[0] = r * Math.cos(a);"),
			std::string("                point[1] = r * Math.sin(a);"),
			std::string("            }"),
			std::string("            return points;"),
			std::string("        }"),
			std::string("        function d3_svg_area(projection) {"),
			std::string("            var x0 = d3_svg_lineX,"),
			std::string("                    x1 = d3_svg_lineX,"),
			std::string("                    y0 = 0,"),
			std::string("                    y1 = d3_svg_lineY,"),
			std::string("                    interpolate,"),
			std::string("                    i0,"),
			std::string("                    i1,"),
			std::string("                    tension = .7;"),
			std::string(""),
			std::string("            function area(d) {"),
			std::string("                if (d.length < 1) return null;"),
			std::string("                var points0 = d3_svg_linePoints(this, d, x0, y0),"),
			std::string("                        points1 = d3_svg_linePoints(this, d, x0 === x1 ? d3_svg_areaX(points0) : x1, y0 === y1 ? d3_svg_areaY(points0) : y1);"),
			std::string("                return \"M\" + i0(projection(points1), tension)"),
			std::string("                        + \"L\" + i1(projection(points0.reverse()), tension)"),
			std::string("                        + \"Z\";"),
			std::string("            }"),
			std::string(""),
			std::string("            area.x = function(x) {"),
			std::string("                if (!arguments.length) return x1;"),
			std::string("                x0 = x1 = x;"),
			std::string("                return area;"),
			std::string("            };"),
			std::string(""),
			std::string("            area.x0 = function(x) {"),
			std::string("                if (!arguments.length) return x0;"),
			std::string("                x0 = x;"),
			std::string("                return area;"),
			std::string("            };"),
			std::string(""),
			std::string("            area.x1 = function(x) {"),
			std::string("                if (!arguments.length) return x1;"),
			std::string("                x1 = x;"),
			std::string("                return area;"),
			std::string("            };"),
			std::string(""),
			std::string("            area.y = function(y) {"),
			std::string("                if (!arguments.length) return y1;"),
			std::string("                y0 = y1 = y;"),
			std::string("                return area;"),
			std::string("            };"),
			std::string(""),
			std::string("            area.y0 = function(y) {"),
			std::string("                if (!arguments.length) return y0;"),
			std::string("                y0 = y;"),
			std::string("                return area;"),
			std::string("            };"),
			std::string(""),
			std::string("            area.y1 = function(y) {"),
			std::string("                if (!arguments.length) return y1;"),
			std::string("                y1 = y;"),
			std::string("                return area;"),
			std::string("            };"),
			std::string(""),
			std::string("            area.interpolate = function(x) {"),
			std::string("                if (!arguments.length) return interpolate;"),
			std::string("                i0 = d3_svg_lineInterpolators[interpolate = x];"),
			std::string("                i1 = i0.reverse || i0;"),
			std::string("                return area;"),
			std::string("            };"),
			std::string(""),
			std::string("            area.tension = function(x) {"),
			std::string("                if (!arguments.length) return tension;"),
			std::string("                tension = x;"),
			std::string("                return area;"),
			std::string("            };"),
			std::string(""),
			std::string("            return area.interpolate(\"linear\");"),
			std::string("        }"),
			std::string(""),
			std::string("        d3_svg_lineStepBefore.reverse = d3_svg_lineStepAfter;"),
			std::string("        d3_svg_lineStepAfter.reverse = d3_svg_lineStepBefore;"),
			std::string(""),
			std::string("        d3.svg.area = function() {"),
			std::string("            return d3_svg_area(Object);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_svg_areaX(points) {"),
			std::string("            return function(d, i) {"),
			std::string("                return points[i][0];"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_areaY(points) {"),
			std::string("            return function(d, i) {"),
			std::string("                return points[i][1];"),
			std::string("            };"),
			std::string("        }"),
			std::string("        d3.svg.area.radial = function() {"),
			std::string("            var area = d3_svg_area(d3_svg_lineRadial);"),
			std::string("            area.radius = area.x, delete area.x;"),
			std::string("            area.innerRadius = area.x0, delete area.x0;"),
			std::string("            area.outerRadius = area.x1, delete area.x1;"),
			std::string("            area.angle = area.y, delete area.y;"),
			std::string("            area.startAngle = area.y0, delete area.y0;"),
			std::string("            area.endAngle = area.y1, delete area.y1;"),
			std::string("            return area;"),
			std::string("        };"),
			std::string("        d3.svg.chord = function() {"),
			std::string("            var source = d3_svg_chordSource,"),
			std::string("                    target = d3_svg_chordTarget,"),
			std::string("                    radius = d3_svg_chordRadius,"),
			std::string("                    startAngle = d3_svg_arcStartAngle,"),
			std::string("                    endAngle = d3_svg_arcEndAngle;"),
			std::string(""),
			std::string("            // TODO Allow control point to be customized."),
			std::string(""),
			std::string("            function chord(d, i) {"),
			std::string("                var s = subgroup(this, source, d, i),"),
			std::string("                        t = subgroup(this, target, d, i);"),
			std::string("                return \"M\" + s.p0"),
			std::string("                        + arc(s.r, s.p1) + (equals(s, t)"),
			std::string("                        ? curve(s.r, s.p1, s.r, s.p0)"),
			std::string("                        : curve(s.r, s.p1, t.r, t.p0)"),
			std::string("                        + arc(t.r, t.p1)"),
			std::string("                        + curve(t.r, t.p1, s.r, s.p0))"),
			std::string("                        + \"Z\";"),
			std::string("            }"),
			std::string(""),
			std::string("            function subgroup(self, f, d, i) {"),
			std::string("                var subgroup = f.call(self, d, i),"),
			std::string("                        r = radius.call(self, subgroup, i),"),
			std::string("                        a0 = startAngle.call(self, subgroup, i) + d3_svg_arcOffset,"),
			std::string("                        a1 = endAngle.call(self, subgroup, i) + d3_svg_arcOffset;"),
			std::string("                return {"),
			std::string("                    r: r,"),
			std::string("                    a0: a0,"),
			std::string("                    a1: a1,"),
			std::string("                    p0: [r * Math.cos(a0), r * Math.sin(a0)],"),
			std::string("                    p1: [r * Math.cos(a1), r * Math.sin(a1)]"),
			std::string("                };"),
			std::string("            }"),
			std::string(""),
			std::string("            function equals(a, b) {"),
			std::string("                return a.a0 == b.a0 && a.a1 == b.a1;"),
			std::string("            }"),
			std::string(""),
			std::string("            function arc(r, p) {"),
			std::string("                return \"A\" + r + \",\" + r + \" 0 0,1 \" + p;"),
			std::string("            }"),
			std::string(""),
			std::string("            function curve(r0, p0, r1, p1) {"),
			std::string("                return \"Q 0,0 \" + p1;"),
			std::string("            }"),
			std::string(""),
			std::string("            chord.radius = function(v) {"),
			std::string("                if (!arguments.length) return radius;"),
			std::string("                radius = d3.functor(v);"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.source = function(v) {"),
			std::string("                if (!arguments.length) return source;"),
			std::string("                source = d3.functor(v);"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.target = function(v) {"),
			std::string("                if (!arguments.length) return target;"),
			std::string("                target = d3.functor(v);"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.startAngle = function(v) {"),
			std::string("                if (!arguments.length) return startAngle;"),
			std::string("                startAngle = d3.functor(v);"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.endAngle = function(v) {"),
			std::string("                if (!arguments.length) return endAngle;"),
			std::string("                endAngle = d3.functor(v);"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            return chord;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_svg_chordSource(d) {"),
			std::string("            return d.source;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_chordTarget(d) {"),
			std::string("            return d.target;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_chordRadius(d) {"),
			std::string("            return d.radius;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_chordStartAngle(d) {"),
			std::string("            return d.startAngle;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_chordEndAngle(d) {"),
			std::string("            return d.endAngle;"),
			std::string("        }"),
			std::string("        d3.svg.diagonal = function() {"),
			std::string("            var source = d3_svg_chordSource,"),
			std::string("                    target = d3_svg_chordTarget,"),
			std::string("                    projection = d3_svg_diagonalProjection;"),
			std::string(""),
			std::string("            function diagonal(d, i) {"),
			std::string("                var p0 = source.call(this, d, i),"),
			std::string("                        p3 = target.call(this, d, i),"),
			std::string("                        m = (p0.y + p3.y) / 2,"),
			std::string("                        p = [p0, {x: p0.x, y: m}, {x: p3.x, y: m}, p3];"),
			std::string("                p = p.map(projection);"),
			std::string("                return \"M\" + p[0] + \"C\" + p[1] + \" \" + p[2] + \" \" + p[3];"),
			std::string("            }"),
			std::string(""),
			std::string("            diagonal.source = function(x) {"),
			std::string("                if (!arguments.length) return source;"),
			std::string("                source = d3.functor(x);"),
			std::string("                return diagonal;"),
			std::string("            };"),
			std::string(""),
			std::string("            diagonal.target = function(x) {"),
			std::string("                if (!arguments.length) return target;"),
			std::string("                target = d3.functor(x);"),
			std::string("                return diagonal;"),
			std::string("            };"),
			std::string(""),
			std::string("            diagonal.projection = function(x) {"),
			std::string("                if (!arguments.length) return projection;"),
			std::string("                projection = x;"),
			std::string("                return diagonal;"),
			std::string("            };"),
			std::string(""),
			std::string("            return diagonal;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_svg_diagonalProjection(d) {"),
			std::string("            return [d.x, d.y];"),
			std::string("        }"),
			std::string("        d3.svg.diagonal.radial = function() {"),
			std::string("            var diagonal = d3.svg.diagonal(),"),
			std::string("                    projection = d3_svg_diagonalProjection,"),
			std::string("                    projection_ = diagonal.projection;"),
			std::string(""),
			std::string("            diagonal.projection = function(x) {"),
			std::string("                return arguments.length"),
			std::string("                        ? projection_(d3_svg_diagonalRadialProjection(projection = x))"),
			std::string("                        : projection;"),
			std::string("            };"),
			std::string(""),
			std::string("            return diagonal;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_svg_diagonalRadialProjection(projection) {"),
			std::string("            return function() {"),
			std::string("                var d = projection.apply(this, arguments),"),
			std::string("                        r = d[0],"),
			std::string("                        a = d[1] + d3_svg_arcOffset;"),
			std::string("                return [r * Math.cos(a), r * Math.sin(a)];"),
			std::string("            };"),
			std::string("        }"),
			std::string("        d3.svg.mouse = function(container) {"),
			std::string("            return d3_svg_mousePoint(container, d3.event);"),
			std::string("        };"),
			std::string(""),
			std::string("// https://bugs.webkit.org/show_bug.cgi?id=44083"),
			std::string("        var d3_mouse_bug44083 = /WebKit/.test(navigator.userAgent) ? -1 : 0;"),
			std::string(""),
			std::string("        function d3_svg_mousePoint(container, e) {"),
			std::string("            var point = (container.ownerSVGElement || container).createSVGPoint();"),
			std::string("            if ((d3_mouse_bug44083 < 0) && (window.scrollX || window.scrollY)) {"),
			std::string("                var svg = d3.select(document.body)"),
			std::string("                        .append(\"svg:svg\")"),
			std::string("                        .style(\"position\", \"absolute\")"),
			std::string("                        .style(\"top\", 0)"),
			std::string("                        .style(\"left\", 0);"),
			std::string("                var ctm = svg[0][0].getScreenCTM();"),
			std::string("                d3_mouse_bug44083 = !(ctm.f || ctm.e);"),
			std::string("                svg.remove();"),
			std::string("            }"),
			std::string("            if (d3_mouse_bug44083) {"),
			std::string("                point.x = e.pageX;"),
			std::string("                point.y = e.pageY;"),
			std::string("            } else {"),
			std::string("                point.x = e.clientX;"),
			std::string("                point.y = e.clientY;"),
			std::string("            }"),
			std::string("            point = point.matrixTransform(container.getScreenCTM().inverse());"),
			std::string("            return [point.x, point.y];"),
			std::string("        };"),
			std::string("        d3.svg.touches = function(container, touches) {"),
			std::string("            if (arguments.length < 2) touches = d3.event.touches;"),
			std::string(""),
			std::string("            return touches ? d3_array(touches).map(function(touch) {"),
			std::string("                var point = d3_svg_mousePoint(container, touch);"),
			std::string("                point.identifier = touch.identifier;"),
			std::string("                return point;"),
			std::string("            }) : [];"),
			std::string("        };"),
			std::string("        d3.svg.symbol = function() {"),
			std::string("            var type = d3_svg_symbolType,"),
			std::string("                    size = d3_svg_symbolSize;"),
			std::string(""),
			std::string("            function symbol(d, i) {"),
			std::string("                return (d3_svg_symbols[type.call(this, d, i)]"),
			std::string("                        || d3_svg_symbols.circle)"),
			std::string("                        (size.call(this, d, i));"),
			std::string("            }"),
			std::string(""),
			std::string("            symbol.type = function(x) {"),
			std::string("                if (!arguments.length) return type;"),
			std::string("                type = d3.functor(x);"),
			std::string("                return symbol;"),
			std::string("            };"),
			std::string(""),
			std::string("            // size of symbol in square pixels"),
			std::string("            symbol.size = function(x) {"),
			std::string("                if (!arguments.length) return size;"),
			std::string("                size = d3.functor(x);"),
			std::string("                return symbol;"),
			std::string("            };"),
			std::string(""),
			std::string("            return symbol;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_svg_symbolSize() {"),
			std::string("            return 64;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_symbolType() {"),
			std::string("            return \"circle\";"),
			std::string("        }"),
			std::string(""),
			std::string("// TODO cross-diagonal?"),
			std::string("        var d3_svg_symbols = {"),
			std::string("            \"circle\": function(size) {"),
			std::string("                var r = Math.sqrt(size / Math.PI);"),
			std::string("                return \"M0,\" + r"),
			std::string("                        + \"A\" + r + \",\" + r + \" 0 1,1 0,\" + (-r)"),
			std::string("                        + \"A\" + r + \",\" + r + \" 0 1,1 0,\" + r"),
			std::string("                        + \"Z\";"),
			std::string("            },"),
			std::string("            \"cross\": function(size) {"),
			std::string("                var r = Math.sqrt(size / 5) / 2;"),
			std::string("                return \"M\" + -3 * r + \",\" + -r"),
			std::string("                        + \"H\" + -r"),
			std::string("                        + \"V\" + -3 * r"),
			std::string("                        + \"H\" + r"),
			std::string("                        + \"V\" + -r"),
			std::string("                        + \"H\" + 3 * r"),
			std::string("                        + \"V\" + r"),
			std::string("                        + \"H\" + r"),
			std::string("                        + \"V\" + 3 * r"),
			std::string("                        + \"H\" + -r"),
			std::string("                        + \"V\" + r"),
			std::string("                        + \"H\" + -3 * r"),
			std::string("                        + \"Z\";"),
			std::string("            },"),
			std::string("            \"diamond\": function(size) {"),
			std::string("                var ry = Math.sqrt(size / (2 * d3_svg_symbolTan30)),"),
			std::string("                        rx = ry * d3_svg_symbolTan30;"),
			std::string("                return \"M0,\" + -ry"),
			std::string("                        + \"L\" + rx + \",0\""),
			std::string("                        + \" 0,\" + ry"),
			std::string("                        + \" \" + -rx + \",0\""),
			std::string("                        + \"Z\";"),
			std::string("            },"),
			std::string("            \"square\": function(size) {"),
			std::string("                var r = Math.sqrt(size) / 2;"),
			std::string("                return \"M\" + -r + \",\" + -r"),
			std::string("                        + \"L\" + r + \",\" + -r"),
			std::string("                        + \" \" + r + \",\" + r"),
			std::string("                        + \" \" + -r + \",\" + r"),
			std::string("                        + \"Z\";"),
			std::string("            },"),
			std::string("            \"triangle-down\": function(size) {"),
			std::string("                var rx = Math.sqrt(size / d3_svg_symbolSqrt3),"),
			std::string("                        ry = rx * d3_svg_symbolSqrt3 / 2;"),
			std::string("                return \"M0,\" + ry"),
			std::string("                        + \"L\" + rx +\",\" + -ry"),
			std::string("                        + \" \" + -rx + \",\" + -ry"),
			std::string("                        + \"Z\";"),
			std::string("            },"),
			std::string("            \"triangle-up\": function(size) {"),
			std::string("                var rx = Math.sqrt(size / d3_svg_symbolSqrt3),"),
			std::string("                        ry = rx * d3_svg_symbolSqrt3 / 2;"),
			std::string("                return \"M0,\" + -ry"),
			std::string("                        + \"L\" + rx +\",\" + ry"),
			std::string("                        + \" \" + -rx + \",\" + ry"),
			std::string("                        + \"Z\";"),
			std::string("            }"),
			std::string("        };"),
			std::string(""),
			std::string("        d3.svg.symbolTypes = d3.keys(d3_svg_symbols);"),
			std::string(""),
			std::string("        var d3_svg_symbolSqrt3 = Math.sqrt(3),"),
			std::string("                d3_svg_symbolTan30 = Math.tan(30 * Math.PI / 180);"),
			std::string("        d3.svg.axis = function() {"),
			std::string("            var scale = d3.scale.linear(),"),
			std::string("                    orient = \"bottom\","),
			std::string("                    tickMajorSize = 6,"),
			std::string("                    tickMinorSize = 6,"),
			std::string("                    tickEndSize = 6,"),
			std::string("                    tickPadding = 3,"),
			std::string("                    tickArguments_ = [10],"),
			std::string("                    tickFormat_,"),
			std::string("                    tickSubdivide = 0;"),
			std::string(""),
			std::string("            function axis(selection) {"),
			std::string("                selection.each(function(d, i, j) {"),
			std::string("                    var g = d3.select(this);"),
			std::string(""),
			std::string("                    // If selection is a transition, create subtransitions."),
			std::string("                    var transition = selection.delay ? function(o) {"),
			std::string("                        var id = d3_transitionInheritId;"),
			std::string("                        try {"),
			std::string("                            d3_transitionInheritId = selection.id;"),
			std::string("                            return o.transition()"),
			std::string("                                    .delay(selection[j][i].delay)"),
			std::string("                                    .duration(selection[j][i].duration)"),
			std::string("                                    .ease(selection.ease());"),
			std::string("                        } finally {"),
			std::string("                            d3_transitionInheritId = id;"),
			std::string("                        }"),
			std::string("                    } : Object;"),
			std::string(""),
			std::string("                    // Ticks."),
			std::string("                    var ticks = scale.ticks.apply(scale, tickArguments_),"),
			std::string("                            tickFormat = tickFormat_ == null ? scale.tickFormat.apply(scale, tickArguments_) : tickFormat_;"),
			std::string(""),
			std::string("                    // Minor ticks."),
			std::string("                    var subticks = d3_svg_axisSubdivide(scale, ticks, tickSubdivide),"),
			std::string("                            subtick = g.selectAll(\".minor\").data(subticks, String),"),
			std::string("                            subtickEnter = subtick.enter().insert(\"svg:line\", \"g\").attr(\"class\", \"tick minor\").style(\"opacity\", 1e-6),"),
			std::string("                            subtickExit = transition(subtick.exit()).style(\"opacity\", 1e-6).remove(),"),
			std::string("                            subtickUpdate = transition(subtick).style(\"opacity\", 1);"),
			std::string(""),
			std::string("                    // Major ticks."),
			std::string("                    var tick = g.selectAll(\"g\").data(ticks, String),"),
			std::string("                            tickEnter = tick.enter().insert(\"svg:g\", \"path\").style(\"opacity\", 1e-6),"),
			std::string("                            tickExit = transition(tick.exit()).style(\"opacity\", 1e-6).remove(),"),
			std::string("                            tickUpdate = transition(tick).style(\"opacity\", 1),"),
			std::string("                            tickTransform;"),
			std::string(""),
			std::string("                    // Domain."),
			std::string("                    var range = d3_scaleExtent(scale.range()),"),
			std::string("                            path = g.selectAll(\".domain\").data([0]),"),
			std::string("                            pathEnter = path.enter().append(\"svg:path\").attr(\"class\", \"domain\"),"),
			std::string("                            pathUpdate = transition(path);"),
			std::string(""),
			std::string("                    // Stash the new scale and grab the old scale."),
			std::string("                    var scale0 = this.__chart__ || scale;"),
			std::string("                    this.__chart__ = scale.copy();"),
			std::string(""),
			std::string("                    tickEnter.append(\"svg:line\").attr(\"class\", \"tick\");"),
			std::string("                    tickEnter.append(\"svg:text\");"),
			std::string("                    tickUpdate.select(\"text\").text(tickFormat);"),
			std::string(""),
			std::string("                    switch (orient) {"),
			std::string("                        case \"bottom\": {"),
			std::string("                            tickTransform = d3_svg_axisX;"),
			std::string("                            subtickUpdate.attr(\"x2\", 0).attr(\"y2\", tickMinorSize);"),
			std::string("                            tickUpdate.select(\"line\").attr(\"x2\", 0).attr(\"y2\", tickMajorSize);"),
			std::string("                            tickUpdate.select(\"text\").attr(\"x\", 0).attr(\"y\", Math.max(tickMajorSize, 0) + tickPadding).attr(\"dy\", \".71em\").attr(\"text-anchor\", \"middle\");"),
			std::string("                            pathUpdate.attr(\"d\", \"M\" + range[0] + \",\" + tickEndSize + \"V0H\" + range[1] + \"V\" + tickEndSize);"),
			std::string("                            break;"),
			std::string("                        }"),
			std::string("                        case \"top\": {"),
			std::string("                            tickTransform = d3_svg_axisX;"),
			std::string("                            subtickUpdate.attr(\"x2\", 0).attr(\"y2\", -tickMinorSize);"),
			std::string("                            tickUpdate.select(\"line\").attr(\"x2\", 0).attr(\"y2\", -tickMajorSize);"),
			std::string("                            tickUpdate.select(\"text\").attr(\"x\", 0).attr(\"y\", -(Math.max(tickMajorSize, 0) + tickPadding)).attr(\"dy\", \"0em\").attr(\"text-anchor\", \"middle\");"),
			std::string("                            pathUpdate.attr(\"d\", \"M\" + range[0] + \",\" + -tickEndSize + \"V0H\" + range[1] + \"V\" + -tickEndSize);"),
			std::string("                            break;"),
			std::string("                        }"),
			std::string("                        case \"left\": {"),
			std::string("                            tickTransform = d3_svg_axisY;"),
			std::string("                            subtickUpdate.attr(\"x2\", -tickMinorSize).attr(\"y2\", 0);"),
			std::string("                            tickUpdate.select(\"line\").attr(\"x2\", -tickMajorSize).attr(\"y2\", 0);"),
			std::string("                            tickUpdate.select(\"text\").attr(\"x\", -(Math.max(tickMajorSize, 0) + tickPadding)).attr(\"y\", 0).attr(\"dy\", \".32em\").attr(\"text-anchor\", \"end\");"),
			std::string("                            pathUpdate.attr(\"d\", \"M\" + -tickEndSize + \",\" + range[0] + \"H0V\" + range[1] + \"H\" + -tickEndSize);"),
			std::string("                            break;"),
			std::string("                        }"),
			std::string("                        case \"right\": {"),
			std::string("                            tickTransform = d3_svg_axisY;"),
			std::string("                            subtickUpdate.attr(\"x2\", tickMinorSize).attr(\"y2\", 0);"),
			std::string("                            tickUpdate.select(\"line\").attr(\"x2\", tickMajorSize).attr(\"y2\", 0);"),
			std::string("                            tickUpdate.select(\"text\").attr(\"x\", Math.max(tickMajorSize, 0) + tickPadding).attr(\"y\", 0).attr(\"dy\", \".32em\").attr(\"text-anchor\", \"start\");"),
			std::string("                            pathUpdate.attr(\"d\", \"M\" + tickEndSize + \",\" + range[0] + \"H0V\" + range[1] + \"H\" + tickEndSize);"),
			std::string("                            break;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string(""),
			std::string("                    tickEnter.call(tickTransform, scale0);"),
			std::string("                    tickUpdate.call(tickTransform, scale);"),
			std::string("                    tickExit.call(tickTransform, scale);"),
			std::string(""),
			std::string("                    subtickEnter.call(tickTransform, scale0);"),
			std::string("                    subtickUpdate.call(tickTransform, scale);"),
			std::string("                    subtickExit.call(tickTransform, scale);"),
			std::string("                });"),
			std::string("            }"),
			std::string(""),
			std::string("            axis.scale = function(x) {"),
			std::string("                if (!arguments.length) return scale;"),
			std::string("                scale = x;"),
			std::string("                return axis;"),
			std::string("            };"),
			std::string(""),
			std::string("            axis.orient = function(x) {"),
			std::string("                if (!arguments.length) return orient;"),
			std::string("                orient = x;"),
			std::string("                return axis;"),
			std::string("            };"),
			std::string(""),
			std::string("            axis.ticks = function() {"),
			std::string("                if (!arguments.length) return tickArguments_;"),
			std::string("                tickArguments_ = arguments;"),
			std::string("                return axis;"),
			std::string("            };"),
			std::string(""),
			std::string("            axis.tickFormat = function(x) {"),
			std::string("                if (!arguments.length) return tickFormat_;"),
			std::string("                tickFormat_ = x;"),
			std::string("                return axis;"),
			std::string("            };"),
			std::string(""),
			std::string("            axis.tickSize = function(x, y, z) {"),
			std::string("                if (!arguments.length) return tickMajorSize;"),
			std::string("                var n = arguments.length - 1;"),
			std::string("                tickMajorSize = +x;"),
			std::string("                tickMinorSize = n > 1 ? +y : tickMajorSize;"),
			std::string("                tickEndSize = n > 0 ? +arguments[n] : tickMajorSize;"),
			std::string("                return axis;"),
			std::string("            };"),
			std::string(""),
			std::string("            axis.tickPadding = function(x) {"),
			std::string("                if (!arguments.length) return tickPadding;"),
			std::string("                tickPadding = +x;"),
			std::string("                return axis;"),
			std::string("            };"),
			std::string(""),
			std::string("            axis.tickSubdivide = function(x) {"),
			std::string("                if (!arguments.length) return tickSubdivide;"),
			std::string("                tickSubdivide = +x;"),
			std::string("                return axis;"),
			std::string("            };"),
			std::string(""),
			std::string("            return axis;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_svg_axisX(selection, x) {"),
			std::string("            selection.attr(\"transform\", function(d) { return \"translate(\" + x(d) + \",0)\"; });"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_axisY(selection, y) {"),
			std::string("            selection.attr(\"transform\", function(d) { return \"translate(0,\" + y(d) + \")\"; });"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_axisSubdivide(scale, ticks, m) {"),
			std::string("            subticks = [];"),
			std::string("            if (m && ticks.length > 1) {"),
			std::string("                var extent = d3_scaleExtent(scale.domain()),"),
			std::string("                        subticks,"),
			std::string("                        i = -1,"),
			std::string("                        n = ticks.length,"),
			std::string("                        d = (ticks[1] - ticks[0]) / ++m,"),
			std::string("                        j,"),
			std::string("                        v;"),
			std::string("                while (++i < n) {"),
			std::string("                    for (j = m; --j > 0;) {"),
			std::string("                        if ((v = +ticks[i] - j * d) >= extent[0]) {"),
			std::string("                            subticks.push(v);"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                }"),
			std::string("                for (--i, j = 0; ++j < m && (v = +ticks[i] + j * d) < extent[1];) {"),
			std::string("                    subticks.push(v);"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return subticks;"),
			std::string("        }"),
			std::string("        d3.svg.brush = function() {"),
			std::string("            var event = d3.dispatch(\"brushstart\", \"brush\", \"brushend\"),"),
		};

		const std::string d3TemplateBlockNo4[] = 
		{
			std::string("                    x, // x-scale, optional"),
			std::string("                    y, // y-scale, optional"),
			std::string("                    extent = [[0, 0], [0, 0]]; // [x0, y0], [x1, y1]"),
			std::string(""),
			std::string("            function brush(g) {"),
			std::string("                var resizes = x && y ? [\"n\", \"e\", \"s\", \"w\", \"nw\", \"ne\", \"se\", \"sw\"]"),
			std::string("                        : x ? [\"e\", \"w\"]"),
			std::string("                        : y ? [\"n\", \"s\"]"),
			std::string("                        : [];"),
			std::string(""),
			std::string("                g.each(function() {"),
			std::string("                    var g = d3.select(this).on(\"mousedown.brush\", down),"),
			std::string("                            bg = g.selectAll(\".background\").data([,]),"),
			std::string("                            fg = g.selectAll(\".extent\").data([,]),"),
			std::string("                            tz = g.selectAll(\".resize\").data(resizes, String),"),
			std::string("                            e;"),
			std::string(""),
			std::string("                    // An invisible, mouseable area for starting a new brush."),
			std::string("                    bg.enter().append(\"svg:rect\")"),
			std::string("                            .attr(\"class\", \"background\")"),
			std::string("                            .style(\"visibility\", \"hidden\")"),
			std::string("                            .style(\"pointer-events\", \"all\")"),
			std::string("                            .style(\"cursor\", \"crosshair\");"),
			std::string(""),
			std::string("                    // The visible brush extent; style this as you like!"),
			std::string("                    fg.enter().append(\"svg:rect\")"),
			std::string("                            .attr(\"class\", \"extent\")"),
			std::string("                            .style(\"cursor\", \"move\");"),
			std::string(""),
			std::string("                    // More invisible rects for resizing the extent."),
			std::string("                    tz.enter().append(\"svg:rect\")"),
			std::string("                            .attr(\"class\", function(d) { return \"resize \" + d; })"),
			std::string("                            .attr(\"width\", 6)"),
			std::string("                            .attr(\"height\", 6)"),
			std::string("                            .style(\"visibility\", \"hidden\")"),
			std::string("                            .style(\"pointer-events\", brush.empty() ? \"none\" : \"all\")"),
			std::string("                            .style(\"cursor\", function(d) { return d3_svg_brushCursor[d]; });"),
			std::string(""),
			std::string("                    // Remove any superfluous resizers."),
			std::string("                    tz.exit().remove();"),
			std::string(""),
			std::string("                    // Initialize the background to fill the defined range."),
			std::string("                    // If the range isn't defined, you can post-process."),
			std::string("                    if (x) {"),
			std::string("                        e = d3_scaleExtent(x.range());"),
			std::string("                        bg.attr(\"x\", e[0]).attr(\"width\", e[1] - e[0]);"),
			std::string("                        d3_svg_brushRedrawX(g, extent);"),
			std::string("                    }"),
			std::string("                    if (y) {"),
			std::string("                        e = d3_scaleExtent(y.range());"),
			std::string("                        bg.attr(\"y\", e[0]).attr(\"height\", e[1] - e[0]);"),
			std::string("                        d3_svg_brushRedrawY(g, extent);"),
			std::string("                    }"),
			std::string("                });"),
			std::string("            }"),
			std::string(""),
			std::string("            function down() {"),
			std::string("                var target = d3.select(d3.event.target);"),
			std::string(""),
			std::string("                // Store some global state for the duration of the brush gesture."),
			std::string("                d3_svg_brush = brush;"),
			std::string("                d3_svg_brushTarget = this;"),
			std::string("                d3_svg_brushExtent = extent;"),
			std::string("                d3_svg_brushOffset = d3.svg.mouse(d3_svg_brushTarget);"),
			std::string(""),
			std::string("                // If the extent was clicked on, drag rather than brush;"),
			std::string("                // store the offset between the mouse and extent origin instead."),
			std::string("                if (d3_svg_brushDrag = target.classed(\"extent\")) {"),
			std::string("                    d3_svg_brushOffset[0] = extent[0][0] - d3_svg_brushOffset[0];"),
			std::string("                    d3_svg_brushOffset[1] = extent[0][1] - d3_svg_brushOffset[1];"),
			std::string("                }"),
			std::string(""),
			std::string("                // If a resizer was clicked on, record which side is to be resized."),
			std::string("                // Also, set the offset to the opposite side."),
			std::string("                else if (target.classed(\"resize\")) {"),
			std::string("                    d3_svg_brushResize = d3.event.target.__data__;"),
			std::string("                    d3_svg_brushOffset[0] = extent[+/w$/.test(d3_svg_brushResize)][0];"),
			std::string("                    d3_svg_brushOffset[1] = extent[+/^n/.test(d3_svg_brushResize)][1];"),
			std::string("                }"),
			std::string(""),
			std::string("                // If the ALT key is down when starting a brush, the center is at the mouse."),
			std::string("                else if (d3.event.altKey) {"),
			std::string("                    d3_svg_brushCenter = d3_svg_brushOffset.slice();"),
			std::string("                }"),
			std::string(""),
			std::string("                // Restrict which dimensions are resized."),
			std::string("                d3_svg_brushX = !/^(n|s)$/.test(d3_svg_brushResize) && x;"),
			std::string("                d3_svg_brushY = !/^(e|w)$/.test(d3_svg_brushResize) && y;"),
			std::string(""),
			std::string("                // Notify listeners."),
			std::string("                d3_svg_brushDispatch = dispatcher(this, arguments);"),
			std::string("                d3_svg_brushDispatch(\"brushstart\");"),
			std::string("                d3_svg_brushMove();"),
			std::string("                d3_eventCancel();"),
			std::string("            }"),
			std::string(""),
			std::string("            function dispatcher(that, argumentz) {"),
			std::string("                return function(type) {"),
			std::string("                    var e = d3.event;"),
			std::string("                    try {"),
			std::string("                        d3.event = {type: type, target: brush};"),
			std::string("                        event[type].apply(that, argumentz);"),
			std::string("                    } finally {"),
			std::string("                        d3.event = e;"),
			std::string("                    }"),
			std::string("                };"),
			std::string("            }"),
			std::string(""),
			std::string("            brush.x = function(z) {"),
			std::string("                if (!arguments.length) return x;"),
			std::string("                x = z;"),
			std::string("                return brush;"),
			std::string("            };"),
			std::string(""),
			std::string("            brush.y = function(z) {"),
			std::string("                if (!arguments.length) return y;"),
			std::string("                y = z;"),
			std::string("                return brush;"),
			std::string("            };"),
			std::string(""),
			std::string("            brush.extent = function(z) {"),
			std::string("                var x0, x1, y0, y1, t;"),
			std::string(""),
			std::string("                // Invert the pixel extent to data-space."),
			std::string("                if (!arguments.length) {"),
			std::string("                    if (x) {"),
			std::string("                        x0 = x.invert(extent[0][0]), x1 = x.invert(extent[1][0]);"),
			std::string("                        if (x1 < x0) t = x0, x0 = x1, x1 = t;"),
			std::string("                    }"),
			std::string("                    if (y) {"),
			std::string("                        y0 = y.invert(extent[0][1]), y1 = y.invert(extent[1][1]);"),
			std::string("                        if (y1 < y0) t = y0, y0 = y1, y1 = t;"),
			std::string("                    }"),
			std::string("                    return x && y ? [[x0, y0], [x1, y1]] : x ? [x0, x1] : y && [y0, y1];"),
			std::string("                }"),
			std::string(""),
			std::string("                // Scale the data-space extent to pixels."),
			std::string("                if (x) {"),
			std::string("                    x0 = z[0], x1 = z[1];"),
			std::string("                    if (y) x0 = x0[0], x1 = x1[0];"),
			std::string("                    x0 = x(x0), x1 = x(x1);"),
			std::string("                    if (x1 < x0) t = x0, x0 = x1, x1 = t;"),
			std::string("                    extent[0][0] = x0, extent[1][0] = x1;"),
			std::string("                }"),
			std::string("                if (y) {"),
			std::string("                    y0 = z[0], y1 = z[1];"),
			std::string("                    if (x) y0 = y0[1], y1 = y1[1];"),
			std::string("                    y0 = y(y0), y1 = y(y1);"),
			std::string("                    if (y1 < y0) t = y0, y0 = y1, y1 = t;"),
			std::string("                    extent[0][1] = y0, extent[1][1] = y1;"),
			std::string("                }"),
			std::string(""),
			std::string("                return brush;"),
			std::string("            };"),
			std::string(""),
			std::string("            brush.clear = function() {"),
			std::string("                extent[0][0] ="),
			std::string("                        extent[0][1] ="),
			std::string("                                extent[1][0] ="),
			std::string("                                        extent[1][1] = 0;"),
			std::string("                return brush;"),
			std::string("            };"),
			std::string(""),
			std::string("            brush.empty = function() {"),
			std::string("                return (x && extent[0][0] === extent[1][0])"),
			std::string("                        || (y && extent[0][1] === extent[1][1]);"),
			std::string("            };"),
			std::string(""),
			std::string("            brush.on = function(type, listener) {"),
			std::string("                event.on(type, listener);"),
			std::string("                return brush;"),
			std::string("            };"),
			std::string(""),
			std::string("            d3.select(window)"),
			std::string("                    .on(\"mousemove.brush\", d3_svg_brushMove)"),
			std::string("                    .on(\"mouseup.brush\", d3_svg_brushUp)"),
			std::string("                    .on(\"keydown.brush\", d3_svg_brushKeydown)"),
			std::string("                    .on(\"keyup.brush\", d3_svg_brushKeyup);"),
			std::string(""),
			std::string("            return brush;"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_svg_brush,"),
			std::string("                d3_svg_brushDispatch,"),
			std::string("                d3_svg_brushTarget,"),
			std::string("                d3_svg_brushX,"),
			std::string("                d3_svg_brushY,"),
			std::string("                d3_svg_brushExtent,"),
			std::string("                d3_svg_brushDrag,"),
			std::string("                d3_svg_brushResize,"),
			std::string("                d3_svg_brushCenter,"),
			std::string("                d3_svg_brushOffset;"),
			std::string(""),
			std::string("        function d3_svg_brushRedrawX(g, extent) {"),
			std::string("            g.select(\".extent\").attr(\"x\", extent[0][0]);"),
			std::string("            g.selectAll(\".n,.s,.w,.nw,.sw\").attr(\"x\", extent[0][0] - 2);"),
			std::string("            g.selectAll(\".e,.ne,.se\").attr(\"x\", extent[1][0] - 3);"),
			std::string("            g.selectAll(\".extent,.n,.s\").attr(\"width\", extent[1][0] - extent[0][0]);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_brushRedrawY(g, extent) {"),
			std::string("            g.select(\".extent\").attr(\"y\", extent[0][1]);"),
			std::string("            g.selectAll(\".n,.e,.w,.nw,.ne\").attr(\"y\", extent[0][1] - 3);"),
			std::string("            g.selectAll(\".s,.se,.sw\").attr(\"y\", extent[1][1] - 4);"),
			std::string("            g.selectAll(\".extent,.e,.w\").attr(\"height\", extent[1][1] - extent[0][1]);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_brushKeydown() {"),
			std::string("            if (d3.event.keyCode == 32 && d3_svg_brushTarget && !d3_svg_brushDrag) {"),
			std::string("                d3_svg_brushCenter = null;"),
			std::string("                d3_svg_brushOffset[0] -= d3_svg_brushExtent[1][0];"),
			std::string("                d3_svg_brushOffset[1] -= d3_svg_brushExtent[1][1];"),
			std::string("                d3_svg_brushDrag = 2;"),
			std::string("                d3_eventCancel();"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_brushKeyup() {"),
			std::string("            if (d3.event.keyCode == 32 && d3_svg_brushDrag == 2) {"),
			std::string("                d3_svg_brushOffset[0] += d3_svg_brushExtent[1][0];"),
			std::string("                d3_svg_brushOffset[1] += d3_svg_brushExtent[1][1];"),
			std::string("                d3_svg_brushDrag = 0;"),
			std::string("                d3_eventCancel();"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_brushMove() {"),
			std::string("            if (d3_svg_brushOffset) {"),
			std::string("                var mouse = d3.svg.mouse(d3_svg_brushTarget),"),
			std::string("                        g = d3.select(d3_svg_brushTarget);"),
			std::string(""),
			std::string("                if (!d3_svg_brushDrag) {"),
			std::string(""),
			std::string("                    // If needed, determine the center from the current extent."),
			std::string("                    if (d3.event.altKey) {"),
			std::string("                        if (!d3_svg_brushCenter) {"),
			std::string("                            d3_svg_brushCenter = ["),
			std::string("                                (d3_svg_brushExtent[0][0] + d3_svg_brushExtent[1][0]) / 2,"),
			std::string("                                (d3_svg_brushExtent[0][1] + d3_svg_brushExtent[1][1]) / 2"),
			std::string("                            ];"),
			std::string("                        }"),
			std::string(""),
			std::string("                        // Update the offset, for when the ALT key is released."),
			std::string("                        d3_svg_brushOffset[0] = d3_svg_brushExtent[+(mouse[0] < d3_svg_brushCenter[0])][0];"),
			std::string("                        d3_svg_brushOffset[1] = d3_svg_brushExtent[+(mouse[1] < d3_svg_brushCenter[1])][1];"),
			std::string("                    }"),
			std::string(""),
			std::string("                    // When the ALT key is released, we clear the center."),
			std::string("                    else d3_svg_brushCenter = null;"),
			std::string("                }"),
			std::string(""),
			std::string("                // Update the brush extent for each dimension."),
			std::string("                if (d3_svg_brushX) {"),
			std::string("                    d3_svg_brushMove1(mouse, d3_svg_brushX, 0);"),
			std::string("                    d3_svg_brushRedrawX(g, d3_svg_brushExtent);"),
			std::string("                }"),
			std::string("                if (d3_svg_brushY) {"),
			std::string("                    d3_svg_brushMove1(mouse, d3_svg_brushY, 1);"),
			std::string("                    d3_svg_brushRedrawY(g, d3_svg_brushExtent);"),
			std::string("                }"),
			std::string(""),
			std::string("                // Notify listeners."),
			std::string("                d3_svg_brushDispatch(\"brush\");"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_brushMove1(mouse, scale, i) {"),
			std::string("            var range = d3_scaleExtent(scale.range()),"),
			std::string("                    offset = d3_svg_brushOffset[i],"),
			std::string("                    size = d3_svg_brushExtent[1][i] - d3_svg_brushExtent[0][i],"),
			std::string("                    min,"),
			std::string("                    max;"),
			std::string(""),
			std::string("            // When dragging, reduce the range by the extent size and offset."),
			std::string("            if (d3_svg_brushDrag) {"),
			std::string("                range[0] -= offset;"),
			std::string("                range[1] -= size + offset;"),
			std::string("            }"),
			std::string(""),
			std::string("            // Clamp the mouse so that the extent fits within the range extent."),
			std::string("            min = Math.max(range[0], Math.min(range[1], mouse[i]));"),
			std::string(""),
			std::string("            // Compute the new extent bounds."),
			std::string("            if (d3_svg_brushDrag) {"),
			std::string("                max = (min += offset) + size;"),
			std::string("            } else {"),
			std::string(""),
			std::string("                // If the ALT key is pressed, then preserve the center of the extent."),
			std::string("                if (d3_svg_brushCenter) offset = Math.max(range[0], Math.min(range[1], 2 * d3_svg_brushCenter[i] - min));"),
			std::string(""),
			std::string("                // Compute the min and max of the offset and mouse."),
			std::string("                if (offset < min) {"),
			std::string("                    max = min;"),
			std::string("                    min = offset;"),
			std::string("                } else {"),
			std::string("                    max = offset;"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            // Update the stored bounds."),
			std::string("            d3_svg_brushExtent[0][i] = min;"),
			std::string("            d3_svg_brushExtent[1][i] = max;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_svg_brushUp() {"),
			std::string("            if (d3_svg_brushOffset) {"),
			std::string("                d3_svg_brushMove();"),
			std::string("                d3.select(d3_svg_brushTarget).selectAll(\".resize\").style(\"pointer-events\", d3_svg_brush.empty() ? \"none\" : \"all\");"),
			std::string("                d3_svg_brushDispatch(\"brushend\");"),
			std::string("                d3_svg_brush ="),
			std::string("                        d3_svg_brushDispatch ="),
			std::string("                                d3_svg_brushTarget ="),
			std::string("                                        d3_svg_brushX ="),
			std::string("                                                d3_svg_brushY ="),
			std::string("                                                        d3_svg_brushExtent ="),
			std::string("                                                                d3_svg_brushDrag ="),
			std::string("                                                                        d3_svg_brushResize ="),
			std::string("                                                                                d3_svg_brushCenter ="),
			std::string("                                                                                        d3_svg_brushOffset = null;"),
			std::string("                d3_eventCancel();"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_svg_brushCursor = {"),
			std::string("            n: \"ns-resize\","),
			std::string("            e: \"ew-resize\","),
			std::string("            s: \"ns-resize\","),
			std::string("            w: \"ew-resize\","),
			std::string("            nw: \"nwse-resize\","),
			std::string("            ne: \"nesw-resize\","),
			std::string("            se: \"nwse-resize\","),
			std::string("            sw: \"nesw-resize\""),
			std::string("        };"),
			std::string("        d3.behavior = {};"),
			std::string("// TODO Track touch points by identifier."),
			std::string(""),
			std::string("        d3.behavior.drag = function() {"),
			std::string("            var event = d3.dispatch(\"drag\", \"dragstart\", \"dragend\"),"),
			std::string("                    origin = null;"),
			std::string(""),
			std::string("            function drag() {"),
			std::string("                this"),
			std::string("                        .on(\"mousedown.drag\", mousedown)"),
			std::string("                        .on(\"touchstart.drag\", mousedown);"),
			std::string(""),
			std::string("                d3.select(window)"),
			std::string("                        .on(\"mousemove.drag\", d3_behavior_dragMove)"),
			std::string("                        .on(\"touchmove.drag\", d3_behavior_dragMove)"),
			std::string("                        .on(\"mouseup.drag\", d3_behavior_dragUp, true)"),
			std::string("                        .on(\"touchend.drag\", d3_behavior_dragUp, true)"),
			std::string("                        .on(\"click.drag\", d3_behavior_dragClick, true);"),
			std::string("            }"),
			std::string(""),
			std::string("            // snapshot the local context for subsequent dispatch"),
			std::string("            function start() {"),
			std::string("                d3_behavior_dragEvent = event;"),
			std::string("                d3_behavior_dragEventTarget = d3.event.target;"),
			std::string("                d3_behavior_dragTarget = this;"),
			std::string("                d3_behavior_dragArguments = arguments;"),
			std::string("                d3_behavior_dragOrigin = d3_behavior_dragPoint();"),
			std::string("                if (origin) {"),
			std::string("                    d3_behavior_dragOffset = origin.apply(d3_behavior_dragTarget, d3_behavior_dragArguments);"),
			std::string("                    d3_behavior_dragOffset = [d3_behavior_dragOffset.x - d3_behavior_dragOrigin[0], d3_behavior_dragOffset.y - d3_behavior_dragOrigin[1]];"),
			std::string("                } else {"),
			std::string("                    d3_behavior_dragOffset = [0, 0];"),
			std::string("                }"),
			std::string("                d3_behavior_dragMoved = 0;"),
			std::string("            }"),
			std::string(""),
			std::string("            function mousedown() {"),
			std::string("                start.apply(this, arguments);"),
			std::string("                d3_behavior_dragDispatch(\"dragstart\");"),
			std::string("            }"),
			std::string(""),
			std::string("            drag.on = function(type, listener) {"),
			std::string("                event.on(type, listener);"),
			std::string("                return drag;"),
			std::string("            };"),
			std::string(""),
			std::string("            drag.origin = function(x) {"),
			std::string("                if (!arguments.length) return origin;"),
			std::string("                origin = x;"),
			std::string("                return drag;"),
			std::string("            };"),
			std::string(""),
			std::string("            return drag;"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_behavior_dragEvent,"),
			std::string("                d3_behavior_dragEventTarget,"),
			std::string("                d3_behavior_dragTarget,"),
			std::string("                d3_behavior_dragArguments,"),
			std::string("                d3_behavior_dragOffset,"),
			std::string("                d3_behavior_dragOrigin,"),
			std::string("                d3_behavior_dragMoved;"),
			std::string(""),
			std::string("        function d3_behavior_dragDispatch(type) {"),
			std::string("            var p = d3_behavior_dragPoint(),"),
			std::string("                    o = d3.event,"),
			std::string("                    e = d3.event = {type: type};"),
			std::string(""),
			std::string("            if (p) {"),
			std::string("                e.x = p[0] + d3_behavior_dragOffset[0];"),
			std::string("                e.y = p[1] + d3_behavior_dragOffset[1];"),
			std::string("                e.dx = p[0] - d3_behavior_dragOrigin[0];"),
			std::string("                e.dy = p[1] - d3_behavior_dragOrigin[1];"),
			std::string("                d3_behavior_dragMoved |= e.dx | e.dy;"),
			std::string("                d3_behavior_dragOrigin = p;"),
			std::string("            }"),
			std::string(""),
			std::string("            try {"),
			std::string("                d3_behavior_dragEvent[type].apply(d3_behavior_dragTarget, d3_behavior_dragArguments);"),
			std::string("            } finally {"),
			std::string("                d3.event = o;"),
			std::string("            }"),
			std::string(""),
			std::string("            o.stopPropagation();"),
			std::string("            o.preventDefault();"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_dragPoint() {"),
			std::string("            var p = d3_behavior_dragTarget.parentNode,"),
			std::string("                    t = d3.event.changedTouches;"),
			std::string("            return p && (t"),
			std::string("                    ? d3.svg.touches(p, t)[0]"),
			std::string("                    : d3.svg.mouse(p));"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_dragMove() {"),
			std::string("            if (!d3_behavior_dragTarget) return;"),
			std::string("            var parent = d3_behavior_dragTarget.parentNode;"),
			std::string(""),
			std::string("            // O NOES! The drag element was removed from the DOM."),
			std::string("            if (!parent) return d3_behavior_dragUp();"),
			std::string(""),
			std::string("            d3_behavior_dragDispatch(\"drag\");"),
			std::string("            d3_eventCancel();"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_dragUp() {"),
			std::string("            if (!d3_behavior_dragTarget) return;"),
			std::string("            d3_behavior_dragDispatch(\"dragend\");"),
			std::string(""),
			std::string("            // If the node was moved, prevent the mouseup from propagating."),
			std::string("            // Also prevent the subsequent click from propagating (e.g., for anchors)."),
			std::string("            if (d3_behavior_dragMoved) {"),
			std::string("                d3_eventCancel();"),
			std::string("                d3_behavior_dragMoved = d3.event.target === d3_behavior_dragEventTarget;"),
			std::string("            }"),
			std::string(""),
			std::string("            d3_behavior_dragEvent ="),
			std::string("                    d3_behavior_dragEventTarget ="),
			std::string("                            d3_behavior_dragTarget ="),
			std::string("                                    d3_behavior_dragArguments ="),
			std::string("                                            d3_behavior_dragOffset ="),
			std::string("                                                    d3_behavior_dragOrigin = null;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_dragClick() {"),
			std::string("            if (d3_behavior_dragMoved) {"),
			std::string("                d3_eventCancel();"),
			std::string("                d3_behavior_dragMoved = 0;"),
			std::string("            }"),
			std::string("        }"),
			std::string("// TODO unbind zoom behavior?"),
			std::string("        d3.behavior.zoom = function() {"),
			std::string("            var xyz = [0, 0, 0],"),
			std::string("                    event = d3.dispatch(\"zoom\"),"),
			std::string("                    extent = d3_behavior_zoomInfiniteExtent;"),
			std::string(""),
			std::string("            function zoom() {"),
			std::string("                this"),
			std::string("                        .on(\"mousedown.zoom\", mousedown)"),
			std::string("                        .on(\"mousewheel.zoom\", mousewheel)"),
			std::string("                        .on(\"DOMMouseScroll.zoom\", mousewheel)"),
			std::string("                        .on(\"dblclick.zoom\", dblclick)"),
			std::string("                        .on(\"touchstart.zoom\", touchstart);"),
			std::string(""),
			std::string("                d3.select(window)"),
			std::string("                        .on(\"mousemove.zoom\", d3_behavior_zoomMousemove)"),
			std::string("                        .on(\"mouseup.zoom\", d3_behavior_zoomMouseup)"),
			std::string("                        .on(\"touchmove.zoom\", d3_behavior_zoomTouchmove)"),
			std::string("                        .on(\"touchend.zoom\", d3_behavior_zoomTouchup)"),
			std::string("                        .on(\"click.zoom\", d3_behavior_zoomClick, true);"),
			std::string("            }"),
			std::string(""),
			std::string("            // snapshot the local context for subsequent dispatch"),
			std::string("            function start() {"),
			std::string("                d3_behavior_zoomXyz = xyz;"),
			std::string("                d3_behavior_zoomExtent = extent;"),
			std::string("                d3_behavior_zoomDispatch = event.zoom;"),
			std::string("                d3_behavior_zoomEventTarget = d3.event.target;"),
			std::string("                d3_behavior_zoomTarget = this;"),
			std::string("                d3_behavior_zoomArguments = arguments;"),
			std::string("            }"),
			std::string(""),
			std::string("            function mousedown() {"),
			std::string("                start.apply(this, arguments);"),
			std::string("                d3_behavior_zoomPanning = d3_behavior_zoomLocation(d3.svg.mouse(d3_behavior_zoomTarget));"),
			std::string("                d3_behavior_zoomMoved = 0;"),
			std::string("                d3.event.preventDefault();"),
			std::string("                window.focus();"),
			std::string("            }"),
			std::string(""),
			std::string("            // store starting mouse location"),
			std::string("            function mousewheel() {"),
			std::string("                start.apply(this, arguments);"),
			std::string("                if (!d3_behavior_zoomZooming) d3_behavior_zoomZooming = d3_behavior_zoomLocation(d3.svg.mouse(d3_behavior_zoomTarget));"),
			std::string("                d3_behavior_zoomTo(d3_behavior_zoomDelta() + xyz[2], d3.svg.mouse(d3_behavior_zoomTarget), d3_behavior_zoomZooming);"),
			std::string("            }"),
			std::string(""),
			std::string("            function dblclick() {"),
			std::string("                start.apply(this, arguments);"),
			std::string("                var mouse = d3.svg.mouse(d3_behavior_zoomTarget);"),
			std::string("                d3_behavior_zoomTo(d3.event.shiftKey ? Math.ceil(xyz[2] - 1) : Math.floor(xyz[2] + 1), mouse, d3_behavior_zoomLocation(mouse));"),
			std::string("            }"),
			std::string(""),
			std::string("            // doubletap detection"),
			std::string("            function touchstart() {"),
			std::string("                start.apply(this, arguments);"),
			std::string("                var touches = d3_behavior_zoomTouchup(),"),
			std::string("                        touch,"),
			std::string("                        now = Date.now();"),
			std::string("                if ((touches.length === 1) && (now - d3_behavior_zoomLast < 300)) {"),
			std::string("                    d3_behavior_zoomTo(1 + Math.floor(xyz[2]), touch = touches[0], d3_behavior_zoomLocations[touch.identifier]);"),
			std::string("                }"),
			std::string("                d3_behavior_zoomLast = now;"),
			std::string("            }"),
			std::string(""),
			std::string("            zoom.extent = function(x) {"),
			std::string("                if (!arguments.length) return extent;"),
			std::string("                extent = x == null ? d3_behavior_zoomInfiniteExtent : x;"),
			std::string("                return zoom;"),
			std::string("            };"),
			std::string(""),
			std::string("            zoom.on = function(type, listener) {"),
			std::string("                event.on(type, listener);"),
			std::string("                return zoom;"),
			std::string("            };"),
			std::string(""),
			std::string("            return zoom;"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_behavior_zoomDiv,"),
			std::string("                d3_behavior_zoomPanning,"),
			std::string("                d3_behavior_zoomZooming,"),
			std::string("                d3_behavior_zoomLocations = {}, // identifier -> location"),
			std::string("                d3_behavior_zoomLast = 0,"),
			std::string("                d3_behavior_zoomXyz,"),
			std::string("                d3_behavior_zoomExtent,"),
			std::string("                d3_behavior_zoomDispatch,"),
			std::string("                d3_behavior_zoomEventTarget,"),
			std::string("                d3_behavior_zoomTarget,"),
			std::string("                d3_behavior_zoomArguments,"),
			std::string("                d3_behavior_zoomMoved;"),
			std::string(""),
			std::string("        function d3_behavior_zoomLocation(point) {"),
			std::string("            return ["),
			std::string("                point[0] - d3_behavior_zoomXyz[0],"),
			std::string("                point[1] - d3_behavior_zoomXyz[1],"),
			std::string("                d3_behavior_zoomXyz[2]"),
			std::string("            ];"),
			std::string("        }"),
			std::string(""),
			std::string("// detect the pixels that would be scrolled by this wheel event"),
			std::string("        function d3_behavior_zoomDelta() {"),
			std::string(""),
			std::string("            // mousewheel events are totally broken!"),
			std::string("            // https://bugs.webkit.org/show_bug.cgi?id=40441"),
			std::string("            // not only that, but Chrome and Safari differ in re. to acceleration!"),
			std::string("            if (!d3_behavior_zoomDiv) {"),
			std::string("                d3_behavior_zoomDiv = d3.select(\"body\").append(\"div\")"),
			std::string("                        .style(\"visibility\", \"hidden\")"),
			std::string("                        .style(\"top\", 0)"),
			std::string("                        .style(\"height\", 0)"),
			std::string("                        .style(\"width\", 0)"),
			std::string("                        .style(\"overflow-y\", \"scroll\")"),
			std::string("                        .append(\"div\")"),
			std::string("                        .style(\"height\", \"2000px\")"),
			std::string("                        .node().parentNode;"),
			std::string("            }"),
			std::string(""),
			std::string("            var e = d3.event, delta;"),
			std::string("            try {"),
			std::string("                d3_behavior_zoomDiv.scrollTop = 1000;"),
			std::string("                d3_behavior_zoomDiv.dispatchEvent(e);"),
			std::string("                delta = 1000 - d3_behavior_zoomDiv.scrollTop;"),
			std::string("            } catch (error) {"),
			std::string("                delta = e.wheelDelta || (-e.detail * 5);"),
			std::string("            }"),
			std::string(""),
			std::string("            return delta * .005;"),
			std::string("        }"),
			std::string(""),
			std::string("// Note: Since we don't rotate, it's possible for the touches to become"),
			std::string("// slightly detached from their original positions. Thus, we recompute the"),
			std::string("// touch points on touchend as well as touchstart!"),
			std::string("        function d3_behavior_zoomTouchup() {"),
			std::string("            var touches = d3.svg.touches(d3_behavior_zoomTarget),"),
			std::string("                    i = -1,"),
			std::string("                    n = touches.length,"),
			std::string("                    touch;"),
			std::string("            while (++i < n) d3_behavior_zoomLocations[(touch = touches[i]).identifier] = d3_behavior_zoomLocation(touch);"),
			std::string("            return touches;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_zoomTouchmove() {"),
			std::string("            var touches = d3.svg.touches(d3_behavior_zoomTarget);"),
			std::string("            switch (touches.length) {"),
			std::string(""),
			std::string("                // single-touch pan"),
			std::string("                case 1: {"),
			std::string("                    var touch = touches[0];"),
			std::string("                    d3_behavior_zoomTo(d3_behavior_zoomXyz[2], touch, d3_behavior_zoomLocations[touch.identifier]);"),
			std::string("                    break;"),
			std::string("                }"),
			std::string(""),
			std::string("                // double-touch pan + zoom"),
			std::string("                case 2: {"),
			std::string("                    var p0 = touches[0],"),
			std::string("                            p1 = touches[1],"),
			std::string("                            p2 = [(p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2],"),
			std::string("                            l0 = d3_behavior_zoomLocations[p0.identifier],"),
			std::string("                            l1 = d3_behavior_zoomLocations[p1.identifier],"),
			std::string("                            l2 = [(l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2, l0[2]];"),
			std::string("                    d3_behavior_zoomTo(Math.log(d3.event.scale) / Math.LN2 + l0[2], p2, l2);"),
			std::string("                    break;"),
			std::string("                }"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_zoomMousemove() {"),
			std::string("            d3_behavior_zoomZooming = null;"),
			std::string("            if (d3_behavior_zoomPanning) {"),
			std::string("                d3_behavior_zoomMoved = 1;"),
			std::string("                d3_behavior_zoomTo(d3_behavior_zoomXyz[2], d3.svg.mouse(d3_behavior_zoomTarget), d3_behavior_zoomPanning);"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_zoomMouseup() {"),
			std::string("            if (d3_behavior_zoomPanning) {"),
			std::string("                if (d3_behavior_zoomMoved) {"),
			std::string("                    d3_eventCancel();"),
			std::string("                    d3_behavior_zoomMoved = d3_behavior_zoomEventTarget === d3.event.target;"),
			std::string("                }"),
			std::string(""),
			std::string("                d3_behavior_zoomXyz ="),
			std::string("                        d3_behavior_zoomExtent ="),
			std::string("                                d3_behavior_zoomDispatch ="),
			std::string("                                        d3_behavior_zoomEventTarget ="),
			std::string("                                                d3_behavior_zoomTarget ="),
			std::string("                                                        d3_behavior_zoomArguments ="),
			std::string("                                                                d3_behavior_zoomPanning = null;"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_zoomClick() {"),
			std::string("            if (d3_behavior_zoomMoved) {"),
			std::string("                d3_eventCancel();"),
			std::string("                d3_behavior_zoomMoved = 0;"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_behavior_zoomTo(z, x0, x1) {"),
			std::string("            z = d3_behavior_zoomExtentClamp(z, 2);"),
			std::string("            var j = Math.pow(2, d3_behavior_zoomXyz[2]),"),
			std::string("                    k = Math.pow(2, z),"),
			std::string("                    K = Math.pow(2, (d3_behavior_zoomXyz[2] = z) - x1[2]),"),
			std::string("                    x_ = d3_behavior_zoomXyz[0],"),
			std::string("                    y_ = d3_behavior_zoomXyz[1],"),
			std::string("                    x = d3_behavior_zoomXyz[0] = d3_behavior_zoomExtentClamp((x0[0] - x1[0] * K), 0, k),"),
			std::string("                    y = d3_behavior_zoomXyz[1] = d3_behavior_zoomExtentClamp((x0[1] - x1[1] * K), 1, k),"),
			std::string("                    o = d3.event; // Events can be reentrant (e.g., focus)."),
			std::string(""),
			std::string("            d3.event = {"),
			std::string("                scale: k,"),
			std::string("                translate: [x, y],"),
			std::string("                transform: function(sx, sy) {"),
			std::string("                    if (sx) transform(sx, x_, x);"),
			std::string("                    if (sy) transform(sy, y_, y);"),
			std::string("                }"),
			std::string("            };"),
			std::string(""),
			std::string("            function transform(scale, a, b) {"),
			std::string("                scale.domain(scale.range().map(function(v) { return scale.invert(((v - b) * j) / k + a); }));"),
			std::string("            }"),
			std::string(""),
			std::string("            try {"),
			std::string("                d3_behavior_zoomDispatch.apply(d3_behavior_zoomTarget, d3_behavior_zoomArguments);"),
			std::string("            } finally {"),
			std::string("                d3.event = o;"),
			std::string("            }"),
			std::string(""),
			std::string("            o.preventDefault();"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_behavior_zoomInfiniteExtent = ["),
			std::string("            [-Infinity, Infinity],"),
			std::string("            [-Infinity, Infinity],"),
			std::string("            [-Infinity, Infinity]"),
			std::string("        ];"),
			std::string(""),
			std::string("        function d3_behavior_zoomExtentClamp(x, i, k) {"),
			std::string("            var range = d3_behavior_zoomExtent[i],"),
			std::string("                    r0 = range[0],"),
			std::string("                    r1 = range[1];"),
			std::string("            return arguments.length === 3"),
			std::string("                    ? Math.max(r1 * (r1 === Infinity ? -Infinity : 1 / k - 1),"),
			std::string("                    Math.min(r0 === -Infinity ? Infinity : r0, x / k)) * k"),
			std::string("                    : Math.max(r0, Math.min(r1, x));"),
			std::string("        }"),
			std::string("    })();"),
			std::string("    </script>"),
			std::string("    <script type=\"text/javascript\">"),
			std::string("    (function(){d3.layout = {};"),
			std::string("// Implements hierarchical edge bundling using Holten's algorithm. For each"),
			std::string("// input link, a path is computed that travels through the tree, up the parent"),
			std::string("// hierarchy to the least common ancestor, and then back down to the destination"),
			std::string("// node. Each path is simply an array of nodes."),
			std::string("        d3.layout.bundle = function() {"),
			std::string("            return function(links) {"),
			std::string("                var paths = [],"),
			std::string("                        i = -1,"),
			std::string("                        n = links.length;"),
			std::string("                while (++i < n) paths.push(d3_layout_bundlePath(links[i]));"),
			std::string("                return paths;"),
			std::string("            };"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_layout_bundlePath(link) {"),
			std::string("            var start = link.source,"),
			std::string("                    end = link.target,"),
			std::string("                    lca = d3_layout_bundleLeastCommonAncestor(start, end),"),
			std::string("                    points = [start];"),
			std::string("            while (start !== lca) {"),
			std::string("                start = start.parent;"),
			std::string("                points.push(start);"),
			std::string("            }"),
			std::string("            var k = points.length;"),
			std::string("            while (end !== lca) {"),
			std::string("                points.splice(k, 0, end);"),
			std::string("                end = end.parent;"),
			std::string("            }"),
			std::string("            return points;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_bundleAncestors(node) {"),
			std::string("            var ancestors = [],"),
			std::string("                    parent = node.parent;"),
			std::string("            while (parent != null) {"),
			std::string("                ancestors.push(node);"),
			std::string("                node = parent;"),
			std::string("                parent = parent.parent;"),
			std::string("            }"),
			std::string("            ancestors.push(node);"),
			std::string("            return ancestors;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_bundleLeastCommonAncestor(a, b) {"),
			std::string("            if (a === b) return a;"),
			std::string("            var aNodes = d3_layout_bundleAncestors(a),"),
			std::string("                    bNodes = d3_layout_bundleAncestors(b),"),
			std::string("                    aNode = aNodes.pop(),"),
			std::string("                    bNode = bNodes.pop(),"),
			std::string("                    sharedNode = null;"),
			std::string("            while (aNode === bNode) {"),
			std::string("                sharedNode = aNode;"),
			std::string("                aNode = aNodes.pop();"),
			std::string("                bNode = bNodes.pop();"),
			std::string("            }"),
			std::string("            return sharedNode;"),
			std::string("        }"),
			std::string("        d3.layout.chord = function() {"),
			std::string("            var chord = {},"),
			std::string("                    chords,"),
			std::string("                    groups,"),
			std::string("                    matrix,"),
			std::string("                    n,"),
			std::string("                    padding = 0,"),
			std::string("                    sortGroups,"),
			std::string("                    sortSubgroups,"),
			std::string("                    sortChords;"),
			std::string(""),
			std::string("            function relayout() {"),
			std::string("                var subgroups = {},"),
			std::string("                        groupSums = [],"),
			std::string("                        groupIndex = d3.range(n),"),
			std::string("                        subgroupIndex = [],"),
			std::string("                        k,"),
			std::string("                        x,"),
			std::string("                        x0,"),
			std::string("                        i,"),
			std::string("                        j;"),
			std::string(""),
			std::string("                chords = [];"),
			std::string("                groups = [];"),
			std::string(""),
			std::string("                // Compute the sum."),
			std::string("                k = 0, i = -1; while (++i < n) {"),
			std::string("                    x = 0, j = -1; while (++j < n) {"),
			std::string("                        x += matrix[i][j];"),
			std::string("                    }"),
			std::string("                    groupSums.push(x);"),
			std::string("                    subgroupIndex.push(d3.range(n));"),
			std::string("                    k += x;"),
			std::string("                }"),
			std::string(""),
			std::string("                // Sort groupsвЂ¦"),
			std::string("                if (sortGroups) {"),
			std::string("                    groupIndex.sort(function(a, b) {"),
			std::string("                        return sortGroups(groupSums[a], groupSums[b]);"),
			std::string("                    });"),
			std::string("                }"),
			std::string(""),
			std::string("                // Sort subgroupsвЂ¦"),
			std::string("                if (sortSubgroups) {"),
			std::string("                    subgroupIndex.forEach(function(d, i) {"),
			std::string("                        d.sort(function(a, b) {"),
			std::string("                            return sortSubgroups(matrix[i][a], matrix[i][b]);"),
			std::string("                        });"),
			std::string("                    });"),
			std::string("                }"),
			std::string(""),
			std::string("                // Convert the sum to scaling factor for [0, 2pi]."),
			std::string("                // TODO Allow start and end angle to be specified."),
			std::string("                // TODO Allow padding to be specified as percentage?"),
			std::string("                k = (2 * Math.PI - padding * n) / k;"),
			std::string(""),
			std::string("                // Compute the start and end angle for each group and subgroup."),
			std::string("                // Note: Opera has a bug reordering object literal properties!"),
			std::string("                x = 0, i = -1; while (++i < n) {"),
			std::string("                    x0 = x, j = -1; while (++j < n) {"),
			std::string("                        var di = groupIndex[i],"),
			std::string("                                dj = subgroupIndex[di][j],"),
			std::string("                                v = matrix[di][dj],"),
			std::string("                                a0 = x,"),
			std::string("                                a1 = x += v * k;"),
			std::string("                        subgroups[di + \"-\" + dj] = {"),
			std::string("                            index: di,"),
			std::string("                            subindex: dj,"),
			std::string("                            startAngle: a0,"),
			std::string("                            endAngle: a1,"),
			std::string("                            value: v"),
			std::string("                        };"),
			std::string("                    }"),
			std::string("                    groups.push({"),
			std::string("                        index: di,"),
			std::string("                        startAngle: x0,"),
			std::string("                        endAngle: x,"),
			std::string("                        value: (x - x0) / k"),
			std::string("                    });"),
			std::string("                    x += padding;"),
			std::string("                }"),
			std::string(""),
			std::string("                // Generate chords for each (non-empty) subgroup-subgroup link."),
			std::string("                i = -1; while (++i < n) {"),
			std::string("                    j = i - 1; while (++j < n) {"),
			std::string("                        var source = subgroups[i + \"-\" + j],"),
			std::string("                                target = subgroups[j + \"-\" + i];"),
			std::string("                        if (source.value || target.value) {"),
			std::string("                            chords.push(source.value < target.value"),
			std::string("                                    ? {source: target, target: source}"),
			std::string("                                    : {source: source, target: target});"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                if (sortChords) resort();"),
			std::string("            }"),
			std::string(""),
			std::string("            function resort() {"),
			std::string("                chords.sort(function(a, b) {"),
			std::string("                    return sortChords("),
			std::string("                            (a.source.value + a.target.value) / 2,"),
			std::string("                            (b.source.value + b.target.value) / 2);"),
			std::string("                });"),
			std::string("            }"),
			std::string(""),
			std::string("            chord.matrix = function(x) {"),
			std::string("                if (!arguments.length) return matrix;"),
			std::string("                n = (matrix = x) && matrix.length;"),
			std::string("                chords = groups = null;"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.padding = function(x) {"),
			std::string("                if (!arguments.length) return padding;"),
			std::string("                padding = x;"),
			std::string("                chords = groups = null;"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.sortGroups = function(x) {"),
			std::string("                if (!arguments.length) return sortGroups;"),
			std::string("                sortGroups = x;"),
			std::string("                chords = groups = null;"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.sortSubgroups = function(x) {"),
			std::string("                if (!arguments.length) return sortSubgroups;"),
			std::string("                sortSubgroups = x;"),
			std::string("                chords = null;"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.sortChords = function(x) {"),
			std::string("                if (!arguments.length) return sortChords;"),
			std::string("                sortChords = x;"),
			std::string("                if (chords) resort();"),
			std::string("                return chord;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.chords = function() {"),
			std::string("                if (!chords) relayout();"),
			std::string("                return chords;"),
			std::string("            };"),
			std::string(""),
			std::string("            chord.groups = function() {"),
			std::string("                if (!groups) relayout();"),
			std::string("                return groups;"),
			std::string("            };"),
			std::string(""),
			std::string("            return chord;"),
			std::string("        };"),
			std::string("// A rudimentary force layout using Gauss-Seidel."),
			std::string("        d3.layout.force = function() {"),
			std::string("            var force = {},"),
			std::string("                    event = d3.dispatch(\"tick\"),"),
			std::string("                    size = [1, 1],"),
			std::string("                    drag,"),
			std::string("                    alpha,"),
			std::string("                    friction = .9,"),
			std::string("                    linkDistance = d3_layout_forceLinkDistance,"),
			std::string("                    linkStrength = d3_layout_forceLinkStrength,"),
			std::string("                    charge = -30,"),
			std::string("                    gravity = .1,"),
			std::string("                    theta = .8,"),
			std::string("                    interval,"),
			std::string("                    nodes = [],"),
			std::string("                    links = [],"),
			std::string("                    distances,"),
			std::string("                    strengths,"),
			std::string("                    charges;"),
			std::string(""),
			std::string("            function repulse(node) {"),
			std::string("                return function(quad, x1, y1, x2, y2) {"),
			std::string("                    if (quad.point !== node) {"),
			std::string("                        var dx = quad.cx - node.x,"),
			std::string("                                dy = quad.cy - node.y,"),
			std::string("                                dn = 1 / Math.sqrt(dx * dx + dy * dy);"),
			std::string(""),
			std::string("                        /* Barnes-Hut criterion. */"),
			std::string("                        if ((x2 - x1) * dn < theta) {"),
			std::string("                            var k = quad.charge * dn * dn;"),
			std::string("                            node.px -= dx * k;"),
			std::string("                            node.py -= dy * k;"),
			std::string("                            return true;"),
			std::string("                        }"),
			std::string(""),
			std::string("                        if (quad.point && isFinite(dn)) {"),
			std::string("                            var k = quad.pointCharge * dn * dn;"),
			std::string("                            node.px -= dx * k;"),
			std::string("                            node.py -= dy * k;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                    return !quad.charge;"),
			std::string("                };"),
			std::string("            }"),
			std::string(""),
			std::string("            function tick() {"),
			std::string("                var n = nodes.length,"),
			std::string("                        m = links.length,"),
			std::string("                        q,"),
			std::string("                        i, // current index"),
			std::string("                        o, // current object"),
			std::string("                        s, // current source"),
			std::string("                        t, // current target"),
			std::string("                        l, // current distance"),
			std::string("                        k, // current force"),
			std::string("                        x, // x-distance"),
			std::string("                        y; // y-distance"),
			std::string(""),
			std::string("                // gauss-seidel relaxation for links"),
			std::string("                for (i = 0; i < m; ++i) {"),
			std::string("                    o = links[i];"),
			std::string("                    s = o.source;"),
			std::string("                    t = o.target;"),
			std::string("                    x = t.x - s.x;"),
			std::string("                    y = t.y - s.y;"),
			std::string("                    if (l = (x * x + y * y)) {"),
			std::string("                        l = alpha * strengths[i] * ((l = Math.sqrt(l)) - distances[i]) / l;"),
			std::string("                        x *= l;"),
			std::string("                        y *= l;"),
			std::string("                        t.x -= x * (k = s.weight / (t.weight + s.weight));"),
			std::string("                        t.y -= y * k;"),
			std::string("                        s.x += x * (k = 1 - k);"),
			std::string("                        s.y += y * k;"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                // apply gravity forces"),
			std::string("                if (k = alpha * gravity) {"),
			std::string("                    x = size[0] / 2;"),
			std::string("                    y = size[1] / 2;"),
			std::string("                    i = -1; if (k) while (++i < n) {"),
			std::string("                        o = nodes[i];"),
			std::string("                        o.x += (x - o.x) * k;"),
			std::string("                        o.y += (y - o.y) * k;"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                // compute quadtree center of mass and apply charge forces"),
			std::string("                if (charge) {"),
			std::string("                    d3_layout_forceAccumulate(q = d3.geom.quadtree(nodes), alpha, charges);"),
			std::string("                    i = -1; while (++i < n) {"),
			std::string("                        if (!(o = nodes[i]).fixed) {"),
			std::string("                            q.visit(repulse(o));"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                // position verlet integration"),
			std::string("                i = -1; while (++i < n) {"),
		};

		const std::string d3TemplateBlockNo5[] = 
		{
			std::string("                    o = nodes[i];"),
			std::string("                    if (o.fixed) {"),
			std::string("                        o.x = o.px;"),
			std::string("                        o.y = o.py;"),
			std::string("                    } else {"),
			std::string("                        o.x -= (o.px - (o.px = o.x)) * friction;"),
			std::string("                        o.y -= (o.py - (o.py = o.y)) * friction;"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                event.tick({type: \"tick\", alpha: alpha});"),
			std::string(""),
			std::string("                // simulated annealing, basically"),
			std::string("                return (alpha *= .99) < .005;"),
			std::string("            }"),
			std::string(""),
			std::string("            force.on = function(type, listener) {"),
			std::string("                event.on(type, listener);"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.nodes = function(x) {"),
			std::string("                if (!arguments.length) return nodes;"),
			std::string("                nodes = x;"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.links = function(x) {"),
			std::string("                if (!arguments.length) return links;"),
			std::string("                links = x;"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.size = function(x) {"),
			std::string("                if (!arguments.length) return size;"),
			std::string("                size = x;"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.linkDistance = function(x) {"),
			std::string("                if (!arguments.length) return linkDistance;"),
			std::string("                linkDistance = d3.functor(x);"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            // For backwards-compatibility."),
			std::string("            force.distance = force.linkDistance;"),
			std::string(""),
			std::string("            force.linkStrength = function(x) {"),
			std::string("                if (!arguments.length) return linkStrength;"),
			std::string("                linkStrength = d3.functor(x);"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.friction = function(x) {"),
			std::string("                if (!arguments.length) return friction;"),
			std::string("                friction = x;"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.charge = function(x) {"),
			std::string("                if (!arguments.length) return charge;"),
			std::string("                charge = typeof x === \"function\" ? x : +x;"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.gravity = function(x) {"),
			std::string("                if (!arguments.length) return gravity;"),
			std::string("                gravity = x;"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.theta = function(x) {"),
			std::string("                if (!arguments.length) return theta;"),
			std::string("                theta = x;"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.start = function() {"),
			std::string("                var i,"),
			std::string("                        j,"),
			std::string("                        n = nodes.length,"),
			std::string("                        m = links.length,"),
			std::string("                        w = size[0],"),
			std::string("                        h = size[1],"),
			std::string("                        neighbors,"),
			std::string("                        o;"),
			std::string(""),
			std::string("                for (i = 0; i < n; ++i) {"),
			std::string("                    (o = nodes[i]).index = i;"),
			std::string("                    o.weight = 0;"),
			std::string("                }"),
			std::string(""),
			std::string("                distances = [];"),
			std::string("                strengths = [];"),
			std::string("                for (i = 0; i < m; ++i) {"),
			std::string("                    o = links[i];"),
			std::string("                    if (typeof o.source == \"number\") o.source = nodes[o.source];"),
			std::string("                    if (typeof o.target == \"number\") o.target = nodes[o.target];"),
			std::string("                    distances[i] = linkDistance.call(this, o, i);"),
			std::string("                    strengths[i] = linkStrength.call(this, o, i);"),
			std::string("                    ++o.source.weight;"),
			std::string("                    ++o.target.weight;"),
			std::string("                }"),
			std::string(""),
			std::string("                for (i = 0; i < n; ++i) {"),
			std::string("                    o = nodes[i];"),
			std::string("                    if (isNaN(o.x)) o.x = position(\"x\", w);"),
			std::string("                    if (isNaN(o.y)) o.y = position(\"y\", h);"),
			std::string("                    if (isNaN(o.px)) o.px = o.x;"),
			std::string("                    if (isNaN(o.py)) o.py = o.y;"),
			std::string("                }"),
			std::string(""),
			std::string("                charges = [];"),
			std::string("                if (typeof charge === \"function\") {"),
			std::string("                    for (i = 0; i < n; ++i) {"),
			std::string("                        charges[i] = +charge.call(this, nodes[i], i);"),
			std::string("                    }"),
			std::string("                } else {"),
			std::string("                    for (i = 0; i < n; ++i) {"),
			std::string("                        charges[i] = charge;"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                // initialize node position based on first neighbor"),
			std::string("                function position(dimension, size) {"),
			std::string("                    var neighbors = neighbor(i),"),
			std::string("                            j = -1,"),
			std::string("                            m = neighbors.length,"),
			std::string("                            x;"),
			std::string("                    while (++j < m) if (!isNaN(x = neighbors[j][dimension])) return x;"),
			std::string("                    return Math.random() * size;"),
			std::string("                }"),
			std::string(""),
			std::string("                // initialize neighbors lazily"),
			std::string("                function neighbor() {"),
			std::string("                    if (!neighbors) {"),
			std::string("                        neighbors = [];"),
			std::string("                        for (j = 0; j < n; ++j) {"),
			std::string("                            neighbors[j] = [];"),
			std::string("                        }"),
			std::string("                        for (j = 0; j < m; ++j) {"),
			std::string("                            var o = links[j];"),
			std::string("                            neighbors[o.source.index].push(o.target);"),
			std::string("                            neighbors[o.target.index].push(o.source);"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                    return neighbors[i];"),
			std::string("                }"),
			std::string(""),
			std::string("                return force.resume();"),
			std::string("            };"),
			std::string(""),
			std::string("            force.resume = function() {"),
			std::string("                alpha = .1;"),
			std::string("                d3.timer(tick);"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            force.stop = function() {"),
			std::string("                alpha = 0;"),
			std::string("                return force;"),
			std::string("            };"),
			std::string(""),
			std::string("            // use `node.call(force.drag)` to make nodes draggable"),
			std::string("            force.drag = function() {"),
			std::string("                if (!drag) drag = d3.behavior.drag()"),
			std::string("                        .origin(Object)"),
			std::string("                        .on(\"dragstart\", dragstart)"),
			std::string("                        .on(\"drag\", d3_layout_forceDrag)"),
			std::string("                        .on(\"dragend\", d3_layout_forceDragEnd);"),
			std::string(""),
			std::string("                this.on(\"mouseover.force\", d3_layout_forceDragOver)"),
			std::string("                        .on(\"mouseout.force\", d3_layout_forceDragOut)"),
			std::string("                        .call(drag);"),
			std::string("            };"),
			std::string(""),
			std::string("            function dragstart(d) {"),
			std::string("                d3_layout_forceDragOver(d3_layout_forceDragNode = d);"),
			std::string("                d3_layout_forceDragForce = force;"),
			std::string("            }"),
			std::string(""),
			std::string("            return force;"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_layout_forceDragForce,"),
			std::string("                d3_layout_forceDragNode;"),
			std::string(""),
			std::string("        function d3_layout_forceDragOver(d) {"),
			std::string("            d.fixed |= 2;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_forceDragOut(d) {"),
			std::string("            if (d !== d3_layout_forceDragNode) d.fixed &= 1;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_forceDragEnd() {"),
			std::string("            d3_layout_forceDrag();"),
			std::string("            d3_layout_forceDragNode.fixed &= 1;"),
			std::string("            d3_layout_forceDragForce = d3_layout_forceDragNode = null;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_forceDrag() {"),
			std::string("            d3_layout_forceDragNode.px = d3.event.x;"),
			std::string("            d3_layout_forceDragNode.py = d3.event.y;"),
			std::string("            d3_layout_forceDragForce.resume(); // restart annealing"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_forceAccumulate(quad, alpha, charges) {"),
			std::string("            var cx = 0,"),
			std::string("                    cy = 0;"),
			std::string("            quad.charge = 0;"),
			std::string("            if (!quad.leaf) {"),
			std::string("                var nodes = quad.nodes,"),
			std::string("                        n = nodes.length,"),
			std::string("                        i = -1,"),
			std::string("                        c;"),
			std::string("                while (++i < n) {"),
			std::string("                    c = nodes[i];"),
			std::string("                    if (c == null) continue;"),
			std::string("                    d3_layout_forceAccumulate(c, alpha, charges);"),
			std::string("                    quad.charge += c.charge;"),
			std::string("                    cx += c.charge * c.cx;"),
			std::string("                    cy += c.charge * c.cy;"),
			std::string("                }"),
			std::string("            }"),
			std::string("            if (quad.point) {"),
			std::string("                // jitter internal nodes that are coincident"),
			std::string("                if (!quad.leaf) {"),
			std::string("                    quad.point.x += Math.random() - .5;"),
			std::string("                    quad.point.y += Math.random() - .5;"),
			std::string("                }"),
			std::string("                var k = alpha * charges[quad.point.index];"),
			std::string("                quad.charge += quad.pointCharge = k;"),
			std::string("                cx += k * quad.point.x;"),
			std::string("                cy += k * quad.point.y;"),
			std::string("            }"),
			std::string("            quad.cx = cx / quad.charge;"),
			std::string("            quad.cy = cy / quad.charge;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_forceLinkDistance(link) {"),
			std::string("            return 20;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_forceLinkStrength(link) {"),
			std::string("            return 1;"),
			std::string("        }"),
			std::string("        d3.layout.partition = function() {"),
			std::string("            var hierarchy = d3.layout.hierarchy(),"),
			std::string("                    size = [1, 1]; // width, height"),
			std::string(""),
			std::string("            function position(node, x, dx, dy) {"),
			std::string("                var children = node.children;"),
			std::string("                node.x = x;"),
			std::string("                node.y = node.depth * dy;"),
			std::string("                node.dx = dx;"),
			std::string("                node.dy = dy;"),
			std::string("                if (children && (n = children.length)) {"),
			std::string("                    var i = -1,"),
			std::string("                            n,"),
			std::string("                            c,"),
			std::string("                            d;"),
			std::string("                    dx = node.value ? dx / node.value : 0;"),
			std::string("                    while (++i < n) {"),
			std::string("                        position(c = children[i], x, d = c.value * dx, dy);"),
			std::string("                        x += d;"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            function depth(node) {"),
			std::string("                var children = node.children,"),
			std::string("                        d = 0;"),
			std::string("                if (children && (n = children.length)) {"),
			std::string("                    var i = -1,"),
			std::string("                            n;"),
			std::string("                    while (++i < n) d = Math.max(d, depth(children[i]));"),
			std::string("                }"),
			std::string("                return 1 + d;"),
			std::string("            }"),
			std::string(""),
			std::string("            function partition(d, i) {"),
			std::string("                var nodes = hierarchy.call(this, d, i);"),
			std::string("                position(nodes[0], 0, size[0], size[1] / depth(nodes[0]));"),
			std::string("                return nodes;"),
			std::string("            }"),
			std::string(""),
			std::string("            partition.size = function(x) {"),
			std::string("                if (!arguments.length) return size;"),
			std::string("                size = x;"),
			std::string("                return partition;"),
			std::string("            };"),
			std::string(""),
			std::string("            return d3_layout_hierarchyRebind(partition, hierarchy);"),
			std::string("        };"),
			std::string("        d3.layout.pie = function() {"),
			std::string("            var value = Number,"),
			std::string("                    sort = d3_layout_pieSortByValue,"),
			std::string("                    startAngle = 0,"),
			std::string("                    endAngle = 2 * Math.PI;"),
			std::string(""),
			std::string("            function pie(data, i) {"),
			std::string(""),
			std::string("                // Compute the numeric values for each data element."),
			std::string("                var values = data.map(function(d, i) { return +value.call(pie, d, i); });"),
			std::string(""),
			std::string("                // Compute the start angle."),
			std::string("                var a = +(typeof startAngle === \"function\""),
			std::string("                        ? startAngle.apply(this, arguments)"),
			std::string("                        : startAngle);"),
			std::string(""),
			std::string("                // Compute the angular scale factor: from value to radians."),
			std::string("                var k = ((typeof endAngle === \"function\""),
			std::string("                        ? endAngle.apply(this, arguments)"),
			std::string("                        : endAngle) - startAngle)"),
			std::string("                        / d3.sum(values);"),
			std::string(""),
			std::string("                // Optionally sort the data."),
			std::string("                var index = d3.range(data.length);"),
			std::string("                if (sort != null) d3.sort(sort === d3_layout_pieSortByValue"),
			std::string("                        ? function(i, j) { return values[j] - values[i]; }"),
			std::string("                        : function(i, j) { return sort(data[i], data[j]); });"),
			std::string(""),
			std::string("                // Compute the arcs!"),
			std::string("                var arcs = d3.map(function(i) {"),
			std::string("                    return {"),
			std::string("                        data: data[i],"),
			std::string("                        value: d = values[i],"),
			std::string("                        startAngle: a,"),
			std::string("                        endAngle: a += d * k"),
			std::string("                    };"),
			std::string("                });"),
			std::string(""),
			std::string("                // Return the arcs in the original data's order."),
			std::string("                return data.map(function(d, i) {"),
			std::string("                    return arcs[d3[i]];"),
			std::string("                });"),
			std::string("            }"),
			std::string(""),
			std::string("            /**"),
			std::string("             * Specifies the value function *x*, which returns a nonnegative numeric value"),
			std::string("             * for each datum. The default value function is `Number`. The value function"),
			std::string("             * is passed two arguments: the current datum and the current index."),
			std::string("             */"),
			std::string("            pie.value = function(x) {"),
			std::string("                if (!arguments.length) return value;"),
			std::string("                value = x;"),
			std::string("                return pie;"),
			std::string("            };"),
			std::string(""),
			std::string("            /**"),
			std::string("             * Specifies a sort comparison operator *x*. The comparator is passed two data"),
			std::string("             * elements from the data array, a and b; it returns a negative value if a is"),
			std::string("             * less than b, a positive value if a is greater than b, and zero if a equals"),
			std::string("             * b."),
			std::string("             */"),
			std::string("            pie.sort = function(x) {"),
			std::string("                if (!arguments.length) return sort;"),
			std::string("                sort = x;"),
			std::string("                return pie;"),
			std::string("            };"),
			std::string(""),
			std::string("            /**"),
			std::string("             * Specifies the overall start angle of the pie chart. Defaults to 0. The"),
			std::string("             * start angle can be specified either as a constant or as a function; in the"),
			std::string("             * case of a function, it is evaluated once per array (as opposed to per"),
			std::string("             * element)."),
			std::string("             */"),
			std::string("            pie.startAngle = function(x) {"),
			std::string("                if (!arguments.length) return startAngle;"),
			std::string("                startAngle = x;"),
			std::string("                return pie;"),
			std::string("            };"),
			std::string(""),
			std::string("            /**"),
			std::string("             * Specifies the overall end angle of the pie chart. Defaults to 2ПЂ. The"),
			std::string("             * end angle can be specified either as a constant or as a function; in the"),
			std::string("             * case of a function, it is evaluated once per array (as opposed to per"),
			std::string("             * element)."),
			std::string("             */"),
			std::string("            pie.endAngle = function(x) {"),
			std::string("                if (!arguments.length) return endAngle;"),
			std::string("                endAngle = x;"),
			std::string("                return pie;"),
			std::string("            };"),
			std::string(""),
			std::string("            return pie;"),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_layout_pieSortByValue = {};"),
			std::string("// data is two-dimensional array of x,y; we populate y0"),
			std::string("        d3.layout.stack = function() {"),
			std::string("            var values = Object,"),
			std::string("                    order = d3_layout_stackOrders[\"default\"],"),
			std::string("                    offset = d3_layout_stackOffsets[\"zero\"],"),
			std::string("                    out = d3_layout_stackOut,"),
			std::string("                    x = d3_layout_stackX,"),
			std::string("                    y = d3_layout_stackY;"),
			std::string(""),
			std::string("            function stack(data, index) {"),
			std::string(""),
			std::string("                // Convert series to canonical two-dimensional representation."),
			std::string("                var series = data.map(function(d, i) {"),
			std::string("                    return values.call(stack, d, i);"),
			std::string("                });"),
			std::string(""),
			std::string("                // Convert each series to canonical [[x,y]] representation."),
			std::string("                var points = series.map(function(d, i) {"),
			std::string("                    return d.map(function(v, i) {"),
			std::string("                        return [x.call(stack, v, i), y.call(stack, v, i)];"),
			std::string("                    });"),
			std::string("                });"),
			std::string(""),
			std::string("                // Compute the order of series, and permute them."),
			std::string("                var orders = order.call(stack, points, d3);"),
			std::string("                series = d3.permute(series, orders);"),
			std::string("                points = d3.permute(points, orders);"),
			std::string(""),
			std::string("                // Compute the baselineвЂ¦"),
			std::string("                var offsets = offset.call(stack, points, d3);"),
			std::string(""),
			std::string("                // And propagate it to other series."),
			std::string("                var n = series.length,"),
			std::string("                        m = series[0].length,"),
			std::string("                        i,"),
			std::string("                        j,"),
			std::string("                        o;"),
			std::string("                for (j = 0; j < m; ++j) {"),
			std::string("                    out.call(stack, series[0][j], o = offsets[j], points[0][j][1]);"),
			std::string("                    for (i = 1; i < n; ++i) {"),
			std::string("                        out.call(stack, series[i][j], o += points[i - 1][j][1], points[i][j][1]);"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                return data;"),
			std::string("            }"),
			std::string(""),
			std::string("            stack.values = function(x) {"),
			std::string("                if (!arguments.length) return values;"),
			std::string("                values = x;"),
			std::string("                return stack;"),
			std::string("            };"),
			std::string(""),
			std::string("            stack.order = function(x) {"),
			std::string("                if (!arguments.length) return order;"),
			std::string("                order = typeof x === \"function\" ? x : d3_layout_stackOrders[x];"),
			std::string("                return stack;"),
			std::string("            };"),
			std::string(""),
			std::string("            stack.offset = function(x) {"),
			std::string("                if (!arguments.length) return offset;"),
			std::string("                offset = typeof x === \"function\" ? x : d3_layout_stackOffsets[x];"),
			std::string("                return stack;"),
			std::string("            };"),
			std::string(""),
			std::string("            stack.x = function(z) {"),
			std::string("                if (!arguments.length) return x;"),
			std::string("                x = z;"),
			std::string("                return stack;"),
			std::string("            };"),
			std::string(""),
			std::string("            stack.y = function(z) {"),
			std::string("                if (!arguments.length) return y;"),
			std::string("                y = z;"),
			std::string("                return stack;"),
			std::string("            };"),
			std::string(""),
			std::string("            stack.out = function(z) {"),
			std::string("                if (!arguments.length) return out;"),
			std::string("                out = z;"),
			std::string("                return stack;"),
			std::string("            };"),
			std::string(""),
			std::string("            return stack;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_stackX(d) {"),
			std::string("            return d.x;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_stackY(d) {"),
			std::string("            return d.y;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_stackOut(d, y0, y) {"),
			std::string("            d.y0 = y0;"),
			std::string("            d.y = y;"),
			std::string("        }"),
			std::string(""),
			std::string("        var d3_layout_stackOrders = {"),
			std::string(""),
			std::string("            \"inside-out\": function(data) {"),
			std::string("                var n = data.length,"),
			std::string("                        i,"),
			std::string("                        j,"),
			std::string("                        max = data.map(d3_layout_stackMaxIndex),"),
			std::string("                        sums = data.map(d3_layout_stackReduceSum),"),
			std::string("                        index = d3.range(n).sort(function(a, b) { return max[a] - max[b]; }),"),
			std::string("                        top = 0,"),
			std::string("                        bottom = 0,"),
			std::string("                        tops = [],"),
			std::string("                        bottoms = [];"),
			std::string("                for (i = 0; i < n; ++i) {"),
			std::string("                    j = d3[i];"),
			std::string("                    if (top < bottom) {"),
			std::string("                        top += sums[j];"),
			std::string("                        tops.push(j);"),
			std::string("                    } else {"),
			std::string("                        bottom += sums[j];"),
			std::string("                        bottoms.push(j);"),
			std::string("                    }"),
			std::string("                }"),
			std::string("                return bottoms.reverse().concat(tops);"),
			std::string("            },"),
			std::string(""),
			std::string("            \"reverse\": function(data) {"),
			std::string("                return d3.range(data.length).reverse();"),
			std::string("            },"),
			std::string(""),
			std::string("            \"default\": function(data) {"),
			std::string("                return d3.range(data.length);"),
			std::string("            }"),
			std::string(""),
			std::string("        };"),
			std::string(""),
			std::string("        var d3_layout_stackOffsets = {"),
			std::string(""),
			std::string("            \"silhouette\": function(data) {"),
			std::string("                var n = data.length,"),
			std::string("                        m = data[0].length,"),
			std::string("                        sums = [],"),
			std::string("                        max = 0,"),
			std::string("                        i,"),
			std::string("                        j,"),
			std::string("                        o,"),
			std::string("                        y0 = [];"),
			std::string("                for (j = 0; j < m; ++j) {"),
			std::string("                    for (i = 0, o = 0; i < n; i++) o += data[i][j][1];"),
			std::string("                    if (o > max) max = o;"),
			std::string("                    sums.push(o);"),
			std::string("                }"),
			std::string("                for (j = 0; j < m; ++j) {"),
			std::string("                    y0[j] = (max - sums[j]) / 2;"),
			std::string("                }"),
			std::string("                return y0;"),
			std::string("            },"),
			std::string(""),
			std::string("            \"wiggle\": function(data) {"),
			std::string("                var n = data.length,"),
			std::string("                        x = data[0],"),
			std::string("                        m = x.length,"),
			std::string("                        max = 0,"),
			std::string("                        i,"),
			std::string("                        j,"),
			std::string("                        k,"),
			std::string("                        s1,"),
			std::string("                        s2,"),
			std::string("                        s3,"),
			std::string("                        dx,"),
			std::string("                        o,"),
			std::string("                        o0,"),
			std::string("                        y0 = [];"),
			std::string("                y0[0] = o = o0 = 0;"),
			std::string("                for (j = 1; j < m; ++j) {"),
			std::string("                    for (i = 0, s1 = 0; i < n; ++i) s1 += data[i][j][1];"),
			std::string("                    for (i = 0, s2 = 0, dx = x[j][0] - x[j - 1][0]; i < n; ++i) {"),
			std::string("                        for (k = 0, s3 = (data[i][j][1] - data[i][j - 1][1]) / (2 * dx); k < i; ++k) {"),
			std::string("                            s3 += (data[k][j][1] - data[k][j - 1][1]) / dx;"),
			std::string("                        }"),
			std::string("                        s2 += s3 * data[i][j][1];"),
			std::string("                    }"),
			std::string("                    y0[j] = o -= s1 ? s2 / s1 * dx : 0;"),
			std::string("                    if (o < o0) o0 = o;"),
			std::string("                }"),
			std::string("                for (j = 0; j < m; ++j) y0[j] -= o0;"),
			std::string("                return y0;"),
			std::string("            },"),
			std::string(""),
			std::string("            \"expand\": function(data) {"),
			std::string("                var n = data.length,"),
			std::string("                        m = data[0].length,"),
			std::string("                        k = 1 / n,"),
			std::string("                        i,"),
			std::string("                        j,"),
			std::string("                        o,"),
			std::string("                        y0 = [];"),
			std::string("                for (j = 0; j < m; ++j) {"),
			std::string("                    for (i = 0, o = 0; i < n; i++) o += data[i][j][1];"),
			std::string("                    if (o) for (i = 0; i < n; i++) data[i][j][1] /= o;"),
			std::string("                    else for (i = 0; i < n; i++) data[i][j][1] = k;"),
			std::string("                }"),
			std::string("                for (j = 0; j < m; ++j) y0[j] = 0;"),
			std::string("                return y0;"),
			std::string("            },"),
			std::string(""),
			std::string("            \"zero\": function(data) {"),
			std::string("                var j = -1,"),
			std::string("                        m = data[0].length,"),
			std::string("                        y0 = [];"),
			std::string("                while (++j < m) y0[j] = 0;"),
			std::string("                return y0;"),
			std::string("            }"),
			std::string(""),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_layout_stackMaxIndex(array) {"),
			std::string("            var i = 1,"),
			std::string("                    j = 0,"),
			std::string("                    v = array[0][1],"),
			std::string("                    k,"),
			std::string("                    n = array.length;"),
			std::string("            for (; i < n; ++i) {"),
			std::string("                if ((k = array[i][1]) > v) {"),
			std::string("                    j = i;"),
			std::string("                    v = k;"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return j;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_stackReduceSum(d) {"),
			std::string("            return d.reduce(d3_layout_stackSum, 0);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_stackSum(p, d) {"),
			std::string("            return p + d[1];"),
			std::string("        }"),
			std::string("        d3.layout.histogram = function() {"),
			std::string("            var frequency = true,"),
			std::string("                    valuer = Number,"),
			std::string("                    ranger = d3_layout_histogramRange,"),
			std::string("                    binner = d3_layout_histogramBinSturges;"),
			std::string(""),
			std::string("            function histogram(data, i) {"),
			std::string("                var bins = [],"),
			std::string("                        values = data.map(valuer, this),"),
			std::string("                        range = ranger.call(this, values, i),"),
			std::string("                        thresholds = binner.call(this, range, values, i),"),
			std::string("                        bin,"),
			std::string("                        i = -1,"),
			std::string("                        n = values.length,"),
			std::string("                        m = thresholds.length - 1,"),
			std::string("                        k = frequency ? 1 : 1 / n,"),
			std::string("                        x;"),
			std::string(""),
			std::string("                // Initialize the bins."),
			std::string("                while (++i < m) {"),
			std::string("                    bin = bins[i] = [];"),
			std::string("                    bin.dx = thresholds[i + 1] - (bin.x = thresholds[i]);"),
			std::string("                    bin.y = 0;"),
			std::string("                }"),
			std::string(""),
			std::string("                // Fill the bins, ignoring values outside the range."),
			std::string("                i = -1; while(++i < n) {"),
			std::string("                    x = values[i];"),
			std::string("                    if ((x >= range[0]) && (x <= range[1])) {"),
			std::string("                        bin = bins[d3.bisect(thresholds, x, 1, m) - 1];"),
			std::string("                        bin.y += k;"),
			std::string("                        bin.push(data[i]);"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                return bins;"),
			std::string("            }"),
			std::string(""),
			std::string("            // Specifies how to extract a value from the associated data. The default"),
			std::string("            // value function is `Number`, which is equivalent to the identity function."),
			std::string("            histogram.value = function(x) {"),
			std::string("                if (!arguments.length) return valuer;"),
			std::string("                valuer = x;"),
			std::string("                return histogram;"),
			std::string("            };"),
			std::string(""),
			std::string("            // Specifies the range of the histogram. Values outside the specified range"),
			std::string("            // will be ignored. The argument `x` may be specified either as a two-element"),
			std::string("            // array representing the minimum and maximum value of the range, or as a"),
			std::string("            // function that returns the range given the array of values and the current"),
			std::string("            // index `i`. The default range is the extent (minimum and maximum) of the"),
			std::string("            // values."),
			std::string("            histogram.range = function(x) {"),
			std::string("                if (!arguments.length) return ranger;"),
			std::string("                ranger = d3.functor(x);"),
			std::string("                return histogram;"),
			std::string("            };"),
			std::string(""),
			std::string("            // Specifies how to bin values in the histogram. The argument `x` may be"),
			std::string("            // specified as a number, in which case the range of values will be split"),
			std::string("            // uniformly into the given number of bins. Or, `x` may be an array of"),
			std::string("            // threshold values, defining the bins; the specified array must contain the"),
			std::string("            // rightmost (upper) value, thus specifying n + 1 values for n bins. Or, `x`"),
			std::string("            // may be a function which is evaluated, being passed the range, the array of"),
			std::string("            // values, and the current index `i`, returning an array of thresholds. The"),
			std::string("            // default bin function will divide the values into uniform bins using"),
			std::string("            // Sturges' formula."),
			std::string("            histogram.bins = function(x) {"),
			std::string("                if (!arguments.length) return binner;"),
			std::string("                binner = typeof x === \"number\""),
			std::string("                        ? function(range) { return d3_layout_histogramBinFixed(range, x); }"),
			std::string("                        : d3.functor(x);"),
			std::string("                return histogram;"),
			std::string("            };"),
			std::string(""),
			std::string("            // Specifies whether the histogram's `y` value is a count (frequency) or a"),
			std::string("            // probability (density). The default value is true."),
			std::string("            histogram.frequency = function(x) {"),
			std::string("                if (!arguments.length) return frequency;"),
			std::string("                frequency = !!x;"),
			std::string("                return histogram;"),
			std::string("            };"),
			std::string(""),
			std::string("            return histogram;"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_layout_histogramBinSturges(range, values) {"),
			std::string("            return d3_layout_histogramBinFixed(range, Math.ceil(Math.log(values.length) / Math.LN2 + 1));"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_histogramBinFixed(range, n) {"),
			std::string("            var x = -1,"),
			std::string("                    b = +range[0],"),
			std::string("                    m = (range[1] - b) / n,"),
			std::string("                    f = [];"),
			std::string("            while (++x <= n) f[x] = m * x + b;"),
			std::string("            return f;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_histogramRange(values) {"),
			std::string("            return [d3.min(values), d3.max(values)];"),
			std::string("        }"),
			std::string("        d3.layout.hierarchy = function() {"),
			std::string("            var sort = d3_layout_hierarchySort,"),
			std::string("                    children = d3_layout_hierarchyChildren,"),
			std::string("                    value = d3_layout_hierarchyValue;"),
			std::string(""),
			std::string("            // Recursively compute the node depth and value."),
			std::string("            // Also converts the data representation into a standard hierarchy structure."),
			std::string("            function recurse(data, depth, nodes) {"),
			std::string("                var childs = children.call(hierarchy, data, depth),"),
			std::string("                        node = d3_layout_hierarchyInline ? data : {data: data};"),
			std::string("                node.depth = depth;"),
			std::string("                nodes.push(node);"),
			std::string("                if (childs && (n = childs.length)) {"),
			std::string("                    var i = -1,"),
			std::string("                            n,"),
			std::string("                            c = node.children = [],"),
			std::string("                            v = 0,"),
			std::string("                            j = depth + 1;"),
			std::string("                    while (++i < n) {"),
			std::string("                        d = recurse(childs[i], j, nodes);"),
			std::string("                        d.parent = node;"),
			std::string("                        c.push(d);"),
			std::string("                        v += d.value;"),
			std::string("                    }"),
			std::string("                    if (sort) c.sort(sort);"),
			std::string("                    if (value) node.value = v;"),
			std::string("                } else if (value) {"),
			std::string("                    node.value = +value.call(hierarchy, data, depth) || 0;"),
			std::string("                }"),
			std::string("                return node;"),
			std::string("            }"),
			std::string(""),
			std::string("            // Recursively re-evaluates the node value."),
			std::string("            function revalue(node, depth) {"),
			std::string("                var children = node.children,"),
			std::string("                        v = 0;"),
			std::string("                if (children && (n = children.length)) {"),
			std::string("                    var i = -1,"),
			std::string("                            n,"),
			std::string("                            j = depth + 1;"),
			std::string("                    while (++i < n) v += revalue(children[i], j);"),
			std::string("                } else if (value) {"),
			std::string("                    v = +value.call(hierarchy, d3_layout_hierarchyInline ? node : node.data, depth) || 0;"),
			std::string("                }"),
			std::string("                if (value) node.value = v;"),
			std::string("                return v;"),
			std::string("            }"),
			std::string(""),
			std::string("            function hierarchy(d) {"),
			std::string("                var nodes = [];"),
			std::string("                recurse(d, 0, nodes);"),
			std::string("                return nodes;"),
			std::string("            }"),
			std::string(""),
			std::string("            hierarchy.sort = function(x) {"),
			std::string("                if (!arguments.length) return sort;"),
			std::string("                sort = x;"),
			std::string("                return hierarchy;"),
			std::string("            };"),
			std::string(""),
			std::string("            hierarchy.children = function(x) {"),
			std::string("                if (!arguments.length) return children;"),
			std::string("                children = x;"),
			std::string("                return hierarchy;"),
			std::string("            };"),
			std::string(""),
			std::string("            hierarchy.value = function(x) {"),
			std::string("                if (!arguments.length) return value;"),
			std::string("                value = x;"),
			std::string("                return hierarchy;"),
			std::string("            };"),
			std::string(""),
			std::string("            // Re-evaluates the `value` property for the specified hierarchy."),
			std::string("            hierarchy.revalue = function(root) {"),
			std::string("                revalue(root, 0);"),
			std::string("                return root;"),
			std::string("            };"),
			std::string(""),
			std::string("            return hierarchy;"),
			std::string("        };"),
			std::string(""),
			std::string("// A method assignment helper for hierarchy subclasses."),
			std::string("        function d3_layout_hierarchyRebind(object, hierarchy) {"),
			std::string("            object.sort = d3.rebind(object, hierarchy.sort);"),
			std::string("            object.children = d3.rebind(object, hierarchy.children);"),
			std::string("            object.links = d3_layout_hierarchyLinks;"),
			std::string("            object.value = d3.rebind(object, hierarchy.value);"),
			std::string(""),
			std::string("            // If the new API is used, enabling inlining."),
			std::string("            object.nodes = function(d) {"),
			std::string("                d3_layout_hierarchyInline = true;"),
			std::string("                return (object.nodes = object)(d);"),
			std::string("            };"),
			std::string(""),
			std::string("            return object;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_hierarchyChildren(d) {"),
			std::string("            return d.children;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_hierarchyValue(d) {"),
			std::string("            return d.value;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_hierarchySort(a, b) {"),
			std::string("            return b.value - a.value;"),
			std::string("        }"),
			std::string(""),
			std::string("// Returns an array source+target objects for the specified nodes."),
			std::string("        function d3_layout_hierarchyLinks(nodes) {"),
			std::string("            return d3.merge(nodes.map(function(parent) {"),
			std::string("                return (parent.children || []).map(function(child) {"),
			std::string("                    return {source: parent, target: child};"),
			std::string("                });"),
			std::string("            }));"),
			std::string("        }"),
			std::string(""),
			std::string("// For backwards-compatibility, don't enable inlining by default."),
			std::string("        var d3_layout_hierarchyInline = false;"),
			std::string("        d3.layout.pack = function() {"),
			std::string("            var hierarchy = d3.layout.hierarchy().sort(d3_layout_packSort),"),
			std::string("                    size = [1, 1];"),
			std::string(""),
			std::string("            function pack(d, i) {"),
			std::string("                var nodes = hierarchy.call(this, d, i),"),
			std::string("                        root = nodes[0];"),
			std::string(""),
			std::string("                // Recursively compute the layout."),
			std::string("                root.x = 0;"),
			std::string("                root.y = 0;"),
			std::string("                d3_layout_packTree(root);"),
			std::string(""),
			std::string("                // Scale the layout to fit the requested size."),
			std::string("                var w = size[0],"),
			std::string("                        h = size[1],"),
			std::string("                        k = 1 / Math.max(2 * root.r / w, 2 * root.r / h);"),
			std::string("                d3_layout_packTransform(root, w / 2, h / 2, k);"),
			std::string(""),
			std::string("                return nodes;"),
			std::string("            }"),
			std::string(""),
			std::string("            pack.size = function(x) {"),
			std::string("                if (!arguments.length) return size;"),
			std::string("                size = x;"),
			std::string("                return pack;"),
			std::string("            };"),
			std::string(""),
			std::string("            return d3_layout_hierarchyRebind(pack, hierarchy);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_layout_packSort(a, b) {"),
			std::string("            return a.value - b.value;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_packInsert(a, b) {"),
			std::string("            var c = a._pack_next;"),
			std::string("            a._pack_next = b;"),
			std::string("            b._pack_prev = a;"),
			std::string("            b._pack_next = c;"),
			std::string("            c._pack_prev = b;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_packSplice(a, b) {"),
			std::string("            a._pack_next = b;"),
			std::string("            b._pack_prev = a;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_packIntersects(a, b) {"),
			std::string("            var dx = b.x - a.x,"),
			std::string("                    dy = b.y - a.y,"),
			std::string("                    dr = a.r + b.r;"),
			std::string("            return (dr * dr - dx * dx - dy * dy) > .001; // within epsilon"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_packCircle(nodes) {"),
			std::string("            var xMin = Infinity,"),
			std::string("                    xMax = -Infinity,"),
			std::string("                    yMin = Infinity,"),
			std::string("                    yMax = -Infinity,"),
			std::string("                    n = nodes.length,"),
			std::string("                    a, b, c, j, k;"),
			std::string(""),
			std::string("            function bound(node) {"),
			std::string("                xMin = Math.min(node.x - node.r, xMin);"),
			std::string("                xMax = Math.max(node.x + node.r, xMax);"),
			std::string("                yMin = Math.min(node.y - node.r, yMin);"),
			std::string("                yMax = Math.max(node.y + node.r, yMax);"),
			std::string("            }"),
			std::string(""),
			std::string("            // Create node links."),
			std::string("            nodes.forEach(d3_layout_packLink);"),
			std::string(""),
			std::string("            // Create first node."),
			std::string("            a = nodes[0];"),
			std::string("            a.x = -a.r;"),
			std::string("            a.y = 0;"),
			std::string("            bound(a);"),
			std::string(""),
			std::string("            // Create second node."),
			std::string("            if (n > 1) {"),
			std::string("                b = nodes[1];"),
			std::string("                b.x = b.r;"),
			std::string("                b.y = 0;"),
			std::string("                bound(b);"),
			std::string(""),
			std::string("                // Create third node and build chain."),
			std::string("                if (n > 2) {"),
			std::string("                    c = nodes[2];"),
			std::string("                    d3_layout_packPlace(a, b, c);"),
			std::string("                    bound(c);"),
			std::string("                    d3_layout_packInsert(a, c);"),
			std::string("                    a._pack_prev = c;"),
			std::string("                    d3_layout_packInsert(c, b);"),
			std::string("                    b = a._pack_next;"),
			std::string(""),
			std::string("                    // Now iterate through the rest."),
			std::string("                    for (var i = 3; i < n; i++) {"),
			std::string("                        d3_layout_packPlace(a, b, c = nodes[i]);"),
			std::string(""),
			std::string("                        // Search for the closest intersection."),
			std::string("                        var isect = 0, s1 = 1, s2 = 1;"),
			std::string("                        for (j = b._pack_next; j !== b; j = j._pack_next, s1++) {"),
			std::string("                            if (d3_layout_packIntersects(j, c)) {"),
			std::string("                                isect = 1;"),
			std::string("                                break;"),
			std::string("                            }"),
			std::string("                        }"),
			std::string("                        if (isect == 1) {"),
			std::string("                            for (k = a._pack_prev; k !== j._pack_prev; k = k._pack_prev, s2++) {"),
			std::string("                                if (d3_layout_packIntersects(k, c)) {"),
			std::string("                                    if (s2 < s1) {"),
			std::string("                                        isect = -1;"),
			std::string("                                        j = k;"),
			std::string("                                    }"),
			std::string("                                    break;"),
			std::string("                                }"),
			std::string("                            }"),
			std::string("                        }"),
			std::string(""),
			std::string("                        // Update node chain."),
			std::string("                        if (isect == 0) {"),
			std::string("                            d3_layout_packInsert(a, c);"),
			std::string("                            b = c;"),
			std::string("                            bound(c);"),
			std::string("                        } else if (isect > 0) {"),
			std::string("                            d3_layout_packSplice(a, j);"),
			std::string("                            b = j;"),
			std::string("                            i--;"),
			std::string("                        } else { // isect < 0"),
			std::string("                            d3_layout_packSplice(j, b);"),
			std::string("                            a = j;"),
			std::string("                            i--;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            // Re-center the circles and return the encompassing radius."),
			std::string("            var cx = (xMin + xMax) / 2,"),
			std::string("                    cy = (yMin + yMax) / 2,"),
			std::string("                    cr = 0;"),
			std::string("            for (var i = 0; i < n; i++) {"),
			std::string("                var node = nodes[i];"),
			std::string("                node.x -= cx;"),
			std::string("                node.y -= cy;"),
			std::string("                cr = Math.max(cr, node.r + Math.sqrt(node.x * node.x + node.y * node.y));"),
			std::string("            }"),
			std::string(""),
			std::string("            // Remove node links."),
			std::string("            nodes.forEach(d3_layout_packUnlink);"),
			std::string(""),
			std::string("            return cr;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_packLink(node) {"),
			std::string("            node._pack_next = node._pack_prev = node;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_packUnlink(node) {"),
			std::string("            delete node._pack_next;"),
			std::string("            delete node._pack_prev;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_packTree(node) {"),
			std::string("            var children = node.children;"),
			std::string("            if (children && children.length) {"),
			std::string("                children.forEach(d3_layout_packTree);"),
			std::string("                node.r = d3_layout_packCircle(children);"),
			std::string("            } else {"),
			std::string("                node.r = Math.sqrt(node.value);"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
		};

		const std::string d3TemplateBlockNo6[] = 
		{
			std::string("        function d3_layout_packTransform(node, x, y, k) {"),
			std::string("            var children = node.children;"),
			std::string("            node.x = (x += k * node.x);"),
			std::string("            node.y = (y += k * node.y);"),
			std::string("            node.r *= k;"),
			std::string("            if (children) {"),
			std::string("                var i = -1, n = children.length;"),
			std::string("                while (++i < n) d3_layout_packTransform(children[i], x, y, k);"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_packPlace(a, b, c) {"),
			std::string("            var db = a.r + c.r,"),
			std::string("                    dx = b.x - a.x,"),
			std::string("                    dy = b.y - a.y;"),
			std::string("            if (db && (dx || dy)) {"),
			std::string("                var da = b.r + c.r,"),
			std::string("                        dc = Math.sqrt(dx * dx + dy * dy),"),
			std::string("                        cos = Math.max(-1, Math.min(1, (db * db + dc * dc - da * da) / (2 * db * dc))),"),
			std::string("                        theta = Math.acos(cos),"),
			std::string("                        x = cos * (db /= dc),"),
			std::string("                        y = Math.sin(theta) * db;"),
			std::string("                c.x = a.x + x * dx + y * dy;"),
			std::string("                c.y = a.y + x * dy - y * dx;"),
			std::string("            } else {"),
			std::string("                c.x = a.x + db;"),
			std::string("                c.y = a.y;"),
			std::string("            }"),
			std::string("        }"),
			std::string("// Implements a hierarchical layout using the cluster (or dendogram) algorithm."),
			std::string("        d3.layout.cluster = function() {"),
			std::string("            var hierarchy = d3.layout.hierarchy().sort(null).value(null),"),
			std::string("                    separation = d3_layout_treeSeparation,"),
			std::string("                    size = [1, 1]; // width, height"),
			std::string(""),
			std::string("            function cluster(d, i) {"),
			std::string("                var nodes = hierarchy.call(this, d, i),"),
			std::string("                        root = nodes[0],"),
			std::string("                        previousNode,"),
			std::string("                        x = 0,"),
			std::string("                        kx,"),
			std::string("                        ky;"),
			std::string(""),
			std::string("                // First walk, computing the initial x & y values."),
			std::string("                d3_layout_treeVisitAfter(root, function(node) {"),
			std::string("                    var children = node.children;"),
			std::string("                    if (children && children.length) {"),
			std::string("                        node.x = d3_layout_clusterX(children);"),
			std::string("                        node.y = d3_layout_clusterY(children);"),
			std::string("                    } else {"),
			std::string("                        node.x = previousNode ? x += separation(node, previousNode) : 0;"),
			std::string("                        node.y = 0;"),
			std::string("                        previousNode = node;"),
			std::string("                    }"),
			std::string("                });"),
			std::string(""),
			std::string("                // Compute the left-most, right-most, and depth-most nodes for extents."),
			std::string("                var left = d3_layout_clusterLeft(root),"),
			std::string("                        right = d3_layout_clusterRight(root),"),
			std::string("                        x0 = left.x - separation(left, right) / 2,"),
			std::string("                        x1 = right.x + separation(right, left) / 2;"),
			std::string(""),
			std::string("                // Second walk, normalizing x & y to the desired size."),
			std::string("                d3_layout_treeVisitAfter(root, function(node) {"),
			std::string("                    node.x = (node.x - x0) / (x1 - x0) * size[0];"),
			std::string("                    node.y = (1 - node.y / root.y) * size[1];"),
			std::string("                });"),
			std::string(""),
			std::string("                return nodes;"),
			std::string("            }"),
			std::string(""),
			std::string("            cluster.separation = function(x) {"),
			std::string("                if (!arguments.length) return separation;"),
			std::string("                separation = x;"),
			std::string("                return cluster;"),
			std::string("            };"),
			std::string(""),
			std::string("            cluster.size = function(x) {"),
			std::string("                if (!arguments.length) return size;"),
			std::string("                size = x;"),
			std::string("                return cluster;"),
			std::string("            };"),
			std::string(""),
			std::string("            return d3_layout_hierarchyRebind(cluster, hierarchy);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_layout_clusterY(children) {"),
			std::string("            return 1 + d3.max(children, function(child) {"),
			std::string("                return child.y;"),
			std::string("            });"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_clusterX(children) {"),
			std::string("            return children.reduce(function(x, child) {"),
			std::string("                return x + child.x;"),
			std::string("            }, 0) / children.length;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_clusterLeft(node) {"),
			std::string("            var children = node.children;"),
			std::string("            return children && children.length ? d3_layout_clusterLeft(children[0]) : node;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_clusterRight(node) {"),
			std::string("            var children = node.children, n;"),
			std::string("            return children && (n = children.length) ? d3_layout_clusterRight(children[n - 1]) : node;"),
			std::string("        }"),
			std::string("// Node-link tree diagram using the Reingold-Tilford \"tidy\" algorithm"),
			std::string("        d3.layout.tree = function() {"),
			std::string("            var hierarchy = d3.layout.hierarchy().sort(null).value(null),"),
			std::string("                    separation = d3_layout_treeSeparation,"),
			std::string("                    size = [1, 1]; // width, height"),
			std::string(""),
			std::string("            function tree(d, i) {"),
			std::string("                var nodes = hierarchy.call(this, d, i),"),
			std::string("                        root = nodes[0];"),
			std::string(""),
			std::string("                function firstWalk(node, previousSibling) {"),
			std::string("                    var children = node.children,"),
			std::string("                            layout = node._tree;"),
			std::string("                    if (children && (n = children.length)) {"),
			std::string("                        var n,"),
			std::string("                                firstChild = children[0],"),
			std::string("                                previousChild,"),
			std::string("                                ancestor = firstChild,"),
			std::string("                                child,"),
			std::string("                                i = -1;"),
			std::string("                        while (++i < n) {"),
			std::string("                            child = children[i];"),
			std::string("                            firstWalk(child, previousChild);"),
			std::string("                            ancestor = apportion(child, previousChild, ancestor);"),
			std::string("                            previousChild = child;"),
			std::string("                        }"),
			std::string("                        d3_layout_treeShift(node);"),
			std::string("                        var midpoint = .5 * (firstChild._tree.prelim + child._tree.prelim);"),
			std::string("                        if (previousSibling) {"),
			std::string("                            layout.prelim = previousSibling._tree.prelim + separation(node, previousSibling);"),
			std::string("                            layout.mod = layout.prelim - midpoint;"),
			std::string("                        } else {"),
			std::string("                            layout.prelim = midpoint;"),
			std::string("                        }"),
			std::string("                    } else {"),
			std::string("                        if (previousSibling) {"),
			std::string("                            layout.prelim = previousSibling._tree.prelim + separation(node, previousSibling);"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                function secondWalk(node, x) {"),
			std::string("                    node.x = node._tree.prelim + x;"),
			std::string("                    var children = node.children;"),
			std::string("                    if (children && (n = children.length)) {"),
			std::string("                        var i = -1,"),
			std::string("                                n;"),
			std::string("                        x += node._tree.mod;"),
			std::string("                        while (++i < n) {"),
			std::string("                            secondWalk(children[i], x);"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                }"),
			std::string(""),
			std::string("                function apportion(node, previousSibling, ancestor) {"),
			std::string("                    if (previousSibling) {"),
			std::string("                        var vip = node,"),
			std::string("                                vop = node,"),
			std::string("                                vim = previousSibling,"),
			std::string("                                vom = node.parent.children[0],"),
			std::string("                                sip = vip._tree.mod,"),
			std::string("                                sop = vop._tree.mod,"),
			std::string("                                sim = vim._tree.mod,"),
			std::string("                                som = vom._tree.mod,"),
			std::string("                                shift;"),
			std::string("                        while (vim = d3_layout_treeRight(vim), vip = d3_layout_treeLeft(vip), vim && vip) {"),
			std::string("                            vom = d3_layout_treeLeft(vom);"),
			std::string("                            vop = d3_layout_treeRight(vop);"),
			std::string("                            vop._tree.ancestor = node;"),
			std::string("                            shift = vim._tree.prelim + sim - vip._tree.prelim - sip + separation(vim, vip);"),
			std::string("                            if (shift > 0) {"),
			std::string("                                d3_layout_treeMove(d3_layout_treeAncestor(vim, node, ancestor), node, shift);"),
			std::string("                                sip += shift;"),
			std::string("                                sop += shift;"),
			std::string("                            }"),
			std::string("                            sim += vim._tree.mod;"),
			std::string("                            sip += vip._tree.mod;"),
			std::string("                            som += vom._tree.mod;"),
			std::string("                            sop += vop._tree.mod;"),
			std::string("                        }"),
			std::string("                        if (vim && !d3_layout_treeRight(vop)) {"),
			std::string("                            vop._tree.thread = vim;"),
			std::string("                            vop._tree.mod += sim - sop;"),
			std::string("                        }"),
			std::string("                        if (vip && !d3_layout_treeLeft(vom)) {"),
			std::string("                            vom._tree.thread = vip;"),
			std::string("                            vom._tree.mod += sip - som;"),
			std::string("                            ancestor = node;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                    return ancestor;"),
			std::string("                }"),
			std::string(""),
			std::string("                // Initialize temporary layout variables."),
			std::string("                d3_layout_treeVisitAfter(root, function(node, previousSibling) {"),
			std::string("                    node._tree = {"),
			std::string("                        ancestor: node,"),
			std::string("                        prelim: 0,"),
			std::string("                        mod: 0,"),
			std::string("                        change: 0,"),
			std::string("                        shift: 0,"),
			std::string("                        number: previousSibling ? previousSibling._tree.number + 1 : 0"),
			std::string("                    };"),
			std::string("                });"),
			std::string(""),
			std::string("                // Compute the layout using Buchheim et al.'s algorithm."),
			std::string("                firstWalk(root);"),
			std::string("                secondWalk(root, -root._tree.prelim);"),
			std::string(""),
			std::string("                // Compute the left-most, right-most, and depth-most nodes for extents."),
			std::string("                var left = d3_layout_treeSearch(root, d3_layout_treeLeftmost),"),
			std::string("                        right = d3_layout_treeSearch(root, d3_layout_treeRightmost),"),
			std::string("                        deep = d3_layout_treeSearch(root, d3_layout_treeDeepest),"),
			std::string("                        x0 = left.x - separation(left, right) / 2,"),
			std::string("                        x1 = right.x + separation(right, left) / 2,"),
			std::string("                        y1 = deep.depth || 1;"),
			std::string(""),
			std::string("                // Clear temporary layout variables; transform x and y."),
			std::string("                d3_layout_treeVisitAfter(root, function(node) {"),
			std::string("                    node.x = (node.x - x0) / (x1 - x0) * size[0];"),
			std::string("                    node.y = node.depth / y1 * size[1];"),
			std::string("                    delete node._tree;"),
			std::string("                });"),
			std::string(""),
			std::string("                return nodes;"),
			std::string("            }"),
			std::string(""),
			std::string("            tree.separation = function(x) {"),
			std::string("                if (!arguments.length) return separation;"),
			std::string("                separation = x;"),
			std::string("                return tree;"),
			std::string("            };"),
			std::string(""),
			std::string("            tree.size = function(x) {"),
			std::string("                if (!arguments.length) return size;"),
			std::string("                size = x;"),
			std::string("                return tree;"),
			std::string("            };"),
			std::string(""),
			std::string("            return d3_layout_hierarchyRebind(tree, hierarchy);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_layout_treeSeparation(a, b) {"),
			std::string("            return a.parent == b.parent ? 1 : 2;"),
			std::string("        }"),
			std::string(""),
			std::string("// function d3_layout_treeSeparationRadial(a, b) {"),
			std::string("//   return (a.parent == b.parent ? 1 : 2) / a.depth;"),
			std::string("// }"),
			std::string(""),
			std::string("        function d3_layout_treeLeft(node) {"),
			std::string("            var children = node.children;"),
			std::string("            return children && children.length ? children[0] : node._tree.thread;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeRight(node) {"),
			std::string("            var children = node.children,"),
			std::string("                    n;"),
			std::string("            return children && (n = children.length) ? children[n - 1] : node._tree.thread;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeSearch(node, compare) {"),
			std::string("            var children = node.children;"),
			std::string("            if (children && (n = children.length)) {"),
			std::string("                var child,"),
			std::string("                        n,"),
			std::string("                        i = -1;"),
			std::string("                while (++i < n) {"),
			std::string("                    if (compare(child = d3_layout_treeSearch(children[i], compare), node) > 0) {"),
			std::string("                        node = child;"),
			std::string("                    }"),
			std::string("                }"),
			std::string("            }"),
			std::string("            return node;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeRightmost(a, b) {"),
			std::string("            return a.x - b.x;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeLeftmost(a, b) {"),
			std::string("            return b.x - a.x;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeDeepest(a, b) {"),
			std::string("            return a.depth - b.depth;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeVisitAfter(node, callback) {"),
			std::string("            function visit(node, previousSibling) {"),
			std::string("                var children = node.children;"),
			std::string("                if (children && (n = children.length)) {"),
			std::string("                    var child,"),
			std::string("                            previousChild = null,"),
			std::string("                            i = -1,"),
			std::string("                            n;"),
			std::string("                    while (++i < n) {"),
			std::string("                        child = children[i];"),
			std::string("                        visit(child, previousChild);"),
			std::string("                        previousChild = child;"),
			std::string("                    }"),
			std::string("                }"),
			std::string("                callback(node, previousSibling);"),
			std::string("            }"),
			std::string("            visit(node, null);"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeShift(node) {"),
			std::string("            var shift = 0,"),
			std::string("                    change = 0,"),
			std::string("                    children = node.children,"),
			std::string("                    i = children.length,"),
			std::string("                    child;"),
			std::string("            while (--i >= 0) {"),
			std::string("                child = children[i]._tree;"),
			std::string("                child.prelim += shift;"),
			std::string("                child.mod += shift;"),
			std::string("                shift += child.shift + (change += child.change);"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeMove(ancestor, node, shift) {"),
			std::string("            ancestor = ancestor._tree;"),
			std::string("            node = node._tree;"),
			std::string("            var change = shift / (node.number - ancestor.number);"),
			std::string("            ancestor.change += change;"),
			std::string("            node.change -= change;"),
			std::string("            node.shift += shift;"),
			std::string("            node.prelim += shift;"),
			std::string("            node.mod += shift;"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treeAncestor(vim, node, ancestor) {"),
			std::string("            return vim._tree.ancestor.parent == node.parent"),
			std::string("                    ? vim._tree.ancestor"),
			std::string("                    : ancestor;"),
			std::string("        }"),
			std::string("// Squarified Treemaps by Mark Bruls, Kees Huizing, and Jarke J. van Wijk"),
			std::string("// Modified to support a target aspect ratio by Jeff Heer"),
			std::string("        d3.layout.treemap = function() {"),
			std::string("            var hierarchy = d3.layout.hierarchy(),"),
			std::string("                    round = Math.round,"),
			std::string("                    size = [1, 1], // width, height"),
			std::string("                    padding = null,"),
			std::string("                    pad = d3_layout_treemapPadNull,"),
			std::string("                    sticky = false,"),
			std::string("                    stickies,"),
			std::string("                    ratio = 0.5 * (1 + Math.sqrt(5)); // golden ratio"),
			std::string(""),
			std::string("            // Compute the area for each child based on value & scale."),
			std::string("            function scale(children, k) {"),
			std::string("                var i = -1,"),
			std::string("                        n = children.length,"),
			std::string("                        child,"),
			std::string("                        area;"),
			std::string("                while (++i < n) {"),
			std::string("                    area = (child = children[i]).value * (k < 0 ? 0 : k);"),
			std::string("                    child.area = isNaN(area) || area <= 0 ? 0 : area;"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            // Recursively arranges the specified node's children into squarified rows."),
			std::string("            function squarify(node) {"),
			std::string("                var children = node.children;"),
			std::string("                if (children && children.length) {"),
			std::string("                    var rect = pad(node),"),
			std::string("                            row = [],"),
			std::string("                            remaining = children.slice(), // copy-on-write"),
			std::string("                            child,"),
			std::string("                            best = Infinity, // the best row score so far"),
			std::string("                            score, // the current row score"),
			std::string("                            u = Math.min(rect.dx, rect.dy), // initial orientation"),
			std::string("                            n;"),
			std::string("                    scale(remaining, rect.dx * rect.dy / node.value);"),
			std::string("                    row.area = 0;"),
			std::string("                    while ((n = remaining.length) > 0) {"),
			std::string("                        row.push(child = remaining[n - 1]);"),
			std::string("                        row.area += child.area;"),
			std::string("                        if ((score = worst(row, u)) <= best) { // continue with this orientation"),
			std::string("                            remaining.pop();"),
			std::string("                            best = score;"),
			std::string("                        } else { // abort, and try a different orientation"),
			std::string("                            row.area -= row.pop().area;"),
			std::string("                            position(row, u, rect, false);"),
			std::string("                            u = Math.min(rect.dx, rect.dy);"),
			std::string("                            row.length = row.area = 0;"),
			std::string("                            best = Infinity;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                    if (row.length) {"),
			std::string("                        position(row, u, rect, true);"),
			std::string("                        row.length = row.area = 0;"),
			std::string("                    }"),
			std::string("                    children.forEach(squarify);"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            // Recursively resizes the specified node's children into existing rows."),
			std::string("            // Preserves the existing layout!"),
			std::string("            function stickify(node) {"),
			std::string("                var children = node.children;"),
			std::string("                if (children && children.length) {"),
			std::string("                    var rect = pad(node),"),
			std::string("                            remaining = children.slice(), // copy-on-write"),
			std::string("                            child,"),
			std::string("                            row = [];"),
			std::string("                    scale(remaining, rect.dx * rect.dy / node.value);"),
			std::string("                    row.area = 0;"),
			std::string("                    while (child = remaining.pop()) {"),
			std::string("                        row.push(child);"),
			std::string("                        row.area += child.area;"),
			std::string("                        if (child.z != null) {"),
			std::string("                            position(row, child.z ? rect.dx : rect.dy, rect, !remaining.length);"),
			std::string("                            row.length = row.area = 0;"),
			std::string("                        }"),
			std::string("                    }"),
			std::string("                    children.forEach(stickify);"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            // Computes the score for the specified row, as the worst aspect ratio."),
			std::string("            function worst(row, u) {"),
			std::string("                var s = row.area,"),
			std::string("                        r,"),
			std::string("                        rmax = 0,"),
			std::string("                        rmin = Infinity,"),
			std::string("                        i = -1,"),
			std::string("                        n = row.length;"),
			std::string("                while (++i < n) {"),
			std::string("                    if (!(r = row[i].area)) continue;"),
			std::string("                    if (r < rmin) rmin = r;"),
			std::string("                    if (r > rmax) rmax = r;"),
			std::string("                }"),
			std::string("                s *= s;"),
			std::string("                u *= u;"),
			std::string("                return s"),
			std::string("                        ? Math.max((u * rmax * ratio) / s, s / (u * rmin * ratio))"),
			std::string("                        : Infinity;"),
			std::string("            }"),
			std::string(""),
			std::string("            // Positions the specified row of nodes. Modifies `rect`."),
			std::string("            function position(row, u, rect, flush) {"),
			std::string("                var i = -1,"),
			std::string("                        n = row.length,"),
			std::string("                        x = rect.x,"),
			std::string("                        y = rect.y,"),
			std::string("                        v = u ? round(row.area / u) : 0,"),
			std::string("                        o;"),
			std::string("                if (u == rect.dx) { // horizontal subdivision"),
			std::string("                    if (flush || v > rect.dy) v = v ? rect.dy : 0; // over+underflow"),
			std::string("                    while (++i < n) {"),
			std::string("                        o = row[i];"),
			std::string("                        o.x = x;"),
			std::string("                        o.y = y;"),
			std::string("                        o.dy = v;"),
			std::string("                        x += o.dx = v ? round(o.area / v) : 0;"),
			std::string("                    }"),
			std::string("                    o.z = true;"),
			std::string("                    o.dx += rect.x + rect.dx - x; // rounding error"),
			std::string("                    rect.y += v;"),
			std::string("                    rect.dy -= v;"),
			std::string("                } else { // vertical subdivision"),
			std::string("                    if (flush || v > rect.dx) v = v ? rect.dx : 0; // over+underflow"),
			std::string("                    while (++i < n) {"),
			std::string("                        o = row[i];"),
			std::string("                        o.x = x;"),
			std::string("                        o.y = y;"),
			std::string("                        o.dx = v;"),
			std::string("                        y += o.dy = v ? round(o.area / v) : 0;"),
			std::string("                    }"),
			std::string("                    o.z = false;"),
			std::string("                    o.dy += rect.y + rect.dy - y; // rounding error"),
			std::string("                    rect.x += v;"),
			std::string("                    rect.dx -= v;"),
			std::string("                }"),
			std::string("            }"),
			std::string(""),
			std::string("            function treemap(d) {"),
			std::string("                var nodes = stickies || hierarchy(d),"),
			std::string("                        root = nodes[0];"),
			std::string("                root.x = 0;"),
			std::string("                root.y = 0;"),
			std::string("                root.dx = size[0];"),
			std::string("                root.dy = size[1];"),
			std::string("                if (stickies) hierarchy.revalue(root);"),
			std::string("                scale([root], root.dx * root.dy / root.value);"),
			std::string("                (stickies ? stickify : squarify)(root);"),
			std::string("                if (sticky) stickies = nodes;"),
			std::string("                return nodes;"),
			std::string("            }"),
			std::string(""),
			std::string("            treemap.size = function(x) {"),
			std::string("                if (!arguments.length) return size;"),
			std::string("                size = x;"),
			std::string("                return treemap;"),
			std::string("            };"),
			std::string(""),
			std::string("            treemap.padding = function(x) {"),
			std::string("                if (!arguments.length) return padding;"),
			std::string(""),
			std::string("                function padFunction(node) {"),
			std::string("                    var p = x.call(treemap, node, node.depth);"),
			std::string("                    return p == null"),
			std::string("                            ? d3_layout_treemapPadNull(node)"),
			std::string("                            : d3_layout_treemapPad(node, typeof p === \"number\" ? [p, p, p, p] : p);"),
			std::string("                }"),
			std::string(""),
			std::string("                function padConstant(node) {"),
			std::string("                    return d3_layout_treemapPad(node, x);"),
			std::string("                }"),
			std::string(""),
			std::string("                var type;"),
			std::string("                pad = (padding = x) == null ? d3_layout_treemapPadNull"),
			std::string("                        : (type = typeof x) === \"function\" ? padFunction"),
			std::string("                        : type === \"number\" ? (x = [x, x, x, x], padConstant)"),
			std::string("                        : padConstant;"),
			std::string("                return treemap;"),
			std::string("            };"),
			std::string(""),
			std::string("            treemap.round = function(x) {"),
			std::string("                if (!arguments.length) return round != Number;"),
			std::string("                round = x ? Math.round : Number;"),
			std::string("                return treemap;"),
			std::string("            };"),
			std::string(""),
			std::string("            treemap.sticky = function(x) {"),
			std::string("                if (!arguments.length) return sticky;"),
			std::string("                sticky = x;"),
			std::string("                stickies = null;"),
			std::string("                return treemap;"),
			std::string("            };"),
			std::string(""),
			std::string("            treemap.ratio = function(x) {"),
			std::string("                if (!arguments.length) return ratio;"),
			std::string("                ratio = x;"),
			std::string("                return treemap;"),
			std::string("            };"),
			std::string(""),
			std::string("            return d3_layout_hierarchyRebind(treemap, hierarchy);"),
			std::string("        };"),
			std::string(""),
			std::string("        function d3_layout_treemapPadNull(node) {"),
			std::string("            return {x: node.x, y: node.y, dx: node.dx, dy: node.dy};"),
			std::string("        }"),
			std::string(""),
			std::string("        function d3_layout_treemapPad(node, padding) {"),
			std::string("            var x = node.x + padding[3],"),
			std::string("                    y = node.y + padding[0],"),
			std::string("                    dx = node.dx - padding[1] - padding[3],"),
			std::string("                    dy = node.dy - padding[0] - padding[2];"),
			std::string("            if (dx < 0) { x += dx / 2; dx = 0; }"),
			std::string("            if (dy < 0) { y += dy / 2; dy = 0; }"),
			std::string("            return {x: x, y: y, dx: dx, dy: dy};"),
			std::string("        }"),
			std::string("    })();"),
			std::string("    </script>"),
			std::string("    <script type=\"text/javascript\">"),
			std::string("        (function() {"),
			std::string("            packages = {"),
			std::string(""),
			std::string("                // Lazily construct the package hierarchy from class names."),
			std::string("                root: function(classes) {"),
			std::string("                    var map = {};"),
			std::string(""),
			std::string("                    function find(name, data) {"),
			std::string("                        var node = map[name], i;"),
			std::string("                        if (!node) {"),
			std::string("                            node = map[name] = data || {name: name, children: []};"),
			std::string("                            if (name.length) {"),
			std::string("                                node.parent = find(name.substring(0, i = name.lastIndexOf(\".\")));"),
			std::string("                                node.parent.children.push(node);"),
			std::string("                                node.key = name.substring(i + 1);"),
			std::string("                            }"),
			std::string("                        }"),
			std::string("                        return node;"),
			std::string("                    }"),
			std::string(""),
			std::string("                    classes.forEach(function(d) {"),
			std::string("                        find(d.name, d);"),
			std::string("                    });"),
			std::string(""),
			std::string("                    return map[\"\"];"),
			std::string("                },"),
			std::string(""),
			std::string("                // Return a list of imports for the given array of nodes."),
			std::string("                imports: function(nodes) {"),
			std::string("                    var map = {},"),
			std::string("                            imports = [];"),
			std::string(""),
			std::string("                    // Compute a map from name to node."),
			std::string("                    nodes.forEach(function(d) {"),
			std::string("                        map[d.name] = d;"),
			std::string("                    });"),
			std::string(""),
			std::string("                    // For each import, construct a link from the source to target node."),
			std::string("                    nodes.forEach(function(d) {"),
			std::string("                        if (d.imports) d.imports.forEach(function(i) {"),
			std::string("                            imports.push({source: map[d.name], target: map[i]});"),
			std::string("                        });"),
			std::string("                    });"),
			std::string(""),
			std::string("                    return imports;"),
			std::string("                }"),
			std::string(""),
			std::string("            };"),
			std::string("        })();"),
			std::string("    </script>"),
			std::string("    <script type=\"text/javascript\">"),
			std::string("//SIBELIA_MARK_INSERT"),
			std::string("    </script>"),
			std::string("    <script type=\"text/javascript\">"),
			std::string(""),
			std::string("        String.prototype.replaceAll = function(search, replace){"),
			std::string("            return this.split(search).join(replace);"),
			std::string("        };"),
			std::string(""),
			std::string("        var w = 1280,"),
			std::string("                h = 800,"),
			std::string("                rx = w / 2,"),
			std::string("                ry = h / 2,"),
			std::string("                m0,"),
			std::string("                rotate = 0;"),
			std::string(""),
			std::string("        var splines = [];"),
			std::string(""),
			std::string("        var cluster = d3.layout.cluster()"),
			std::string("                .size([360, ry - 120])"),
			std::string("                .sort(function(a, b) { return d3.ascending(a.key, b.key); });"),
			std::string(""),
			std::string("        var bundle = d3.layout.bundle();"),
			std::string(""),
			std::string("        var line = d3.svg.line.radial()"),
			std::string("                .interpolate(\"bundle\")"),
			std::string("                .tension(.85)"),
			std::string("                .radius(function(d) { return d.y; })"),
			std::string("                .angle(function(d) { return d.x / 180 * Math.PI; });"),
			std::string(""),
			std::string("        // Chrome 15 bug: <http://code.google.com/p/chromium/issues/detail?id=98951>"),
			std::string("        var div = d3.select(\"body\").insert(\"div\", \"h2\")"),
			std::string("                .style(\"top\", \"-80px\")"),
			std::string("                .style(\"left\", \"-160px\")"),
			std::string("                .style(\"width\", w + \"px\")"),
			std::string("                .style(\"height\", w + \"px\")"),
			std::string("                .style(\"position\", \"absolute\");"),
			std::string(""),
			std::string("        var legend = d3.select(\"div#legend\").html(\"<strong>Legend:</strong><br>\" + chart_legend.join(\"<br>\"));"),
			std::string(""),
			std::string("        var svg = div.append(\"svg:svg\")"),
			std::string("                .attr(\"width\", w)"),
			std::string("                .attr(\"height\", w)"),
			std::string("                .append(\"svg:g\")"),
			std::string("                .attr(\"transform\", \"translate(\" + rx + \",\" + ry + \")\");"),
			std::string(""),
			std::string("        svg.append(\"svg:path\")"),
			std::string("                .attr(\"class\", \"arc\")"),
			std::string("                .attr(\"d\", d3.svg.arc().outerRadius(ry - 120).innerRadius(0).startAngle(0).endAngle(2 * Math.PI))"),
			std::string("                .on(\"mousedown\", mousedown);"),
			std::string(""),
			std::string("        var nodes = cluster.nodes(packages.root(chart_data)),"),
			std::string("                links = packages.imports(nodes),"),
			std::string("                splines = bundle(links);"),
			std::string(""),
			std::string("        var path = svg.selectAll(\"path.link\")"),
			std::string("                .data(links)"),
			std::string("                .enter().append(\"svg:path\")"),
			std::string("                .attr(\"class\", function(d) { return \"link source-\" + d.source.key.replaceAll(\" \", \"_\") + \" target-\" + d.target.key.replaceAll(\" \", \"_\"); })"),
			std::string("                .attr(\"d\", function(d, i) { return line(splines[i]); });"),
			std::string(""),
			std::string("        svg.selectAll(\"g.node\")"),
			std::string("                .data(nodes.filter(function(n) { return !n.children; }))"),
			std::string("                .enter().append(\"svg:g\")"),
			std::string("                .attr(\"class\", \"node\")"),
			std::string("                .attr(\"id\", function(d) { return \"node-\" + d.key.replaceAll(\" \", \"_\"); })"),
			std::string("                .attr(\"transform\", function(d) { return \"rotate(\" + (d.x - 90) + \")translate(\" + d.y + \")\"; })"),
			std::string("                .append(\"svg:text\")"),
			std::string("                .attr(\"dx\", function(d) { return 8; })"),
			std::string("                .attr(\"dy\", \".31em\")"),
			std::string("                .attr(\"text-anchor\", function(d) { return \"start\"; })"),
			std::string("                .attr(\"transform\", function(d) { return null; })"),
			std::string("                .text(function(d) { return d.key; })"),
			std::string("                .on(\"mouseover\", mouseover)"),
			std::string("                .on(\"mouseout\", mouseout);"),
			std::string(""),
			std::string("        d3.select(\"input[type=range]\").on(\"change\", function() {"),
			std::string("            line.tension(this.value / 100);"),
			std::string("            path.attr(\"d\", function(d, i) { return line(splines[i]); });"),
			std::string("        });"),
			std::string(""),
			std::string(""),
			std::string("        d3.select(window)"),
			std::string("                .on(\"mousemove\", mousemove)"),
			std::string("                .on(\"mouseup\", mouseup);"),
			std::string(""),
			std::string("        function mouse(e) {"),
			std::string("            return [e.pageX - rx, e.pageY - ry];"),
			std::string("        }"),
			std::string(""),
			std::string("        function mousedown() {"),
			std::string("            m0 = mouse(d3.event);"),
			std::string("            d3.event.preventDefault();"),
			std::string("        }"),
			std::string(""),
			std::string("        function mousemove() {"),
			std::string("            if (m0) {"),
			std::string("                var m1 = mouse(d3.event),"),
			std::string("                        dm = Math.atan2(cross(m0, m1), dot(m0, m1)) * 180 / Math.PI;"),
			std::string("                div.style(\"-webkit-transform\", \"translate3d(0,\" + (ry - rx) + \"px,0)rotate3d(0,0,0,\" + dm + \"deg)translate3d(0,\" + (rx - ry) + \"px,0)\");"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function mouseup() {"),
			std::string("            if (m0) {"),
			std::string("                var m1 = mouse(d3.event),"),
			std::string("                        dm = Math.atan2(cross(m0, m1), dot(m0, m1)) * 180 / Math.PI;"),
			std::string(""),
			std::string("                rotate += dm;"),
			std::string("                if (rotate > 360) rotate -= 360;"),
			std::string("                else if (rotate < 0) rotate += 360;"),
			std::string("                m0 = null;"),
			std::string(""),
			std::string("                div.style(\"-webkit-transform\", \"rotate3d(0,0,0,0deg)\");"),
			std::string(""),
			std::string("                svg"),
			std::string("                        .attr(\"transform\", \"translate(\" + rx + \",\" + ry + \")rotate(\" + rotate + \")\")"),
			std::string("                        .selectAll(\"g.node text\")"),
			std::string("                        .attr(\"dx\", function(d) { return 8; })"),
			std::string("                        .attr(\"text-anchor\", function(d) { return \"start\"; })"),
			std::string("                        .attr(\"transform\", function(d) { return null; });"),
			std::string("            }"),
			std::string("        }"),
			std::string(""),
			std::string("        function mouseover(d) {"),
			std::string("            svg.selectAll(\"path.link.target-\" + d.key.replaceAll(\" \", \"_\"))"),
			std::string("                    .classed(\"target\", true)"),
			std::string("                    .each(updateNodes(\"source\", true));"),
			std::string(""),
			std::string("            svg.selectAll(\"path.link.source-\" + d.key.replaceAll(\" \", \"_\"))"),
			std::string("                    .classed(\"source\", true)"),
			std::string("                    .each(updateNodes(\"target\", true));"),
			std::string("        }"),
			std::string(""),
			std::string("        function mouseout(d) {"),
			std::string("            svg.selectAll(\"path.link.source-\" + d.key.replaceAll(\" \", \"_\"))"),
			std::string("                    .classed(\"source\", false)"),
			std::string("                    .each(updateNodes(\"target\", false));"),
			std::string(""),
			std::string("            svg.selectAll(\"path.link.target-\" + d.key.replaceAll(\" \", \"_\"))"),
			std::string("                    .classed(\"target\", false)"),
			std::string("                    .each(updateNodes(\"source\", false));"),
			std::string("        }"),
			std::string(""),
			std::string("        function updateNodes(name, value) {"),
			std::string("            return function(d) {"),
			std::string("                if (value) this.parentNode.appendChild(this);"),
			std::string("                svg.select(\"#node-\" + d[name].key.replaceAll(\" \", \"_\")).classed(name, value);"),
			std::string("            };"),
			std::string("        }"),
			std::string(""),
			std::string("        function cross(a, b) {"),
			std::string("            return a[0] * b[1] - a[1] * b[0];"),
			std::string("        }"),
			std::string(""),
			std::string("        function dot(a, b) {"),
			std::string("            return a[0] * b[0] + a[1] * b[1];"),
			std::string("        }"),
			std::string(""),
			std::string("    </script>"),
			std::string("    </body>"),
			std::string("</html>"),
		};

		std::string GlueResourceVd3Template()
		{
			std::stringstream buf;
			std::copy(d3TemplateBlockNo0, d3TemplateBlockNo0 + 1024, std::ostream_iterator<std::string>(buf, "\n"));
			std::copy(d3TemplateBlockNo1, d3TemplateBlockNo1 + 1024, std::ostream_iterator<std::string>(buf, "\n"));
			std::copy(d3TemplateBlockNo2, d3TemplateBlockNo2 + 1024, std::ostream_iterator<std::string>(buf, "\n"));
			std::copy(d3TemplateBlockNo3, d3TemplateBlockNo3 + 1024, std::ostream_iterator<std::string>(buf, "\n"));
			std::copy(d3TemplateBlockNo4, d3TemplateBlockNo4 + 1024, std::ostream_iterator<std::string>(buf, "\n"));
			std::copy(d3TemplateBlockNo5, d3TemplateBlockNo5 + 1024, std::ostream_iterator<std::string>(buf, "\n"));
			std::copy(d3TemplateBlockNo6, d3TemplateBlockNo6 + 776, std::ostream_iterator<std::string>(buf, "\n"));
			return buf.str();
		}

		const std::string circosTemplateBlockNo0[] = 
		{
			std::string("karyotype = circos.sequences.txt"),
			std::string("chromosomes_units = 1000000"),
			std::string(""),
			std::string("<ideogram>"),
			std::string("	<spacing>"),
			std::string("		default = 0.010r"),
			std::string("	</spacing>"),
			std::string("	radius    = 0.75r"),
			std::string("	thickness = 50p"),
			std::string("	fill      = yes"),
			std::string("	show_label       = yes"),
			std::string("	label_font       = default"),
			std::string("	label_size       = 14"),
			std::string("	label_parallel   = no"),
			std::string("</ideogram>"),
			std::string(""),
			std::string("show_ticks       = yes"),
			std::string("show_tick_labels = yes"),
			std::string(""),
			std::string("<ticks>"),
			std::string("	radius           = 1r"),
			std::string("	color            = black"),
			std::string("	thickness        = 4p"),
			std::string("	multiplier       = 1e-3"),
			std::string("	format           = %d"),
			std::string("	<tick>"),
			std::string("		spacing        = 0.05u"),
			std::string("		size           = 20p"),
			std::string("		show_label     = yes"),
			std::string("		label_size     = 14p"),
			std::string("		label_offset   = 10p"),
			std::string("	</tick>"),
			std::string("</ticks>"),
			std::string(""),
			std::string("<colors>"),
			std::string("	chr1* = red"),
			std::string("	chr2* = green"),
			std::string("	chr3* = blue"),
			std::string("	chr4* = orange"),
			std::string("</colors>"),
			std::string(""),
			std::string("<links>"),
			std::string("	crest = 1"),
			std::string("	bezier_radius = 0.3r"),
			std::string("	bezier_radius_purity = 1.0"),
			std::string("	<link>"),
			std::string("		show = yes"),
			std::string("		ribbon = yes"),
			std::string("		stroke_color = vdgrey"),
			std::string("		stroke_thickness = 2"),
			std::string("		file 		  = circos.segdup.txt"),
			std::string("		radius        = 0.99r"),
			std::string("		#color         = red_a4"),
			std::string("		thickness     = 15"),
			std::string("	</link>"),
			std::string("</links>"),
			std::string(""),
			std::string("################################################################"),
			std::string("# The remaining content is standard and required. It is imported"),
			std::string("# from default files in the Circos distribution."),
			std::string("#"),
			std::string("# These should be present in every Circos configuration file and"),
			std::string("# overridden as required. To see the content of these files,"),
			std::string("# look in etc/ in the Circos distribution."),
			std::string(""),
			std::string("<image>"),
			std::string("<<include circos.image.conf>>"),
			std::string("</image>"),
			std::string(""),
			std::string("# RGB/HSV color definitions, color lists, location of fonts, fill patterns."),
			std::string("# Included from Circos distribution."),
			std::string("<<include etc/colors_fonts_patterns.conf>>"),
			std::string(""),
			std::string("# Debugging, I/O an dother system parameters"),
			std::string("# Included from Circos distribution."),
			std::string("<<include etc/housekeeping.conf>>"),
			std::string(""),
		};

		std::string GlueResourceVcircosTemplate()
		{
			std::stringstream buf;
			std::copy(circosTemplateBlockNo0, circosTemplateBlockNo0 + 77, std::ostream_iterator<std::string>(buf, "\n"));
			return buf.str();
		}

		const std::string circosImageConfigBlockNo0[] = 
		{
			std::string("background = white"),
			std::string("dir   = ."),
			std::string("file  = circos.png"),
			std::string("png   = yes"),
			std::string("svg   = yes"),
			std::string("# radius of inscribed circle in image"),
			std::string(""),
			std::string("# by default angle=0 is at 3 o'clock position"),
			std::string("angle_offset      = -90"),
			std::string(""),
			std::string("#angle_orientation = counterclockwise"),
			std::string(""),
			std::string("auto_alpha_colors = yes"),
			std::string("auto_alpha_steps  = 5"),
		};

		std::string GlueResourceVcircosImageConfig()
		{
			std::stringstream buf;
			std::copy(circosImageConfigBlockNo0, circosImageConfigBlockNo0 + 14, std::ostream_iterator<std::string>(buf, "\n"));
			return buf.str();
		}

		const std::string variantTemplateBlockNo0[] = 
		{
			std::string("##fileformat=VCFv4.1"),
			std::string("##source=Sibelia"),
			std::string("##reference="),
			std::string("##assembly="),
			std::string("#CHROM	POS	ID	REF	ALT	QUAL	FILTER	INFO"),
		};

		std::string GlueResourceVvariantTemplate()
		{
			std::stringstream buf;
			std::copy(variantTemplateBlockNo0, variantTemplateBlockNo0 + 5, std::ostream_iterator<std::string>(buf, "\n"));
			return buf.str();
		}

	}

	const std::string d3Template = GlueResourceVd3Template();
	const std::string circosTemplate = GlueResourceVcircosTemplate();
	const std::string circosImageConfig = GlueResourceVcircosImageConfig();
	const std::string variantTemplate = GlueResourceVvariantTemplate();
}

