#include <iostream>
#include <ctype.h>

#include "CommandlineOptions.hh"
#include "Symmetry.hh"
#include "PointConfiguration.hh"

int main(const int argc, const char** argv) {
  using namespace topcom;

  if (argc < 2) {
    MessageStreams::forced() << "usage: " << argv[0] << " n" << std::endl;
    return 1;
  }
  parameter_type n = atoi(argv[1]);
  if (n <= 0) {
    MessageStreams::forced() << "n > 0 required" << std::endl;
    return 1;
  }

  // first compute the group D_n generated by the full cycle and a median reflection:
  symmetry_collectordata D_data;
  Permutation p(n,n);
  Symmetry cycle(p, true); // the cycle (1,2,...,n)
  Symmetry reflection(p.reverse(), false); // the reflection (n, n-1, ..., 1)
  D_data.insert(cycle);
  D_data.insert(reflection);
  SymmetryGroup D(n, D_data);

  // transform symmetries into permutation matrices:
  std::pair<PointConfiguration, SymmetryGroup> B_D_center(D.permutation_polytope(true));
  MessageStreams::result() << B_D_center.first << std::endl;
  B_D_center.second.write_sorted_generators(MessageStreams::result());
  MessageStreams::result() << std::endl;
  
  return 0;
}

// eof B_D_center.cc
