/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.ds.DataSheet;
import WIMSchem.ds.DataSheetStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Stack;

public class DataSheetCache {
    private final int MAX_UNDO = 10;
    private Stack<String> undo = new Stack();
    private Stack<String> redo = new Stack();

    public boolean canUndo() {
        return !this.undo.empty();
    }

    public boolean canRedo() {
        return !this.redo.empty();
    }

    public void cacheUndo(DataSheet DS) {
        String str = this.toString(DS);
        this.undo.push(str);
        while (this.undo.size() > 10) {
            this.undo.remove(0);
        }
        this.redo.clear();
    }

    public DataSheet performUndo(DataSheet Cur) {
        if (this.undo.empty()) {
            return null;
        }
        this.redo.push(this.toString(Cur));
        return this.fromString(this.undo.pop());
    }

    public DataSheet performRedo(DataSheet Cur) {
        if (this.redo.empty()) {
            return null;
        }
        this.undo.push(this.toString(Cur));
        return this.fromString(this.redo.pop());
    }

    private String toString(DataSheet DS) {
        StringWriter sw = new StringWriter();
        try {
            DataSheetStream.writeXML(new BufferedWriter(sw), DS);
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }

    private DataSheet fromString(String StrDS) {
        DataSheet ds = null;
        try {
            if (DataSheetStream.examineIsXMLDS(new BufferedReader(new StringReader(StrDS)))) {
                ds = DataSheetStream.readXML(new BufferedReader(new StringReader(StrDS)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ds;
    }
}

