/*
 * QT Client for X2GoKDrive
 * Copyright (C) 2018-2023 Oleksandr Shneyder <o.shneyder@phoca-gmbh.de>
 * Copyright (C) 2018-2023 phoca-GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef MENUFRAME_H
#define MENUFRAME_H
#include <QFrame>
#include <QLabel>

class RotatedLabel: public QLabel
{
    Q_OBJECT
public:
    typedef enum{NORMAL,LEFT, RIGHT} orient;
    explicit RotatedLabel(QWidget *parent=0);
    explicit RotatedLabel(const QString &text, QWidget *parent=0);
    void setOrientation(orient ort);

private:
    orient orientation=NORMAL;

protected:
    void paintEvent(QPaintEvent* ev);
    void mouseDoubleClickEvent(QMouseEvent*);
signals:
    void doubleClick();
};

class QMenu;
class QLabel;
class QHBoxLayout;
class QVBoxLayout;
class QToolButton;
class MenuFrame : public QFrame
{
    Q_OBJECT
public:
    MenuFrame(QWidget* parent, QMenu* menu);
    void setHasPointer(bool hasPointer);
    void enableViewMenu(bool enabled);

private:
    void applyStyle();
    void setupFrame();
    bool isPinned=false;
    int startPosX=0;
    int startPosY=0;
    double position;
    bool drag=false;
    bool hovered=false;
    int defaultMargin=0;
    int defaultSpacing=0;
    RotatedLabel *capt;
    QHBoxLayout* hLayout;
    QVBoxLayout* vLayout;
    QToolButton* bPin;
    QToolButton* viewMenu;
    QToolButton* bDisc;
    QToolButton* bMin;

    enum{TOP,BOTTOM, LEFT, RIGHT} orientation=TOP;

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);

public slots:
    void setPinned(bool toggled);
    void setCaption(const QString& text);
    void adjustPosition();

signals:
    void editCaption();
};

#endif // MENUFRAME_H
