; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:   -mtriple powerpc64-ibm-aix-xcoff -code-model=large < %s | \
; RUN:   FileCheck %s -check-prefix=LARGE64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:   -mtriple powerpc64-ibm-aix-xcoff -code-model=small < %s | \
; RUN:   FileCheck %s -check-prefix=SMALL64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:   -mtriple powerpc-ibm-aix-xcoff -code-model=large < %s | \
; RUN:   FileCheck %s -check-prefix=LARGE32
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:   -mtriple powerpc-ibm-aix-xcoff -code-model=small < %s | \
; RUN:   FileCheck %s -check-prefix=SMALL32

@global_int_zero = thread_local(initialexec) global i32 0, align 4
@global_int_nonzero = thread_local(initialexec) global i32 1, align 4
@intern_int_zero = internal thread_local(initialexec) global i32 0, align 4
@intern_int_nonzero = internal thread_local(initialexec) global i32 1, align 4

@global_long_zero = thread_local(initialexec) global i64 0, align 8
@global_long_nonzero = thread_local(initialexec) global i64 1, align 8
@intern_long_zero = internal thread_local(initialexec) global i64 0, align 8
@intern_long_nonzero = internal thread_local(initialexec) global i64 1, align 8

@global_float_zero = thread_local(initialexec) global float 0.000000, align 4
@global_float_nonzero = thread_local(initialexec) global float 1.000000, align 4
@intern_float_zero = internal thread_local(initialexec) global float 0.000000, align 4
@intern_float_nonzero = internal thread_local(initialexec) global float 1.000000, align 4

@global_double_zero = thread_local(initialexec) global double 0.000000, align 8
@global_double_nonzero = thread_local(initialexec) global double 1.000000, align 8
@intern_double_zero = internal thread_local(initialexec) global double 0.000000, align 8
@intern_double_nonzero = internal thread_local(initialexec) global double 1.000000, align 8

define void @store_global_int_zero(i32 noundef signext %i) {
; LARGE64-LABEL: store_global_int_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r4, L..C0@u(r2)
; LARGE64-NEXT:    ld r4, L..C0@l(r4)
; LARGE64-NEXT:    stwx r3, r13, r4
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_global_int_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r4, L..C0(r2) # target-flags(ppc-tprel) @global_int_zero
; SMALL64-NEXT:    stwx r3, r13, r4
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_global_int_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    mr r4, r3
; LARGE32-NEXT:    addis r3, L..C0@u(r2)
; LARGE32-NEXT:    lwz r5, L..C0@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stwx r4, r3, r5
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_global_int_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r5, L..C0(r2) # target-flags(ppc-tprel) @global_int_zero
; SMALL32-NEXT:    mr r4, r3
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stwx r4, r3, r5
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @global_int_zero)
  store i32 %i, ptr %addr, align 4
  ret void
}

define void @store_global_int_nonzero(i32 noundef signext %i) {
; LARGE64-LABEL: store_global_int_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r4, L..C1@u(r2)
; LARGE64-NEXT:    ld r4, L..C1@l(r4)
; LARGE64-NEXT:    stwx r3, r13, r4
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_global_int_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r4, L..C1(r2) # target-flags(ppc-tprel) @global_int_nonzero
; SMALL64-NEXT:    stwx r3, r13, r4
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_global_int_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    mr r4, r3
; LARGE32-NEXT:    addis r3, L..C1@u(r2)
; LARGE32-NEXT:    lwz r5, L..C1@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stwx r4, r3, r5
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_global_int_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r5, L..C1(r2) # target-flags(ppc-tprel) @global_int_nonzero
; SMALL32-NEXT:    mr r4, r3
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stwx r4, r3, r5
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @global_int_nonzero)
  store i32 %i, ptr %addr, align 4
  ret void
}

define void @store_intern_int_zero(i32 noundef signext %i) {
; LARGE64-LABEL: store_intern_int_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r4, L..C2@u(r2)
; LARGE64-NEXT:    ld r4, L..C2@l(r4)
; LARGE64-NEXT:    stwx r3, r13, r4
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_intern_int_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r4, L..C2(r2) # target-flags(ppc-tprel) @intern_int_zero
; SMALL64-NEXT:    stwx r3, r13, r4
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_intern_int_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    mr r4, r3
; LARGE32-NEXT:    addis r3, L..C2@u(r2)
; LARGE32-NEXT:    lwz r5, L..C2@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stwx r4, r3, r5
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_intern_int_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r5, L..C2(r2) # target-flags(ppc-tprel) @intern_int_zero
; SMALL32-NEXT:    mr r4, r3
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stwx r4, r3, r5
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @intern_int_zero)
  store i32 %i, ptr %addr, align 4
  ret void
}

define void @store_intern_int_nonzero(i32 noundef signext %i) {
; LARGE64-LABEL: store_intern_int_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r4, L..C3@u(r2)
; LARGE64-NEXT:    ld r4, L..C3@l(r4)
; LARGE64-NEXT:    stwx r3, r13, r4
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_intern_int_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r4, L..C3(r2) # target-flags(ppc-tprel) @intern_int_nonzero
; SMALL64-NEXT:    stwx r3, r13, r4
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_intern_int_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    mr r4, r3
; LARGE32-NEXT:    addis r3, L..C3@u(r2)
; LARGE32-NEXT:    lwz r5, L..C3@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stwx r4, r3, r5
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_intern_int_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r5, L..C3(r2) # target-flags(ppc-tprel) @intern_int_nonzero
; SMALL32-NEXT:    mr r4, r3
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stwx r4, r3, r5
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @intern_int_nonzero)
  store i32 %i, ptr %addr, align 4
  ret void
}

define signext i32 @load_global_int_zero() {
; LARGE64-LABEL: load_global_int_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C0@u(r2)
; LARGE64-NEXT:    ld r3, L..C0@l(r3)
; LARGE64-NEXT:    lwax r3, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_global_int_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C0(r2) # target-flags(ppc-tprel) @global_int_zero
; SMALL64-NEXT:    lwax r3, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_global_int_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C0@u(r2)
; LARGE32-NEXT:    lwz r4, L..C0@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lwzx r3, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_global_int_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C0(r2) # target-flags(ppc-tprel) @global_int_zero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lwzx r3, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @global_int_zero)
  %val = load i32, ptr %addr, align 4
  ret i32 %val
}

define signext i32 @load_global_int_nonzero() {
; LARGE64-LABEL: load_global_int_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C1@u(r2)
; LARGE64-NEXT:    ld r3, L..C1@l(r3)
; LARGE64-NEXT:    lwax r3, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_global_int_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C1(r2) # target-flags(ppc-tprel) @global_int_nonzero
; SMALL64-NEXT:    lwax r3, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_global_int_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C1@u(r2)
; LARGE32-NEXT:    lwz r4, L..C1@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lwzx r3, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_global_int_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C1(r2) # target-flags(ppc-tprel) @global_int_nonzero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lwzx r3, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @global_int_nonzero)
  %val = load i32, ptr %addr, align 4
  ret i32 %val
}

define signext i32 @load_intern_int_zero() {
; LARGE64-LABEL: load_intern_int_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C2@u(r2)
; LARGE64-NEXT:    ld r3, L..C2@l(r3)
; LARGE64-NEXT:    lwax r3, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_intern_int_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C2(r2) # target-flags(ppc-tprel) @intern_int_zero
; SMALL64-NEXT:    lwax r3, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_intern_int_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C2@u(r2)
; LARGE32-NEXT:    lwz r4, L..C2@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lwzx r3, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_intern_int_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C2(r2) # target-flags(ppc-tprel) @intern_int_zero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lwzx r3, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @intern_int_zero)
  %val = load i32, ptr %addr, align 4
  ret i32 %val
}

define signext i32 @load_intern_int_nonzero() {
; LARGE64-LABEL: load_intern_int_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C3@u(r2)
; LARGE64-NEXT:    ld r3, L..C3@l(r3)
; LARGE64-NEXT:    lwax r3, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_intern_int_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C3(r2) # target-flags(ppc-tprel) @intern_int_nonzero
; SMALL64-NEXT:    lwax r3, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_intern_int_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C3@u(r2)
; LARGE32-NEXT:    lwz r4, L..C3@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lwzx r3, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_intern_int_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C3(r2) # target-flags(ppc-tprel) @intern_int_nonzero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lwzx r3, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @intern_int_nonzero)
  %val = load i32, ptr %addr, align 4
  ret i32 %val
}

define void @store_global_long_zero(i64 noundef %i) {
; LARGE64-LABEL: store_global_long_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r4, L..C4@u(r2)
; LARGE64-NEXT:    ld r4, L..C4@l(r4)
; LARGE64-NEXT:    stdx r3, r13, r4
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_global_long_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r4, L..C4(r2) # target-flags(ppc-tprel) @global_long_zero
; SMALL64-NEXT:    stdx r3, r13, r4
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_global_long_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    mr r5, r3
; LARGE32-NEXT:    addis r3, L..C4@u(r2)
; LARGE32-NEXT:    lwz r6, L..C4@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    add r3, r3, r6
; LARGE32-NEXT:    stw r4, 4(r3)
; LARGE32-NEXT:    stw r5, 0(r3)
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_global_long_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r6, L..C4(r2) # target-flags(ppc-tprel) @global_long_zero
; SMALL32-NEXT:    mr r5, r3
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    add r3, r3, r6
; SMALL32-NEXT:    stw r4, 4(r3)
; SMALL32-NEXT:    stw r5, 0(r3)
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @global_long_zero)
  store i64 %i, ptr %addr, align 8
  ret void
}

define void @store_global_long_nonzero(i64 noundef %i) {
; LARGE64-LABEL: store_global_long_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r4, L..C5@u(r2)
; LARGE64-NEXT:    ld r4, L..C5@l(r4)
; LARGE64-NEXT:    stdx r3, r13, r4
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_global_long_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r4, L..C5(r2) # target-flags(ppc-tprel) @global_long_nonzero
; SMALL64-NEXT:    stdx r3, r13, r4
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_global_long_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    mr r5, r3
; LARGE32-NEXT:    addis r3, L..C5@u(r2)
; LARGE32-NEXT:    lwz r6, L..C5@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    add r3, r3, r6
; LARGE32-NEXT:    stw r4, 4(r3)
; LARGE32-NEXT:    stw r5, 0(r3)
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_global_long_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r6, L..C5(r2) # target-flags(ppc-tprel) @global_long_nonzero
; SMALL32-NEXT:    mr r5, r3
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    add r3, r3, r6
; SMALL32-NEXT:    stw r4, 4(r3)
; SMALL32-NEXT:    stw r5, 0(r3)
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @global_long_nonzero)
  store i64 %i, ptr %addr, align 8
  ret void
}

define void @store_intern_long_zero(i64 noundef %i) {
; LARGE64-LABEL: store_intern_long_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r4, L..C6@u(r2)
; LARGE64-NEXT:    ld r4, L..C6@l(r4)
; LARGE64-NEXT:    stdx r3, r13, r4
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_intern_long_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r4, L..C6(r2) # target-flags(ppc-tprel) @intern_long_zero
; SMALL64-NEXT:    stdx r3, r13, r4
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_intern_long_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    mr r5, r3
; LARGE32-NEXT:    addis r3, L..C6@u(r2)
; LARGE32-NEXT:    lwz r6, L..C6@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    add r3, r3, r6
; LARGE32-NEXT:    stw r4, 4(r3)
; LARGE32-NEXT:    stw r5, 0(r3)
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_intern_long_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r6, L..C6(r2) # target-flags(ppc-tprel) @intern_long_zero
; SMALL32-NEXT:    mr r5, r3
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    add r3, r3, r6
; SMALL32-NEXT:    stw r4, 4(r3)
; SMALL32-NEXT:    stw r5, 0(r3)
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @intern_long_zero)
  store i64 %i, ptr %addr, align 8
  ret void
}

define void @store_intern_long_nonzero(i64 noundef %i) {
; LARGE64-LABEL: store_intern_long_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r4, L..C7@u(r2)
; LARGE64-NEXT:    ld r4, L..C7@l(r4)
; LARGE64-NEXT:    stdx r3, r13, r4
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_intern_long_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r4, L..C7(r2) # target-flags(ppc-tprel) @intern_long_nonzero
; SMALL64-NEXT:    stdx r3, r13, r4
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_intern_long_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    mr r5, r3
; LARGE32-NEXT:    addis r3, L..C7@u(r2)
; LARGE32-NEXT:    lwz r6, L..C7@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    add r3, r3, r6
; LARGE32-NEXT:    stw r4, 4(r3)
; LARGE32-NEXT:    stw r5, 0(r3)
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_intern_long_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r6, L..C7(r2) # target-flags(ppc-tprel) @intern_long_nonzero
; SMALL32-NEXT:    mr r5, r3
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    add r3, r3, r6
; SMALL32-NEXT:    stw r4, 4(r3)
; SMALL32-NEXT:    stw r5, 0(r3)
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @intern_long_nonzero)
  store i64 %i, ptr %addr, align 8
  ret void
}

define i64 @load_global_long_zero() {
; LARGE64-LABEL: load_global_long_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C4@u(r2)
; LARGE64-NEXT:    ld r3, L..C4@l(r3)
; LARGE64-NEXT:    ldx r3, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_global_long_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C4(r2) # target-flags(ppc-tprel) @global_long_zero
; SMALL64-NEXT:    ldx r3, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_global_long_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C4@u(r2)
; LARGE32-NEXT:    lwz r4, L..C4@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    add r4, r3, r4
; LARGE32-NEXT:    lwz r3, 0(r4)
; LARGE32-NEXT:    lwz r4, 4(r4)
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_global_long_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C4(r2) # target-flags(ppc-tprel) @global_long_zero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    add r4, r3, r4
; SMALL32-NEXT:    lwz r3, 0(r4)
; SMALL32-NEXT:    lwz r4, 4(r4)
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @global_long_zero)
  %val = load i64, ptr %addr, align 8
  ret i64 %val
}

define i64 @load_global_long_nonzero() {
; LARGE64-LABEL: load_global_long_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C5@u(r2)
; LARGE64-NEXT:    ld r3, L..C5@l(r3)
; LARGE64-NEXT:    ldx r3, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_global_long_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C5(r2) # target-flags(ppc-tprel) @global_long_nonzero
; SMALL64-NEXT:    ldx r3, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_global_long_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C5@u(r2)
; LARGE32-NEXT:    lwz r4, L..C5@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    add r4, r3, r4
; LARGE32-NEXT:    lwz r3, 0(r4)
; LARGE32-NEXT:    lwz r4, 4(r4)
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_global_long_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C5(r2) # target-flags(ppc-tprel) @global_long_nonzero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    add r4, r3, r4
; SMALL32-NEXT:    lwz r3, 0(r4)
; SMALL32-NEXT:    lwz r4, 4(r4)
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @global_long_nonzero)
  %val = load i64, ptr %addr, align 8
  ret i64 %val
}

define i64 @load_intern_long_zero() {
; LARGE64-LABEL: load_intern_long_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C6@u(r2)
; LARGE64-NEXT:    ld r3, L..C6@l(r3)
; LARGE64-NEXT:    ldx r3, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_intern_long_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C6(r2) # target-flags(ppc-tprel) @intern_long_zero
; SMALL64-NEXT:    ldx r3, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_intern_long_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C6@u(r2)
; LARGE32-NEXT:    lwz r4, L..C6@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    add r4, r3, r4
; LARGE32-NEXT:    lwz r3, 0(r4)
; LARGE32-NEXT:    lwz r4, 4(r4)
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_intern_long_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C6(r2) # target-flags(ppc-tprel) @intern_long_zero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    add r4, r3, r4
; SMALL32-NEXT:    lwz r3, 0(r4)
; SMALL32-NEXT:    lwz r4, 4(r4)
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @intern_long_zero)
  %val = load i64, ptr %addr, align 8
  ret i64 %val
}

define i64 @load_intern_long_nonzero() {
; LARGE64-LABEL: load_intern_long_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C7@u(r2)
; LARGE64-NEXT:    ld r3, L..C7@l(r3)
; LARGE64-NEXT:    ldx r3, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_intern_long_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C7(r2) # target-flags(ppc-tprel) @intern_long_nonzero
; SMALL64-NEXT:    ldx r3, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_intern_long_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C7@u(r2)
; LARGE32-NEXT:    lwz r4, L..C7@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    add r4, r3, r4
; LARGE32-NEXT:    lwz r3, 0(r4)
; LARGE32-NEXT:    lwz r4, 4(r4)
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_intern_long_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C7(r2) # target-flags(ppc-tprel) @intern_long_nonzero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    add r4, r3, r4
; SMALL32-NEXT:    lwz r3, 0(r4)
; SMALL32-NEXT:    lwz r4, 4(r4)
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @intern_long_nonzero)
  %val = load i64, ptr %addr, align 8
  ret i64 %val
}

define void @store_global_float_zero(float noundef %i) {
; LARGE64-LABEL: store_global_float_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C8@u(r2)
; LARGE64-NEXT:    ld r3, L..C8@l(r3)
; LARGE64-NEXT:    stfsx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_global_float_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C8(r2) # target-flags(ppc-tprel) @global_float_zero
; SMALL64-NEXT:    stfsx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_global_float_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C8@u(r2)
; LARGE32-NEXT:    lwz r4, L..C8@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stfsx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_global_float_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C8(r2) # target-flags(ppc-tprel) @global_float_zero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stfsx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @global_float_zero)
  store float %i, ptr %addr, align 4
  ret void
}

define void @store_global_float_nonzero(float noundef %i) {
; LARGE64-LABEL: store_global_float_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C9@u(r2)
; LARGE64-NEXT:    ld r3, L..C9@l(r3)
; LARGE64-NEXT:    stfsx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_global_float_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C9(r2) # target-flags(ppc-tprel) @global_float_nonzero
; SMALL64-NEXT:    stfsx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_global_float_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C9@u(r2)
; LARGE32-NEXT:    lwz r4, L..C9@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stfsx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_global_float_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C9(r2) # target-flags(ppc-tprel) @global_float_nonzero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stfsx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @global_float_nonzero)
  store float %i, ptr %addr, align 4
  ret void
}

define void @store_intern_float_zero(float noundef %i) {
; LARGE64-LABEL: store_intern_float_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C10@u(r2)
; LARGE64-NEXT:    ld r3, L..C10@l(r3)
; LARGE64-NEXT:    stfsx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_intern_float_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C10(r2) # target-flags(ppc-tprel) @intern_float_zero
; SMALL64-NEXT:    stfsx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_intern_float_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C10@u(r2)
; LARGE32-NEXT:    lwz r4, L..C10@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stfsx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_intern_float_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C10(r2) # target-flags(ppc-tprel) @intern_float_zero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stfsx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @intern_float_zero)
  store float %i, ptr %addr, align 4
  ret void
}

define void @store_intern_float_nonzero(float noundef %i) {
; LARGE64-LABEL: store_intern_float_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C11@u(r2)
; LARGE64-NEXT:    ld r3, L..C11@l(r3)
; LARGE64-NEXT:    stfsx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_intern_float_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C11(r2) # target-flags(ppc-tprel) @intern_float_nonzero
; SMALL64-NEXT:    stfsx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_intern_float_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C11@u(r2)
; LARGE32-NEXT:    lwz r4, L..C11@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stfsx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_intern_float_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C11(r2) # target-flags(ppc-tprel) @intern_float_nonzero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stfsx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @intern_float_nonzero)
  store float %i, ptr %addr, align 4
  ret void
}

define float @load_global_float_zero() {
; LARGE64-LABEL: load_global_float_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C8@u(r2)
; LARGE64-NEXT:    ld r3, L..C8@l(r3)
; LARGE64-NEXT:    lfsx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_global_float_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C8(r2) # target-flags(ppc-tprel) @global_float_zero
; SMALL64-NEXT:    lfsx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_global_float_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C8@u(r2)
; LARGE32-NEXT:    lwz r4, L..C8@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lfsx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_global_float_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C8(r2) # target-flags(ppc-tprel) @global_float_zero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lfsx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @global_float_zero)
  %val = load float, ptr %addr, align 4
  ret float %val
}

define float @load_global_float_nonzero() {
; LARGE64-LABEL: load_global_float_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C9@u(r2)
; LARGE64-NEXT:    ld r3, L..C9@l(r3)
; LARGE64-NEXT:    lfsx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_global_float_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C9(r2) # target-flags(ppc-tprel) @global_float_nonzero
; SMALL64-NEXT:    lfsx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_global_float_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C9@u(r2)
; LARGE32-NEXT:    lwz r4, L..C9@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lfsx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_global_float_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C9(r2) # target-flags(ppc-tprel) @global_float_nonzero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lfsx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @global_float_nonzero)
  %val = load float, ptr %addr, align 4
  ret float %val
}

define float @load_intern_float_zero() {
; LARGE64-LABEL: load_intern_float_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C10@u(r2)
; LARGE64-NEXT:    ld r3, L..C10@l(r3)
; LARGE64-NEXT:    lfsx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_intern_float_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C10(r2) # target-flags(ppc-tprel) @intern_float_zero
; SMALL64-NEXT:    lfsx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_intern_float_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C10@u(r2)
; LARGE32-NEXT:    lwz r4, L..C10@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lfsx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_intern_float_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C10(r2) # target-flags(ppc-tprel) @intern_float_zero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lfsx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @intern_float_zero)
  %val = load float, ptr %addr, align 4
  ret float %val
}

define float @load_intern_float_nonzero() {
; LARGE64-LABEL: load_intern_float_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C11@u(r2)
; LARGE64-NEXT:    ld r3, L..C11@l(r3)
; LARGE64-NEXT:    lfsx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_intern_float_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C11(r2) # target-flags(ppc-tprel) @intern_float_nonzero
; SMALL64-NEXT:    lfsx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_intern_float_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C11@u(r2)
; LARGE32-NEXT:    lwz r4, L..C11@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lfsx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_intern_float_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C11(r2) # target-flags(ppc-tprel) @intern_float_nonzero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lfsx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @intern_float_nonzero)
  %val = load float, ptr %addr, align 4
  ret float %val
}

define void @store_global_double_zero(double noundef %i) {
; LARGE64-LABEL: store_global_double_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C12@u(r2)
; LARGE64-NEXT:    ld r3, L..C12@l(r3)
; LARGE64-NEXT:    stfdx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_global_double_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C12(r2) # target-flags(ppc-tprel) @global_double_zero
; SMALL64-NEXT:    stfdx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_global_double_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C12@u(r2)
; LARGE32-NEXT:    lwz r4, L..C12@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stfdx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_global_double_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C12(r2) # target-flags(ppc-tprel) @global_double_zero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stfdx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @global_double_zero)
  store double %i, ptr %addr, align 8
  ret void
}

define void @store_global_double_nonzero(double noundef %i) {
; LARGE64-LABEL: store_global_double_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C13@u(r2)
; LARGE64-NEXT:    ld r3, L..C13@l(r3)
; LARGE64-NEXT:    stfdx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_global_double_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C13(r2) # target-flags(ppc-tprel) @global_double_nonzero
; SMALL64-NEXT:    stfdx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_global_double_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C13@u(r2)
; LARGE32-NEXT:    lwz r4, L..C13@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stfdx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_global_double_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C13(r2) # target-flags(ppc-tprel) @global_double_nonzero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stfdx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @global_double_nonzero)
  store double %i, ptr %addr, align 8
  ret void
}

define void @store_intern_double_zero(double noundef %i) {
; LARGE64-LABEL: store_intern_double_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C14@u(r2)
; LARGE64-NEXT:    ld r3, L..C14@l(r3)
; LARGE64-NEXT:    stfdx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_intern_double_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C14(r2) # target-flags(ppc-tprel) @intern_double_zero
; SMALL64-NEXT:    stfdx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_intern_double_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C14@u(r2)
; LARGE32-NEXT:    lwz r4, L..C14@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stfdx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_intern_double_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C14(r2) # target-flags(ppc-tprel) @intern_double_zero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stfdx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @intern_double_zero)
  store double %i, ptr %addr, align 8
  ret void
}

define void @store_intern_double_nonzero(double noundef %i) {
; LARGE64-LABEL: store_intern_double_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C15@u(r2)
; LARGE64-NEXT:    ld r3, L..C15@l(r3)
; LARGE64-NEXT:    stfdx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: store_intern_double_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C15(r2) # target-flags(ppc-tprel) @intern_double_nonzero
; SMALL64-NEXT:    stfdx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: store_intern_double_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C15@u(r2)
; LARGE32-NEXT:    lwz r4, L..C15@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    stfdx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: store_intern_double_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C15(r2) # target-flags(ppc-tprel) @intern_double_nonzero
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    stfdx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @intern_double_nonzero)
  store double %i, ptr %addr, align 8
  ret void
}

define double @load_global_double_zero() {
; LARGE64-LABEL: load_global_double_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C12@u(r2)
; LARGE64-NEXT:    ld r3, L..C12@l(r3)
; LARGE64-NEXT:    lfdx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_global_double_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C12(r2) # target-flags(ppc-tprel) @global_double_zero
; SMALL64-NEXT:    lfdx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_global_double_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C12@u(r2)
; LARGE32-NEXT:    lwz r4, L..C12@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lfdx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_global_double_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C12(r2) # target-flags(ppc-tprel) @global_double_zero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lfdx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @global_double_zero)
  %val = load double, ptr %addr, align 8
  ret double %val
}

define double @load_global_double_nonzero() {
; LARGE64-LABEL: load_global_double_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C13@u(r2)
; LARGE64-NEXT:    ld r3, L..C13@l(r3)
; LARGE64-NEXT:    lfdx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_global_double_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C13(r2) # target-flags(ppc-tprel) @global_double_nonzero
; SMALL64-NEXT:    lfdx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_global_double_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C13@u(r2)
; LARGE32-NEXT:    lwz r4, L..C13@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lfdx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_global_double_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C13(r2) # target-flags(ppc-tprel) @global_double_nonzero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lfdx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @global_double_nonzero)
  %val = load double, ptr %addr, align 8
  ret double %val
}

define double @load_intern_double_zero() {
; LARGE64-LABEL: load_intern_double_zero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C14@u(r2)
; LARGE64-NEXT:    ld r3, L..C14@l(r3)
; LARGE64-NEXT:    lfdx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_intern_double_zero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C14(r2) # target-flags(ppc-tprel) @intern_double_zero
; SMALL64-NEXT:    lfdx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_intern_double_zero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C14@u(r2)
; LARGE32-NEXT:    lwz r4, L..C14@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lfdx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_intern_double_zero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C14(r2) # target-flags(ppc-tprel) @intern_double_zero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lfdx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @intern_double_zero)
  %val = load double, ptr %addr, align 8
  ret double %val
}

define double @load_intern_double_nonzero() {
; LARGE64-LABEL: load_intern_double_nonzero:
; LARGE64:       # %bb.0: # %entry
; LARGE64-NEXT:    addis r3, L..C15@u(r2)
; LARGE64-NEXT:    ld r3, L..C15@l(r3)
; LARGE64-NEXT:    lfdx f1, r13, r3
; LARGE64-NEXT:    blr
;
; SMALL64-LABEL: load_intern_double_nonzero:
; SMALL64:       # %bb.0: # %entry
; SMALL64-NEXT:    ld r3, L..C15(r2) # target-flags(ppc-tprel) @intern_double_nonzero
; SMALL64-NEXT:    lfdx f1, r13, r3
; SMALL64-NEXT:    blr
;
; LARGE32-LABEL: load_intern_double_nonzero:
; LARGE32:       # %bb.0: # %entry
; LARGE32-NEXT:    mflr r0
; LARGE32-NEXT:    stwu r1, -32(r1)
; LARGE32-NEXT:    stw r0, 40(r1)
; LARGE32-NEXT:    addis r3, L..C15@u(r2)
; LARGE32-NEXT:    lwz r4, L..C15@l(r3)
; LARGE32-NEXT:    bla .__get_tpointer[PR]
; LARGE32-NEXT:    lfdx f1, r3, r4
; LARGE32-NEXT:    addi r1, r1, 32
; LARGE32-NEXT:    lwz r0, 8(r1)
; LARGE32-NEXT:    mtlr r0
; LARGE32-NEXT:    blr
;
; SMALL32-LABEL: load_intern_double_nonzero:
; SMALL32:       # %bb.0: # %entry
; SMALL32-NEXT:    mflr r0
; SMALL32-NEXT:    stwu r1, -32(r1)
; SMALL32-NEXT:    lwz r4, L..C15(r2) # target-flags(ppc-tprel) @intern_double_nonzero
; SMALL32-NEXT:    stw r0, 40(r1)
; SMALL32-NEXT:    bla .__get_tpointer[PR]
; SMALL32-NEXT:    lfdx f1, r3, r4
; SMALL32-NEXT:    addi r1, r1, 32
; SMALL32-NEXT:    lwz r0, 8(r1)
; SMALL32-NEXT:    mtlr r0
; SMALL32-NEXT:    blr
entry:
  %addr = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @intern_double_nonzero)
  %val = load double, ptr %addr, align 8
  ret double %val
}

declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull)

; Lines below check if the symbols have correct suffix for TLS model, not
; generated by test update script, but kept well after updates.

; LARGE64: L..C0:
; LARGE64-NEXT: .tc global_int_zero[TE],global_int_zero[TL]@ie
; LARGE64-NEXT: L..C1:
; LARGE64-NEXT: .tc global_int_nonzero[TE],global_int_nonzero[TL]@ie
; LARGE64-NEXT: L..C2:
; LARGE64-NEXT: .tc intern_int_zero[TE],intern_int_zero[UL]@ie
; LARGE64-NEXT: L..C3:
; LARGE64-NEXT: .tc intern_int_nonzero[TE],intern_int_nonzero[TL]@ie
; LARGE64-NEXT: L..C4:
; LARGE64-NEXT: .tc global_long_zero[TE],global_long_zero[TL]@ie
; LARGE64-NEXT: L..C5:
; LARGE64-NEXT: .tc global_long_nonzero[TE],global_long_nonzero[TL]@ie
; LARGE64-NEXT: L..C6:
; LARGE64-NEXT: .tc intern_long_zero[TE],intern_long_zero[UL]@ie
; LARGE64-NEXT: L..C7:
; LARGE64-NEXT: .tc intern_long_nonzero[TE],intern_long_nonzero[TL]@ie
; LARGE64-NEXT: L..C8:
; LARGE64-NEXT: .tc global_float_zero[TE],global_float_zero[TL]@ie
; LARGE64-NEXT: L..C9:
; LARGE64-NEXT: .tc global_float_nonzero[TE],global_float_nonzero[TL]@ie
; LARGE64-NEXT: L..C10:
; LARGE64-NEXT: .tc intern_float_zero[TE],intern_float_zero[UL]@ie
; LARGE64-NEXT: L..C11:
; LARGE64-NEXT: .tc intern_float_nonzero[TE],intern_float_nonzero[TL]@ie
; LARGE64-NEXT: L..C12:
; LARGE64-NEXT: .tc global_double_zero[TE],global_double_zero[TL]@ie
; LARGE64-NEXT: L..C13:
; LARGE64-NEXT: .tc global_double_nonzero[TE],global_double_nonzero[TL]@ie
; LARGE64-NEXT: L..C14:
; LARGE64-NEXT: .tc intern_double_zero[TE],intern_double_zero[UL]@ie
; LARGE64-NEXT: L..C15:
; LARGE64-NEXT: .tc intern_double_nonzero[TE],intern_double_nonzero[TL]@ie

; SMALL64: L..C0:
; SMALL64-NEXT: .tc global_int_zero[TC],global_int_zero[TL]@ie
; SMALL64-NEXT: L..C1:
; SMALL64-NEXT: .tc global_int_nonzero[TC],global_int_nonzero[TL]@ie
; SMALL64-NEXT: L..C2:
; SMALL64-NEXT: .tc intern_int_zero[TC],intern_int_zero[UL]@ie
; SMALL64-NEXT: L..C3:
; SMALL64-NEXT: .tc intern_int_nonzero[TC],intern_int_nonzero[TL]@ie
; SMALL64-NEXT: L..C4:
; SMALL64-NEXT: .tc global_long_zero[TC],global_long_zero[TL]@ie
; SMALL64-NEXT: L..C5:
; SMALL64-NEXT: .tc global_long_nonzero[TC],global_long_nonzero[TL]@ie
; SMALL64-NEXT: L..C6:
; SMALL64-NEXT: .tc intern_long_zero[TC],intern_long_zero[UL]@ie
; SMALL64-NEXT: L..C7:
; SMALL64-NEXT: .tc intern_long_nonzero[TC],intern_long_nonzero[TL]@ie
; SMALL64-NEXT: L..C8:
; SMALL64-NEXT: .tc global_float_zero[TC],global_float_zero[TL]@ie
; SMALL64-NEXT: L..C9:
; SMALL64-NEXT: .tc global_float_nonzero[TC],global_float_nonzero[TL]@ie
; SMALL64-NEXT: L..C10:
; SMALL64-NEXT: .tc intern_float_zero[TC],intern_float_zero[UL]@ie
; SMALL64-NEXT: L..C11:
; SMALL64-NEXT: .tc intern_float_nonzero[TC],intern_float_nonzero[TL]@ie
; SMALL64-NEXT: L..C12:
; SMALL64-NEXT: .tc global_double_zero[TC],global_double_zero[TL]@ie
; SMALL64-NEXT: L..C13:
; SMALL64-NEXT: .tc global_double_nonzero[TC],global_double_nonzero[TL]@ie
; SMALL64-NEXT: L..C14:
; SMALL64-NEXT: .tc intern_double_zero[TC],intern_double_zero[UL]@ie
; SMALL64-NEXT: L..C15:
; SMALL64-NEXT: .tc intern_double_nonzero[TC],intern_double_nonzero[TL]@ie

; LARGE32: L..C0:
; LARGE32-NEXT: .tc global_int_zero[TE],global_int_zero[TL]@ie
; LARGE32-NEXT: L..C1:
; LARGE32-NEXT: .tc global_int_nonzero[TE],global_int_nonzero[TL]@ie
; LARGE32-NEXT: L..C2:
; LARGE32-NEXT: .tc intern_int_zero[TE],intern_int_zero[UL]@ie
; LARGE32-NEXT: L..C3:
; LARGE32-NEXT: .tc intern_int_nonzero[TE],intern_int_nonzero[TL]@ie
; LARGE32-NEXT: L..C4:
; LARGE32-NEXT: .tc global_long_zero[TE],global_long_zero[TL]@ie
; LARGE32-NEXT: L..C5:
; LARGE32-NEXT: .tc global_long_nonzero[TE],global_long_nonzero[TL]@ie
; LARGE32-NEXT: L..C6:
; LARGE32-NEXT: .tc intern_long_zero[TE],intern_long_zero[UL]@ie
; LARGE32-NEXT: L..C7:
; LARGE32-NEXT: .tc intern_long_nonzero[TE],intern_long_nonzero[TL]@ie
; LARGE32-NEXT: L..C8:
; LARGE32-NEXT: .tc global_float_zero[TE],global_float_zero[TL]@ie
; LARGE32-NEXT: L..C9:
; LARGE32-NEXT: .tc global_float_nonzero[TE],global_float_nonzero[TL]@ie
; LARGE32-NEXT: L..C10:
; LARGE32-NEXT: .tc intern_float_zero[TE],intern_float_zero[UL]@ie
; LARGE32-NEXT: L..C11:
; LARGE32-NEXT: .tc intern_float_nonzero[TE],intern_float_nonzero[TL]@ie
; LARGE32-NEXT: L..C12:
; LARGE32-NEXT: .tc global_double_zero[TE],global_double_zero[TL]@ie
; LARGE32-NEXT: L..C13:
; LARGE32-NEXT: .tc global_double_nonzero[TE],global_double_nonzero[TL]@ie
; LARGE32-NEXT: L..C14:
; LARGE32-NEXT: .tc intern_double_zero[TE],intern_double_zero[UL]@ie
; LARGE32-NEXT: L..C15:
; LARGE32-NEXT: .tc intern_double_nonzero[TE],intern_double_nonzero[TL]@ie

; SMALL32: L..C0:
; SMALL32-NEXT: .tc global_int_zero[TC],global_int_zero[TL]@ie
; SMALL32-NEXT: L..C1:
; SMALL32-NEXT: .tc global_int_nonzero[TC],global_int_nonzero[TL]@ie
; SMALL32-NEXT: L..C2:
; SMALL32-NEXT: .tc intern_int_zero[TC],intern_int_zero[UL]@ie
; SMALL32-NEXT: L..C3:
; SMALL32-NEXT: .tc intern_int_nonzero[TC],intern_int_nonzero[TL]@ie
; SMALL32-NEXT: L..C4:
; SMALL32-NEXT: .tc global_long_zero[TC],global_long_zero[TL]@ie
; SMALL32-NEXT: L..C5:
; SMALL32-NEXT: .tc global_long_nonzero[TC],global_long_nonzero[TL]@ie
; SMALL32-NEXT: L..C6:
; SMALL32-NEXT: .tc intern_long_zero[TC],intern_long_zero[UL]@ie
; SMALL32-NEXT: L..C7:
; SMALL32-NEXT: .tc intern_long_nonzero[TC],intern_long_nonzero[TL]@ie
; SMALL32-NEXT: L..C8:
; SMALL32-NEXT: .tc global_float_zero[TC],global_float_zero[TL]@ie
; SMALL32-NEXT: L..C9:
; SMALL32-NEXT: .tc global_float_nonzero[TC],global_float_nonzero[TL]@ie
; SMALL32-NEXT: L..C10:
; SMALL32-NEXT: .tc intern_float_zero[TC],intern_float_zero[UL]@ie
; SMALL32-NEXT: L..C11:
; SMALL32-NEXT: .tc intern_float_nonzero[TC],intern_float_nonzero[TL]@ie
; SMALL32-NEXT: L..C12:
; SMALL32-NEXT: .tc global_double_zero[TC],global_double_zero[TL]@ie
; SMALL32-NEXT: L..C13:
; SMALL32-NEXT: .tc global_double_nonzero[TC],global_double_nonzero[TL]@ie
; SMALL32-NEXT: L..C14:
; SMALL32-NEXT: .tc intern_double_zero[TC],intern_double_zero[UL]@ie
; SMALL32-NEXT: L..C15:
; SMALL32-NEXT: .tc intern_double_nonzero[TC],intern_double_nonzero[TL]@ie
