;;; EMAIL-SIGN
;;; ----------

; sign-message message key -> message
; signs message with key
(defun sign-message (msg key)
;  (declare (xargs :guard (and (messagep msg)
;			      (stringp  key))))
  (begin
   (cw "    [sign-message] ~x0~%" key)
   (wrap-msg-body msg (list 'signature key))))

; email-sign-init env -> env
; initializes signing variables
(defun email-sign-init (env)
  (begin
   (cw "  [email-sign-init]~%")
   (set-var 'own-key '() env)))

(defun email-sign-command (cmd args env)
;  (declare (xargs :guard (and (stringp cmd)
;			      (string-listp    args))))
  (begin
   (cw "  [email-sign-command: ~x0]~%" (lookup 'name))
  (cond ((equal 'SET_OWN_KEY cmd)
         (let ((key (caar args)))
           (set-var 'own-key key env)))
        (t 
         env))))

(defun email-sign-outgoing (msg env)
;  (declare (xargs :guard (messagep msg)))
  (begin
   (cw "  [email-sign-outgoing: ~x0:~x1]~%" (lookup 'name) (car (lookup 'own-key)))
  (let ((key (car (lookup 'own-key))))
    (if (equal key '())
	(make-action 'mail msg env)
      (make-action 'mail (sign-message msg key) env)))))

(defun email-sign-incoming (msg env)
  (declare ;(xargs :guard (messagep msg))
           (ignore msg))  ; Msg not used
  (begin 
   (cw "  [email-sign-incoming: ~x0]~%" (lookup 'user))
   (mv nil env)))



