#ifndef FILTER_H
#define FILTER_H

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <QtWidgets/QWidget>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QVBoxLayout>
#include <QtGui/QMouseEvent>
#include "model.h"

class Filter : public QWidget
{
  Q_OBJECT

  private:
    Model *model;
    int leftBorder, rightBorder, topBorder, bottomBorder;
    int index;
    double scaleX, scaleY;
    int mousePos;
    double mouseVal;

  public:
    Filter(Model *p_model, int p_index, QWidget* parent=0, int w=300, int h=200);
    ~Filter();

  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void viewportResizeEvent (QResizeEvent *ev);
    virtual void mousePressEvent (QMouseEvent* );
    virtual void mouseReleaseEvent (QMouseEvent* );
    virtual void mouseMoveEvent (QMouseEvent* );

  public slots: 
};
  
#endif
