
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvsroot/aolserver/aolserver/doc/ns_time.n,v 1.3 2003/04/10 16:16:09 shmooved Exp $
'\"
'\" 
.so man.macros

.TH ns_time n 4.0 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_time, ns_fmttime, ns_gmtime, ns_localtime, \- commands
.SH SYNOPSIS
\fBns_fmttime \fItime \fR?\fIformat string\fR?
.sp
\fBns_gmtime 
.sp
\fBns_localtime 
.sp
\fBns_time
.BE

.SH DESCRIPTION
.PP
\fBns_time\fR: Returns the value of time in seconds since 00:00:00 UTC, January 1, 1970. This return value is suitable as input to the ns_httptime function to get the current time.

\fBns_fmttime\fR: Formats the time string,time,according to the format provided in format string. If no format is provided, defaults to "%a %b %e %H:%M:%S %Z %Y".

\fBns_gmttime\fR: Returns a Tcl list of the pieces of the current Greenwich Mean Time. The pieces are
    seconds (0-59)
    minutes (0-59)
    hours (0-23)
    dayofmonth (1-31)
    monthofyear (0-11)
    year (year-1900)*
    dayofweek (Sunday=0)
    dayofyear (0-365)
    1 if Daylight Savings Time is in effect


\fBns_localtime\fR: Returns a Tcl list of the pieces of the current local time. The pieces are
    seconds (0-59)
    minutes (0-59)
    hours (0-23)
    dayofmonth (1-31)
    monthofyear (0-11)
    year (year-1900)*
    dayofweek (Sunday=0)
    dayofyear (0-365)
    1 if Daylight Savings Time is in effect

.SH EXAMPLES
.PP
ns_fmttime [ns_time] returns: Tue Nov 12 15:14:47 2002
ns_fmttime [ns_time] "%Y%m%d" returns: 20021112

.SH "SEE ALSO"
ns_httptime

.SH KEYWORDS

