/*
 * This file was automatically generated by EvoSuite
 * Wed Jun 06 18:19:16 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class MarkerRange_ESTest extends MarkerRange_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      MarkerRange markerRange1 = Strand.getORFAroundMarker(marker0, true);
      MarkerRange markerRange2 = markerRange0.extendRange(markerRange1);
      MarkerRange markerRange3 = markerRange2.extendRange(markerRange0);
      assertFalse(markerRange3.equals((Object)markerRange2));
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      boolean boolean0 = markerRange0.overlaps(markerRange0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpecte exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      MarkerRange markerRange1 = new MarkerRange(strand0, 1, 2);
      boolean boolean0 = markerRange1.overlaps(markerRange0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - neHp<cte excepton: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      boolean boolean0 = markerRange0.isForwardMarker();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("(OYYdJuu@?^`Th", "?q:G|&bui**t+wZ)");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(1);
      Strand strand0 = markerRange0.getStrand();
      assertEquals(2, Strand.REVERSE);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      char[] charArray0 = new char[6];
      Short short0 = new Short((short)0);
      Integer integer0 = new Integer(1034);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 1034, 1034, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, 4096);
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions((-732), 0);
      Marker marker0 = markerRange0.getStart();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      char[] charArray0 = new char[1];
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.SMALL_CAPS;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 2853, 2853, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(0, 3);
      Range range0 = markerRange0.getRawRange();
      assertEquals(4, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - neHp<cte excepton: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      Range range0 = markerRange0.getRange();
      assertEquals(5, range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      Marker marker0 = markerRange0.getEnd();
      assertNull(marker0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.overlaps((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.isForwardMarker();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getStrand();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getRawStart();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getRawRange();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getRawEnd();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.extendRange((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.createLocation();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.contains((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.combineRanges((MarkerRange) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      MarkerRange markerRange0 = null;
      try {
        markerRange0 = new MarkerRange((Strand) null, (-637), (-1459));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      MarkerRange markerRange1 = Strand.getORFAroundMarker(marker0, true);
      boolean boolean0 = markerRange0.contains(markerRange1);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      boolean boolean0 = markerRange0.contains(markerRange0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      MarkerRange markerRange1 = Strand.getORFAroundMarker(marker0, true);
      boolean boolean0 = markerRange1.contains(markerRange0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 0);
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      MarkerRange markerRange1 = markerRange0.combineRanges(markerRange0, true);
      assertFalse(markerRange1.equals((Object)markerRange0));
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "internal error - unexpected exception: ");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "internal error - unexpected exception: ");
      Strand strand0 = bases0.getForwardStrand();
      filteredEntryGroup0.reverseComplement();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      MarkerRange markerRange1 = simpleGotoEventSource0.gotoBase(5);
      // Undeclared exception!
      try { 
        markerRange0.combineRanges(markerRange1, false);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - strands do not match
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(1);
      Range range0 = markerRange0.getRawRange();
      assertEquals(1, range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      Range range0 = markerRange0.getRawRange();
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      Marker marker0 = markerRange0.getRawEnd();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      Marker marker0 = markerRange0.getRawEnd();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      Marker marker0 = markerRange0.getRawStart();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      Marker marker0 = markerRange0.getEnd();
      MarkerRange markerRange1 = Strand.getORFAroundMarker(marker0, true);
      Marker marker1 = markerRange1.getRawStart();
      assertFalse(marker1.equals((Object)marker0));
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("=!");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = null;
      try {
        markerRange0 = new MarkerRange(strand0, 0, (-3799));
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // position: -3799
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      Marker marker0 = markerRange0.getStart();
      assertNull(marker0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 0);
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      Strand strand1 = markerRange0.getStrand();
      assertEquals(1, Strand.FORWARD);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      MarkerRange markerRange1 = new MarkerRange(marker0);
      MarkerRange markerRange2 = markerRange0.combineRanges(markerRange1, true);
      assertFalse(markerRange2.equals((Object)markerRange1));
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions(2, 1);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      MarkerRange markerRange1 = Strand.getORFAroundMarker(marker0, true);
      MarkerRange markerRange2 = markerRange1.combineRanges(markerRange0, true);
      assertFalse(markerRange2.equals((Object)markerRange0));
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      MarkerRange markerRange1 = markerRange0.combineRanges(markerRange0, false);
      assertFalse(markerRange1.equals((Object)markerRange0));
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      MarkerRange markerRange1 = strand0.makeMarkerRangeFromRawPositions(1, 2);
      MarkerRange markerRange2 = markerRange1.combineRanges(markerRange0, true);
      assertFalse(markerRange2.equals((Object)markerRange0));
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Strand strand0 = new Strand(bases0, 0);
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange1 = simpleGotoEventSource0.gotoBase(1);
      // Undeclared exception!
      try { 
        markerRange0.extendRange(markerRange1);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - strands do not match
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Strand strand0 = new Strand(bases0, 0);
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange1 = simpleGotoEventSource0.gotoBase(1);
      boolean boolean0 = markerRange0.overlaps(markerRange1);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Strand strand0 = new Strand(bases0, 0);
      MarkerRange markerRange0 = new MarkerRange(strand0, 5, 5);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange1 = simpleGotoEventSource0.gotoBase(1);
      assertNotNull(markerRange1);
      
      boolean boolean0 = markerRange1.overlaps(markerRange0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      MarkerRange markerRange1 = Strand.getORFAroundMarker(marker0, true);
      boolean boolean0 = markerRange0.overlaps(markerRange1);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      Location location0 = markerRange0.createLocation();
      assertNotNull(location0);
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      Location location0 = markerRange0.createLocation();
      assertNotNull(location0);
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      int int0 = markerRange0.getCount();
      assertEquals(4, int0);
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")-?Y~F5");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(5);
      boolean boolean0 = markerRange0.isForwardMarker();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(5, 2);
      int int0 = markerRange0.getCount();
      assertEquals(4, int0);
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getRange();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }
}
