/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.HashMap;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.xpath.XPathException;

public final class Tokenizer {
    private int state = 0;
    public static final int DEFAULT_STATE = 0;
    public static final int BARE_NAME_STATE = 1;
    public static final int SEQUENCE_TYPE_STATE = 2;
    public static final int OPERATOR_STATE = 3;
    public static final int UNKNOWN = -1;
    public static final int EOF = 0;
    public static final int UNION = 1;
    public static final int SLASH = 2;
    public static final int AT = 3;
    public static final int LSQB = 4;
    public static final int LPAR = 5;
    public static final int EQUALS = 6;
    public static final int COMMA = 7;
    public static final int SLSL = 8;
    public static final int OR = 9;
    public static final int AND = 10;
    public static final int GT = 11;
    public static final int LT = 12;
    public static final int GE = 13;
    public static final int LE = 14;
    public static final int PLUS = 15;
    public static final int MINUS = 16;
    public static final int MULT = 17;
    public static final int DIV = 18;
    public static final int MOD = 19;
    public static final int IS = 20;
    public static final int DOLLAR = 21;
    public static final int NE = 22;
    public static final int INTERSECT = 23;
    public static final int EXCEPT = 24;
    public static final int RETURN = 25;
    public static final int THEN = 26;
    public static final int ELSE = 27;
    public static final int WHERE = 28;
    public static final int TO = 29;
    public static final int IN = 30;
    public static final int SOME = 31;
    public static final int EVERY = 32;
    public static final int SATISFIES = 33;
    public static final int FUNCTION = 34;
    public static final int AXIS = 35;
    public static final int IF = 36;
    public static final int PRECEDES = 37;
    public static final int FOLLOWS = 38;
    public static final int COLONCOLON = 39;
    public static final int COLONSTAR = 40;
    public static final int INSTANCE_OF = 41;
    public static final int CAST_AS = 42;
    public static final int TREAT_AS = 43;
    public static final int FEQ = 44;
    public static final int FNE = 45;
    public static final int FGT = 46;
    public static final int FLT = 47;
    public static final int FGE = 48;
    public static final int FLE = 49;
    public static final int IDIV = 50;
    public static final int CASTABLE_AS = 51;
    public static final int ASSIGN = 52;
    public static final int LCURLY = 53;
    public static final int KEYWORD_CURLY = 54;
    public static final int ELEMENT_QNAME = 55;
    public static final int ATTRIBUTE_QNAME = 56;
    public static final int PI_QNAME = 57;
    public static final int TYPESWITCH = 58;
    public static final int CASE = 59;
    public static final int DEFAULT = 60;
    public static final int XQUERY_VERSION = 70;
    public static final int DECLARE_NAMESPACE = 71;
    public static final int DECLARE_DEFAULT = 72;
    public static final int DECLARE_VALIDATION = 73;
    public static final int DECLARE_BASEURI = 74;
    public static final int DECLARE_XMLSPACE = 75;
    public static final int IMPORT_SCHEMA = 76;
    public static final int IMPORT_MODULE = 77;
    public static final int DECLARE_VARIABLE = 78;
    public static final int DECLARE_FUNCTION = 79;
    public static final int MODULE_NAMESPACE = 80;
    public static final int VALIDATE = 81;
    public static final int VALIDATE_STRICT = 82;
    public static final int VALIDATE_LAX = 83;
    public static final int VALIDATE_SKIP = 84;
    public static final int VALIDATE_GLOBAL = 85;
    public static final int VALIDATE_CONTEXT = 86;
    public static final int SEMICOLON = 90;
    static int LAST_OPERATOR = 100;
    public static final int NAME = 101;
    public static final int STRING_LITERAL = 102;
    public static final int RSQB = 103;
    public static final int RPAR = 104;
    public static final int DOT = 105;
    public static final int DOTDOT = 106;
    public static final int STAR = 107;
    public static final int PREFIX = 108;
    public static final int NUMBER = 109;
    public static final int NODEKIND = 110;
    public static final int FOR = 111;
    public static final int SUFFIX = 112;
    public static final int QMARK = 113;
    public static final int TYPETEST = 114;
    public static final int RCURLY = 115;
    public static final int LET = 116;
    public static final int TAG = 117;
    public static final int NEGATE = 199;
    public static String[] tokens = new String[200];
    public static HashMap doubleKeywords;
    public int currentToken = 0;
    public String currentTokenValue = null;
    public int currentTokenStartIndex = 0;
    private int nextToken = 0;
    private String nextTokenValue = null;
    private int nextTokenStartIndex = 0;
    public String input;
    public int inputIndex = 0;
    private int inputLength;
    private int lineNumber = 1;
    private int nextLineNumber = 1;
    private int precedingToken = -1;

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
        if (n == 0) {
            this.precedingToken = -1;
            this.currentToken = -1;
        } else if (n == 3) {
            this.precedingToken = 104;
            this.currentToken = 104;
        }
    }

    private static void mapDouble(String string, int n) {
        doubleKeywords.put(string, new Integer(n));
        Tokenizer.tokens[n] = string;
    }

    public void tokenize(String string, int n, int n2) throws XPathException {
        this.nextToken = 0;
        this.nextTokenValue = null;
        this.nextTokenStartIndex = 0;
        this.inputIndex = n;
        this.input = string;
        this.inputLength = n2 == -1 ? string.length() : n2;
        this.lookAhead();
        this.next();
    }

    public void next() throws XPathException {
        this.precedingToken = this.currentToken;
        this.currentToken = this.nextToken;
        this.currentTokenValue = this.nextTokenValue;
        this.currentTokenStartIndex = this.nextTokenStartIndex;
        this.lineNumber = this.nextLineNumber;
        switch (this.currentToken) {
            case 101: {
                int n = Tokenizer.getBinaryOp(this.currentTokenValue);
                if (n == -1 || this.followsOperator()) break;
                this.currentToken = n;
                break;
            }
            case 12: {
                if (!this.followsOperator()) break;
                this.currentToken = 117;
                break;
            }
            case 107: {
                if (this.followsOperator()) break;
                this.currentToken = 17;
            }
        }
        if (this.currentToken == 117 || this.currentToken == 115) {
            return;
        }
        this.lookAhead();
        if (this.currentToken == 101) {
            if (this.state == 1) {
                return;
            }
            switch (this.nextToken) {
                case 5: {
                    int n = Tokenizer.getBinaryOp(this.currentTokenValue);
                    if (n != -1) {
                        this.currentToken = n;
                        break;
                    }
                    this.currentToken = Tokenizer.getFunctionType(this.currentTokenValue);
                    this.lookAhead();
                    break;
                }
                case 53: {
                    if (this.state == 2) break;
                    this.currentToken = 54;
                    this.lookAhead();
                    break;
                }
                case 39: {
                    this.lookAhead();
                    this.currentToken = 35;
                    break;
                }
                case 40: {
                    this.lookAhead();
                    this.currentToken = 108;
                    break;
                }
                case 21: {
                    if (this.currentTokenValue == "for") {
                        this.currentToken = 111;
                        break;
                    }
                    if (this.currentTokenValue == "some") {
                        this.currentToken = 31;
                        break;
                    }
                    if (this.currentTokenValue == "every") {
                        this.currentToken = 32;
                        break;
                    }
                    if (this.currentTokenValue != "let") break;
                    this.currentToken = 116;
                    break;
                }
                case 101: {
                    Object object;
                    String string;
                    int n = -1;
                    if (this.currentTokenValue.equals("element")) {
                        n = 55;
                    } else if (this.currentTokenValue.equals("attribute")) {
                        n = 56;
                    } else if (this.currentTokenValue.equals("processing-instruction")) {
                        n = 57;
                    }
                    if (n != -1) {
                        string = this.nextTokenValue;
                        object = this.currentTokenValue;
                        int n2 = this.inputIndex;
                        this.lookAhead();
                        if (this.nextToken == 53) {
                            this.currentToken = n;
                            this.currentTokenValue = string;
                            this.lookAhead();
                            return;
                        }
                        this.currentToken = 101;
                        this.currentTokenValue = object;
                        this.inputIndex = n2;
                        this.nextToken = 101;
                        this.nextTokenValue = string;
                    }
                    if ((object = (Integer)doubleKeywords.get(string = this.currentTokenValue + " " + this.nextTokenValue)) == null) break;
                    this.currentToken = (Integer)object;
                    this.currentTokenValue = string;
                    this.lookAhead();
                    return;
                }
            }
        }
    }

    public void treatCurrentAsOperator() {
        switch (this.currentToken) {
            case 101: {
                int n = Tokenizer.getBinaryOp(this.currentTokenValue);
                if (n == -1) break;
                this.currentToken = n;
                break;
            }
            case 107: {
                this.currentToken = 17;
            }
        }
    }

    public void lookAhead() throws XPathException {
        char c;
        this.precedingToken = this.nextToken;
        this.nextTokenValue = null;
        this.nextTokenStartIndex = this.inputIndex;
        block39: while (true) {
            if (this.inputIndex >= this.inputLength) {
                this.nextToken = 0;
                return;
            }
            c = this.input.charAt(this.inputIndex++);
            switch (c) {
                case '/': {
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == '/') {
                        ++this.inputIndex;
                        this.nextToken = 8;
                        return;
                    }
                    this.nextToken = 2;
                    return;
                }
                case ':': {
                    if (this.inputIndex < this.inputLength) {
                        if (this.input.charAt(this.inputIndex) == ':') {
                            ++this.inputIndex;
                            this.nextToken = 39;
                            return;
                        }
                        if (this.input.charAt(this.inputIndex) == '=') {
                            this.nextToken = 52;
                            ++this.inputIndex;
                            return;
                        }
                    }
                    throw new XPathException.Static("Unexpected colon at start of token");
                }
                case '@': {
                    this.nextToken = 3;
                    return;
                }
                case '?': {
                    this.nextToken = 113;
                    return;
                }
                case '[': {
                    this.nextToken = 4;
                    return;
                }
                case ']': {
                    this.nextToken = 103;
                    return;
                }
                case '{': {
                    this.nextToken = 53;
                    return;
                }
                case '}': {
                    this.nextToken = 115;
                    return;
                }
                case ';': {
                    this.nextToken = 90;
                    this.state = 0;
                    return;
                }
                case '(': {
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == ':') {
                        ++this.inputIndex;
                        int n = 1;
                        while (n > 0 && this.inputIndex < this.inputLength - 1) {
                            if (this.input.charAt(this.inputIndex) == '\n') {
                                ++this.nextLineNumber;
                            } else if (this.input.charAt(this.inputIndex) == ':' && this.input.charAt(this.inputIndex + 1) == ')') {
                                --n;
                                ++this.inputIndex;
                            } else if (this.input.charAt(this.inputIndex) == '(' && this.input.charAt(this.inputIndex + 1) == ':') {
                                ++n;
                                ++this.inputIndex;
                            }
                            ++this.inputIndex;
                        }
                        if (n > 0) {
                            throw new XPathException.Static("Unclosed XPath comment");
                        }
                        this.lookAhead();
                    } else {
                        this.nextToken = 5;
                    }
                    return;
                }
                case ')': {
                    this.nextToken = 104;
                    return;
                }
                case '+': {
                    this.nextToken = 15;
                    return;
                }
                case '-': {
                    this.nextToken = 16;
                    return;
                }
                case '=': {
                    this.nextToken = 6;
                    return;
                }
                case '!': {
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == '=') {
                        ++this.inputIndex;
                        this.nextToken = 22;
                        return;
                    }
                    throw new XPathException.Static("\u00ab!\u00bb without \u00ab=\u00bb");
                }
                case '*': {
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == ':') {
                        char c2;
                        ++this.inputIndex;
                        this.nextToken = 112;
                        if (this.inputIndex < this.inputLength && " \r\t\n".indexOf(c2 = this.input.charAt(this.inputIndex)) >= 0) {
                            throw new XPathException.Static("Whitespace is not allowed after \u00ab*:\u00bb");
                        }
                        return;
                    }
                    this.nextToken = 107;
                    return;
                }
                case ',': {
                    this.nextToken = 7;
                    return;
                }
                case '$': {
                    this.nextToken = 21;
                    return;
                }
                case '|': {
                    this.nextToken = 1;
                    return;
                }
                case '<': {
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == '=') {
                        ++this.inputIndex;
                        this.nextToken = 14;
                        return;
                    }
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == '<') {
                        ++this.inputIndex;
                        this.nextToken = 37;
                        return;
                    }
                    this.nextToken = 12;
                    return;
                }
                case '>': {
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == '=') {
                        ++this.inputIndex;
                        this.nextToken = 13;
                        return;
                    }
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == '>') {
                        ++this.inputIndex;
                        this.nextToken = 38;
                        return;
                    }
                    this.nextToken = 11;
                    return;
                }
                case '.': {
                    if (this.inputIndex < this.inputLength && this.input.charAt(this.inputIndex) == '.') {
                        ++this.inputIndex;
                        this.nextToken = 106;
                        return;
                    }
                    if (this.inputIndex == this.inputLength || this.input.charAt(this.inputIndex) < '0' || this.input.charAt(this.inputIndex) > '9') {
                        this.nextToken = 105;
                        return;
                    }
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    boolean bl = true;
                    boolean bl2 = false;
                    boolean bl3 = true;
                    boolean bl4 = false;
                    block41: while (!bl4) {
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                bl2 = false;
                                break;
                            }
                            case '.': {
                                if (bl3) {
                                    bl3 = false;
                                    bl2 = false;
                                    break;
                                }
                                --this.inputIndex;
                                break block41;
                            }
                            case 'E': 
                            case 'e': {
                                if (bl) {
                                    bl2 = true;
                                    bl = false;
                                    break;
                                }
                                --this.inputIndex;
                                break block41;
                            }
                            case '+': 
                            case '-': {
                                if (bl2) {
                                    bl2 = false;
                                    break;
                                }
                                --this.inputIndex;
                                break block41;
                            }
                            default: {
                                --this.inputIndex;
                                break block41;
                            }
                        }
                        if (this.inputIndex >= this.inputLength) break;
                        c = this.input.charAt(this.inputIndex++);
                    }
                    this.nextTokenValue = this.input.substring(this.nextTokenStartIndex, this.inputIndex);
                    this.nextToken = 109;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.nextTokenValue = "";
                    while (true) {
                        this.inputIndex = this.input.indexOf(c, this.inputIndex);
                        if (this.inputIndex < 0) {
                            this.inputIndex = this.nextTokenStartIndex + 1;
                            throw new XPathException.Static("Unmatched quote in expression");
                        }
                        this.nextTokenValue = this.nextTokenValue + this.input.substring(this.nextTokenStartIndex + 1, this.inputIndex++);
                        if (this.inputIndex >= this.inputLength || this.input.charAt(this.inputIndex) != c) break;
                        this.nextTokenValue = this.nextTokenValue + c;
                        this.nextTokenStartIndex = this.inputIndex++;
                    }
                    if (this.nextTokenValue.indexOf(10) >= 0) {
                        int n = 0;
                        while (n < this.nextTokenValue.length()) {
                            if (this.nextTokenValue.charAt(n) == '\n') {
                                ++this.lineNumber;
                            }
                            ++n;
                        }
                    }
                    this.nextTokenValue = this.nextTokenValue.intern();
                    this.nextToken = 102;
                    return;
                }
                case '\n': {
                    ++this.nextLineNumber;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    this.nextTokenStartIndex = this.inputIndex;
                    continue block39;
                }
                default: {
                    if (c >= '\u0080' || Character.isLetter(c)) break block39;
                    throw new XPathException.Static("Invalid character \u00ab" + c + "\u00bb in expression");
                }
                case '_': 
            }
            break;
        }
        block44: while (this.inputIndex < this.inputLength) {
            c = this.input.charAt(this.inputIndex);
            switch (c) {
                case ':': {
                    if (this.inputIndex + 1 >= this.inputLength) break;
                    char c3 = this.input.charAt(this.inputIndex + 1);
                    if (c3 == ':') {
                        this.nextTokenValue = this.input.substring(this.nextTokenStartIndex, this.inputIndex).intern();
                        this.nextToken = 35;
                        this.inputIndex += 2;
                        return;
                    }
                    if (c3 == '*') {
                        this.nextTokenValue = this.input.substring(this.nextTokenStartIndex, this.inputIndex).intern();
                        this.nextToken = 108;
                        this.inputIndex += 2;
                        return;
                    }
                    if (c3 != '=') break;
                    this.nextTokenValue = this.input.substring(this.nextTokenStartIndex, this.inputIndex).intern();
                    this.nextToken = 101;
                    return;
                }
                case '-': 
                case '.': 
                case '_': {
                    break;
                }
                default: {
                    if (c < '\u0080' && !Character.isLetterOrDigit(c)) break block44;
                }
            }
            ++this.inputIndex;
        }
        this.nextTokenValue = this.input.substring(this.nextTokenStartIndex, this.inputIndex).intern();
        this.nextToken = 101;
    }

    private static int getBinaryOp(String string) {
        switch (string.length()) {
            case 2: {
                if (string == "or") {
                    return 9;
                }
                if (string == "is") {
                    return 20;
                }
                if (string == "to") {
                    return 29;
                }
                if (string == "in") {
                    return 30;
                }
                if (string == "eq") {
                    return 44;
                }
                if (string == "ne") {
                    return 45;
                }
                if (string == "gt") {
                    return 46;
                }
                if (string == "ge") {
                    return 48;
                }
                if (string == "lt") {
                    return 47;
                }
                if (string != "le") break;
                return 49;
            }
            case 3: {
                if (string == "and") {
                    return 10;
                }
                if (string == "div") {
                    return 18;
                }
                if (string != "mod") break;
                return 19;
            }
            case 4: {
                if (string == "idiv") {
                    return 50;
                }
                if (string == "then") {
                    return 26;
                }
                if (string == "else") {
                    return 27;
                }
                if (string != "case") break;
                return 59;
            }
            case 5: {
                if (string == "where") {
                    return 28;
                }
                if (string != "union") break;
                return 1;
            }
            case 6: {
                if (string == "except") {
                    return 24;
                }
                if (string != "return") break;
                return 25;
            }
            case 7: {
                if (string == "default") {
                    return 60;
                }
            }
            case 9: {
                if (string == "intersect") {
                    return 23;
                }
                if (string != "satisfies") break;
                return 33;
            }
        }
        return -1;
    }

    private static int getFunctionType(String string) {
        switch (string.length()) {
            case 2: {
                if (string != "if") break;
                return 36;
            }
            case 4: {
                if (string == "node") {
                    return 110;
                }
                if (string == "item") {
                    return 110;
                }
                if (string == "text") {
                    return 110;
                }
                if (string != "type") break;
                return 114;
            }
            case 7: {
                if (string == "element") {
                    return 110;
                }
                if (string != "comment") break;
                return 110;
            }
            case 9: {
                if (string == "attribute") {
                    return 110;
                }
                if (string != "namespace") break;
                return 110;
            }
            case 10: {
                if (string != "typeswitch") break;
                return 58;
            }
            default: {
                if (string == "document-node") {
                    return 110;
                }
                if (string != "processing-instruction") break;
                return 110;
            }
        }
        return 34;
    }

    private boolean followsOperator() {
        return this.precedingToken <= LAST_OPERATOR;
    }

    public char nextChar() throws StringIndexOutOfBoundsException {
        char c;
        if ((c = this.input.charAt(this.inputIndex++)) == '\n') {
            ++this.nextLineNumber;
            ++this.lineNumber;
        }
        return c;
    }

    public void unreadChar() {
        if (this.input.charAt(--this.inputIndex) == '\n') {
            --this.nextLineNumber;
            --this.lineNumber;
        }
    }

    public String recentText() {
        if (this.inputIndex > this.inputLength) {
            this.inputIndex = this.inputLength;
        }
        if (this.inputIndex < 34) {
            return this.input.substring(0, this.inputIndex);
        }
        return NormalizeSpace.normalize("..." + this.input.substring(this.inputIndex - 30, this.inputIndex));
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLexicalSubstring(int n, int n2) {
        return this.input.substring(n, n2);
    }

    static {
        Tokenizer.tokens[0] = "<eof>";
        Tokenizer.tokens[1] = "|";
        Tokenizer.tokens[2] = "/";
        Tokenizer.tokens[3] = "@";
        Tokenizer.tokens[4] = "[";
        Tokenizer.tokens[5] = "(";
        Tokenizer.tokens[6] = "=";
        Tokenizer.tokens[7] = ",";
        Tokenizer.tokens[8] = "//";
        Tokenizer.tokens[9] = "or";
        Tokenizer.tokens[10] = "and";
        Tokenizer.tokens[11] = ">";
        Tokenizer.tokens[12] = "<";
        Tokenizer.tokens[13] = ">=";
        Tokenizer.tokens[14] = "<=";
        Tokenizer.tokens[15] = "+";
        Tokenizer.tokens[16] = "-";
        Tokenizer.tokens[17] = "*";
        Tokenizer.tokens[18] = "div";
        Tokenizer.tokens[19] = "mod";
        Tokenizer.tokens[20] = "is";
        Tokenizer.tokens[21] = "$";
        Tokenizer.tokens[22] = "!=";
        Tokenizer.tokens[23] = "intersect";
        Tokenizer.tokens[24] = "except";
        Tokenizer.tokens[25] = "return";
        Tokenizer.tokens[26] = "then";
        Tokenizer.tokens[27] = "else";
        Tokenizer.tokens[29] = "to";
        Tokenizer.tokens[30] = "in";
        Tokenizer.tokens[31] = "some";
        Tokenizer.tokens[32] = "every";
        Tokenizer.tokens[33] = "satisfies";
        Tokenizer.tokens[34] = "<function>(";
        Tokenizer.tokens[35] = "<axis>";
        Tokenizer.tokens[36] = "if(";
        Tokenizer.tokens[37] = "<<";
        Tokenizer.tokens[38] = ">>";
        Tokenizer.tokens[39] = "::";
        Tokenizer.tokens[40] = ":*";
        Tokenizer.tokens[41] = "instance of";
        Tokenizer.tokens[42] = "cast as";
        Tokenizer.tokens[43] = "treat as";
        Tokenizer.tokens[44] = "eq";
        Tokenizer.tokens[45] = "ne";
        Tokenizer.tokens[46] = "gt";
        Tokenizer.tokens[48] = "ge";
        Tokenizer.tokens[47] = "lt";
        Tokenizer.tokens[49] = "le";
        Tokenizer.tokens[50] = "idiv";
        Tokenizer.tokens[51] = "castable as";
        Tokenizer.tokens[52] = ":=";
        Tokenizer.tokens[58] = "typeswitch";
        Tokenizer.tokens[59] = "case";
        Tokenizer.tokens[60] = "default";
        Tokenizer.tokens[101] = "<name>";
        Tokenizer.tokens[102] = "<string-literal>";
        Tokenizer.tokens[103] = "]";
        Tokenizer.tokens[104] = ")";
        Tokenizer.tokens[105] = ".";
        Tokenizer.tokens[106] = "..";
        Tokenizer.tokens[107] = "*";
        Tokenizer.tokens[108] = "<prefix:*>";
        Tokenizer.tokens[109] = "<numeric-literal>";
        Tokenizer.tokens[110] = "<node-type>()";
        Tokenizer.tokens[111] = "for";
        Tokenizer.tokens[112] = "<*:local-name>";
        Tokenizer.tokens[113] = "?";
        Tokenizer.tokens[114] = "type(";
        Tokenizer.tokens[53] = "{";
        Tokenizer.tokens[54] = "<keyword> {";
        Tokenizer.tokens[115] = "}";
        Tokenizer.tokens[116] = "let";
        Tokenizer.tokens[81] = "validate {";
        Tokenizer.tokens[90] = ";";
        Tokenizer.tokens[199] = "-";
        doubleKeywords = new HashMap(30);
        Tokenizer.mapDouble("instance of", 41);
        Tokenizer.mapDouble("cast as", 42);
        Tokenizer.mapDouble("treat as", 43);
        Tokenizer.mapDouble("castable as", 51);
        Tokenizer.mapDouble("xquery version", 70);
        Tokenizer.mapDouble("declare namespace", 71);
        Tokenizer.mapDouble("declare default", 72);
        Tokenizer.mapDouble("declare validation", 73);
        Tokenizer.mapDouble("declare base-uri", 74);
        Tokenizer.mapDouble("declare xmlspace", 75);
        Tokenizer.mapDouble("import schema", 76);
        Tokenizer.mapDouble("import module", 77);
        Tokenizer.mapDouble("declare variable", 78);
        Tokenizer.mapDouble("declare function", 79);
        Tokenizer.mapDouble("module namespace", 80);
        Tokenizer.mapDouble("validate strict", 82);
        Tokenizer.mapDouble("validate lax", 83);
        Tokenizer.mapDouble("validate skip", 84);
        Tokenizer.mapDouble("validate global", 85);
        Tokenizer.mapDouble("validate context", 86);
    }
}

