
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsesong.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bsemathsignal.hh>
#include <bse/bsesong.hh>
#include <bse/bsebus.hh>
#include <bse/bsepart.hh>
#include <bse/bsetrack.hh>
#include "bsemidireceiver.hh"
#include "bseundostack.hh"
#include "bseproject.hh"
#include "gslcommon.hh"
#include "bseengine.hh"
#include "bsecxxplugin.hh"
#include <string.h>
/* --- create-bus --- */
static void
create_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 18 "bsesong.proc"
 {
#line 20 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 24 "bsesong.proc"
}  }
static BseErrorType
#line 24 "bsesong.proc"
create_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 27 "bsesong.proc"
{
#line 28 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseUndoStack *ustack;
  BseItem *child = NULL;
#line 33 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 36 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      ustack = bse_item_undo_open (self, "create-bus");
      child = (BseItem*) bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_BUS, NULL);
      bse_item_push_undo_proc (self, "remove-bus", child);
      bse_item_undo_close (ustack);
    }
#line 46 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  return error;
}
/* --- remove-bus --- */
static void
remove_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 50 "bsesong.proc"
 {
#line 52 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 56 "bsesong.proc"
}  }
static BseErrorType
#line 56 "bsesong.proc"
remove_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 59 "bsesong.proc"
{
#line 60 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BseItem *child = (BseItem*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 64 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_BUS (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 67 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 73 "bsesong.proc"
      
      bse_item_set (child, "master-output", FALSE, NULL);
#line 75 "bsesong.proc"
      
#line 76 "bsesong.proc"
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);     
#line 77 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-bus", child);
#line 79 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 81 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }
  return error;
}
/* --- ensure-master-bus --- */
static void
ensure_master_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 86 "bsesong.proc"
 {
#line 88 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 92 "bsesong.proc"
}  }
static BseErrorType
#line 92 "bsesong.proc"
ensure_master_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 95 "bsesong.proc"
{
#line 96 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BseSource *child;
#line 99 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 102 "bsesong.proc"
  
  child = bse_song_ensure_master (self);
#line 104 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  return BSE_ERROR_NONE;
}
/* --- get-master-bus --- */
static void
get_master_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 108 "bsesong.proc"
 {
#line 110 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 114 "bsesong.proc"
}  }
static BseErrorType
#line 114 "bsesong.proc"
get_master_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 117 "bsesong.proc"
{
#line 118 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
#line 120 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 123 "bsesong.proc"
  
  BseBus *bus = bse_song_find_master (self);
#line 125 "bsesong.proc"
  
  bse_value_set_object (out_values++, bus);
  return BSE_ERROR_NONE;
}
static const gchar*
orphans_track_name (void)
{
#line 132 "bsesong.proc"
  
  return _("Orphan Parts");
}
static BseTrack*
bse_song_ensure_orphans_track_noundo (BseSong *self)
{
  for (SfiRing *ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *track = (BseTrack*) ring->data;
      gboolean muted = FALSE;
      g_object_get (track, "muted", &muted, NULL);
#line 145 "bsesong.proc"
      if (muted && g_object_get_data ((GObject*) track, "BseSong-orphan-track") == bse_song_ensure_orphans_track_noundo) 
        return track;
    }
  BseTrack *child = (BseTrack*) bse_container_new_child_bname (BSE_CONTAINER (self), BSE_TYPE_TRACK, orphans_track_name(), NULL);
#line 149 "bsesong.proc"
  g_object_set (child, "muted", TRUE, NULL); 
#line 150 "bsesong.proc"
  g_object_set_data ((GObject*) child, "BseSong-orphan-track", (void*) bse_song_ensure_orphans_track_noundo); 
  return child;
}
static BseTrack*
bse_song_find_first_track (BseSong *self,
                           BsePart *part)
{
  SfiRing *ring;
#line 158 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *track = (BseTrack*) ring->data;
      guint start;
      if (bse_track_find_part (track, part, &start))
        return track;
    }
  return NULL;
}
/* --- ensure-track-links --- */
static void
ensure_track_links_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 168 "bsesong.proc"
 {
#line 170 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
#line 172 "bsesong.proc"
}  }
static BseErrorType
#line 172 "bsesong.proc"
ensure_track_links_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 175 "bsesong.proc"
{
#line 176 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
#line 178 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 181 "bsesong.proc"
  
  gboolean clear_undo = FALSE;
  SfiRing *ring;
  for (ring = self->parts; ring; ring = sfi_ring_walk (ring, self->parts))
    if (!bse_song_find_first_track (self, (BsePart*) ring->data))
      {
        BseTrack *track = bse_song_ensure_orphans_track_noundo (self);
        bse_item_exec_void (track, "insert-part", bse_track_get_last_tick (track), ring->data);
        clear_undo = TRUE;
      }
  if (clear_undo)
    {
      BseProject *project = bse_item_get_project (BSE_ITEM (self));
      if (project)
        bse_project_clear_undo (project);
    }
  return BSE_ERROR_NONE;
}
/* --- create-part --- */
static void
create_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 199 "bsesong.proc"
 {
#line 201 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("part", NULL, NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 205 "bsesong.proc"
}  }
static BseErrorType
#line 205 "bsesong.proc"
create_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 208 "bsesong.proc"
{
#line 209 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  BseItem *child;
#line 213 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 216 "bsesong.proc"
  
  ustack = bse_item_undo_open (self, "create-part");
  child = (BseItem*) bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_PART, NULL);
  bse_item_push_undo_proc (self, "remove-part", child);
  bse_item_undo_close (ustack);
#line 221 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  return BSE_ERROR_NONE;
}
/* --- remove-part --- */
static void
remove_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 225 "bsesong.proc"
 {
#line 227 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 231 "bsesong.proc"
}  }
static BseErrorType
#line 231 "bsesong.proc"
remove_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 234 "bsesong.proc"
{
#line 235 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BseItem *child = (BseItem*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 239 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 242 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 248 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 250 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-part", child);
#line 252 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 254 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }
  return error;
}
/* --- create-track --- */
static void
create_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 259 "bsesong.proc"
 {
#line 261 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 265 "bsesong.proc"
}  }
static BseErrorType
#line 265 "bsesong.proc"
create_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 268 "bsesong.proc"
{
#line 269 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseItem *child = NULL;
#line 273 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 276 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "create-track");
      child = (BseItem*) bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_TRACK, NULL);
      bse_item_push_undo_proc (self, "remove-track", child);
      bse_item_undo_close (ustack);
    }
#line 286 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  return error;
}
/* --- remove-track --- */
static void
remove_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 290 "bsesong.proc"
 {
#line 292 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 296 "bsesong.proc"
}  }
static BseErrorType
#line 296 "bsesong.proc"
remove_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 299 "bsesong.proc"
{
#line 300 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BseItem *child = (BseItem*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 304 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (child) ||
      BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 308 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 314 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 316 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-track", child);
#line 318 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 320 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }
  return error;
}
/* --- find-track-for-part --- */
static void
find_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 325 "bsesong.proc"
 {
#line 327 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 333 "bsesong.proc"
}  }
static BseErrorType
#line 333 "bsesong.proc"
find_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 336 "bsesong.proc"
{
#line 337 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BsePart *part = (BsePart*) bse_value_get_object (in_values++);
  BseTrack *track = NULL;
  guint tick = 0;
  SfiRing *ring;
#line 343 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 347 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *test_track = (BseTrack*) ring->data;
      guint start;
      if (bse_track_find_part (test_track, part, &start) &&
	  (!track || start < tick))
	{
	  track = test_track;
	  tick = start;
	}
    }
#line 359 "bsesong.proc"
  
  bse_value_set_object (out_values++, track);
  return BSE_ERROR_NONE;
}
/* --- find-any-track-for-part --- */
static void
find_any_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 363 "bsesong.proc"
 {
#line 365 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 371 "bsesong.proc"
}  }
static BseErrorType
#line 371 "bsesong.proc"
find_any_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 374 "bsesong.proc"
{
#line 375 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BsePart *part = (BsePart*) bse_value_get_object (in_values++);
#line 378 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 382 "bsesong.proc"
  
  bse_value_set_object (out_values++, bse_song_find_first_track (self, part));
  return BSE_ERROR_NONE;
}
/* --- synthesize-note --- */
static void
synthesize_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 386 "bsesong.proc"
 {
#line 388 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++)    = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
#line 400 "bsesong.proc"
}  }
static BseErrorType
#line 400 "bsesong.proc"
synthesize_note_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 403 "bsesong.proc"
{
#line 404 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  BseTrack *track    = (BseTrack*) bse_value_get_object (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note      = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
#line 411 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 415 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self) && self->midi_receiver_SL)
    {
      double semitone_factor = bse_transpose_factor (self->musical_tuning, CLAMP (note, SFI_MIN_NOTE, SFI_MAX_NOTE) - SFI_KAMMER_NOTE);
      double freq = BSE_KAMMER_FREQUENCY * semitone_factor * bse_cent_tune_fast (fine_tune);
      SfiTime tstamp = gsl_tick_stamp () + bse_engine_block_size () * 2;
      BseMidiEvent *eon, *eoff;
      eon  = bse_midi_event_note_on (track->midi_channel_SL, tstamp, freq, velocity);
      eoff = bse_midi_event_note_off (track->midi_channel_SL, tstamp + duration, freq);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eon);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eoff);
      bse_midi_receiver_process_events (self->midi_receiver_SL, tstamp + duration);
      bse_project_keep_activated (BSE_PROJECT (BSE_ITEM (self)->parent), tstamp + duration);
    }
  return BSE_ERROR_NONE;
}
/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 431 "bsesong.proc"
 {
#line 433 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL, BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 436 "bsesong.proc"
}  }
static BseErrorType
#line 436 "bsesong.proc"
get_timing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 439 "bsesong.proc"
{
#line 440 "bsesong.proc"
  
  BseSong *self = (BseSong*) bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseSongTiming timing = { 0, };
#line 444 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 447 "bsesong.proc"
  
  bse_song_get_timing (self, tick, &timing);
#line 449 "bsesong.proc"
  
  bse_value_set_boxed (out_values++, &timing);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_create_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new mixer bus for a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 19;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_bus = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSong+create-bus", 
    NULL,
    "/Methods/BseSong/General/Create Bus",
    NULL,
    __enode_create_bus__fill_strings,
  },
  0, create_bus_setup, create_bus_exec, 
};
static void
__enode_remove_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a mixer bus from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 51;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_bus = {
  { (BseExportNode*) &__enode_create_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-bus", 
    NULL,
    "/Methods/BseSong/General/Remove Bus",
    NULL,
    __enode_remove_bus__fill_strings,
  },
  0, remove_bus_setup, remove_bus_exec, 
};
static void
__enode_ensure_master_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve master output bus of a song, will create one if it doesn't exist.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 87;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ensure_master_bus = {
  { (BseExportNode*) &__enode_remove_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+ensure-master-bus", 
    NULL,
    "/Methods/BseSong/General/Ensure Master Bus",
    NULL,
    __enode_ensure_master_bus__fill_strings,
  },
  0, ensure_master_bus_setup, ensure_master_bus_exec, 
};
static void
__enode_get_master_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve master output bus of a song if it exists.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 109;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_master_bus = {
  { (BseExportNode*) &__enode_ensure_master_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+get-master-bus", 
    NULL,
    "/Methods/BseSong/General/Get Master Bus",
    NULL,
    __enode_get_master_bus__fill_strings,
  },
  0, get_master_bus_setup, get_master_bus_exec, 
};
static void
__enode_ensure_track_links__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Ensure that each part in a song is inserted into at least one track.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 169;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ensure_track_links = {
  { (BseExportNode*) &__enode_get_master_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+ensure-track-links", 
    NULL,
    "/Methods/BseSong/General/Ensure Track Links",
    NULL,
    __enode_ensure_track_links__fill_strings,
  },
  0, ensure_track_links_setup, ensure_track_links_exec, 
};
static void
__enode_create_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new Part in a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 200;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_part = {
  { (BseExportNode*) &__enode_ensure_track_links, BSE_EXPORT_NODE_PROC,
    "BseSong+create-part", 
    NULL,
    "/Methods/BseSong/General/Create Part",
    NULL,
    __enode_create_part__fill_strings,
  },
  0, create_part_setup, create_part_exec, 
};
static void
__enode_remove_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a Part from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 226;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_part = {
  { (BseExportNode*) &__enode_create_part, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-part", 
    NULL,
    "/Methods/BseSong/General/Remove Part",
    NULL,
    __enode_remove_part__fill_strings,
  },
  0, remove_part_setup, remove_part_exec, 
};
static void
__enode_create_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new Track for a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 260;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_track = {
  { (BseExportNode*) &__enode_remove_part, BSE_EXPORT_NODE_PROC,
    "BseSong+create-track", 
    NULL,
    "/Methods/BseSong/General/Create Track",
    NULL,
    __enode_create_track__fill_strings,
  },
  0, create_track_setup, create_track_exec, 
};
static void
__enode_remove_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a Track from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 291;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_track = {
  { (BseExportNode*) &__enode_create_track, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-track", 
    NULL,
    "/Methods/BseSong/General/Remove Track",
    NULL,
    __enode_remove_track__fill_strings,
  },
  0, remove_track_setup, remove_track_exec, 
};
static void
__enode_find_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Find a track suitable for playing notes of a given part.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 326;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_track_for_part = {
  { (BseExportNode*) &__enode_remove_track, BSE_EXPORT_NODE_PROC,
    "BseSong+find-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Track For Part",
    NULL,
    __enode_find_track_for_part__fill_strings,
  },
  0, find_track_for_part_setup, find_track_for_part_exec, 
};
static void
__enode_find_any_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Find the first track that contains part, suitable to check for orphan parts.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 364;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_any_track_for_part = {
  { (BseExportNode*) &__enode_find_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+find-any-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Any Track For Part",
    NULL,
    __enode_find_any_track_for_part__fill_strings,
  },
  0, find_any_track_for_part_setup, find_any_track_for_part_exec, 
};
static void
__enode_synthesize_note__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Synthesize a note on a song of an active project.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 387;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_synthesize_note = {
  { (BseExportNode*) &__enode_find_any_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+synthesize-note", 
    NULL,
    "/Methods/BseSong/General/Synthesize Note",
    NULL,
    __enode_synthesize_note__fill_strings,
  },
  0, synthesize_note_setup, synthesize_note_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve song timing information at a specific tick.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 432;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_synthesize_note, BSE_EXPORT_NODE_PROC,
    "BseSong+get-timing", 
    NULL,
    "/Methods/BseSong/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsesong_genprc_cc (void)
{
  return (BseExportNode*) &__enode_get_timing;
}

/*
 * Generated data ends here
 */
