__all__ = ['scan', 'execute', 'ModuleException']

from binwalk.core.module import Modules
from binwalk.core.exceptions import ModuleException

try:
    from binwalk.core.version import __version__  # This file is auto-generated by setup.py and ignored by .gitignore
except ImportError:
    __version__ = '(unknown)'

# Convenience functions
def scan(*args, **kwargs):
    with Modules(*args, **kwargs) as m:
        objs = m.execute()
    return objs


def execute(*args, **kwargs):
    return scan(*args, **kwargs)
