<?xml version="1.0" encoding="US-ASCII"?>
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:u="http://docbook.sf.net/xmlns/unichar/1.0"
                exclude-result-prefixes="u">

<!-- ********************************************************************
     $Id: charmap.groff.xsl 6528 2007-01-19 08:54:04Z xmldoc $
     ********************************************************************

     This file is part of the XSL DocBook Stylesheet distribution.
     See ../README or http://docbook.sf.net/release/xsl/current/ for
     copyright and other information.

     ******************************************************************** -->

<xsl:character-map name="groff">

  <!-- * *************************************************************** -->
  <!-- *    Commentary -->
  <!-- * *************************************************************** -->
  <!-- * -->
  <!-- * This file maps a selection of Unicode symbols and special -->
  <!-- * characters (about 800) to corresponding groff escape sequences.-->
  <!-- * -->
  <!-- * Although the format of this file follows the "character map" -->
  <!-- * format described in the XSLT 2.0 specification[1], the file can -->
  <!-- * also be used with an appropriate XSLT 1.0 stylesheet and any -->
  <!-- * XSLT 1.0 processor. -->
  <!-- * -->
  <!-- *   [1] http://www.w3.org/TR/xslt20/#character-maps -->
  <!-- * -->
  <!-- * In order to make the character map more readable, and to make -->
  <!-- * it possible to create subsets of it at run time, it uses the -->
  <!-- * following "extension attributes" (in the "unichar" namespace): -->
  <!-- * -->
  <!-- *   - u:name   = ISO character name (e.g., "OHM SIGN") -->
  <!-- *   - u:entity = ISO entity name (e.g., "ohm") -->
  <!-- *   - u:block  = Unicode block name (e.g., "Letterlike Symbols") -->
  <!-- *   - u:class  = character class (e.g., "bullets") -->
  <!-- * -->
  <!-- * Use of such extension attributes is permitted by the XSLT 2.0 -->
  <!-- * spec; see the "Extension Attributes" section[2]. -->
  <!-- * -->
  <!-- *   [2] http://www.w3.org/TR/xslt20/#extension-attributes -->
  <!-- * -->
  <!-- * *************************************************************** -->
  <!-- *    Acknowledgements -->
  <!-- * *************************************************************** -->
  <!-- * The following references were consulted when selecting roff -->
  <!-- * mappings and character information: -->
  <!-- * -->
  <!-- *   - groff_char(7) man page[3] -->
  <!-- *   - groff info file[4]; in particular, the "Page Motions" node[5] -->
  <!-- *   - tables in "Character Sets" chapter of "XML In a Nutshell"[6] -->
  <!-- *   - Zvon Character Search[7] -->
  <!-- * -->
  <!-- *   [3] http://www.linux.se/showMan.php?TITLE=groff_char&SECTION=7 -->
  <!-- *   [4] http://www.fifi.org/cgi-bin/info2www?(groff) -->
  <!-- *   [5] http://www.fifi.org/cgi-bin/info2www?(groff)Page+Motions -->
  <!-- *   [6] http://www.ibiblio.org/xml/books/xian2/ -->
  <!-- *   [7] http://zvon.org/other/charSearch/PHP/search.php -->
  <!-- * -->
  <!-- * The initial version of this file (before the "string" mappings -->
  <!-- * were added) was generated by taking the "unichars.el" file from -->
  <!-- * Norm Walsh's "xmlunicode.el"[8] elisp distro, and running a -->
  <!-- * script on it to convert it to XML. -->
  <!-- * -->
  <!-- *   [8] http://nwalsh.com/emacs/xmlchars/ -->
  <!-- * -->
  <!-- * The idea for implementing a character map in the DocBook Project -->
  <!-- * manpages system was inspired by Steve Cheng's docbook2x[9]; -->
  <!-- * in particular, its "utf8trans" utility and character-map system. -->
  <!-- * -->
  <!-- *   [9] http://docbook2x.sourceforge.net/ -->
  <!-- * -->
  <!-- * ################################################################# -->

  <!-- * ***************************************************************** -->
  <!-- * Begin: Latin-1/ISO-8859-1 -->
  <!-- * x00a0 to x00ff -->
  <!-- * ***************************************************************** -->

  <!-- * A no-break space can be written two ways in roff; the difference, -->
  <!-- * according to the "Page Motions" node in the groff info page, is: -->
  <!-- * -->
  <!-- *   "\ " = -->
  <!-- *   An unbreakable and unpaddable (i.e. not expanded during filling) -->
  <!-- *   space. -->
  <!-- * -->
  <!-- *   "\~" = -->
  <!-- *   An unbreakable space that stretches like a normal -->
  <!-- *   inter-word space when a line is adjusted."  -->
  <!-- * -->
  <!-- * Unfortunately, roff seems to do some weird things with long -->
  <!-- * lines that only have words separated by "\~" spaces, so it's -->
  <!-- * safer just to stick with the "\ " space -->
  <xsl:output-character
   character="&#x00a0;"
   u:name="NO-BREAK SPACE"
   u:entity="nbsp"
   string="\ "
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a1;"
   u:name="INVERTED EXCLAMATION MARK"
   u:entity="iexcl"
   string="\(r!"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a2;"
   u:name="CENT SIGN"
   u:entity="cent"
   string="\(ct"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a3;"
   u:name="POUND SIGN"
   u:entity="pound"
   string="\(Po"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a4;"
   u:name="CURRENCY SIGN"
   u:entity="curren"
   string="\(Cs"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a5;"
   u:name="YEN SIGN"
   u:entity="yen"
   string="\(Ye"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a6;"
   u:name="BROKEN BAR"
   u:entity="brvbar"
   string="\(bb"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a7;"
   u:name="SECTION SIGN"
   u:entity="sect"
   string="\(sc"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a8;"
   u:name="DIAERESIS"
   u:entity="Dot"
   string="\(ad"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00a9;"
   u:name="COPYRIGHT SIGN"
   u:entity="copy"
   string="\(co"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00aa;"
   u:name="FEMININE ORDINAL INDICATOR"
   u:entity="ordf"
   string="\(Of"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00ab;"
   u:name="LEFT-POINTING DOUBLE ANGLE QUOTATION MARK"
   u:entity="laquo"
   string="\(Fo"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00ac;"
   u:name="NOT SIGN"
   u:entity="not"
   string="\(no"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <!-- * groff_char(7) man page sayxsl: "the soft hyphen control character -->
  <!-- * (prints as itself).  groff never use this character for output -->
  <!-- * (thus it is omitted in the table below); the input character 173 -->
  <!-- * is onto \%." -->
  <xsl:output-character
   character="&#x00ad;"
   u:name="SOFT HYPHEN"
   u:entity="shy"
   string="\%"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00ae;"
   u:name="REGISTERED SIGN"
   u:entity="reg"
   string="\(rg"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00af;"
   u:name="MACRON"
   u:entity="macr"
   string="\(a-"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b0;"
   u:name="DEGREE SIGN"
   u:entity="deg"
   string="\(de"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b1;"
   u:name="PLUS-MINUS SIGN"
   u:entity="plusmn"
   string="\(+-"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b2;"
   u:name="SUPERSCRIPT TWO"
   u:entity="sup2"
   string="\(S2"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b3;"
   u:name="SUPERSCRIPT THREE"
   u:entity="sup3"
   string="\(S3"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b4;"
   u:name="ACUTE ACCENT"
   u:entity="acute"
   string="\(aa"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b5;"
   u:name="MICRO SIGN"
   u:entity="micro"
   string="\(mc"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b6;"
   u:name="PILCROW SIGN"
   u:entity="para"
   string="\(ps"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <!-- * according to groff_char(7), I think the escape string \(pc -->
  <!-- * "periodcentered" could also be used for middot; not sure which -->
  <!-- * is better, but "md" mnemonic is a better fit :-) -->
  <xsl:output-character
   character="&#x00b7;"
   u:name="MIDDLE DOT"
   u:entity="middot"
   string="\(md"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b8;"
   u:name="CEDILLA"
   u:entity="cedil"
   string="\(ac"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00b9;"
   u:name="SUPERSCRIPT ONE"
   u:entity="sup1"
   string="\(S1"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00ba;"
   u:name="MASCULINE ORDINAL INDICATOR"
   u:entity="ordm"
   string="\(Om"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00bb;"
   u:name="RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK"
   u:entity="raquo"
   string="\(Fc"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00bc;"
   u:name="VULGAR FRACTION ONE QUARTER"
   u:entity="frac14"
   string="\(14"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00bd;"
   u:name="VULGAR FRACTION ONE HALF"
   u:entity="frac12"
   string="\(12"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00be;"
   u:name="VULGAR FRACTION THREE QUARTERS"
   u:entity="frac34"
   string="\(34"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00bf;"
   u:name="INVERTED QUESTION MARK"
   u:entity="iquest"
   string="\(r?"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00c0;"
   u:name="LATIN CAPITAL LETTER A WITH GRAVE"
   u:entity="Agrave"
   string="\(`A"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c1;"
   u:name="LATIN CAPITAL LETTER A WITH ACUTE"
   u:entity="Aacute"
   string="\('A"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c2;"
   u:name="LATIN CAPITAL LETTER A WITH CIRCUMFLEX"
   u:entity="Acirc"
   string="\(^A"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c3;"
   u:name="LATIN CAPITAL LETTER A WITH TILDE"
   u:entity="Atilde"
   string="\(~A"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c4;"
   u:name="LATIN CAPITAL LETTER A WITH DIAERESIS"
   u:entity="Auml"
   string="\(:A"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c5;"
   u:name="LATIN CAPITAL LETTER A WITH RING ABOVE"
   u:entity="Aring"
   string="\(oA"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c6;"
   u:name="LATIN CAPITAL LETTER AE"
   u:entity="AElig"
   string="\(AE"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c7;"
   u:name="LATIN CAPITAL LETTER C WITH CEDILLA"
   u:entity="Ccedil"
   string="\(,C"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c8;"
   u:name="LATIN CAPITAL LETTER E WITH GRAVE"
   u:entity="Egrave"
   string="\(`E"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00c9;"
   u:name="LATIN CAPITAL LETTER E WITH ACUTE"
   u:entity="Eacute"
   string="\('E"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00ca;"
   u:name="LATIN CAPITAL LETTER E WITH CIRCUMFLEX"
   u:entity="Ecirc"
   string="\(^E"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00cb;"
   u:name="LATIN CAPITAL LETTER E WITH DIAERESIS"
   u:entity="Euml"
   string="\(:E"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00cc;"
   u:name="LATIN CAPITAL LETTER I WITH GRAVE"
   u:entity="Igrave"
   string="\(`I"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00cd;"
   u:name="LATIN CAPITAL LETTER I WITH ACUTE"
   u:entity="Iacute"
   string="\('I"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00ce;"
   u:name="LATIN CAPITAL LETTER I WITH CIRCUMFLEX"
   u:entity="Icirc"
   string="\(^I"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00cf;"
   u:name="LATIN CAPITAL LETTER I WITH DIAERESIS"
   u:entity="Iuml"
   string="\(:I"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d0;"
   u:name="LATIN CAPITAL LETTER ETH"
   u:entity="ETH"
   string="\(-D"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d1;"
   u:name="LATIN CAPITAL LETTER N WITH TILDE"
   u:entity="Ntilde"
   string="\(~N"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d2;"
   u:name="LATIN CAPITAL LETTER O WITH GRAVE"
   u:entity="Ograve"
   string="\(`O"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d3;"
   u:name="LATIN CAPITAL LETTER O WITH ACUTE"
   u:entity="Oacute"
   string="\('O"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d4;"
   u:name="LATIN CAPITAL LETTER O WITH CIRCUMFLEX"
   u:entity="Ocirc"
   string="\(^O"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d5;"
   u:name="LATIN CAPITAL LETTER O WITH TILDE"
   u:entity="Otilde"
   string="\(~O"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d6;"
   u:name="LATIN CAPITAL LETTER O WITH DIAERESIS"
   u:entity="Ouml"
   string="\(:O"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d7;"
   u:name="MULTIPLICATION SIGN"
   u:entity="times"
   string="\(mu"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00d8;"
   u:name="LATIN CAPITAL LETTER O WITH STROKE"
   u:entity="Oslash"
   string="\(/O"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00d9;"
   u:name="LATIN CAPITAL LETTER U WITH GRAVE"
   u:entity="Ugrave"
   string="\(`U"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00da;"
   u:name="LATIN CAPITAL LETTER U WITH ACUTE"
   u:entity="Uacute"
   string="\('U"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00db;"
   u:name="LATIN CAPITAL LETTER U WITH CIRCUMFLEX"
   u:entity="Ucirc"
   string="\(^U"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00dc;"
   u:name="LATIN CAPITAL LETTER U WITH DIAERESIS"
   u:entity="Uuml"
   string="\(:U"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00dd;"
   u:name="LATIN CAPITAL LETTER Y WITH ACUTE"
   u:entity="Yacute"
   string="\('Y"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00de;"
   u:name="LATIN CAPITAL LETTER THORN"
   u:entity="THORN"
   string="\(TP"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00df;"
   u:name="LATIN SMALL LETTER SHARP S"
   u:entity="szlig"
   string="\(ss"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e0;"
   u:name="LATIN SMALL LETTER A WITH GRAVE"
   u:entity="agrave"
   string="\(`a"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e1;"
   u:name="LATIN SMALL LETTER A WITH ACUTE"
   u:entity="aacute"
   string="\('a"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e2;"
   u:name="LATIN SMALL LETTER A WITH CIRCUMFLEX"
   u:entity="acirc"
   string="\(^a"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e3;"
   u:name="LATIN SMALL LETTER A WITH TILDE"
   u:entity="atilde"
   string="\(~a"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e4;"
   u:name="LATIN SMALL LETTER A WITH DIAERESIS"
   u:entity="auml"
   string="\(:a"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e5;"
   u:name="LATIN SMALL LETTER A WITH RING ABOVE"
   u:entity="aring"
   string="\(oa"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e6;"
   u:name="LATIN SMALL LETTER AE"
   u:entity="aelig"
   string="\(ae"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e7;"
   u:name="LATIN SMALL LETTER C WITH CEDILLA"
   u:entity="ccedil"
   string="\(,c"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e8;"
   u:name="LATIN SMALL LETTER E WITH GRAVE"
   u:entity="egrave"
   string="\(`e"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00e9;"
   u:name="LATIN SMALL LETTER E WITH ACUTE"
   u:entity="eacute"
   string="\('e"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00ea;"
   u:name="LATIN SMALL LETTER E WITH CIRCUMFLEX"
   u:entity="ecirc"
   string="\(^e"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00eb;"
   u:name="LATIN SMALL LETTER E WITH DIAERESIS"
   u:entity="euml"
   string="\(:e"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00ec;"
   u:name="LATIN SMALL LETTER I WITH GRAVE"
   u:entity="igrave"
   string="\(`i"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00ed;"
   u:name="LATIN SMALL LETTER I WITH ACUTE"
   u:entity="iacute"
   string="\('i"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00ee;"
   u:name="LATIN SMALL LETTER I WITH CIRCUMFLEX"
   u:entity="icirc"
   string="\(^i"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00ef;"
   u:name="LATIN SMALL LETTER I WITH DIAERESIS"
   u:entity="iuml"
   string="\(:i"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f0;"
   u:name="LATIN SMALL LETTER ETH"
   u:entity="eth"
   string="\(Sd"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f1;"
   u:name="LATIN SMALL LETTER N WITH TILDE"
   u:entity="ntilde"
   string="\(~n"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f2;"
   u:name="LATIN SMALL LETTER O WITH GRAVE"
   u:entity="ograve"
   string="\(`o"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f3;"
   u:name="LATIN SMALL LETTER O WITH ACUTE"
   u:entity="oacute"
   string="\('o"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f4;"
   u:name="LATIN SMALL LETTER O WITH CIRCUMFLEX"
   u:entity="ocirc"
   string="\(^o"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f5;"
   u:name="LATIN SMALL LETTER O WITH TILDE"
   u:entity="otilde"
   string="\(~o"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f6;"
   u:name="LATIN SMALL LETTER O WITH DIAERESIS"
   u:entity="ouml"
   string="\(:o"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f7;"
   u:name="DIVISION SIGN"
   u:entity="divide"
   string="\(di"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="symbols"
   />
  <xsl:output-character
   character="&#x00f8;"
   u:name="LATIN SMALL LETTER O WITH STROKE"
   u:entity="oslash"
   string="\(/o"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00f9;"
   u:name="LATIN SMALL LETTER U WITH GRAVE"
   u:entity="ugrave"
   string="\(`u"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00fa;"
   u:name="LATIN SMALL LETTER U WITH ACUTE"
   u:entity="uacute"
   string="\('u"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00fb;"
   u:name="LATIN SMALL LETTER U WITH CIRCUMFLEX"
   u:entity="ucirc"
   string="\(^u"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00fc;"
   u:name="LATIN SMALL LETTER U WITH DIAERESIS"
   u:entity="uuml"
   string="\(:u"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00fd;"
   u:name="LATIN SMALL LETTER Y WITH ACUTE"
   u:entity="yacute"
   string="\('y"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00fe;"
   u:name="LATIN SMALL LETTER THORN"
   u:entity="thorn"
   string="\(Tp"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <xsl:output-character
   character="&#x00ff;"
   u:name="LATIN SMALL LETTER Y WITH DIAERESIS"
   u:entity="yuml"
   string="\(:y"
   u:block="C1 Controls And Latin-1 Supplement (Latin-1 Supplement)"
   u:class="letters"
   />
  <!-- * **************************************************************** -->
  <!-- *   End: Latin-1/ISO-8859-1 -->
  <!-- * **************************************************************** -->
  
  <!-- * **************************************************************** -->
  <!-- *   Begin: -->
  <!-- * -->
  <!-- *     - x0100 to x017f (Latin Extended-A) -->
  <!-- *     - x0180 to x023f (Latin Extended-B) -->
  <!-- *     - x0250 to x02ad (IPA Extensions) -->
  <!-- *     - x02b0 to x02ee (Spacing Modifier Letters) -->
  <!-- *     - x0300 to x036f (Combining Diacritical Marks) -->
  <!-- * -->
  <!-- *   Other than the following exceptions, characters in these -->
  <!-- *   blocks don't have any roff equivalents -->
  <!-- * **************************************************************** -->

  <xsl:output-character
   character="&#x0131;"
   u:name="LATIN SMALL LETTER DOTLESS I"
   u:entity="inodot"
   string="\(.i"
   u:block="Latin Extended-A"
   />
  <xsl:output-character
   character="&#x0132;"
   u:name="LATIN CAPITAL LIGATURE IJ"
   u:entity="IJlig"
   string="\(IJ"
   u:block="Latin Extended-A"
   />
  <xsl:output-character
   character="&#x0133;"
   u:name="LATIN SMALL LIGATURE IJ"
   u:entity="ijlig"
   string="\(ij"
   u:block="Latin Extended-A"
   />
  <xsl:output-character
   character="&#x0141;"
   u:name="LATIN CAPITAL LETTER L WITH STROKE"
   u:entity="Lstrok"
   string="\(/L"
   u:block="Latin Extended-A"
   />
  <xsl:output-character
   character="&#x0142;"
   u:name="LATIN SMALL LETTER L WITH STROKE"
   u:entity="lstrok"
   string="\(/l"
   u:block="Latin Extended-A"
   />
  <xsl:output-character
   character="&#x0152;"
   u:name="LATIN CAPITAL LIGATURE OE"
   u:entity="OElig"
   string="\(OE"
   u:block="Latin Extended-A"
   />
  <xsl:output-character
   character="&#x0153;"
   u:name="LATIN SMALL LIGATURE OE"
   u:entity="oelig"
   string="\(oe"
   u:block="Latin Extended-A"
   />
  <xsl:output-character
   character="&#x0192;"
   u:name="LATIN SMALL LETTER F WITH HOOK"
   u:entity="fnof"
   string="\(Fn"
   u:block="Latin Extended-B"
   />
  <xsl:output-character
   character="&#x02c6;"
   u:name="MODIFIER LETTER CIRCUMFLEX ACCENT"
   u:entity="circ"
   string="\(a^"
   u:block="Spacing Modifier Letters"
   />
  <xsl:output-character
   character="&#x02c7;"
   u:name="CARON"
   u:entity="caron"
   string="\(ac"
   u:block="Spacing Modifier Letters"
   />
  <xsl:output-character
   character="&#x02c9;"
   u:name="MODIFIER LETTER MACRON"
   string="\(a-"
   u:block="Spacing Modifier Letters"
   />
  <xsl:output-character
   character="&#x02d8;"
   u:name="BREVE"
   u:entity="breve"
   string="\(ab"
   u:block="Spacing Modifier Letters"
   />
<!-- * there does not seem to by any roff equivalent for "dot above" -->
<!-- * <xsl:output-character -->
<!-- *  character="&#x02d9;" -->
<!-- *  u:name="DOT ABOVE" -->
<!-- *  u:entity="dot" -->
<!-- *  /> -->
  <xsl:output-character
   character="&#x02da;"
   u:name="RING ABOVE"
   u:entity="ring"
   string="\(ao"
   u:block="Spacing Modifier Letters"
   />
  <xsl:output-character
   character="&#x02db;"
   u:name="OGONEK"
   u:entity="ogon"
   string="\(ho"
   u:block="Spacing Modifier Letters"
   />
  <!-- groff_char(7) calls Unicode x02dd a "Hungarian umlaut"  -->
  <xsl:output-character
   character="&#x02dd;"
   u:name="DOUBLE ACUTE ACCENT"
   u:entity="dblac"
   string='\(a"'
   u:block="Spacing Modifier Letters"
   />

  <!-- * **************************************************************** -->
  <!-- *   End: -->
  <!-- *     - Latin Extended-A -->
  <!-- *     - Latin Extended-B -->
  <!-- *     - IPA Extensions -->
  <!-- *     - Spacing Modifier Letters -->
  <!-- *     - Combining Diacritical Marks -->
  <!-- * **************************************************************** -->
  
  <!-- * **************************************************************** -->
  <!-- *   Begin: Greek and Coptic -->
  <!-- *     x0370 to x03ff -->
  <!-- * **************************************************************** -->
  
  <xsl:output-character
   character="&#x0391;"
   u:name="GREEK CAPITAL LETTER ALPHA"
   u:entity="Agr"
   string="\(*A)"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x0392;"
   u:name="GREEK CAPITAL LETTER BETA"
   u:entity="Bgr"
   string="\(*B"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x0393;"
   u:name="GREEK CAPITAL LETTER GAMMA"
   u:entity="Gamma"
   string="\(*G"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x0394;"
   u:name="GREEK CAPITAL LETTER DELTA"
   u:entity="Delta"
   string="\(*D"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x0395;"
   u:name="GREEK CAPITAL LETTER EPSILON"
   u:entity="Egr"
   string="\(*E"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x0396;"
   u:name="GREEK CAPITAL LETTER ZETA"
   u:entity="Zgr"
   string="\(*Z"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x0397;"
   u:name="GREEK CAPITAL LETTER ETA"
   u:entity="EEgr"
   string="\(*Y"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x0398;"
   u:name="GREEK CAPITAL LETTER THETA"
   u:entity="THgr"
   string="\(*H"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x0399;"
   u:name="GREEK CAPITAL LETTER IOTA"
   u:entity="Igr"
   string="\(*I"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x039a;"
   u:name="GREEK CAPITAL LETTER KAPPA"
   u:entity="Kgr"
   string="\(*K"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x039b;"
   u:name="GREEK CAPITAL LETTER LAMDA"
   u:entity="Lambda"
   string="\(*L"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x039c;"
   u:name="GREEK CAPITAL LETTER MU"
   u:entity="Mgr"
   string="\(*M"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x039d;"
   u:name="GREEK CAPITAL LETTER NU"
   u:entity="Ngr"
   string="\(*N"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x039e;"
   u:name="GREEK CAPITAL LETTER XI"
   u:entity="Xgr"
   string="\(*C"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x039f;"
   u:name="GREEK CAPITAL LETTER OMICRON"
   u:entity="Ogr"
   string="\(*O"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a0;"
   u:name="GREEK CAPITAL LETTER PI"
   u:entity="Pgr"
   string="\(*P"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a1;"
   u:name="GREEK CAPITAL LETTER RHO"
   u:entity="Rgr"
   string="\(*R"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a3;"
   u:name="GREEK CAPITAL LETTER SIGMA"
   u:entity="Sgr"
   string="\(*S"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a4;"
   u:name="GREEK CAPITAL LETTER TAU"
   u:entity="Tgr"
   string="\(*T"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a5;"
   u:name="GREEK CAPITAL LETTER UPSILON"
   u:entity="Ugr"
   string="\(*U"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a6;"
   u:name="GREEK CAPITAL LETTER PHI"
   u:entity="PHgr"
   string="\(*F"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a7;"
   u:name="GREEK CAPITAL LETTER CHI"
   u:entity="KHgr"
   string="\(*X"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a8;"
   u:name="GREEK CAPITAL LETTER PSI"
   u:entity="PSgr"
   string="\(*Q"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03a9;"
   u:name="GREEK CAPITAL LETTER OMEGA"
   u:entity="OHgr"
   string="\(*W"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03aa;"
   u:name="GREEK CAPITAL LETTER IOTA WITH DIALYTIKA"
   u:entity="Idigr"
   string="\(*I"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03ab;"
   u:name="GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA"
   u:entity="Udigr"
   string="\(*U"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03ac;"
   u:name="GREEK SMALL LETTER ALPHA WITH TONOS"
   u:entity="aacgr"
   string="\(*a"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03ad;"
   u:name="GREEK SMALL LETTER EPSILON WITH TONOS"
   u:entity="eacgr"
   string="\(*e"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03ae;"
   u:name="GREEK SMALL LETTER ETA WITH TONOS"
   u:entity="eeacgr"
   string="\(*y"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03af;"
   u:name="GREEK SMALL LETTER IOTA WITH TONOS"
   u:entity="iacgr"
   string="\(*i"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b0;"
   u:name="GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS"
   u:entity="udiagr"
   string="\(*u"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b1;"
   u:name="GREEK SMALL LETTER ALPHA"
   u:entity="agr"
   string="\(*a"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b2;"
   u:name="GREEK SMALL LETTER BETA"
   u:entity="beta"
   string="\(*b"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b3;"
   u:name="GREEK SMALL LETTER GAMMA"
   u:entity="gamma"
   string="\(*g"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b4;"
   u:name="GREEK SMALL LETTER DELTA"
   u:entity="delta"
   string="\(*d"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b5;"
   u:name="GREEK SMALL LETTER EPSILON"
   u:entity="epsi"
   string="\(*e"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b6;"
   u:name="GREEK SMALL LETTER ZETA"
   u:entity="zeta"
   string="\(*z"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b7;"
   u:name="GREEK SMALL LETTER ETA"
   u:entity="eegr"
   string="\(*y"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b8;"
   u:name="GREEK SMALL LETTER THETA"
   u:entity="thetas"
   string="\(*h"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03b9;"
   u:name="GREEK SMALL LETTER IOTA"
   u:entity="igr"
   string="\(*i"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03ba;"
   u:name="GREEK SMALL LETTER KAPPA"
   u:entity="kappa"
   string="\(*k"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03bb;"
   u:name="GREEK SMALL LETTER LAMDA"
   u:entity="lambda"
   string="\(*l"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03bc;"
   u:name="GREEK SMALL LETTER MU"
   u:entity="mgr"
   string="\(*m"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03bd;"
   u:name="GREEK SMALL LETTER NU"
   u:entity="ngr"
   string="\(*n"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03be;"
   u:name="GREEK SMALL LETTER XI"
   u:entity="xgr"
   string="\(*c"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03bf;"
   u:name="GREEK SMALL LETTER OMICRON"
   u:entity="ogr"
   string="\(*o"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c0;"
   u:name="GREEK SMALL LETTER PI"
   u:entity="pgr"
   string="\(*p"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c1;"
   u:name="GREEK SMALL LETTER RHO"
   u:entity="rgr"
   string="\(*r"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c2;"
   u:name="GREEK SMALL LETTER FINAL SIGMA"
   u:entity="sfgr"
   string="\(ts"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c3;"
   u:name="GREEK SMALL LETTER SIGMA"
   u:entity="sgr"
   string="\(*s"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c4;"
   u:name="GREEK SMALL LETTER TAU"
   u:entity="tau"
   string="\(*t"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c5;"
   u:name="GREEK SMALL LETTER UPSILON"
   u:entity="ugr"
   string="\(*u"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c6;"
   u:name="GREEK SMALL LETTER PHI"
   u:entity="phgr"
   string="\(*f"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c7;"
   u:name="GREEK SMALL LETTER CHI"
   u:entity="chi"
   string="\(*x"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c8;"
   u:name="GREEK SMALL LETTER PSI"
   u:entity="psgr"
   string="\(*q"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03c9;"
   u:name="GREEK SMALL LETTER OMEGA"
   u:entity="ohgr"
   string="\(*w"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03ca;"
   u:name="GREEK SMALL LETTER IOTA WITH DIALYTIKA"
   u:entity="idigr"
   string="\(*i"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03cb;"
   u:name="GREEK SMALL LETTER UPSILON WITH DIALYTIKA"
   u:entity="udigr"
   string="\(*u"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03cc;"
   u:name="GREEK SMALL LETTER OMICRON WITH TONOS"
   u:entity="oacgr"
   string="\(*o"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03cd;"
   u:name="GREEK SMALL LETTER UPSILON WITH TONOS"
   u:entity="uacgr"
   string="\(*u"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03ce;"
   u:name="GREEK SMALL LETTER OMEGA WITH TONOS"
   u:entity="ohacgr"
   string="\(*w"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03d0;"
   u:name="GREEK BETA SYMBOL"
   string="\(*B"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03d1;"
   u:name="GREEK THETA SYMBOL"
   u:entity="thetav"
   string="\(+h"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03d2;"
   u:name="GREEK UPSILON WITH HOOK SYMBOL"
   u:entity="Upsi"
   string="\(*U"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03d3;"
   u:name="GREEK UPSILON WITH ACUTE AND HOOK SYMBOL"
   string="\(*U"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03d4;"
   u:name="GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL"
   string="\(*U"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03d5;"
   u:name="GREEK PHI SYMBOL"
   u:entity="phis"
   string="\(+f"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03d6;"
   u:name="GREEK PI SYMBOL"
   u:entity="piv"
   string="\(+p"
   u:block="Greek and Coptic"
   />
  <!-- no mappings for remaining chars x03d7 to x03ef -->
  <xsl:output-character
   character="&#x03f0;"
   u:name="GREEK KAPPA SYMBOL"
   u:entity="kappav"
   string="(*k"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03f1;"
   u:name="GREEK RHO SYMBOL"
   u:entity="rhov"
   string="\(*r"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03f2;"
   u:name="GREEK LUNATE SIGMA SYMBOL"
   string="\(*s"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03f4;"
   u:name="GREEK CAPITAL THETA SYMBOL"
   string="\(*H"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03f5;"
   u:name="GREEK LUNATE EPSILON SYMBOL"
   string="\(*e"
   u:block="Greek and Coptic"
   />
  <xsl:output-character
   character="&#x03f6;"
   u:name="GREEK REVERSED LUNATE EPSILON SYMBOL"
   u:entity="bepsi"
   string="\(*e"
   u:block="Greek and Coptic"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Greek and Coptic -->
  <!-- * ***************************************************************** -->
  
  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->
  <!-- *   Cyrillic -->
  <!-- *   x0400 to x04ff -->
  <!-- *   - do nothing - -->
  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->
  
  <!-- * ***************************************************************** -->
  <!-- *   Begin: General Punctuation -->
  <!-- *   x2000 to x206f -->
  <!-- * ***************************************************************** -->
  
  <!-- * first, spaces of various widths -->

  <!-- * Note: There does not seem to be either a real em space or en space -->
  <!-- * in roff; to approximate them, this character map assumes that in -->
  <!-- * most fonts, an en space is about the same as the width of a digit -->
  <!-- * (in roff, "\0"), so an em space (which by definition is -->
  <!-- * equal to the width of two en spaces) is about the same as the width -->
  <!-- * of two digits (thus, in roff, "\0\0") -->

  <xsl:output-character
   character="&#x2000;"
   u:name="EN QUAD"
   string="\0"
   u:block="General Punctuation"
   u:class="spaces"
   />
  <xsl:output-character
   character="&#x2001;"
   u:name="EM QUAD"
   string="\0\0"
   u:block="General Punctuation"
   u:class="spaces"
   />
  <xsl:output-character
   character="&#x2002;"
   u:name="EN SPACE"
   u:entity="ensp"
   string="\0"
   u:block="General Punctuation"
   u:class="spaces"
   />
  <xsl:output-character
   character="&#x2003;"
   u:name="EM SPACE"
   u:entity="emsp"
   string="\0\0"
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * roughly same width as a normal space -->
  <xsl:output-character
   character="&#x2004;"
   u:name="THREE-PER-EM SPACE"
   u:entity="emsp13"
   string=" "
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * roughly same width as a normal space -->
  <xsl:output-character
   character="&#x2005;"
   u:name="FOUR-PER-EM SPACE"
   u:entity="emsp14"
   string=" "
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * roughly same width as a normal space -->
  <xsl:output-character
   character="&#x2006;"
   u:name="SIX-PER-EM SPACE"
   string=" "
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * same as roff "digit" space -->
  <xsl:output-character
   character="&#x2007;"
   u:name="FIGURE SPACE"
   u:entity="numsp"
   string="\0"
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * punctuation space in most fonts is actually closer to a normal -->
  <!-- * space than it is to a thin space -->
  <xsl:output-character
   character="&#x2008;"
   u:name="PUNCTUATION SPACE"
   u:entity="puncsp"
   string=" "
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * Note: Not sure how best to deal with thin space, because the roff -->
  <!-- * thin space, "\^", prints as a zero-width space in TTY -->
  <!-- * output. However, it seems that, unlike a hair space, a thin space, -->
  <!-- * at 1/12 of an em, is still recognizable to most people as a space, -->
  <!-- * so treating it as zero-width seems wrong. So, for the sake of making -->
  <!-- * TTY output look OK, just substitute with a normal space; but real -->
  <!-- * roff escape is "\(\^" -->
  <xsl:output-character
   character="&#x2009;"
   u:name="THIN SPACE"
   u:entity="thinsp"
   string=" "
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * I don't think there's a standard definition of what a hair -->
  <!-- * space is; some guides just say it's "less than 1/5 of an em" or -->
  <!-- * that it's "narrower than a thin space"; seems like in practice, -->
  <!-- * it's *a lot* narrower than a thin space, to the point where -->
  <!-- * it's close to being a non-space, so here it's substituted with -->
  <!-- * roff equivalent of a zero-width no-break space -->
  <xsl:output-character
   character="&#x200a;"
   u:name="HAIR SPACE"
   u:entity="hairsp"
   string="\&amp;"
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * map to roff "zero-width break point"  -->
  <xsl:output-character
   character="&#x200b;"
   u:name="ZERO WIDTH SPACE"
   string="\:"
   u:block="General Punctuation"
   u:class="spaces"
   />

  <!-- *   x200c and x200d have special purposes in some Indic languages (I -->
  <!-- *   think); for the "correct" zero-width space, according to Unicode docs, -->
  <!-- *   use x2060, not x200c or x200d -->
  <!-- *     <xsl:output-character -->
  <!-- *      character="&#x200c;" -->
  <!-- *      u:name="ZERO WIDTH NON-JOINER" -->
  <!-- *      string="\:" -->
  <!-- *      /> -->
  <!-- *     <xsl:output-character -->
  <!-- *      character="&#x200d;" -->
  <!-- *      u:name="ZERO WIDTH JOINER" -->
  <!-- *      string="\&amp;" -->
  <!-- *      /> -->
  <!-- * non-visible  -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x200e;" -->
  <!-- *      u:name="LEFT-TO-RIGHT MARK" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x200f;" -->
  <!-- *      u:name="RIGHT-TO-LEFT MARK" -->
  <!-- *      /> -->

  <!-- * .................................................... -->
  <!-- * next, hyphens and various dashes, bars, underscores  -->
  <xsl:output-character
   character="&#x2010;"
   u:name="HYPHEN"
   u:entity="hyphen"
   string="\(hy"
   u:block="General Punctuation"
   u:class="dashes"
   />
  <!-- * although the groff docs do not make it clear, testing -->
  <!-- * indicates that the only reliable way to make a non-breaking -->
  <!-- * hyphen is to put just a backslash in front of it. -->
  <!-- * -->
  <!-- * based on testing, it also appears that no character is needed -->
  <!-- * after the hyphen in order to make it non-breaking -->
  <xsl:output-character
   character="&#x2011;"
   u:name="NON-BREAKING HYPHEN"
   string="\-"
   u:block="General Punctuation"
   u:class="dashes"
   />
  <!-- * roughly same width as en dash -->
  <xsl:output-character
   character="&#x2012;"
   u:name="FIGURE DASH"
   string="\(en"
   u:block="General Punctuation"
   u:class="dashes"
   />
  <xsl:output-character
   character="&#x2013;"
   u:name="EN DASH"
   u:entity="ndash"
   string="\(en"
   u:block="General Punctuation"
   u:class="dashes"
   />
  <xsl:output-character
   character="&#x2014;"
   u:name="EM DASH"
   u:entity="mdash"
   string="\(em"
   u:block="General Punctuation"
   u:class="dashes"
   />
  <!-- * seems roughly same width as em dash -->
  <xsl:output-character
   character="&#x2015;"
   u:name="HORIZONTAL BAR"
   u:entity="horbar"
   string="\(em"
   u:block="General Punctuation"
   u:class="dashes"
   />
  <xsl:output-character
   character="&#x2016;"
   u:name="DOUBLE VERTICAL LINE"
   u:entity="Verbar"
   string="\(bv\(bv"
   u:block="General Punctuation"
   />
  <!-- * no double-underscore in roff; so just make it a single -->
  <!-- * underscore -->
  <xsl:output-character
   character="&#x2017;"
   u:name="DOUBLE LOW LINE"
   string="_"
   u:block="General Punctuation"
   />

  <!-- * .................................................... -->
  <!-- * various quotation marks -->
  <xsl:output-character
   character="&#x2018;"
   u:name="LEFT SINGLE QUOTATION MARK"
   u:entity="lsquo"
   string="\(oq"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <xsl:output-character
   character="&#x2019;"
   u:name="RIGHT SINGLE QUOTATION MARK"
   u:entity="rsquo"
   string="\(cq"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <xsl:output-character
   character="&#x201a;"
   u:name="SINGLE LOW-9 QUOTATION MARK"
   u:entity="lsquor"
   string="\(bq"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <!-- * no roff equiv; treat same as lsquo -->
  <xsl:output-character
   character="&#x201b;"
   u:name="SINGLE HIGH-REVERSED-9 QUOTATION MARK"
   string="\(oq"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <xsl:output-character
   character="&#x201c;"
   u:name="LEFT DOUBLE QUOTATION MARK"
   u:entity="ldquo"
   string="\(lq"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <xsl:output-character
   character="&#x201d;"
   u:name="RIGHT DOUBLE QUOTATION MARK"
   u:entity="rdquo"
   string="\(rq"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <xsl:output-character
   character="&#x201e;"
   u:name="DOUBLE LOW-9 QUOTATION MARK"
   u:entity="ldquor"
   string="\(Bq"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <!-- * no roff equiv; treat same as rdquo -->
  <xsl:output-character
   character="&#x201f;"
   u:name="DOUBLE HIGH-REVERSED-9 QUOTATION MARK"
   string="\(rq"
   u:block="General Punctuation"
   u:class="quotes"
   />

  <!-- * .................................................... -->
  <!-- * various symbols -->
  <xsl:output-character
   character="&#x2020;"
   u:name="DAGGER"
   u:entity="dagger"
   string="\(dg"
   u:block="General Punctuation_daggers"
   />
  <xsl:output-character
   character="&#x2021;"
   u:name="DOUBLE DAGGER"
   u:entity="Dagger"
   string="\(dd"
   u:block="General Punctuation_daggers"
   />
  <xsl:output-character
   character="&#x2022;"
   u:name="BULLET"
   u:entity="bull"
   string="\(bu"
   u:block="General Punctuation"
   u:class="bullets"
   />
  <!-- * no roff equiv -->
  <xsl:output-character
   character="&#x2023;"
   u:name="TRIANGULAR BULLET"
   string=">\&amp;"
   u:block="General Punctuation"
   u:class="bullets"
   />
  <!-- * no roff equiv -->
  <xsl:output-character
   character="&#x2024;"
   u:name="ONE DOT LEADER"
   string="\&amp;."
   u:block="General Punctuation_leaders"
   />
  <!-- * no roff equiv -->
  <xsl:output-character
   character="&#x2025;"
   u:name="TWO DOT LEADER"
   u:entity="nldr"
   string="\&amp;.."
   u:block="General Punctuation_leaders"
   />
  <!-- * no roff equiv -->
  <xsl:output-character
   character="&#x2026;"
   u:name="HORIZONTAL ELLIPSIS"
   u:entity="hellip"
   string="\&amp;..."
   u:block="General Punctuation"
   />
  <!-- what is "hyphenation point" used for? looks like middot to me... -->
  <xsl:output-character
   character="&#x2027;"
   u:name="HYPHENATION POINT"
   string="\(md"
   u:block="General Punctuation"
   />
  <!-- * Begin x2028 to x202e - no idea what to do with these -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2028;" -->
  <!-- *      u:name="LINE SEPARATOR" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2029;" -->
  <!-- *      u:name="PARAGRAPH SEPARATOR" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x202a;" -->
  <!-- *      u:name="LEFT-TO-RIGHT EMBEDDING" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x202b;" -->
  <!-- *      u:name="RIGHT-TO-LEFT EMBEDDING" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x202c;" -->
  <!-- *      u:name="POP DIRECTIONAL FORMATTING" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x202d;" -->
  <!-- *      u:name="LEFT-TO-RIGHT OVERRIDE" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x202e;" -->
  <!-- *      u:name="RIGHT-TO-LEFT OVERRIDE" -->
  <!-- *      /> -->
  <!-- *      End x2028 to x202e - no idea what to do with these -->

  <!-- * seems like "narrow" nbsp is basically the same as a no-break -->
  <!-- * space -->
  <xsl:output-character
   character="&#x202f;"
   u:name="NARROW NO-BREAK SPACE"
   string="\ "
   u:block="General Punctuation"
   u:class="spaces"
   />
  <xsl:output-character
   character="&#x2030;"
   u:name="PER MILLE SIGN"
   u:entity="permil"
   string="\(%0"
   u:block="General Punctuation"
   />
  <!-- * no roff equiv; no idea what to do with it -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2031;" -->
  <!-- *      u:name="PER TEN THOUSAND SIGN" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2032;"
   u:name="PRIME"
   u:entity="prime"
   string="\(fm"
   u:block="General Punctuation"
   u:class="primes"
   />
  <xsl:output-character
   character="&#x2033;"
   u:name="DOUBLE PRIME"
   u:entity="Prime"
   string="\(sd"
   u:block="General Punctuation"
   u:class="primes"
   />
  <xsl:output-character
   character="&#x2034;"
   u:name="TRIPLE PRIME"
   u:entity="tprime"
   string="\(sd\(fm"
   u:block="General Punctuation"
   u:class="primes"
   />
  <!-- * no idea for these  -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2035;" -->
  <!-- *      u:name="REVERSED PRIME" -->
  <!-- *      u:entity="bprime" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2036;" -->
  <!-- *      u:name="REVERSED DOUBLE PRIME" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2037;" -->
  <!-- *      u:name="REVERSED TRIPLE PRIME" -->
  <!-- *      /> -->

  <!-- * there is no low caret in roff -->
  <xsl:output-character
   character="&#x2038;"
   u:name="CARET"
   string="^"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x2039;"
   u:name="SINGLE LEFT-POINTING ANGLE QUOTATION MARK"
   string="\(fo"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <xsl:output-character
   character="&#x203a;"
   u:name="SINGLE RIGHT-POINTING ANGLE QUOTATION MARK"
   string="\(fc"
   u:block="General Punctuation"
   u:class="quotes"
   />
  <!-- * not in roff -->
  <xsl:output-character
   character="&#x203b;"
   u:name="REFERENCE MARK"
   string="*"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x203c;"
   u:name="DOUBLE EXCLAMATION MARK"
   string="!!"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x203d;"
   u:name="INTERROBANG"
   string="?!"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x203e;"
   u:name="OVERLINE"
   string="\(rn"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x203f;"
   u:name="UNDERTIE"
   string="\(ul"
   u:block="General Punctuation"
   />
  <!-- * not in roff -->
  <xsl:output-character
   character="&#x2040;"
   u:name="CHARACTER TIE"
   string="\(rn"
   u:block="General Punctuation"
   />
  <!-- * not in roff -->
  <xsl:output-character
   character="&#x2041;"
   u:name="CARET INSERTION POINT"
   u:entity="caret"
   string="^"
   u:block="General Punctuation"
   />
  <!-- * not in roff -->
  <xsl:output-character
   character="&#x2042;"
   u:name="ASTERISM"
   string="*"
   u:block="General Punctuation"
   />
  <!-- * not in roff; just make bold hyphen -->
  <xsl:output-character
   character="&#x2043;"
   u:name="HYPHEN BULLET"
   u:entity="hybull"
   string="\fB-\fR"
   u:block="General Punctuation"
   u:class="bullets"
   />
  <xsl:output-character
   character="&#x2044;"
   u:name="FRACTION SLASH"
   string="\(sl"
   u:block="General Punctuation"
   />
  <!-- * not in roff -->
  <xsl:output-character
   character="&#x2045;"
   u:name="LEFT SQUARE BRACKET WITH QUILL"
   string="["
   u:block="General Punctuation"
   />
  <!-- * not in roff -->
  <xsl:output-character
   character="&#x2046;"
   u:name="RIGHT SQUARE BRACKET WITH QUILL"
   string="]"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x2047;"
   u:name="DOUBLE QUESTION MARK"
   string="??"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x2048;"
   u:name="QUESTION EXCLAMATION MARK"
   string="?!"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x2049;"
   u:name="EXCLAMATION QUESTION MARK"
   string="!?"
   u:block="General Punctuation"
   />
  <!-- * not in roff -->
  <xsl:output-character
   character="&#x204a;"
   u:name="TIRONIAN SIGN ET"
   string="7"
   u:block="General Punctuation"
   />
  <!-- * not in roff; just replace with un-reversed pilcrow -->
  <xsl:output-character
   character="&#x204b;"
   u:name="REVERSED PILCROW SIGN"
   string="\(ps"
   u:block="General Punctuation"
   />
  <!-- * not in roff; just make regular bullet -->
  <xsl:output-character
   character="&#x204c;"
   u:name="BLACK LEFTWARDS BULLET"
   string="\(bu"
   u:block="General Punctuation"
   />
  <!-- * not in roff; just make regular bullet -->
  <xsl:output-character
   character="&#x204d;"
   u:name="BLACK RIGHTWARDS BULLET"
   string="\(bu"
   u:block="General Punctuation"
   />
  <xsl:output-character
   character="&#x204e;"
   u:name="LOW ASTERISK"
   string="*"
   u:block="General Punctuation"
   />

  <!-- * ............................................................... -->
  <!-- *   Remaining General Punctuation -->
  <!-- *   from x2050 to x206f -->
  <!-- *   only map a couple of these -->
  <!-- * ............................................................... -->

  <!-- * basically same as a normal space -->
  <xsl:output-character
   character="&#x205f;"
   u:name="MEDIUM MATHEMATICAL SPACE"
   string=" "
   u:block="General Punctuation"
   u:class="spaces"
   />
  <!-- * Regarding x2060 vs. xFEFF, the document "Unicode Standard Annex #14, -->
  <!-- * Line Breaking Properties"[1] says: -->
  <!-- * -->
  <!-- *   The word joiner character [x2060 a.k.a "WJ"] is the preferred -->
  <!-- *   choice for an invisible character to keep other characters -->
  <!-- *   together that would otherwise be split across the line at a direct -->
  <!-- *   break. The character FEFF has the same effect, but because it is -->
  <!-- *   also used in an unrelated way as a byte order mark, the use of the -->
  <!-- *   WJ as the preferred interword glue simplifies the handling of FEFF. -->
  <!-- * -->
  <!-- * [1] http://www.unicode.org/reports/tr14/ -->
  <!-- * -->
  <!-- * The groff docs seem ambiguous about whether \& is a joiner and -->
  <!-- * prevents breaks, but, based on testing, seems like it does -->
  <xsl:output-character
   character="&#x2060;"
   u:name="WORD JOINER"
   string="\&amp;"
   u:block="General Punctuation"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: General Punctuation -->
  <!-- * ***************************************************************** -->
  
  <!-- * ***************************************************************** -->
  <!-- *   Begin: Superscripts and Subscripts -->
  <!-- *    x2070 to x209f -->
  <!-- *    For superscripts, just do a^n thing -->
  <!-- *    For subscripts, just do a_n -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x2070;"
   u:name="SUPERSCRIPT ZERO"
   string="^0"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2071;"
   u:name="SUPERSCRIPT LATIN SMALL LETTER I"
   string="^i"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2074;"
   u:name="SUPERSCRIPT FOUR"
   string="^4"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2075;"
   u:name="SUPERSCRIPT FIVE"
   string="^5"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2076;"
   u:name="SUPERSCRIPT SIX"
   string="^6"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2077;"
   u:name="SUPERSCRIPT SEVEN"
   string="^7"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2078;"
   u:name="SUPERSCRIPT EIGHT"
   string="^8"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2079;"
   u:name="SUPERSCRIPT NINE"
   string="^9"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x207a;"
   u:name="SUPERSCRIPT PLUS SIGN"
   string="^+"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x207b;"
   u:name="SUPERSCRIPT MINUS"
   string="^-"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x207c;"
   u:name="SUPERSCRIPT EQUALS SIGN"
   string="^="
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x207d;"
   u:name="SUPERSCRIPT LEFT PARENTHESIS"
   string="^("
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x207e;"
   u:name="SUPERSCRIPT RIGHT PARENTHESIS"
   string="^)"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x207f;"
   u:name="SUPERSCRIPT LATIN SMALL LETTER N"
   string="^n"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2080;"
   u:name="SUBSCRIPT ZERO"
   string="_0"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2081;"
   u:name="SUBSCRIPT ONE"
   string="_1"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2082;"
   u:name="SUBSCRIPT TWO"
   string="_2"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2083;"
   u:name="SUBSCRIPT THREE"
   string="_3"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2084;"
   u:name="SUBSCRIPT FOUR"
   string="_4"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2085;"
   u:name="SUBSCRIPT FIVE"
   string="_5"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2086;"
   u:name="SUBSCRIPT SIX"
   string="_6"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2087;"
   u:name="SUBSCRIPT SEVEN"
   string="_7"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2088;"
   u:name="SUBSCRIPT EIGHT"
   string="_8"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x2089;"
   u:name="SUBSCRIPT NINE"
   string="_9"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x208a;"
   u:name="SUBSCRIPT PLUS SIGN"
   string="_+"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x208b;"
   u:name="SUBSCRIPT MINUS"
   string="_-"
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x208c;"
   u:name="SUBSCRIPT EQUALS SIGN"
   string="_="
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x208d;"
   u:name="SUBSCRIPT LEFT PARENTHESIS"
   string="_("
   u:block="Superscripts and Subscripts"
   />
  <xsl:output-character
   character="&#x208e;"
   u:name="SUBSCRIPT RIGHT PARENTHESIS"
   string="_)"
   u:block="Superscripts and Subscripts"
   />
  <!-- * ***************************************************************** -->
  <!-- *   End: Superscripts and Subscripts -->
  <!-- *     x2070 to x209f -->
  <!-- * ***************************************************************** -->

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Currency Symbols -->
  <!-- *     x20a0 to x20b1 -->
  <!-- *     No mappings for any of these; just spell out -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x20a0;"
   u:name="EURO-CURRENCY SIGN"
   string="EUR"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a1;"
   u:name="COLON SIGN"
   string="COLON"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a2;"
   u:name="CRUZEIRO SIGN"
   string="CRUZEIRO"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a3;"
   u:name="FRENCH FRANC SIGN"
   string="FRANC"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a4;"
   u:name="LIRA SIGN"
   string="LIRA"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a5;"
   u:name="MILL SIGN"
   string="MILL"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a6;"
   u:name="NAIRA SIGN"
   string="NAIRA"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a7;"
   u:name="PESETA SIGN"
   string="PESETA"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a8;"
   u:name="RUPEE SIGN"
   string="RUPEE"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20a9;"
   u:name="WON SIGN"
   string="WON"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20aa;"
   u:name="NEW SHEQEL SIGN"
   string="SHEQEL"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20ab;"
   u:name="DONG SIGN"
   string="DONG"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20ac;"
   u:name="EURO SIGN"
   string="EUR"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20ad;"
   u:name="KIP SIGN"
   string="KIP"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20ae;"
   u:name="TUGRIK SIGN"
   string="TUGRIK"
   u:block="Currency Symbols"
   />
  <xsl:output-character
   character="&#x20af;"
   u:name="DRACHMA SIGN"
   string="DRACHMA"
   u:block="Currency Symbols"
   />
  <!-- <xsl:output-character -->
  <!--  character="&#x20b0;" -->
  <!--  u:name="GERMAN PENNY SIGN" -->
  <!--  string="?" -->
  <!--  u:block="Currency Symbols" -->
  <!--  /> -->
  <xsl:output-character
   character="&#x20b1;"
   u:name="PESO SIGN"
   string="PESO"
   u:block="Currency Symbols"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Currency Symbols -->
  <!-- *   x20a0 to x20b1 -->
  <!-- * ***************************************************************** -->

  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->
  <!-- *   Combining Diacritical Marks for Symbols -->
  <!-- *     x20d0 to x20ff -->
  <!-- *     - do nothing - -->
  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Letterlike Symbols -->
  <!-- *     x2100 to x214b -->
  <!-- * -->
  <!-- *     No mappings for any of these, and nothing appropriate for -->
  <!-- *     most of them; so, just spell out the ones that we can -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x2103;"
   u:name="DEGREE CELSIUS"
   string="\(deC"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x2105;"
   u:name="CARE OF"
   u:entity="incare"
   string="c/o"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x2109;"
   u:name="DEGREE FAHRENHEIT"
   string="\(deF"
   u:block="Letterlike Symbols"
   />
  <!-- roff Ifraktur -->
  <xsl:output-character
   character="&#x2111;"
   u:name="BLACK-LETTER CAPITAL I"
   string="\(Im"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x2113;"
   u:name="SCRIPT SMALL L"
   u:entity="ell"
   string="l"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x2116;"
   u:name="NUMERO SIGN"
   u:entity="numero"
   string="No."
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x2118;"
   u:name="SCRIPT CAPITAL P"
   u:entity="weierp"
   string="\(wp"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x211c;"
   u:name="BLACK-LETTER CAPITAL R"
   u:entity="real"
   string="\(Re"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x211e;"
   u:name="PRESCRIPTION TAKE"
   u:entity="rx"
   string="Rx"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x2120;"
   u:name="SERVICE MARK"
   string="(SM)"
   u:block="Letterlike Symbols"
   />
  <!-- * We don't do "\(tm" for &#x2122; because for console output, groff -->
  <!-- * just renders that as "tm", without any preceding space, parens, -->
  <!-- * or anything. So it just gets run into the preceding word; i.e.: -->
  <!-- * -->
  <!-- *  Product&#x2122; -> Producttm -->
  <!-- * -->
  <!-- * That it probably not what most people would want. So we just -->
  <!-- * render it as (TM) instead, Thus: -->
  <!-- * -->
  <!-- *  Product&#x2122; -> Product(TM) -->
  <xsl:output-character
   character="&#x2122;"
   u:name="TRADE MARK SIGN"
   u:entity="trade"
   string="(TM)"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x2126;"
   u:name="OHM SIGN"
   u:entity="ohm"
   string="\(*W"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x212a;"
   u:name="KELVIN SIGN"
   string="K"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x212b;"
   u:name="ANGSTROM SIGN"
   u:entity="angst"
   string="\(oA"
   u:block="Letterlike Symbols"
   />
  <xsl:output-character
   character="&#x2135;"
   u:name="ALEF SYMBOL"
   u:entity="aleph"
   string="\(Ah"
   u:block="Letterlike Symbols"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Letterlike Symbols -->
  <!-- *     x2100 to x214b -->
  <!-- * ***************************************************************** -->
  
  <!-- * ***************************************************************** -->
  <!-- *   Begin: Number Forms -->
  <!-- *     x2150 to x218f -->
  <!-- * -->
  <!-- *   No mappings for any of these, and nothing appropriate for most -->
  <!-- *   of them; so, just spell out the ones that we can -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x2153;"
   u:name="VULGAR FRACTION ONE THIRD"
   u:entity="frac13"
   string="1/3"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2154;"
   u:name="VULGAR FRACTION TWO THIRDS"
   u:entity="frac23"
   string="2/3"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2155;"
   u:name="VULGAR FRACTION ONE FIFTH"
   u:entity="frac15"
   string="1/5"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2156;"
   u:name="VULGAR FRACTION TWO FIFTHS"
   u:entity="frac25"
   string="2/5"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2157;"
   u:name="VULGAR FRACTION THREE FIFTHS"
   u:entity="frac35"
   string="3/5"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2158;"
   u:name="VULGAR FRACTION FOUR FIFTHS"
   u:entity="frac45"
   string="4/5"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2159;"
   u:name="VULGAR FRACTION ONE SIXTH"
   u:entity="frac16"
   string="1/6"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x215a;"
   u:name="VULGAR FRACTION FIVE SIXTHS"
   u:entity="frac56"
   string="5/6"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x215b;"
   u:name="VULGAR FRACTION ONE EIGHTH"
   u:entity="frac18"
   string="1/8"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x215c;"
   u:name="VULGAR FRACTION THREE EIGHTHS"
   u:entity="frac38"
   string="3/8"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x215d;"
   u:name="VULGAR FRACTION FIVE EIGHTHS"
   u:entity="frac58"
   string="5/8"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x215e;"
   u:name="VULGAR FRACTION SEVEN EIGHTHS"
   u:entity="frac78"
   string="7/8"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x215f;"
   u:name="FRACTION NUMERATOR ONE"
   string="1/"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2160;"
   u:name="ROMAN NUMERAL ONE"
   string="I"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2161;"
   u:name="ROMAN NUMERAL TWO"
   string="II"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2162;"
   u:name="ROMAN NUMERAL THREE"
   string="III"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2163;"
   u:name="ROMAN NUMERAL FOUR"
   string="IV"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2164;"
   u:name="ROMAN NUMERAL FIVE"
   string="V"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2165;"
   u:name="ROMAN NUMERAL SIX"
   string="VI"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2166;"
   u:name="ROMAN NUMERAL SEVEN"
   string="VII"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2167;"
   u:name="ROMAN NUMERAL EIGHT"
   string="VIII"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2168;"
   u:name="ROMAN NUMERAL NINE"
   string="IX"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2169;"
   u:name="ROMAN NUMERAL TEN"
   string="X"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x216a;"
   u:name="ROMAN NUMERAL ELEVEN"
   string="XI"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x216b;"
   u:name="ROMAN NUMERAL TWELVE"
   string="XII"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x216c;"
   u:name="ROMAN NUMERAL FIFTY"
   string="L"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x216d;"
   u:name="ROMAN NUMERAL ONE HUNDRED"
   string="C"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x216e;"
   u:name="ROMAN NUMERAL FIVE HUNDRED"
   string="D"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x216f;"
   u:name="ROMAN NUMERAL ONE THOUSAND"
   string="M"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2170;"
   u:name="SMALL ROMAN NUMERAL ONE"
   string="i"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2171;"
   u:name="SMALL ROMAN NUMERAL TWO"
   string="ii"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2172;"
   u:name="SMALL ROMAN NUMERAL THREE"
   string="iii"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2173;"
   u:name="SMALL ROMAN NUMERAL FOUR"
   string="iv"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2174;"
   u:name="SMALL ROMAN NUMERAL FIVE"
   string="v"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2175;"
   u:name="SMALL ROMAN NUMERAL SIX"
   string="vi"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2176;"
   u:name="SMALL ROMAN NUMERAL SEVEN"
   string="vii"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2177;"
   u:name="SMALL ROMAN NUMERAL EIGHT"
   string="viii"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2178;"
   u:name="SMALL ROMAN NUMERAL NINE"
   string="ix"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2179;"
   u:name="SMALL ROMAN NUMERAL TEN"
   string="x"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x217a;"
   u:name="SMALL ROMAN NUMERAL ELEVEN"
   string="xi"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x217b;"
   u:name="SMALL ROMAN NUMERAL TWELVE"
   string="xii"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x217c;"
   u:name="SMALL ROMAN NUMERAL FIFTY"
   string="l"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x217d;"
   u:name="SMALL ROMAN NUMERAL ONE HUNDRED"
   string="c"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x217e;"
   u:name="SMALL ROMAN NUMERAL FIVE HUNDRED"
   string="d"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x217f;"
   u:name="SMALL ROMAN NUMERAL ONE THOUSAND"
   string="m"
   u:block="Number Forms"
   />
  <xsl:output-character
   character="&#x2180;"
   u:name="ROMAN NUMERAL ONE THOUSAND C D"
   string="CD"
   u:block="Number Forms"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Number Forms -->
  <!-- *     x2150 to x218f -->
  <!-- * ***************************************************************** -->

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Arrows -->
  <!-- *   x2190 to x21ff -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x2190;"
   u:name="LEFTWARDS ARROW"
   u:entity="larr"
   string="\(&lt;-"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x2191;"
   u:name="UPWARDS ARROW"
   u:entity="uarr"
   string="\(ua"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x2192;"
   u:name="RIGHTWARDS ARROW"
   u:entity="rarr"
   string="\(->"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x2193;"
   u:name="DOWNWARDS ARROW"
   u:entity="darr"
   string="\(da"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x2194;"
   u:name="LEFT RIGHT ARROW"
   u:entity="harr"
   string="\(&lt;>"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x2195;"
   u:name="UP DOWN ARROW"
   u:entity="varr"
   string="\(va"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x21b5;"
   u:name="DOWNWARDS ARROW WITH CORNER LEFTWARDS"
   u:entity="crarr"
   string="\(CR"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x21d0;"
   u:name="LEFTWARDS DOUBLE ARROW"
   u:entity="lArr"
   string="\(la"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x21d1;"
   u:name="UPWARDS DOUBLE ARROW"
   u:entity="uArr"
   string="\(uA"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x21d2;"
   u:name="RIGHTWARDS DOUBLE ARROW"
   u:entity="rArr"
   string="\(rA"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x21d3;"
   u:name="DOWNWARDS DOUBLE ARROW"
   u:entity="dArr"
   string="\(dA"
   u:block="Arrows"
   />
  <xsl:output-character
   character="&#x21d4;"
   u:name="LEFT RIGHT DOUBLE ARROW"
   u:entity="hArr"
   string="\(hA"
   u:block="Arrows"
   />
  <!-- no roff equiv; render same as single arrow -->
  <xsl:output-character
   character="&#x21d5;"
   u:name="UP DOWN DOUBLE ARROW"
   u:entity="vArr"
   string="\(va"
   u:block="Arrows"
   />

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Mathematical Operators -->
  <!-- *     x2200 to x22ff -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x2200;"
   u:name="FOR ALL"
   u:entity="forall"
   string="\(fa"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2201;"
   u:name="COMPLEMENT"
   u:entity="comp"
   string="C"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2202;"
   u:name="PARTIAL DIFFERENTIAL"
   u:entity="part"
   string="\(pd"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2203;"
   u:name="THERE EXISTS"
   u:entity="exist"
   string="\(te"
   u:block="Mathematical Operators"
   />
  <!-- * no roff equiv  -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2204;" -->
  <!-- *      u:name="THERE DOES NOT EXIST" -->
  <!-- *      u:entity="nexist" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2205;"
   u:name="EMPTY SET"
   u:entity="empty"
   string="\(es"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2206;"
   u:name="INCREMENT"
   string="\(*D"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2207;"
   u:name="NABLA"
   u:entity="nabla"
   string="\(gr"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2208;"
   u:name="ELEMENT OF"
   u:entity="isin"
   string="\(mo"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2209;"
   u:name="NOT AN ELEMENT OF"
   u:entity="notin"
   string="\(nm"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x220a;"
   u:name="SMALL ELEMENT OF"
   string="\(mo"
   u:block="Mathematical Operators"
   />

  <xsl:output-character
   character="&#x220b;"
   u:name="CONTAINS AS MEMBER"
   u:entity="ni"
   string="\(st"
   u:block="Mathematical Operators"
   />
  <!-- * not in roff  -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x220c;" -->
  <!-- *      u:name="DOES NOT CONTAIN AS MEMBER" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x220d;"
   u:name="SMALL CONTAINS AS MEMBER"
   string="\(st"
   u:block="Mathematical Operators"
   />
  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x220e;" -->
  <!-- *      u:name="END OF PROOF" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x220f;"
   u:name="N-ARY PRODUCT"
   u:entity="prod"
   string="\(product"
   u:block="Mathematical Operators"
   />
  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2210;" -->
  <!-- *      u:name="N-ARY COPRODUCT" -->
  <!-- *      u:entity="coprod" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2211;"
   u:name="N-ARY SUMMATION"
   u:entity="sum"
   string="\(sum"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2212;"
   u:name="MINUS SIGN"
   u:entity="minus"
   string="\-"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2213;"
   u:name="MINUS-OR-PLUS SIGN"
   u:entity="mnplus"
   string="\(+-"
   u:block="Mathematical Operators"
   />
  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2214;" -->
  <!-- *      u:name="DOT PLUS" -->
  <!-- *      u:entity="plusdo" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2215;"
   u:name="DIVISION SLASH"
   string="\(f/"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2216;"
   u:name="SET MINUS"
   u:entity="setmn"
   string="\e"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2217;"
   u:name="ASTERISK OPERATOR"
   u:entity="lowast"
   string="\(**"
   u:block="Mathematical Operators"
   />
  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2218;" -->
  <!-- *      u:name="RING OPERATOR" -->
  <!-- *      u:entity="compfn" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2219;"
   u:name="BULLET OPERATOR"
   string="\(bu"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x221a;"
   u:name="SQUARE ROOT"
   u:entity="radic"
   string="\(sr"
   u:block="Mathematical Operators"
   />
  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x221b;" -->
  <!-- *      u:name="CUBE ROOT" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x221c;" -->
  <!-- *      u:name="FOURTH ROOT" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x221d;"
   u:name="PROPORTIONAL TO"
   u:entity="prop"
   string="\(pt"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x221e;"
   u:name="INFINITY"
   u:entity="infin"
   string="\(if"
   u:block="Mathematical Operators"
   />
  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x221f;" -->
  <!-- *      u:name="RIGHT ANGLE" -->
  <!-- *      u:entity="ang90" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2220;"
   u:name="ANGLE"
   u:entity="ang"
   string="\(/_"
   u:block="Mathematical Operators"
   />

  <!-- * 0x2221 to 0x2226 not in roff; -->
  <!-- * but fake a parallel sign with vert bars -->

  <xsl:output-character
   character="&#x2225;"
   u:name="PARALLEL TO"
   u:entity="par"
   string="\(bv\(bv"
   u:block="Mathematical Operators"
   />

  <xsl:output-character
   character="&#x2227;"
   u:name="LOGICAL AND"
   u:entity="and"
   string="\(AN"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2228;"
   u:name="LOGICAL OR"
   u:entity="or"
   string="\(OR"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2229;"
   u:name="INTERSECTION"
   u:entity="cap"
   string="\(ca"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x222a;"
   u:name="UNION"
   u:entity="cup"
   string="\(cu"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x222b;"
   u:name="INTEGRAL"
   u:entity="int"
   string="\(is"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x222c;"
   u:name="DOUBLE INTEGRAL"
   string="\(is\(is"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x222d;"
   u:name="TRIPLE INTEGRAL"
   string="\(is\(is\(is"
   u:block="Mathematical Operators"
   />

  <!-- * 0x222e to 0x2233 not in roff -->

  <xsl:output-character
   character="&#x2234;"
   u:name="THEREFORE"
   u:entity="there4"
   string="\(tf"
   u:block="Mathematical Operators"
   />

  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2235;" -->
  <!-- *      u:name="BECAUSE" -->
  <!-- *      u:entity="becaus" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2236;"
   u:name="RATIO"
   string=":"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2237;"
   u:name="PROPORTION"
   string="::"
   u:block="Mathematical Operators"
   />

  <!-- * 0x2238 to 0x223b not in roff -->

  <xsl:output-character
   character="&#x223c;"
   u:name="TILDE OPERATOR"
   u:entity="sim"
   string="\(ti"
   u:block="Mathematical Operators"
   />

  <!-- * 0x223d to 0x224b not in roff -->

  <xsl:output-character
   character="&#x2245;"
   u:name="APPROXIMATELY EQUAL TO"
   u:entity="cong"
   string="\(=~"
   u:block="Mathematical Operators"
   />

  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2246;" -->
  <!-- *      u:name="APPROXIMATELY BUT NOT ACTUALLY EQUAL TO" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2247;" -->
  <!-- *      u:name="NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO" -->
  <!-- *      u:entity="ncong" -->
  <!-- *      /> -->

  <xsl:output-character
   character="&#x2248;"
   u:name="ALMOST EQUAL TO"
   u:entity="asymp"
   string="\(~~"
   u:block="Mathematical Operators"
   />

  <!-- * x2249 to x2253 not in roff -->

  <xsl:output-character
   character="&#x2254;"
   u:name="COLON EQUALS"
   u:entity="colone"
   string=":="
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2255;"
   u:name="EQUALS COLON"
   u:entity="ecolon"
   string="=:"
   u:block="Mathematical Operators"
   />

  <!-- * x2256 to x2255 not in roff -->

  <xsl:output-character
   character="&#x225f;"
   u:name="QUESTIONED EQUAL TO"
   string="?="
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2260;"
   u:name="NOT EQUAL TO"
   u:entity="ne"
   string="\(!="
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2261;"
   u:name="IDENTICAL TO"
   u:entity="equiv"
   string="\(=="
   u:block="Mathematical Operators"
   />
  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2262;" -->
  <!-- *      u:name="NOT IDENTICAL TO" -->
  <!-- *      u:entity="nequiv" -->
  <!-- *      /> -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2263;" -->
  <!-- *      u:name="STRICTLY EQUIVALENT TO" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2264;"
   u:name="LESS-THAN OR EQUAL TO"
   u:entity="le"
   string="\(&lt;="
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2265;"
   u:name="GREATER-THAN OR EQUAL TO"
   u:entity="ge"
   string="\(>="
   u:block="Mathematical Operators"
   />
  <!-- * x2266 to x2269 not in roff -->

  <xsl:output-character
   character="&#x226a;"
   u:name="MUCH LESS-THAN"
   u:entity="Lt"
   string="&lt;&lt;"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x226b;"
   u:name="MUCH GREATER-THAN"
   u:entity="Gt"
   string=">>"
   u:block="Mathematical Operators"
   />
  <!-- * x226c to x2281 not in roff -->

  <xsl:output-character
   character="&#x2282;"
   u:name="SUBSET OF"
   u:entity="sub"
   string="\(sb"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2283;"
   u:name="SUPERSET OF"
   u:entity="sup"
   string="\(sp"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2284;"
   u:name="NOT A SUBSET OF"
   u:entity="nsub"
   string="\(nb"
   u:block="Mathematical Operators"
   />
  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x2285;" -->
  <!-- *      u:name="NOT A SUPERSET OF" -->
  <!-- *      u:entity="nsup" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x2286;"
   u:name="SUBSET OF OR EQUAL TO"
   u:entity="sube"
   string="\(ib"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2287;"
   u:name="SUPERSET OF OR EQUAL TO"
   u:entity="supe"
   string="\(ip"
   u:block="Mathematical Operators"
   />
  <!-- * x2288 to x2294 not in roff -->

  <xsl:output-character
   character="&#x2295;"
   u:name="CIRCLED PLUS"
   u:entity="oplus"
   string="\(c+"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2296;"
   u:name="CIRCLED MINUS"
   u:entity="ominus"
   string="\(c*"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x2297;"
   u:name="CIRCLED TIMES"
   u:entity="otimes"
   string="\(c*"
   u:block="Mathematical Operators"
   />

  <!-- * x2298 to x22a4 not in roff -->

  <xsl:output-character
   character="&#x22a5;"
   u:name="UP TACK"
   u:entity="bottom"
   string="\(pp"
   u:block="Mathematical Operators"
   />

  <!-- * x22a6 to x22bf not in roff -->

  <xsl:output-character
   character="&#x22c0;"
   u:name="N-ARY LOGICAL AND"
   string="\(AN"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x22c1;"
   u:name="N-ARY LOGICAL OR"
   string="\(OR"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x22c2;"
   u:name="N-ARY INTERSECTION"
   string="\(ca"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x22c3;"
   u:name="N-ARY UNION"
   string="\(cu"
   u:block="Mathematical Operators"
   />

  <!-- * not in roff -->
  <!-- *      <xsl:output-character -->
  <!-- *      character="&#x22c4;" -->
  <!-- *      u:name="DIAMOND OPERATOR" -->
  <!-- *      u:entity="diam" -->
  <!-- *      /> -->
  <xsl:output-character
   character="&#x22c5;"
   u:name="DOT OPERATOR"
   u:entity="sdot"
   string="\(md"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x22c6;"
   u:name="STAR OPERATOR"
   u:entity="sstarf"
   string="\(**"
   u:block="Mathematical Operators"
   />
  <!-- * x22c7 to x22cd not in roff -->

  <xsl:output-character
   character="&#x22ce;"
   u:name="CURLY LOGICAL OR"
   u:entity="cuvee"
   string="\(OR"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x22cf;"
   u:name="CURLY LOGICAL AND"
   u:entity="cuwed"
   string="\(AN"
   u:block="Mathematical Operators"
   />

  <!-- * x22d0 to x22d7 not in roff -->

  <xsl:output-character
   character="&#x22d8;"
   u:name="VERY MUCH LESS-THAN"
   u:entity="Ll"
   string="&lt;&lt;&lt;"
   u:block="Mathematical Operators"
   />
  <xsl:output-character
   character="&#x22d9;"
   u:name="VERY MUCH GREATER-THAN"
   u:entity="Gg"
   string=">>>"
   u:block="Mathematical Operators"
   />

  <!-- * x22da to x22ee not in roff -->

  <xsl:output-character
   character="&#x22ef;"
   u:name="MIDLINE HORIZONTAL ELLIPSIS"
   string="\&amp;..."
   u:block="Mathematical Operators"
   />

  <!-- * x22fo to x22ff not in roff -->

  <!-- * ***************************************************************** -->
  <!-- *   End: Mathematical Operators -->
  <!-- * ***************************************************************** -->
  
  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->
  <!-- *   Miscellaneous Technical -->
  <!-- *     x2300 to x23ff -->
  <!-- *     - do nothing except for angle brackets - -->
  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->

  <xsl:output-character
   character="&#x2329;"
   u:name="LEFT-POINTING ANGLE BRACKET"
   u:entity="lang"
   string="\(la"
   u:block="Miscellaneous Technical"
   />
  <xsl:output-character
   character="&#x232a;"
   u:name="RIGHT-POINTING ANGLE BRACKET"
   u:entity="rang"
   string="\(ra"
   u:block="Miscellaneous Technical"
   />

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Control Pictures -->
  <!-- *     x2400 to x243f -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x2400;"
   u:name="SYMBOL FOR NULL"
   string="NUL"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2401;"
   u:name="SYMBOL FOR START OF HEADING"
   string="SOH"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2402;"
   u:name="SYMBOL FOR START OF TEXT"
   string="STX"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2403;"
   u:name="SYMBOL FOR END OF TEXT"
   string="ETX"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2404;"
   u:name="SYMBOL FOR END OF TRANSMISSION"
   string="EOT"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2405;"
   u:name="SYMBOL FOR ENQUIRY"
   string="ENQ"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2406;"
   u:name="SYMBOL FOR ACKNOWLEDGE"
   string="ACK"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2407;"
   u:name="SYMBOL FOR BELL"
   string="BEL"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2408;"
   u:name="SYMBOL FOR BACKSPACE"
   string="BS"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2409;"
   u:name="SYMBOL FOR HORIZONTAL TABULATION"
   string="HT"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x240a;"
   u:name="SYMBOL FOR LINE FEED"
   string="LF"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x240b;"
   u:name="SYMBOL FOR VERTICAL TABULATION"
   string="VT"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x240c;"
   u:name="SYMBOL FOR FORM FEED"
   string="FF"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x240d;"
   u:name="SYMBOL FOR CARRIAGE RETURN"
   string="CR"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x240e;"
   u:name="SYMBOL FOR SHIFT OUT"
   string="SO"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x240f;"
   u:name="SYMBOL FOR SHIFT IN"
   string="SI"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2410;"
   u:name="SYMBOL FOR DATA LINK ESCAPE"
   string="DLE"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2411;"
   u:name="SYMBOL FOR DEVICE CONTROL ONE"
   string="DC1"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2412;"
   u:name="SYMBOL FOR DEVICE CONTROL TWO"
   string="DC2"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2413;"
   u:name="SYMBOL FOR DEVICE CONTROL THREE"
   string="DC3"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2414;"
   u:name="SYMBOL FOR DEVICE CONTROL FOUR"
   string="DC4"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2415;"
   u:name="SYMBOL FOR NEGATIVE ACKNOWLEDGE"
   string="NAK"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2416;"
   u:name="SYMBOL FOR SYNCHRONOUS IDLE"
   string="SYN"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2417;"
   u:name="SYMBOL FOR END OF TRANSMISSION BLOCK"
   string="ETB"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2418;"
   u:name="SYMBOL FOR CANCEL"
   string="CAN"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2419;"
   u:name="SYMBOL FOR END OF MEDIUM"
   string="EM"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x241a;"
   u:name="SYMBOL FOR SUBSTITUTE"
   string="SUB"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x241b;"
   u:name="SYMBOL FOR ESCAPE"
   string="ESC"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x241c;"
   u:name="SYMBOL FOR FILE SEPARATOR"
   string="FS"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x241d;"
   u:name="SYMBOL FOR GROUP SEPARATOR"
   string="GS"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x241e;"
   u:name="SYMBOL FOR RECORD SEPARATOR"
   string="RS"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x241f;"
   u:name="SYMBOL FOR UNIT SEPARATOR"
   string="US"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2420;"
   u:name="SYMBOL FOR SPACE"
   string="SP"
   u:block="Control Pictures"
   />
  <xsl:output-character
   character="&#x2421;"
   u:name="SYMBOL FOR DELETE"
   string="DEL"
   u:block="Control Pictures"
   />
  <!-- * no roff equivs for x2422 and x2423 -->
  <!-- *   <xsl:output-character -->
  <!-- *    character="&#x2422;" -->
  <!-- *    u:name="BLANK SYMBOL" -->
  <!-- *    string="?" -->
  <!-- *    u:block="Control Pictures" -->
  <!-- *    /> -->
  <!-- * I think there should be a roff equiv for &blank;, but as far as I -->
  <!-- * know, there is not... -->
  <!-- *   <xsl:output-character -->
  <!-- *    character="&#x2423;" -->
  <!-- *    u:name="OPEN BOX" -->
  <!-- *    u:entity="blank" -->
  <!-- *    string="?" -->
  <!-- *    u:block="Control Pictures" -->
  <!-- *    /> -->
  <xsl:output-character
   character="&#x2424;"
   u:name="SYMBOL FOR NEWLINE"
   string="NL"
   u:block="Control Pictures"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Control Pictures -->
  <!-- * ***************************************************************** -->

  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->
  <!-- *   Optical Character Recognition -->
  <!-- *     x2440 to x24ff -->
  <!-- *     - do nothing - -->
  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Enclosed Alphanumerics -->
  <!-- *     x2460 to x24ff -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x2460;"
   u:name="CIRCLED DIGIT ONE"
   string="1"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2461;"
   u:name="CIRCLED DIGIT TWO"
   string="2"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2462;"
   u:name="CIRCLED DIGIT THREE"
   string="3"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2463;"
   u:name="CIRCLED DIGIT FOUR"
   string="4"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2464;"
   u:name="CIRCLED DIGIT FIVE"
   string="5"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2465;"
   u:name="CIRCLED DIGIT SIX"
   string="6"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2466;"
   u:name="CIRCLED DIGIT SEVEN"
   string="7"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2467;"
   u:name="CIRCLED DIGIT EIGHT"
   string="8"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2468;"
   u:name="CIRCLED DIGIT NINE"
   string="9"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2469;"
   u:name="CIRCLED NUMBER TEN"
   string="10"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x246a;"
   u:name="CIRCLED NUMBER ELEVEN"
   string="11"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x246b;"
   u:name="CIRCLED NUMBER TWELVE"
   string="12"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x246c;"
   u:name="CIRCLED NUMBER THIRTEEN"
   string="13"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x246d;"
   u:name="CIRCLED NUMBER FOURTEEN"
   string="14"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x246e;"
   u:name="CIRCLED NUMBER FIFTEEN" 
   string="15"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x246f;"
   u:name="CIRCLED NUMBER SIXTEEN"
   string="16"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2470;"
   u:name="CIRCLED NUMBER SEVENTEEN"
   string="17"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2471;"
   u:name="CIRCLED NUMBER EIGHTEEN"
   string="18"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2472;"
   u:name="CIRCLED NUMBER NINETEEN"
   string="19"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2473;"
   u:name="CIRCLED NUMBER TWENTY"
   string="20"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2474;"
   u:name="PARENTHESIZED DIGIT ONE"
   string="(1)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2475;"
   u:name="PARENTHESIZED DIGIT TWO"
   string="(2)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2476;"
   u:name="PARENTHESIZED DIGIT THREE"
   string="(3)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2477;"
   u:name="PARENTHESIZED DIGIT FOUR"
   string="(4)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2478;"
   u:name="PARENTHESIZED DIGIT FIVE"
   string="(5)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2479;"
   u:name="PARENTHESIZED DIGIT SIX"
   string="(6)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x247a;"
   u:name="PARENTHESIZED DIGIT SEVEN"
   string="(7)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x247b;"
   u:name="PARENTHESIZED DIGIT EIGHT"
   string="(8)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x247c;"
   u:name="PARENTHESIZED DIGIT NINE"
   string="(9)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x247d;"
   u:name="PARENTHESIZED NUMBER TEN"
   string="(10)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x247e;"
   u:name="PARENTHESIZED NUMBER ELEVEN"
   string="(11)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x247f;"
   u:name="PARENTHESIZED NUMBER TWELVE"
   string="(12)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2480;"
   u:name="PARENTHESIZED NUMBER THIRTEEN"
   string="(13)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2481;"
   u:name="PARENTHESIZED NUMBER FOURTEEN"
   string="(14)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2482;"
   u:name="PARENTHESIZED NUMBER FIFTEEN"
   string="(15)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2483;"
   u:name="PARENTHESIZED NUMBER SIXTEEN"
   string="(16)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2484;"
   u:name="PARENTHESIZED NUMBER SEVENTEEN"
   string="(17)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2485;"
   u:name="PARENTHESIZED NUMBER EIGHTEEN"
   string="(18)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2486;"
   u:name="PARENTHESIZED NUMBER NINETEEN"
   string="(19)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2487;"
   u:name="PARENTHESIZED NUMBER TWENTY"
   string="(20)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2488;"
   u:name="DIGIT ONE FULL STOP"
   string="1."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2489;"
   u:name="DIGIT TWO FULL STOP"
   string="2."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x248a;"
   u:name="DIGIT THREE FULL STOP"
   string="3."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x248b;"
   u:name="DIGIT FOUR FULL STOP"
   string="4."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x248c;"
   u:name="DIGIT FIVE FULL STOP"
   string="5."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x248d;"
   u:name="DIGIT SIX FULL STOP"
   string="6."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x248e;"
   u:name="DIGIT SEVEN FULL STOP"
   string="7."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x248f;"
   u:name="DIGIT EIGHT FULL STOP"
   string="8."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2490;"
   u:name="DIGIT NINE FULL STOP"
   string="9."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2491;"
   u:name="NUMBER TEN FULL STOP"
   string="10."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2492;"
   u:name="NUMBER ELEVEN FULL STOP"
   string="11."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2493;"
   u:name="NUMBER TWELVE FULL STOP"
   string="12."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2494;"
   u:name="NUMBER THIRTEEN FULL STOP"
   string="13."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2495;"
   u:name="NUMBER FOURTEEN FULL STOP"
   string="14."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2496;"
   u:name="NUMBER FIFTEEN FULL STOP"
   string="15."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2497;"
   u:name="NUMBER SIXTEEN FULL STOP"
   string="16."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2498;"
   u:name="NUMBER SEVENTEEN FULL STOP"
   string="17."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x2499;"
   u:name="NUMBER EIGHTEEN FULL STOP"
   string="18."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x249a;"
   u:name="NUMBER NINETEEN FULL STOP"
   string="19."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x249b;"
   u:name="NUMBER TWENTY FULL STOP"
   string="20."
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x249c;"
   u:name="PARENTHESIZED LATIN SMALL LETTER A"
   string="(a)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x249d;"
   u:name="PARENTHESIZED LATIN SMALL LETTER B"
   string="(b)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x249e;"
   u:name="PARENTHESIZED LATIN SMALL LETTER C"
   string="(c)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x249f;"
   u:name="PARENTHESIZED LATIN SMALL LETTER D"
   string="(d)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a0;"
   u:name="PARENTHESIZED LATIN SMALL LETTER E"
   string="(e)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a1;"
   u:name="PARENTHESIZED LATIN SMALL LETTER F"
   string="(f)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a2;"
   u:name="PARENTHESIZED LATIN SMALL LETTER G"
   string="(g)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a3;"
   u:name="PARENTHESIZED LATIN SMALL LETTER H"
   string="(h)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a4;"
   u:name="PARENTHESIZED LATIN SMALL LETTER I"
   string="(i)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a5;"
   u:name="PARENTHESIZED LATIN SMALL LETTER J"
   string="(j)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a6;"
   u:name="PARENTHESIZED LATIN SMALL LETTER K"
   string="(k)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a7;"
   u:name="PARENTHESIZED LATIN SMALL LETTER L"
   string="(l)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a8;"
   u:name="PARENTHESIZED LATIN SMALL LETTER M"
   string="(m)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24a9;"
   u:name="PARENTHESIZED LATIN SMALL LETTER N"
   string="(n)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24aa;"
   u:name="PARENTHESIZED LATIN SMALL LETTER O"
   string="(o)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ab;"
   u:name="PARENTHESIZED LATIN SMALL LETTER P"
   string="(p)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ac;"
   u:name="PARENTHESIZED LATIN SMALL LETTER Q"
   string="(q)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ad;"
   u:name="PARENTHESIZED LATIN SMALL LETTER R"
   string="(r)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ae;"
   u:name="PARENTHESIZED LATIN SMALL LETTER S"
   string="(s)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24af;"
   u:name="PARENTHESIZED LATIN SMALL LETTER T"
   string="(t)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b0;"
   u:name="PARENTHESIZED LATIN SMALL LETTER U"
   string="(u)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b1;"
   u:name="PARENTHESIZED LATIN SMALL LETTER V"
   string="(v)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b2;"
   u:name="PARENTHESIZED LATIN SMALL LETTER W"
   string="(w)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b3;"
   u:name="PARENTHESIZED LATIN SMALL LETTER X"
   string="(x)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b4;"
   u:name="PARENTHESIZED LATIN SMALL LETTER Y"
   string="(y)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b5;"
   u:name="PARENTHESIZED LATIN SMALL LETTER Z"
   string="(z)"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b6;"
   u:name="CIRCLED LATIN CAPITAL LETTER A"
   string="A"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b7;"
   u:name="CIRCLED LATIN CAPITAL LETTER B"
   string="B"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b8;"
   u:name="CIRCLED LATIN CAPITAL LETTER C"
   string="C"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24b9;"
   u:name="CIRCLED LATIN CAPITAL LETTER D"
   string="D"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ba;"
   u:name="CIRCLED LATIN CAPITAL LETTER E"
   string="E"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24bb;"
   u:name="CIRCLED LATIN CAPITAL LETTER F"
   string="F"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24bc;"
   u:name="CIRCLED LATIN CAPITAL LETTER G"
   string="G"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24bd;"
   u:name="CIRCLED LATIN CAPITAL LETTER H"
   string="H"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24be;"
   u:name="CIRCLED LATIN CAPITAL LETTER I"
   string="I"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24bf;"
   u:name="CIRCLED LATIN CAPITAL LETTER J"
   string="J"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c0;"
   u:name="CIRCLED LATIN CAPITAL LETTER K"
   string="K"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c1;"
   u:name="CIRCLED LATIN CAPITAL LETTER L"
   string="L"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c2;"
   u:name="CIRCLED LATIN CAPITAL LETTER M"
   string="M"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c3;"
   u:name="CIRCLED LATIN CAPITAL LETTER N"
   string="N"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c4;"
   u:name="CIRCLED LATIN CAPITAL LETTER O"
   string="O"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c5;"
   u:name="CIRCLED LATIN CAPITAL LETTER P"
   string="P"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c6;"
   u:name="CIRCLED LATIN CAPITAL LETTER Q"
   string="Q"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c7;"
   u:name="CIRCLED LATIN CAPITAL LETTER R"
   string="R"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c8;"
   u:name="CIRCLED LATIN CAPITAL LETTER S"
   u:entity="oS"
   string="S"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24c9;"
   u:name="CIRCLED LATIN CAPITAL LETTER T"
   string="T"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ca;"
   u:name="CIRCLED LATIN CAPITAL LETTER U"
   string="U"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24cb;"
   u:name="CIRCLED LATIN CAPITAL LETTER V"
   string="V"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24cc;"
   u:name="CIRCLED LATIN CAPITAL LETTER W"
   string="W"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24cd;"
   u:name="CIRCLED LATIN CAPITAL LETTER X"
   string="X"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ce;"
   u:name="CIRCLED LATIN CAPITAL LETTER Y"
   string="Y"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24cf;"
   u:name="CIRCLED LATIN CAPITAL LETTER Z"
   string="Z"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d0;"
   u:name="CIRCLED LATIN SMALL LETTER A"
   string="a"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d1;"
   u:name="CIRCLED LATIN SMALL LETTER B"
   string="b"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d2;"
   u:name="CIRCLED LATIN SMALL LETTER C"
   string="c"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d3;"
   u:name="CIRCLED LATIN SMALL LETTER D"
   string="d"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d4;"
   u:name="CIRCLED LATIN SMALL LETTER E"
   string="e"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d5;"
   u:name="CIRCLED LATIN SMALL LETTER F"
   string="f"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d6;"
   u:name="CIRCLED LATIN SMALL LETTER G"
   string="g"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d7;"
   u:name="CIRCLED LATIN SMALL LETTER H"
   string="h"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d8;"
   u:name="CIRCLED LATIN SMALL LETTER I"
   string="i"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24d9;"
   u:name="CIRCLED LATIN SMALL LETTER J"
   string="j"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24da;"
   u:name="CIRCLED LATIN SMALL LETTER K"
   string="k"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24db;"
   u:name="CIRCLED LATIN SMALL LETTER L"
   string="l"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24dc;"
   u:name="CIRCLED LATIN SMALL LETTER M"
   string="m"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24dd;"
   u:name="CIRCLED LATIN SMALL LETTER N"
   string="n"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24de;"
   u:name="CIRCLED LATIN SMALL LETTER O"
   string="o"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24df;"
   u:name="CIRCLED LATIN SMALL LETTER P"
   string="p"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e0;"
   u:name="CIRCLED LATIN SMALL LETTER Q"
   string="q"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e1;"
   u:name="CIRCLED LATIN SMALL LETTER R"
   string="r"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e2;"
   u:name="CIRCLED LATIN SMALL LETTER S"
   string="s"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e3;"
   u:name="CIRCLED LATIN SMALL LETTER T"
   string="t"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e4;"
   u:name="CIRCLED LATIN SMALL LETTER U"
   string="u"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e5;"
   u:name="CIRCLED LATIN SMALL LETTER V"
   string="b"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e6;"
   u:name="CIRCLED LATIN SMALL LETTER W"
   string="w"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e7;"
   u:name="CIRCLED LATIN SMALL LETTER X"
   string="x"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e8;"
   u:name="CIRCLED LATIN SMALL LETTER Y"
   string="y"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24e9;"
   u:name="CIRCLED LATIN SMALL LETTER Z"
   string="z"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ea;"
   u:name="CIRCLED DIGIT ZERO"
   string="0"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24eb;"
   u:name="NEGATIVE CIRCLED NUMBER ELEVEN"
   string="11"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ec;"
   u:name="NEGATIVE CIRCLED NUMBER TWELVE"
   string="12"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ed;"
   u:name="NEGATIVE CIRCLED NUMBER THIRTEEN"
   string="13"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ee;"
   u:name="NEGATIVE CIRCLED NUMBER FOURTEEN"
   string="14"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24ef;"
   u:name="NEGATIVE CIRCLED NUMBER FIFTEEN"
   string="15"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f0;"
   u:name="NEGATIVE CIRCLED NUMBER SIXTEEN"
   string="16"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f1;"
   u:name="NEGATIVE CIRCLED NUMBER SEVENTEEN"
   string="17"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f2;"
   u:name="NEGATIVE CIRCLED NUMBER EIGHTEEN"
   string="18"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f3;"
   u:name="NEGATIVE CIRCLED NUMBER NINETEEN"
   string="19"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f4;"
   u:name="NEGATIVE CIRCLED NUMBER TWENTY"
   string="20"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f5;"
   u:name="DOUBLE CIRCLED DIGIT ONE"
   string="1"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f6;"
   u:name="DOUBLE CIRCLED DIGIT TWO"
   string="2"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f7;"
   u:name="DOUBLE CIRCLED DIGIT THREE"
   string="3"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f8;"
   u:name="DOUBLE CIRCLED DIGIT FOUR"
   string="4"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24f9;"
   u:name="DOUBLE CIRCLED DIGIT FIVE"
   string="5"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24fa;"
   u:name="DOUBLE CIRCLED DIGIT SIX"
   string="6"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24fb;"
   u:name="DOUBLE CIRCLED DIGIT SEVEN"
   string="7"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24fc;"
   u:name="DOUBLE CIRCLED DIGIT EIGHT"
   string="8"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24fd;"
   u:name="DOUBLE CIRCLED DIGIT NINE"
   string="9"
   u:block="Enclosed Alphanumerics"
   />
  <xsl:output-character
   character="&#x24fe;"
   u:name="DOUBLE CIRCLED NUMBER TEN"
   string="10"
   u:block="Enclosed Alphanumerics"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Enclosed Alphanumerics -->
  <!-- * ***************************************************************** -->

  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->
  <!-- *   Box Drawing -->
  <!-- *     x2500 to x257f -->
  <!-- *   Block Elements -->
  <!-- *     x2580 to x259f -->
  <!-- *   - do nothing - -->
  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->
  
  <!-- * ***************************************************************** -->
  <!-- *   Begin: Geometric Shapes -->
  <!-- *     x25a0 to x25f7 -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x25a1;"
   u:name="WHITE SQUARE"
   u:entity="squ"
   string="\(sq"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25a2;"
   u:name="WHITE SQUARE WITH ROUNDED CORNERS"
   string="\(sq"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25ab;"
   u:name="WHITE SMALL SQUARE"
   string="\(sq"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25ba;"
   u:name="BLACK RIGHT-POINTING POINTER"
   string="\fB>\fR"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25bb;"
   u:name="WHITE RIGHT-POINTING POINTER"
   string=">"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25bc;"
   u:name="BLACK DOWN-POINTING TRIANGLE"
   string="\fBv\fR"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25bd;"
   u:name="WHITE DOWN-POINTING TRIANGLE"
   u:entity="xdtri"
   string="v"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25c4;"
   u:name="BLACK LEFT-POINTING POINTER"
   string="\fB&lt;\fR"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25c5;"
   u:name="WHITE LEFT-POINTING POINTER"
   string="&lt;"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25c6;"
   u:name="BLACK DIAMOND"
   string="\(DI"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25c7;"
   u:name="WHITE DIAMOND"
   string="\(lz"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25ca;"
   u:name="LOZENGE"
   u:entity="loz"
   string="\(lz"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25cb;"
   u:name="WHITE CIRCLE"
   u:entity="cir"
   string="\(ci"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25cf;"
   u:name="BLACK CIRCLE"
   string="\(bu"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25e6;"
   u:name="WHITE BULLET"
   string="\(ci"
   u:block="Geometric Shapes"
   />
  <xsl:output-character
   character="&#x25ef;"
   u:name="LARGE CIRCLE"
   u:entity="xcirc"
   string="\(ci"
   u:block="Geometric Shapes"
   />
  <!-- * ***************************************************************** -->
  <!-- *   End: Geometric Shapes -->
  <!-- *   x25a0 to x25f7 -->
  <!-- * ***************************************************************** -->

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Miscellaneous Symbols -->
  <!-- *   x2600 to x26ff -->
  <!-- * ***************************************************************** -->
  
  <xsl:output-character
   character="&#x261a;"
   u:name="BLACK LEFT POINTING INDEX"
   string="\(lh"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x261b;"
   u:name="BLACK RIGHT POINTING INDEX"
   string="\(rh)"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x261c;"
   u:name="WHITE LEFT POINTING INDEX"
   string="\(lh"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x261e;"
   u:name="WHITE RIGHT POINTING INDEX"
   string="\(rh)"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x2660;"
   u:name="BLACK SPADE SUIT"
   u:entity="spades"
   string="\(SP"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x2661;"
   u:name="WHITE HEART SUIT"
   string="\(HE"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x2662;"
   u:name="WHITE DIAMOND SUIT"
   string="\(DI"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x2663;"
   u:name="BLACK CLUB SUIT"
   u:entity="clubs"
   string="\(CL"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x2664;"
   u:name="WHITE SPADE SUIT"
   string="\(SP"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x2665;"
   u:name="BLACK HEART SUIT"
   u:entity="hearts"
   string="\(HE"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x2666;"
   u:name="BLACK DIAMOND SUIT"
   u:entity="diams"
   string="\(DI"
   u:block="Miscellaneous Symbols"
   />
  <xsl:output-character
   character="&#x2667;"
   u:name="WHITE CLUB SUIT"
   string="\(CL"
   u:block="Miscellaneous Symbols"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Miscellaneous Symbols -->
  <!-- * ***************************************************************** -->

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Dingbats -->
  <!-- *     x2700 to x27be -->
  <!-- *     No roff equiv for most of these; just map to something close -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#x2713;"
   u:name="CHECK MARK"
   u:entity="check"
   string="\(OK"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2714;"
   u:name="HEAVY CHECK MARK"
   string="\fB\(OK\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2715;"
   u:name="MULTIPLICATION X"
   string="\(mu"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2716;"
   u:name="HEAVY MULTIPLICATION X"
   string="\fB\(mu\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2717;"
   u:name="BALLOT X"
   u:entity="cross"
   string="\(mu"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2718;"
   u:name="HEAVY BALLOT X"
   string="\fB\(mu\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2719;"
   u:name="OUTLINED GREEK CROSS"
   string="\fB+\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x271a;"
   u:name="HEAVY GREEK CROSS"
   string="\fB+\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x271b;"
   u:name="OPEN CENTRE CROSS"
   string="\fB+\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x271c;"
   u:name="HEAVY OPEN CENTRE CROSS"
   string="\fB+\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x271d;"
   u:name="LATIN CROSS"
   string="\fB+\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x271e;"
   u:name="SHADOWED WHITE LATIN CROSS"
   string="\fB+\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x271f;"
   u:name="OUTLINED LATIN CROSS"
   string="\fB+\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2720;"
   u:name="MALTESE CROSS"
   u:entity="malt"
   string="\fB+\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2721;"
   u:name="STAR OF DAVID"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2722;"
   u:name="FOUR TEARDROP-SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2723;"
   u:name="FOUR BALLOON-SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2724;"
   u:name="HEAVY FOUR BALLOON-SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2725;"
   u:name="FOUR CLUB-SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2726;"
   u:name="BLACK FOUR POINTED STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2727;"
   u:name="WHITE FOUR POINTED STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2729;"
   u:name="STRESS OUTLINED WHITE STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x272a;"
   u:name="CIRCLED WHITE STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x272b;"
   u:name="OPEN CENTRE BLACK STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x272c;"
   u:name="BLACK CENTRE WHITE STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x272d;"
   u:name="OUTLINED BLACK STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x272e;"
   u:name="HEAVY OUTLINED BLACK STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x272f;"
   u:name="PINWHEEL STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2730;"
   u:name="SHADOWED WHITE STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2731;"
   u:name="HEAVY ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2732;"
   u:name="OPEN CENTRE ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2733;"
   u:name="EIGHT SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2734;"
   u:name="EIGHT POINTED BLACK STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2735;"
   u:name="EIGHT POINTED PINWHEEL STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2736;"
   u:name="SIX POINTED BLACK STAR"
   u:entity="sext"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2737;"
   u:name="EIGHT POINTED RECTILINEAR BLACK STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2738;"
   u:name="HEAVY EIGHT POINTED RECTILINEAR BLACK STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2739;"
   u:name="TWELVE POINTED BLACK STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x273a;"
   u:name="SIXTEEN POINTED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x273b;"
   u:name="TEARDROP-SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x273c;"
   u:name="OPEN CENTRE TEARDROP-SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x273d;"
   u:name="HEAVY TEARDROP-SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x273e;"
   u:name="SIX PETALLED BLACK AND WHITE FLORETTE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x273f;"
   u:name="BLACK FLORETTE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2740;"
   u:name="WHITE FLORETTE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2741;"
   u:name="EIGHT PETALLED OUTLINED BLACK FLORETTE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2742;"
   u:name="CIRCLED OPEN CENTRE EIGHT POINTED STAR"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2743;"
   u:name="HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2744;"
   u:name="SNOWFLAKE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2745;"
   u:name="TIGHT TRIFOLIATE SNOWFLAKE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2746;"
   u:name="HEAVY CHEVRON SNOWFLAKE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2747;"
   u:name="SPARKLE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2748;"
   u:name="HEAVY SPARKLE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2749;"
   u:name="BALLOON-SPOKED ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x274a;"
   u:name="EIGHT TEARDROP-SPOKED PROPELLER ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x274b;"
   u:name="HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x274d;"
   u:name="SHADOWED WHITE CIRCLE"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x274f;"
   u:name="LOWER RIGHT DROP-SHADOWED WHITE SQUARE"
   string="\(sq"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2750;"
   u:name="UPPER RIGHT DROP-SHADOWED WHITE SQUARE"
   string="\(sq"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2751;"
   u:name="LOWER RIGHT SHADOWED WHITE SQUARE"
   string="\(sq"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2752;"
   u:name="UPPER RIGHT SHADOWED WHITE SQUARE"
   string="\(sq"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2756;"
   u:name="BLACK DIAMOND MINUS WHITE X"
   string="*"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2758;"
   u:name="LIGHT VERTICAL BAR"
   string="\(bv"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2759;"
   u:name="MEDIUM VERTICAL BAR"
   string="\fB\(bv\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x275a;"
   u:name="HEAVY VERTICAL BAR"
   string="\fB\(bv\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x275b;"
   u:name="HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT"
   string="\fB\(oq\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x275c;"
   u:name="HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT"
   string="\fB\(cq\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x275d;"
   u:name="HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT"
   string="\fB\(lq\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x275e;"
   u:name="HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT"
   string="\fB\(rq\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2761;"
   u:name="CURVED STEM PARAGRAPH SIGN ORNAMENT"
   string="\(ps"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2762;"
   u:name="HEAVY EXCLAMATION MARK ORNAMENT"
   string="\fB!\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2763;"
   u:name="HEAVY HEART EXCLAMATION MARK ORNAMENT"
   string="\fB!\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2764;"
   u:name="HEAVY BLACK HEART"
   string="\fB\(HE\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2765;"
   u:name="ROTATED HEAVY BLACK HEART BULLET"
   string="\fB\(HE\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2766;"
   u:name="FLORAL HEART"
   string="\fB\(HE\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2767;"
   u:name="ROTATED FLORAL HEART BULLET"
   string="\fB\(HE\fR"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2776;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT ONE"
   string="1"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2777;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT TWO"
   string="2"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2778;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT THREE"
   string="3"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2779;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT FOUR"
   string="4"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x277a;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT FIVE"
   string="5"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x277b;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT SIX"
   string="6"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x277c;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT SEVEN"
   string="7"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x277d;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT EIGHT"
   string="8"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x277e;"
   u:name="DINGBAT NEGATIVE CIRCLED DIGIT NINE"
   string="9"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x277f;"
   u:name="DINGBAT NEGATIVE CIRCLED NUMBER TEN"
   string="10"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2780;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT ONE"
   string="1"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2781;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT TWO"
   string="2"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2782;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT THREE"
   string="3"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2783;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT FOUR"
   string="4"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2784;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT FIVE"
   string="5"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2785;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT SIX"
   string="6"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2786;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN"
   string="7"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2787;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT"
   string="8"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2788;"
   u:name="DINGBAT CIRCLED SANS-SERIF DIGIT NINE"
   string="9"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2789;"
   u:name="DINGBAT CIRCLED SANS-SERIF NUMBER TEN"
   string="10"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x278a;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE"
   string="1"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x278b;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO"
   string="2"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x278c;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE"
   string="3"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x278d;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR"
   string="4"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x278e;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE"
   string="5"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x278f;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX"
   string="6"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2790;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN"
   string="7"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2791;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT"
   string="8"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2792;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE"
   string="9"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2793;"
   u:name="DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN"
   string="10"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2794;"
   u:name="HEAVY WIDE-HEADED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x2799;"
   u:name="HEAVY RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x279b;"
   u:name="DRAFTING POINT RIGHTWARDS ARROW"
   string="\(->"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x279c;"
   u:name="HEAVY ROUND-TIPPED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x279d;"
   u:name="TRIANGLE-HEADED RIGHTWARDS ARROW"
   string="\(->"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x279e;"
   u:name="HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x279f;"
   u:name="DASHED TRIANGLE-HEADED RIGHTWARDS ARROW"
   string="\(->"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27a0;"
   u:name="HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27a1;"
   u:name="BLACK RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27a2;"
   u:name="THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD"
   string="\(->"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27a3;"
   u:name="THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD"
   string="\(->"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27a4;"
   u:name="BLACK RIGHTWARDS ARROWHEAD"
   string="\(->"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27a7;"
   u:name="SQUAT BLACK RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27a8;"
   u:name="HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27a9;"
   u:name="RIGHT-SHADED WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27aa;"
   u:name="LEFT-SHADED WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27ab;"
   u:name="BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27ac;"
   u:name="FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27ad;"
   u:name="HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27ae;"
   u:name="HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27af;"
   u:name="NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b1;"
   u:name="NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b2;"
   u:name="CIRCLED HEAVY WHITE RIGHTWARDS ARROW"
   string="\(rA"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b3;"
   u:name="WHITE-FEATHERED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b4;"
   u:name="BLACK-FEATHERED SOUTH EAST ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b5;"
   u:name="BLACK-FEATHERED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b6;"
   u:name="BLACK-FEATHERED NORTH EAST ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b7;"
   u:name="HEAVY BLACK-FEATHERED SOUTH EAST ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b8;"
   u:name="HEAVY BLACK-FEATHERED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27b9;"
   u:name="HEAVY BLACK-FEATHERED NORTH EAST ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27ba;"
   u:name="TEARDROP-BARBED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27bb;"
   u:name="HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27bc;"
   u:name="WEDGE-TAILED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27bd;"
   u:name="HEAVY WEDGE-TAILED RIGHTWARDS ARROW"
   string="\fR\(->\fB"
   u:block="Dingbats"
   />
  <xsl:output-character
   character="&#x27be;"
   u:name="OPEN-OUTLINED RIGHTWARDS ARROW"
   string="\fR\(rA\fB"
   u:block="Dingbats"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Dingbats -->
  <!-- * ***************************************************************** -->

  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->
  <!-- *   Miscellaneous Mathematical Symbols -->
  <!-- *     x27c0 to x27ef -->
  <!-- *   Supplemental Arrows -->
  <!-- *     x27f0 to x297f -->
  <!-- *   Miscellaneous Mathematical Symbols -->
  <!-- *     x2980 to x29ff -->
  <!-- *   Supplemental Mathematical Operators -->
  <!-- *     x2a00 to x2aff -->
  <!-- *   - no nothing - -->
  <!-- * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -->

  <!-- * ***************************************************************** -->
  <!-- *   Begin: Alphabetic Presentation Forms -->
  <!-- *     xfb00 to xfb04 -->
  <!-- * ***************************************************************** -->

  <xsl:output-character
   character="&#xfb00;"
   u:name="LATIN SMALL LIGATURE FF"
   u:entity="fflig"
   string="\(ff"
   u:block="Alphabetic Presentation Forms"
   />
  <xsl:output-character
   character="&#xfb01;"
   u:name="LATIN SMALL LIGATURE FI"
   u:entity="filig"
   string="\(fi"
   u:block="Alphabetic Presentation Forms"
   />
  <xsl:output-character
   character="&#xfb02;"
   u:name="LATIN SMALL LIGATURE FL"
   u:entity="fllig"
   string="\(fl"
   u:block="Alphabetic Presentation Forms"
   />
  <xsl:output-character
   character="&#xfb03;"
   u:name="LATIN SMALL LIGATURE FFI"
   u:entity="ffilig"
   string="\(Fi"
   u:block="Alphabetic Presentation Forms"
   />
  <xsl:output-character
   character="&#xfb04;"
   u:name="LATIN SMALL LIGATURE FFL"
   u:entity="ffllig"
   string="\(Fl"
   u:block="Alphabetic Presentation Forms"
   />

  <!-- * ***************************************************************** -->
  <!-- *   End: Alphabetic Presentation Forms -->
  <!-- * ***************************************************************** -->

  <!-- * ================================================================= -->

  <!-- * Regarding x2060 vs. xFEFF, the document "Unicode Standard Annex #14, -->
  <!-- * Line Breaking Properties"[1] says: -->
  <!-- * -->
  <!-- *   The word joiner character [x2060 a.k.a "WJ"] is the preferred -->
  <!-- *   choice for an invisible character to keep other characters -->
  <!-- *   together that would otherwise be split across the line at a direct -->
  <!-- *   break. The character FEFF has the same effect, but because it is -->
  <!-- *   also used in an unrelated way as a byte order mark, the use of the -->
  <!-- *   WJ as the preferred interword glue simplifies the handling of FEFF. -->
  <!-- * -->
  <!-- * [1] http://www.unicode.org/reports/tr14/ -->
  <!-- * -->
  <!-- * We include it here anyway & map to the roff zero-width no-break -->
  <xsl:output-character
   character="&#xfeff;"
   u:name="ZERO WIDTH NO-BREAK SPACE"
   string="\&amp;"
   u:block="Arabic Presentation Forms-B"
   />
</xsl:character-map>
</xsl:stylesheet>
