/**
 *    Copyright 2011 Peter Murray-Rust et. al.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// /*======AUTOGENERATED FROM SCHEMA; DO NOT EDIT BELOW THIS LINE ======*/
package org.xmlcml.cml.element;

import java.io.IOException;
import java.io.Writer;

import nu.xom.Element;
import org.xmlcml.cml.base.CMLElement;

/** Metadata for a column of a table.
*
*
* Must be used in conjunction with multiplierToSI and/or constantToSI
*
* user-modifiable class autogenerated from schema if no class exists
* use as a shell which can be edited
* the autogeneration software will not overwrite an existing class file

*/
public class CMLTableHeaderCell extends org.xmlcml.cml.element.AbstractTableHeaderCell {

    /** must give simple documentation.
    *

    */

    public CMLTableHeaderCell() {
    }
    /** must give simple documentation.
    *
    * @param old CMLTableHeaderCell to copy

    */

    public CMLTableHeaderCell(CMLTableHeaderCell old) {
        super((org.xmlcml.cml.element.AbstractTableHeaderCell) old);
    }

    /** copy node .
    *
    * @return Node
    */
    public Element copy() {
        return new CMLTableHeaderCell(this);
    }
    /** create new instance in context of parent, overridable by subclasses.
    *
    * @param parent parent of element to be constructed (ignored by default)
    * @return CMLTableHeaderCell
    */
    public CMLElement makeElementInContext(Element parent) {
        return new CMLTableHeaderCell();
    }

    /** create CMLArray with attributes from this.
     *
     * @return array
     */
    public CMLArray createCMLArray() {
        CMLArray array = new CMLArray();
        if (this.getDataTypeAttribute() != null) {
            array.setDataType(this.getDataType());
        }
        if (this.getDictRefAttribute() != null) {
            array.setDictRef(this.getDictRef());
        }
        if (this.getTitleAttribute() != null) {
            array.setTitle(this.getTitle());
        }
        if (this.getConventionAttribute() != null) {
            array.setConvention(this.getConvention());
        }
        if (this.getIdAttribute() != null) {
            array.setId(this.getId());
        }
        return array;
    }

    /** write as HTML.
     *
     * @param w writer
     * @throws IOException
     */
    public void writeHTML(Writer w) throws IOException {
        String dictRef = this.getDictRef();
        w.write("<th");
        if (dictRef != null) {
            w.write(" class='" + dictRef + "'");
        }
        w.write(">");
        w.write(this.getTitle());
        w.write("</th>");
    }
}
