/****************************************************************************
 *    lib/c/StaticRule.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "StaticRule.h"

using namespace C;

StaticRule::StaticRule(int line, Formula* F, Formula* G, Types* types) : Statement(line, types) {
	F_ = F;
	G_ = G;
}

StaticRule::~StaticRule ( ) { }

void StaticRule::print(Printer* p) {
	if(p->no_direct_enc) {
		printNonDirect(p);
	}
	else {
		printDirect(p);
	}
}

void StaticRule::printDirect(Printer* p) {
	string T;
	set<Variable*>* vars = new set<Variable*>();
	
	// print the static rule twice: for T=0 and T>0
	for(int i = 1; i <= 2; ++i) {
		if(i == 1) {
			p->setSection('b');
			T = "0";
		}
		else {
			p->setSection('c');
			T = p->T;
		}

		FluentAction* f;
		FluentAction* g;
		string neg_f = p->neg;
		string neg_g = p->neg;

		// f1_fluent(T-1) :- not -g1_fluent(T-1).
		for(vector<Formula*>::iterator fluent_f = F_->begin(); fluent_f != F_->end(); ++fluent_f) {
			if(!(*fluent_f)->isFalse()) {
				// check for negation
				if((*fluent_f)->getType() == 'n') {
					f = (FluentAction*) (*fluent_f)->getFirstFormula();
					neg_f = p->neg;
				}
				else {
					f = (FluentAction*) *fluent_f;
					neg_f = "";
				}
				
				vars = f->getVariables();
				
				p->add(neg_f + f->print(p, T));
			}
			
			// print G part
			if(G_ && !G_->isTrue()) {
				p->add(" :- ");

				for(vector<Formula*>::iterator fluent_g = G_->begin(); fluent_g != G_->end(); ++fluent_g) {
					// check for negation
					if((*fluent_g)->getType() == 'n') {
						g = (FluentAction*) (*fluent_g)->getFirstFormula();
						neg_g = "";
					}
					else {
						g = (FluentAction*) *fluent_g;
						neg_g = p->neg;
					}
					
					p->add("not " + neg_g + g->print(p, T));
					if(fluent_g != G_->end()-1) p->add(", ");
					
					// get the vars
					set<Variable*>* tmp_vars = g->getVariables();
					if(!tmp_vars->empty()) vars->insert(tmp_vars->begin(), tmp_vars->end());
					delete tmp_vars;
				}
			}

			if(!vars->empty()) {
				if(G_ && !G_->isTrue()) {
					p->add(", ");
				} else {
					p->add(" :- ");
				}
				types_.print(p, vars, line_);
			}
			p->add(".\n");

		}
	} // end main for
	
	delete vars;
}


void StaticRule::printNonDirect(Printer* p) {
	p->setSection('b');
	set<Variable*>* vars = new set<Variable*>();
	
	p->add("caused(");
	F_->print(p, vars);
	p->add(",");
	if(G_) G_->print(p, vars);
	else p->add("\"true\"");
	p->add(",\"true\",\"true\")");
	
	if(vars->empty()) p->add(".\n");
	else {
		p->add(" :- ");
		types_.print(p, vars, line_);
		p->add(".\n");
	}
	
	F_->printCompositeFluents(p, &types_);
	if(G_) G_->printCompositeFluents(p, &types_);
	
	delete vars;
}
