/*
 * libcolorblind - Pixel Filter for colorblind accessibility
 *
 * This is in Public Domain
 * Original Author: Daniel Ruoso <daniel@ruoso.com>
 *
 * This library provides an unified way to recalculate colors
 * in order to present alternative views on images for colorblind
 * people.
 *
 */
#include <string.h>
#include <stdlib.h>
#include "colorblind.h"
#include "filters.h"

COLORBLIND_RUNTIME* colorblind_create() {
        COLORBLIND_RUNTIME* runtime = malloc(sizeof(COLORBLIND_RUNTIME));
        memset(runtime,0,sizeof(COLORBLIND_RUNTIME));
        return runtime;
}

int colorblind_destroy(COLORBLIND_RUNTIME* cbr) {
        free(cbr);
        return 0;
}

int colorblind_filter(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        switch (cbr->filter_type) {
        case colorblind_filter_t_no_filter:
                return 0;
        case colorblind_filter_t_selective_saturate_red:
                return colorblind_filter_selective_saturate_red(cbr,color);
        case colorblind_filter_t_selective_saturate_green:
                return colorblind_filter_selective_saturate_green(cbr,color);
        case colorblind_filter_t_selective_saturate_blue:
                return colorblind_filter_selective_saturate_blue(cbr,color);
        case colorblind_filter_t_selective_dessaturate_red:
                return colorblind_filter_selective_dessaturate_red(cbr,color);
        case colorblind_filter_t_selective_dessaturate_green:
                return colorblind_filter_selective_dessaturate_green(cbr,color);
        case colorblind_filter_t_selective_dessaturate_blue:
                return colorblind_filter_selective_dessaturate_blue(cbr,color);
        case colorblind_filter_t_hue_shift_positive:
                return colorblind_filter_hue_shift_positive(cbr,color);
        case colorblind_filter_t_hue_shift_negative:
                return colorblind_filter_hue_shift_negative(cbr,color);
        default:
                return 0;
        }
}

int colorblind_set_filter_type(COLORBLIND_RUNTIME* cbr, enum COLORBLIND_FILTER_TYPE type) {
        // For start, the first filters doesn't need arguments
        if (type >= colorblind_filter_t_selective_saturate) {
                if (cbr->base_color == NULL) {
                        return 1;
                }
        }
        cbr->filter_type = type;
        return 0;
}

int colorblind_set_base_color(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        cbr->base_color_count = 1;
        cbr->base_color = color;
        return 0;
}

int colorblind_set_base_colors(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color, int count) {
        cbr->base_color_count = count;
        cbr->base_color = color;
        return 0;
}

int colorblind_remove_base_color(COLORBLIND_RUNTIME* cbr) {
        cbr->base_color = NULL;
        cbr->base_color_count = 0;
        return 0;
}
