# discover-my-major

Discover key bindings and their meaning for the current Emacs major mode.

The command is inspired by [discover.el](https://github.com/mickeynp/discover.el) and also uses the [makey library](https://github.com/mickeynp/makey). I thought, "Hey! Why not parse the information about the major mode bindings somehow and display that like `discover.el` does..."

The output is pretty bare bones and not optimized but it seems to work already quite well for most modes:

![package-menu-mode screenshot](https://raw.github.com/steckerhalter/discover-my-major/master/package-menu-mode.png)

![git-commit-mode screenshot](https://raw.github.com/steckerhalter/discover-my-major/master/git-commit-mode.png)

## Installation

### quelpa

`quelpa` is at https://github.com/quelpa/quelpa

```lisp
(quelpa '(discover-my-major :fetcher github :repo "steckerhalter/discover-my-major"))
```

### MELPA

Packages are available in [MELPA](http://melpa.milkbox.net/).

### el-get

```lisp
(:name discover-my-major
       :type git
       :url "https://github.com/steckerhalter/discover-my-major")
```

## Usage

In any mode you should be able to summon the popup by invoking `M-x discover-my-major` which will show you a list of key bindings with descriptions.

The recommended key binding is `C-h C-m` (please be aware that by default `C-h C-m` is bound to `view-order-manuals` so please use another binding if you want to keep that):

```lisp
(global-set-key (kbd "C-h C-m") 'discover-my-major)
```
