/*++

Copyright (c) 2004 - 2006, Intel Corporation. All rights reserved.<BR>
This program and the accompanying materials                          
are licensed and made available under the terms and conditions of the BSD License         
which accompanies this distribution.  The full text of the license may be found at        
http://opensource.org/licenses/bsd-license.php                                            
                                                                                          
THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,                     
WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.  


Module Name:

  EdkIIGluePeimEntryPoint.h
  
Abstract: 

  Public header file for PEIM Entry Point Lib

--*/

#ifndef __EDKII_GLUE_PEIM_ENTRY_POINT_H__
#define __EDKII_GLUE_PEIM_ENTRY_POINT_H__

//
// Declare the EFI/UEFI Specification Revision to which this driver is implemented 
//
extern const UINT32                   _gPeimRevision;

/**
  Image entry point of Peim.

  @param  FfsHeader   Pointer to FFS header the loaded driver.
  @param  PeiServices Pointer to the PEI services.

  @return  Status returned by entry points of Peims.

**/
EFI_STATUS
EFIAPI
_ModuleEntryPoint (
  IN EFI_FFS_FILE_HEADER       *FfsHeader,
  IN EFI_PEI_SERVICES          **PeiServices
  );


/**
  Wrapper of Peim image entry point.

  @param  FfsHeader   Pointer to FFS header the loaded driver.
  @param  PeiServices Pointer to the PEI services.

  @return  Status returned by entry points of Peims.

**/
EFI_STATUS
EFIAPI
EfiMain (
  IN EFI_FFS_FILE_HEADER       *FfsHeader,
  IN EFI_PEI_SERVICES          **PeiServices
  );


/**
  Call constructs for all libraries. Automatics Generated by tool.

  @param  FfsHeader   Pointer to FFS header the loaded driver.
  @param  PeiServices Pointer to the PEI services.

**/
VOID
EFIAPI
ProcessLibraryConstructorList (
  IN EFI_FFS_FILE_HEADER       *FfsHeader,
  IN EFI_PEI_SERVICES          **PeiServices
  );


/**
  Call destructors for all libraries. Automatics Generated by tool.

  @param  FfsHeader   Pointer to FFS header the loaded driver.
  @param  PeiServices Pointer to the PEI services.

**/
VOID
EFIAPI
ProcessLibraryDestructorList (
  IN EFI_FFS_FILE_HEADER       *FfsHeader,
  IN EFI_PEI_SERVICES          **PeiServices
  );


/**
  Call the list of driver entry points. Automatics Generated by tool.

  @param  FfsHeader   Pointer to FFS header the loaded driver.
  @param  PeiServices Pointer to the PEI services.

  @return Status returned by entry points of drivers.  
 
**/
EFI_STATUS
EFIAPI
ProcessModuleEntryPointList (
  IN EFI_FFS_FILE_HEADER       *FfsHeader,
  IN EFI_PEI_SERVICES          **PeiServices
  );

#endif
