#
# Autogenerated by Thrift
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

require 'Evernote/EDAM/limits_types'


module Evernote
  module EDAM
    module Type
            module PrivilegeLevel
              NORMAL = 1
              PREMIUM = 3
              MANAGER = 7
              SUPPORT = 8
              ADMIN = 9
              VALUE_MAP = {1 => "NORMAL", 3 => "PREMIUM", 7 => "MANAGER", 8 => "SUPPORT", 9 => "ADMIN"}
              VALID_VALUES = Set.new([NORMAL, PREMIUM, MANAGER, SUPPORT, ADMIN]).freeze
            end

            module QueryFormat
              USER = 1
              SEXP = 2
              VALUE_MAP = {1 => "USER", 2 => "SEXP"}
              VALID_VALUES = Set.new([USER, SEXP]).freeze
            end

            module NoteSortOrder
              CREATED = 1
              UPDATED = 2
              RELEVANCE = 3
              UPDATE_SEQUENCE_NUMBER = 4
              TITLE = 5
              VALUE_MAP = {1 => "CREATED", 2 => "UPDATED", 3 => "RELEVANCE", 4 => "UPDATE_SEQUENCE_NUMBER", 5 => "TITLE"}
              VALID_VALUES = Set.new([CREATED, UPDATED, RELEVANCE, UPDATE_SEQUENCE_NUMBER, TITLE]).freeze
            end

            module PremiumOrderStatus
              NONE = 0
              PENDING = 1
              ACTIVE = 2
              FAILED = 3
              CANCELLATION_PENDING = 4
              CANCELED = 5
              VALUE_MAP = {0 => "NONE", 1 => "PENDING", 2 => "ACTIVE", 3 => "FAILED", 4 => "CANCELLATION_PENDING", 5 => "CANCELED"}
              VALID_VALUES = Set.new([NONE, PENDING, ACTIVE, FAILED, CANCELLATION_PENDING, CANCELED]).freeze
            end

            #  In several places, EDAM exchanges blocks of bytes of data for a component
            #  which may be relatively large.  For example:  the contents of a clipped
            #  HTML note, the bytes of an embedded image, or the recognition XML for
            #  a large image.  This structure is used in the protocol to represent
            #  any of those large blocks of data when they are transmitted or when
            #  they are only referenced their metadata.
            # 
            # <dl>
            #  <dt>bodyHash</dt>
            #    <dd>This field carries a one-way hash of the contents of the
            #    data body, in binary form.  The hash function is MD5<br/>
            #    Length:  EDAM_HASH_LEN (exactly)
            #    </dd>
            # 
            #  <dt>size</dt>
            #    <dd>The length, in bytes, of the data body.
            #    </dd>
            # 
            #  <dt>body</dt>
            #    <dd>This field is set to contain the binary contents of the data
            #    whenever the resource is being transferred.  If only metadata is
            #    being exchanged, this field will be empty.  For example, a client could
            #    notify the service about the change to an attribute for a resource
            #    without transmitting the binary resource contents.
            #    </dd>
            #  </dl>
            class Data
              include ::Thrift::Struct, ::Thrift::Struct_Union
              BODYHASH = 1
              SIZE = 2
              BODY = 3

              FIELDS = {
                BODYHASH => {:type => ::Thrift::Types::STRING, :name => 'bodyHash', :binary => true, :optional => true},
                SIZE => {:type => ::Thrift::Types::I32, :name => 'size', :optional => true},
                BODY => {:type => ::Thrift::Types::STRING, :name => 'body', :binary => true, :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            #  A structure holding the optional attributes that can be stored
            #  on a User.  These are generally less critical than the core User fields.
            # 
            # <dl>
            #  <dt>defaultLocationName</dt>
            #    <dd>the location string that should be associated
            #    with the user in order to determine where notes are taken if not otherwise
            #    specified.<br/>
            #    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #    </dd>
            # 
            #  <dt>defaultLatitude</dt>
            #    <dd>if set, this is the latitude that should be
            #    assigned to any notes that have no other latitude information.
            #    </dd>
            # 
            #  <dt>defaultLongitude</dt>
            #    <dd>if set, this is the longitude that should be
            #    assigned to any notes that have no other longitude information.
            #    </dd>
            # 
            #  <dt>preactivation</dt>
            #    <dd>if set, the user account is not yet confirmed for
            #    login.  I.e. the account has been created, but we are still waiting for
            #    the user to complete the activation step.
            #    </dd>
            # 
            #  <dt>viewedPromotions</dt>
            #    <dd>a list of promotions the user has seen.
            #     This list may occasionally be modified by the system when promotions are
            #     no longer available.<br/>
            #     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #    </dd>
            # 
            #  <dt>incomingEmailAddress</dt>
            #    <dd>if set, this is the email address that the
            #     user may send email to in order to add an email note directly into the
            #     account via the SMTP email gateway.  This is the part of the email
            #     address before the '@' symbol ... our domain is not included.
            #     If this is not set, the user may not add notes via the gateway.<br/>
            #     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #    </dd>
            # 
            #  <dt>recentMailedAddresses</dt>
            #    <dd>if set, this will contain a list of email
            #     addresses that have recently been used as recipients
            #     of outbound emails by the user.  This can be used to pre-populate a
            #     list of possible destinations when a user wishes to send a note via
            #     email.<br/>
            #     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX each<br/>
            #     Max:  EDAM_USER_RECENT_MAILED_ADDRESSES_MAX entries
            #    </dd>
            # 
            #  <dt>comments</dt>
            #    <dd>Free-form text field that may hold general support
            #     information, etc.<br/>
            #     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #    </dd>
            # 
            #  <dt>dateAgreedToTermsOfService</dt>
            #    <dd>The date/time when the user agreed to
            #     the terms of service.  This can be used as the effective "start date"
            #     for the account.
            #    </dd>
            # 
            #  <dt>maxReferrals</dt>
            #    <dd>The number of referrals that the user is permitted
            #     to make.
            #    </dd>
            # 
            #  <dt>referralCount</dt>
            #    <dd>The number of referrals sent from this account.
            #    </dd>
            # 
            #  <dt>refererCode</dt>
            #    <dd>A code indicating where the user was sent from. AKA
            #     promotion code
            #    </dd>
            #     
            #  <dt>sentEmailDate</dt>
            #    <dd>The most recent date when the user sent outbound
            #     emails from the service.  Used with sentEmailCount to limit the number
            #     of emails that can be sent per day.
            #    </dd>
            #     
            #  <dt>sentEmailCount</dt>
            #    <dd>The number of emails that were sent from the user
            #     via the service on sentEmailDate.  Used to enforce a limit on the number
            #     of emails per user per day to prevent spamming.
            #    </dd>
            # 
            #  <dt>dailyEmailLimit</dt>
            #    <dd>If set, this is the maximum number of emails that
            #     may be sent in a given day from this account.  If unset, the server will
            #     use the configured default limit.
            #    </dd>
            # 
            #  <dt>emailOptOutDate</dt>
            #    <dd>If set, this is the date when the user asked
            #     to be excluded from offers and promotions sent by Evernote.  If not set,
            #     then the user currently agrees to receive these messages.
            #    </dd>
            # 
            #  <dt>partnerEmailOptInDate</dt>
            #    <dd>If set, this is the date when the user asked
            #     to be included in offers and promotions sent by Evernote's partners.
            #     If not sent, then the user currently does not agree to receive these
            #     emails.
            #    </dd>
            # 
            #  <dt>preferredLanguage</dt>
            #    <dd>a 2 character language codes based on:
            #        http://ftp.ics.uci.edu/pub/ietf/http/related/iso639.txt used for
            #       localization purposes to determine what language to use for the web
            #       interface and for other direct communication (e.g. emails).
            #    </dd>
            # 
            #  <dt>preferredCountry</dt>
            #    <dd>Preferred country code based on ISO 3166-1-alpha-2 indicating the
            #    users preferred country</dd>
            # 
            #  <dt>clipFullPage</dt>
            #    <dd>Boolean flag set to true if the user wants to clip full pages by
            #    default when they use the web clipper without a selection.</dd>
            # 
            #  <dt>twitterUserName</dt>
            #    <dd>The username of the account of someone who has chosen to enable
            #    Twittering into Evernote.  This value is subject to change, since users
            #    may change their Twitter user name.</dd>
            # 
            #  <dt>twitterId</dt>
            #    <dd>The unique identifier of the user's Twitter account if that user
            #    has chosen to enable Twittering into Evernote.</dd>
            # 
            #  <dt>groupName</dt>
            #    <dd>A name identifier used to identify a particular set of branding and
            #     light customization.</dd>
            #     
            #  <dt>recognitionLanguage</dt>
            #    <dd>a 2 character language codes based on:
            #        http://ftp.ics.uci.edu/pub/ietf/http/related/iso639.txt
            #        If set, this is used to determine the language that should be used
            #        when processing images and PDF files to find text.
            #        If not set, then the 'preferredLanguage' will be used.
            #    </dd>
            #  </dl>
            # 
            #  <dt>customerProfileId</dt>
            #    <dd>a numeric identified which provides a linkage between the user record
            #        and the direct credit card payment creditcard profile.
            #    </dd>
            #  </dl>
            # 
            class UserAttributes
              include ::Thrift::Struct, ::Thrift::Struct_Union
              DEFAULTLOCATIONNAME = 1
              DEFAULTLATITUDE = 2
              DEFAULTLONGITUDE = 3
              PREACTIVATION = 4
              VIEWEDPROMOTIONS = 5
              INCOMINGEMAILADDRESS = 6
              RECENTMAILEDADDRESSES = 7
              COMMENTS = 9
              DATEAGREEDTOTERMSOFSERVICE = 11
              MAXREFERRALS = 12
              REFERRALCOUNT = 13
              REFERERCODE = 14
              SENTEMAILDATE = 15
              SENTEMAILCOUNT = 16
              DAILYEMAILLIMIT = 17
              EMAILOPTOUTDATE = 18
              PARTNEREMAILOPTINDATE = 19
              PREFERREDLANGUAGE = 20
              PREFERREDCOUNTRY = 21
              CLIPFULLPAGE = 22
              TWITTERUSERNAME = 23
              TWITTERID = 24
              GROUPNAME = 25
              RECOGNITIONLANGUAGE = 26
              CUSTOMERPROFILEID = 27
              REFERRALPROOF = 28

              FIELDS = {
                DEFAULTLOCATIONNAME => {:type => ::Thrift::Types::STRING, :name => 'defaultLocationName', :optional => true},
                DEFAULTLATITUDE => {:type => ::Thrift::Types::DOUBLE, :name => 'defaultLatitude', :optional => true},
                DEFAULTLONGITUDE => {:type => ::Thrift::Types::DOUBLE, :name => 'defaultLongitude', :optional => true},
                PREACTIVATION => {:type => ::Thrift::Types::BOOL, :name => 'preactivation', :optional => true},
                VIEWEDPROMOTIONS => {:type => ::Thrift::Types::LIST, :name => 'viewedPromotions', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                INCOMINGEMAILADDRESS => {:type => ::Thrift::Types::STRING, :name => 'incomingEmailAddress', :optional => true},
                RECENTMAILEDADDRESSES => {:type => ::Thrift::Types::LIST, :name => 'recentMailedAddresses', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                COMMENTS => {:type => ::Thrift::Types::STRING, :name => 'comments', :optional => true},
                DATEAGREEDTOTERMSOFSERVICE => {:type => ::Thrift::Types::I64, :name => 'dateAgreedToTermsOfService', :optional => true},
                MAXREFERRALS => {:type => ::Thrift::Types::I32, :name => 'maxReferrals', :optional => true},
                REFERRALCOUNT => {:type => ::Thrift::Types::I32, :name => 'referralCount', :optional => true},
                REFERERCODE => {:type => ::Thrift::Types::STRING, :name => 'refererCode', :optional => true},
                SENTEMAILDATE => {:type => ::Thrift::Types::I64, :name => 'sentEmailDate', :optional => true},
                SENTEMAILCOUNT => {:type => ::Thrift::Types::I32, :name => 'sentEmailCount', :optional => true},
                DAILYEMAILLIMIT => {:type => ::Thrift::Types::I32, :name => 'dailyEmailLimit', :optional => true},
                EMAILOPTOUTDATE => {:type => ::Thrift::Types::I64, :name => 'emailOptOutDate', :optional => true},
                PARTNEREMAILOPTINDATE => {:type => ::Thrift::Types::I64, :name => 'partnerEmailOptInDate', :optional => true},
                PREFERREDLANGUAGE => {:type => ::Thrift::Types::STRING, :name => 'preferredLanguage', :optional => true},
                PREFERREDCOUNTRY => {:type => ::Thrift::Types::STRING, :name => 'preferredCountry', :optional => true},
                CLIPFULLPAGE => {:type => ::Thrift::Types::BOOL, :name => 'clipFullPage', :optional => true},
                TWITTERUSERNAME => {:type => ::Thrift::Types::STRING, :name => 'twitterUserName', :optional => true},
                TWITTERID => {:type => ::Thrift::Types::STRING, :name => 'twitterId', :optional => true},
                GROUPNAME => {:type => ::Thrift::Types::STRING, :name => 'groupName', :optional => true},
                RECOGNITIONLANGUAGE => {:type => ::Thrift::Types::STRING, :name => 'recognitionLanguage', :optional => true},
                CUSTOMERPROFILEID => {:type => ::Thrift::Types::I64, :name => 'customerProfileId', :optional => true},
                REFERRALPROOF => {:type => ::Thrift::Types::STRING, :name => 'referralProof', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            #  This represents the bookkeeping information for the user's subscription.
            #  
            # <dl>
            #  <dt>uploadLimit</dt>
            #    <dd>The number of bytes that can be uploaded to the account
            #    in the current month.  For new notes that are created, this is the length
            #    of the note content (in Unicode characters) plus the size of each resource
            #    (in bytes).  For edited notes, this is the the difference between the old
            #    length and the new length (if this is greater than 0) plus the size of
            #    each new resource.
            #    </dd>
            #  <dt>uploadLimitEnd</dt>
            #    <dd>The date and time when the current upload limit
            #    expires.  At this time, the monthly upload count reverts to 0 and a new
            #    limit is imposed.  This date and time is exclusive, so this is effectively
            #    the start of the new month.
            #    </dd>
            #  <dt>uploadLimitNextMonth</dt>
            #    <dd> When uploadLimitEnd is reached, the service
            #    will change uploadLimit to uploadLimitNextMonth. If a premium account is
            #    canceled, this mechanism will reset the quota appropriately.
            #    </dd>
            #  <dt>premiumServiceStatus</dt>
            #    <dd>Indicates the phases of a premium account
            #    during the billing process.
            #    </dd>
            #  <dt>premiumOrderNumber</dt>
            #    <dd>The order number used by the commerce system to
            #    process recurring payments
            #    </dd>
            #  <dt>premiumServiceStart</dt>
            #    <dd>The start date when this premium promotion
            #    began (this number will get overwritten if a premium service is canceled
            #    and then re-activated).
            #    </dd>
            #  <dt>premiumCommerceService</dt>
            #    <dd>The commerce system used (paypal, Google
            #    checkout, etc)
            #    </dd>
            #  <dt>premiumServiceSKU</dt>
            #    <dd>The code associated with the purchase eg. monthly
            #    or annual purchase. Clients should interpret this value and localize it.
            #    </dd>
            #  <dt>lastSuccessfulCharge</dt>
            #    <dd>Date the last time the user was charged.
            #    Null if never charged.
            #    </dd>
            #  <dt>lastFailedCharge</dt>
            #    <dd>Date the last time a charge was attempted and
            #    failed.
            #    </dd>
            #  <dt>lastFailedChargeReason</dt>
            #    <dd>Reason provided for the charge failure
            #    </dd>
            #  <dt>nextPaymentDue</dt>
            #    <dd>The end of the billing cycle. This could be in the
            #    past if there are failed charges.
            #    </dd>
            #  <dt>premiumLockUntil</dt>
            #    <dd>An internal variable to manage locking operations
            #    on the commerce variables.
            #    </dd>
            #  <dt>updated</dt>
            #    <dd>The date any modification where made to this record.
            #    </dd>
            #  <dt>premiumSubscriptionNumber</dt>
            #    <dd>The number number identifying the
            #    recurring subscription used to make the recurring charges.
            #    </dd>
            #  </dl>
            class Accounting
              include ::Thrift::Struct, ::Thrift::Struct_Union
              UPLOADLIMIT = 1
              UPLOADLIMITEND = 2
              UPLOADLIMITNEXTMONTH = 3
              PREMIUMSERVICESTATUS = 4
              PREMIUMORDERNUMBER = 5
              PREMIUMCOMMERCESERVICE = 6
              PREMIUMSERVICESTART = 7
              PREMIUMSERVICESKU = 8
              LASTSUCCESSFULCHARGE = 9
              LASTFAILEDCHARGE = 10
              LASTFAILEDCHARGEREASON = 11
              NEXTPAYMENTDUE = 12
              PREMIUMLOCKUNTIL = 13
              UPDATED = 14
              PREMIUMSUBSCRIPTIONNUMBER = 16
              LASTREQUESTEDCHARGE = 17

              FIELDS = {
                UPLOADLIMIT => {:type => ::Thrift::Types::I64, :name => 'uploadLimit', :optional => true},
                UPLOADLIMITEND => {:type => ::Thrift::Types::I64, :name => 'uploadLimitEnd', :optional => true},
                UPLOADLIMITNEXTMONTH => {:type => ::Thrift::Types::I64, :name => 'uploadLimitNextMonth', :optional => true},
                PREMIUMSERVICESTATUS => {:type => ::Thrift::Types::I32, :name => 'premiumServiceStatus', :optional => true, :enum_class => Evernote::EDAM::Type::PremiumOrderStatus},
                PREMIUMORDERNUMBER => {:type => ::Thrift::Types::STRING, :name => 'premiumOrderNumber', :optional => true},
                PREMIUMCOMMERCESERVICE => {:type => ::Thrift::Types::STRING, :name => 'premiumCommerceService', :optional => true},
                PREMIUMSERVICESTART => {:type => ::Thrift::Types::I64, :name => 'premiumServiceStart', :optional => true},
                PREMIUMSERVICESKU => {:type => ::Thrift::Types::STRING, :name => 'premiumServiceSKU', :optional => true},
                LASTSUCCESSFULCHARGE => {:type => ::Thrift::Types::I64, :name => 'lastSuccessfulCharge', :optional => true},
                LASTFAILEDCHARGE => {:type => ::Thrift::Types::I64, :name => 'lastFailedCharge', :optional => true},
                LASTFAILEDCHARGEREASON => {:type => ::Thrift::Types::STRING, :name => 'lastFailedChargeReason', :optional => true},
                NEXTPAYMENTDUE => {:type => ::Thrift::Types::I64, :name => 'nextPaymentDue', :optional => true},
                PREMIUMLOCKUNTIL => {:type => ::Thrift::Types::I64, :name => 'premiumLockUntil', :optional => true},
                UPDATED => {:type => ::Thrift::Types::I64, :name => 'updated', :optional => true},
                PREMIUMSUBSCRIPTIONNUMBER => {:type => ::Thrift::Types::STRING, :name => 'premiumSubscriptionNumber', :optional => true},
                LASTREQUESTEDCHARGE => {:type => ::Thrift::Types::I64, :name => 'lastRequestedCharge', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
                unless @premiumServiceStatus.nil? || Evernote::EDAM::Type::PremiumOrderStatus::VALID_VALUES.include?(@premiumServiceStatus)
                  raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field premiumServiceStatus!')
                end
              end

              ::Thrift::Struct.generate_accessors self
            end

            #  This represents the information about a single user account.
            # <dl>
            #  <dt>id</dt>
            #    <dd>The unique numeric identifier for the account, which will not
            #    change for the lifetime of the account.
            #    </dd>
            # 
            #  <dt>username</dt>
            #    <dd>The name that the user provides to log in to their
            #    account. In the future, this may be empty for some accounts if their login
            #    process is indirect (e.g. via social networks, etc.).
            #    May only contain a-z, 0-9, or '-', and may not start or end with the '-'
            #    <br/>
            #    Length:  EDAM_USER_USERNAME_LEN_MIN - EDAM_USER_USERNAME_LEN_MAX
            #    <br/>
            #    Regex:  EDAM_USER_USERNAME_REGEX
            #    </dd>
            # 
            #  <dt>email</dt>
            #    <dd>The email address registered for the user.  Must comply with
            #    RFC 2821 and RFC 2822.<br/>
            #    Length:  EDAM_EMAIL_LEN_MIN - EDAM_EMAIL_LEN_MAX
            #    <br/>
            #    Regex:  EDAM_EMAIL_REGEX
            #    </dd>
            # 
            #  <dt>name</dt>
            #    <dd>The printable name of the user, which may be a combination
            #    of given and family names.  This is used instead of separate "first"
            #    and "last" names due to variations in international name format/order.
            #    May not start or end with a whitespace character.  May contain any
            #    character but carriage return or newline (Unicode classes Zl and Zp).
            #    <br/>
            #    Length:  EDAM_USER_NAME_LEN_MIN - EDAM_USER_NAME_LEN_MAX
            #    <br/>
            #    Regex:  EDAM_USER_NAME_REGEX
            #    </dd>
            # 
            #  <dt>timezone</dt>
            #    <dd>The zone ID for the user's default location.  If present,
            #    this may be used to localize the display of any timestamp for which no
            #    other timezone is available - for example, an note that arrives via
            #    a micro-browser may not contain enough information to display its
            #    local time, so this default timezone may be assigned to the note.
            #    The format must be encoded as a standard zone ID such as
            #    "America/Los_Angeles" or "GMT+08:00"
            #    <br/>
            #    Length:  EDAM_TIMEZONE_LEN_MIN - EDAM_TIMEZONE_LEN_MAX
            #    <br/>
            #    Regex:  EDAM_TIMEZONE_REGEX
            #    </dd>
            # 
            #  <dt>privilege</dt>
            #    <dd>The level of access permitted for the user.
            #    </dd>
            # 
            #  <dt>created</dt>
            #    <dd>The date and time when this user account was created in the
            #    service.
            #    </dd>
            # 
            #  <dt>updated</dt>
            #    <dd>The date and time when this user account was last modified
            #    in the service.
            #    </dd>
            # 
            #  <dt>deleted</dt>
            #    <dd>If the account has been deleted from the system (e.g. as
            #    the result of a legal request by the user), the date and time of the
            #    deletion will be represented here.  If not, this value will not be set.
            #    </dd>
            # 
            #  <dt>active</dt>
            #    <dd>If the user account is available for login and
            #    synchronization, this flag will be set to true.
            #    </dd>
            # 
            #  <dt>shardId</dt>
            #    <dd>The name of the virtual server that manages the state of
            #    this user.  This value is used internally to determine which system should
            #    service requests about this user's data.
            #    </dd>
            # 
            #  <dt>attributes</dt>
            #    <dd>If present, this will contain a list of the attributes
            #    for this user account.
            #    </dd>
            # 
            #  <dt>accounting</dt>
            #    <dd>Bookkeeping information for the user's subscription.
            #    </dd>
            #  </dl>
            class User
              include ::Thrift::Struct, ::Thrift::Struct_Union
              ID = 1
              USERNAME = 2
              EMAIL = 3
              NAME = 4
              TIMEZONE = 6
              PRIVILEGE = 7
              CREATED = 9
              UPDATED = 10
              DELETED = 11
              ACTIVE = 13
              SHARDID = 14
              ATTRIBUTES = 15
              ACCOUNTING = 16

              FIELDS = {
                ID => {:type => ::Thrift::Types::I32, :name => 'id', :optional => true},
                USERNAME => {:type => ::Thrift::Types::STRING, :name => 'username', :optional => true},
                EMAIL => {:type => ::Thrift::Types::STRING, :name => 'email', :optional => true},
                NAME => {:type => ::Thrift::Types::STRING, :name => 'name', :optional => true},
                TIMEZONE => {:type => ::Thrift::Types::STRING, :name => 'timezone', :optional => true},
                PRIVILEGE => {:type => ::Thrift::Types::I32, :name => 'privilege', :optional => true, :enum_class => Evernote::EDAM::Type::PrivilegeLevel},
                CREATED => {:type => ::Thrift::Types::I64, :name => 'created', :optional => true},
                UPDATED => {:type => ::Thrift::Types::I64, :name => 'updated', :optional => true},
                DELETED => {:type => ::Thrift::Types::I64, :name => 'deleted', :optional => true},
                ACTIVE => {:type => ::Thrift::Types::BOOL, :name => 'active', :optional => true},
                SHARDID => {:type => ::Thrift::Types::STRING, :name => 'shardId', :optional => true},
                ATTRIBUTES => {:type => ::Thrift::Types::STRUCT, :name => 'attributes', :class => Evernote::EDAM::Type::UserAttributes, :optional => true},
                ACCOUNTING => {:type => ::Thrift::Types::STRUCT, :name => 'accounting', :class => Evernote::EDAM::Type::Accounting, :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
                unless @privilege.nil? || Evernote::EDAM::Type::PrivilegeLevel::VALID_VALUES.include?(@privilege)
                  raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field privilege!')
                end
              end

              ::Thrift::Struct.generate_accessors self
            end

            #  A tag within a user's account is a unique name which may be organized
            #  a simple hierarchy.
            # <dl>
            #  <dt>guid</dt>
            #    <dd>The unique identifier of this tag. Will be set by the service,
            #    so may be omitted by the client when creating the Tag.
            #    <br/>
            #    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
            #    <br/>
            #    Regex:  EDAM_GUID_REGEX
            #    </dd>
            # 
            #  <dt>name</dt>
            #    <dd>A sequence of characters representing the tag's identifier.
            #    Case is preserved, but is ignored for comparisons.
            #    This means that an account may only have one tag with a given name, via
            #    case-insensitive comparison, so an account may not have both "food" and
            #    "Food" tags.
            #    May not contain a comma (','), and may not begin or end with a space.
            #    <br/>
            #    Length:  EDAM_TAG_NAME_LEN_MIN - EDAM_TAG_NAME_LEN_MAX
            #    <br/>
            #    Regex:  EDAM_TAG_NAME_REGEX
            #    </dd>
            # 
            #  <dt>parentGuid</dt>
            #    <dd>If this is set, then this is the GUID of the tag that
            #    holds this tag within the tag organizational heirarchy.  If this is
            #    not set, then the tag has no parent and it is a "top level" tag.
            #    Cycles are not allowed (e.g. a->parent->parent == a) and will be
            #    rejected by the service.
            #    <br/>
            #    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
            #    <br/>
            #    Regex:  EDAM_GUID_REGEX
            #    </dd>
            # 
            #  <dt>updateSequenceNum</dt>
            #    <dd>A number identifying the last transaction to
            #    modify the state of this object.  The USN values are sequential within an
            #    account, and can be used to compare the order of modifications within the
            #    service.
            #    </dd>
            #  </dl>
            class Tag
              include ::Thrift::Struct, ::Thrift::Struct_Union
              GUID = 1
              NAME = 2
              PARENTGUID = 3
              UPDATESEQUENCENUM = 4

              FIELDS = {
                GUID => {:type => ::Thrift::Types::STRING, :name => 'guid', :optional => true},
                NAME => {:type => ::Thrift::Types::STRING, :name => 'name', :optional => true},
                PARENTGUID => {:type => ::Thrift::Types::STRING, :name => 'parentGuid', :optional => true},
                UPDATESEQUENCENUM => {:type => ::Thrift::Types::I32, :name => 'updateSequenceNum', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # Structure holding the optional attributes of a Resource
            # <dl>
            # <dt>sourceURL</dt>
            #   <dd>the original location where the resource was hosted
            #   <br/>
            #    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #   </dd>
            # 
            # <dt>timestamp</dt>
            #   <dd>the date and time that is associated with this resource
            #   (e.g. the time embedded in an image from a digital camera with a clock)
            #   </dd>
            # 
            # <dt>latitude</dt>
            #   <dd>the latitude where the resource was captured
            #   </dd>
            # 
            # <dt>longitude</dt>
            #   <dd>the longitude where the resource was captured
            #   </dd>
            # 
            # <dt>altitude</dt>
            #   <dd>the altitude where the resource was captured
            #   </dd>
            # 
            # <dt>cameraMake</dt>
            #   <dd>information about an image's camera, e.g. as embedded in
            #   the image's EXIF data
            #   <br/>
            #   Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #   </dd>
            # 
            # <dt>cameraModel</dt>
            #   <dd>information about an image's camera, e.g. as embedded
            #   in the image's EXIF data
            #   <br/>
            #   Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #   </dd>
            # 
            # <dt>clientWillIndex</dt>
            #   <dd>if true, then the original client that submitted
            #   the resource plans to submit the recognition index for this resource at a
            #   later time.
            #   </dd>
            # 
            # <dt>recoType</dt>
            #   <dd>DEPRECATED - this field is no longer set by the service, so should
            #     be ignored.
            #   </dd>
            # 
            # <dt>fileName</dt>
            #   <dd>if the resource came from a source that provided an
            #   explicit file name, the original name will be stored here.  Many resources
            #   come from unnamed sources, so this will not always be set.
            #   </dd>
            # 
            # <dt>attachment</dt>
            #   <dd>this will be true if the resource is a Premium file attachment.  This
            #   will be available within the search grammar so that you can identify
            #   notes that contain attachments.
            #   </dd>
            # </dl>
            class ResourceAttributes
              include ::Thrift::Struct, ::Thrift::Struct_Union
              SOURCEURL = 1
              TIMESTAMP = 2
              LATITUDE = 3
              LONGITUDE = 4
              ALTITUDE = 5
              CAMERAMAKE = 6
              CAMERAMODEL = 7
              CLIENTWILLINDEX = 8
              RECOTYPE = 9
              FILENAME = 10
              ATTACHMENT = 11

              FIELDS = {
                SOURCEURL => {:type => ::Thrift::Types::STRING, :name => 'sourceURL', :optional => true},
                TIMESTAMP => {:type => ::Thrift::Types::I64, :name => 'timestamp', :optional => true},
                LATITUDE => {:type => ::Thrift::Types::DOUBLE, :name => 'latitude', :optional => true},
                LONGITUDE => {:type => ::Thrift::Types::DOUBLE, :name => 'longitude', :optional => true},
                ALTITUDE => {:type => ::Thrift::Types::DOUBLE, :name => 'altitude', :optional => true},
                CAMERAMAKE => {:type => ::Thrift::Types::STRING, :name => 'cameraMake', :optional => true},
                CAMERAMODEL => {:type => ::Thrift::Types::STRING, :name => 'cameraModel', :optional => true},
                CLIENTWILLINDEX => {:type => ::Thrift::Types::BOOL, :name => 'clientWillIndex', :optional => true},
                RECOTYPE => {:type => ::Thrift::Types::STRING, :name => 'recoType', :optional => true},
                FILENAME => {:type => ::Thrift::Types::STRING, :name => 'fileName', :optional => true},
                ATTACHMENT => {:type => ::Thrift::Types::BOOL, :name => 'attachment', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # Every media file that is embedded or attached to a note is represented
            # through a Resource entry.
            # <dl>
            # <dt>guid</dt>
            #   <dd>The unique identifier of this resource.  Will be set whenever
            #   a resource is retrieved from the service, but may be null when a client
            #   is creating a resource.
            #   <br/>
            #   Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_GUID_REGEX
            #   </dd>
            # 
            # <dt>noteGuid</dt>
            #   <dd>The unique identifier of the Note that holds this
            #   Resource. Will be set whenever the resource is retrieved from the service,
            #   but may be null when a client is creating a resource.
            #   <br/>
            #   Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_GUID_REGEX
            #   </dd>
            # 
            # <dt>data</dt>
            #   <dd>The contents of the resource.
            #   Maximum length:  The data.body is limited to EDAM_RESOURCE_SIZE_MAX_FREE
            #   for free accounts and EDAM_RESOURCE_SIZE_MAX_PREMIUM for premium accounts.
            #   </dd>
            # 
            # <dt>mime</dt>
            #   <dd>The MIME type for the embedded resource.  E.g. "image/gif"
            #   <br/>
            #   Length:  EDAM_MIME_LEN_MIN - EDAM_MIME_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_MIME_REGEX
            #   </dd>
            # 
            # <dt>width</dt>
            #   <dd>If set, this contains the display width of this resource, in
            #   pixels.
            #   </dd>
            # 
            # <dt>height</dt>
            #   <dd>If set, this contains the display height of this resource,
            #   in pixels.
            #   </dd>
            # 
            # <dt>duration</dt>
            #   <dd>DEPRECATED: ignored.
            #   </dd>
            # 
            # <dt>active</dt>
            #   <dd>DEPRECATED: ignored.
            #   </dd>
            # 
            # <dt>recognition</dt>
            #   <dd>If set, this will hold the encoded data that provides
            #   information on search and recognition within this resource.
            #   </dd>
            # 
            # <dt>attributes</dt>
            #   <dd>A list of the attributes for this resource.
            #   </dd>
            # 
            # <dt>updateSequenceNum</dt>
            #   <dd>A number identifying the last transaction to
            #   modify the state of this object. The USN values are sequential within an
            #   account, and can be used to compare the order of modifications within the
            #   service.
            #   </dd>
            # 
            # <dt>alternateData</dt>
            #   <dd>Some Resources may be assigned an alternate data format by the service
            #   which may be more appropriate for indexing or rendering than the original
            #   data provided by the user.  In these cases, the alternate data form will
            #   be available via this Data element.  If a Resource has no alternate form,
            #   this field will be unset.</dd>
            # </dl>
            class Resource
              include ::Thrift::Struct, ::Thrift::Struct_Union
              GUID = 1
              NOTEGUID = 2
              DATA = 3
              MIME = 4
              WIDTH = 5
              HEIGHT = 6
              DURATION = 7
              ACTIVE = 8
              RECOGNITION = 9
              ATTRIBUTES = 11
              UPDATESEQUENCENUM = 12
              ALTERNATEDATA = 13

              FIELDS = {
                GUID => {:type => ::Thrift::Types::STRING, :name => 'guid', :optional => true},
                NOTEGUID => {:type => ::Thrift::Types::STRING, :name => 'noteGuid', :optional => true},
                DATA => {:type => ::Thrift::Types::STRUCT, :name => 'data', :class => Evernote::EDAM::Type::Data, :optional => true},
                MIME => {:type => ::Thrift::Types::STRING, :name => 'mime', :optional => true},
                WIDTH => {:type => ::Thrift::Types::I16, :name => 'width', :optional => true},
                HEIGHT => {:type => ::Thrift::Types::I16, :name => 'height', :optional => true},
                DURATION => {:type => ::Thrift::Types::I16, :name => 'duration', :optional => true},
                ACTIVE => {:type => ::Thrift::Types::BOOL, :name => 'active', :optional => true},
                RECOGNITION => {:type => ::Thrift::Types::STRUCT, :name => 'recognition', :class => Evernote::EDAM::Type::Data, :optional => true},
                ATTRIBUTES => {:type => ::Thrift::Types::STRUCT, :name => 'attributes', :class => Evernote::EDAM::Type::ResourceAttributes, :optional => true},
                UPDATESEQUENCENUM => {:type => ::Thrift::Types::I32, :name => 'updateSequenceNum', :optional => true},
                ALTERNATEDATA => {:type => ::Thrift::Types::STRUCT, :name => 'alternateData', :class => Evernote::EDAM::Type::Data, :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # The list of optional attributes that can be stored on a note.
            # <dl>
            # <dt>subjectDate</dt>
            #   <dd>time that the note refers to
            #   </dd>
            # 
            # <dt>latitude</dt>
            #   <dd>the latitude where the note was taken
            #   </dd>
            # 
            # <dt>longitude</dt>
            #   <dd>the longitude where the note was taken
            #   </dd>
            # 
            # <dt>altitude</dt>
            #   <dd>the altitude where the note was taken
            #   </dd>
            # 
            # <dt>author</dt>
            #   <dd>the author of the content of the note
            #   <br/>
            #   Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #   </dd>
            # 
            # <dt>source</dt>
            #   <dd>the method that the note was added to the account, if the
            #   note wasn't directly authored in an Evernote client.
            #   <br/>
            #   Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #   </dd>
            # 
            # <dt>sourceURL</dt>
            #   <dd>the original location where the resource was hosted
            #   <br/>
            #   Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #   </dd>
            # 
            # <dt>sourceApplication</dt>
            #   <dd>an identifying string for the application that
            #   created this note.  This string does not have a guaranteed syntax or
            #   structure -- it is intended for human inspection and tracking.
            #   <br/>
            #   Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
            #   </dd>
            # </dl>
            class NoteAttributes
              include ::Thrift::Struct, ::Thrift::Struct_Union
              SUBJECTDATE = 1
              LATITUDE = 10
              LONGITUDE = 11
              ALTITUDE = 12
              AUTHOR = 13
              SOURCE = 14
              SOURCEURL = 15
              SOURCEAPPLICATION = 16

              FIELDS = {
                SUBJECTDATE => {:type => ::Thrift::Types::I64, :name => 'subjectDate', :optional => true},
                LATITUDE => {:type => ::Thrift::Types::DOUBLE, :name => 'latitude', :optional => true},
                LONGITUDE => {:type => ::Thrift::Types::DOUBLE, :name => 'longitude', :optional => true},
                ALTITUDE => {:type => ::Thrift::Types::DOUBLE, :name => 'altitude', :optional => true},
                AUTHOR => {:type => ::Thrift::Types::STRING, :name => 'author', :optional => true},
                SOURCE => {:type => ::Thrift::Types::STRING, :name => 'source', :optional => true},
                SOURCEURL => {:type => ::Thrift::Types::STRING, :name => 'sourceURL', :optional => true},
                SOURCEAPPLICATION => {:type => ::Thrift::Types::STRING, :name => 'sourceApplication', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # Represents a single note in the user's account.
            # 
            # <dl>
            # <dt>guid</dt>
            #   <dd>The unique identifier of this note.  Will be set by the
            #   server, but will be omitted by clients calling NoteStore.createNote()
            #   <br/>
            #   Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_GUID_REGEX
            #   </dd>
            # 
            # <dt>title</dt>
            #   <dd>The subject of the note.  Can't begin or end with a space.
            #   <br/>
            #   Length:  EDAM_NOTE_TITLE_LEN_MIN - EDAM_NOTE_TITLE_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_NOTE_TITLE_REGEX
            #   </dd>
            # 
            # <dt>content</dt>
            #   <dd>The XHTML block that makes up the note.  This is
            #   the canonical form of the note's contents, so will include abstract
            #   Evernote tags for internal resource references.  A client may create
            #   a separate transformed version of this content for internal presentation,
            #   but the same canonical bytes should be used for transmission and
            #   comparison unless the user chooses to modify their content.
            #   <br/>
            #   Length:  EDAM_NOTE_CONTENT_LEN_MIN - EDAM_NOTE_CONTENT_LEN_MAX
            #   </dd>
            # 
            # <dt>contentHash</dt>
            #   <dd>The binary MD5 checksum of the UTF-8 encoded content
            #   body. This will always be set by the server, but clients may choose to omit
            #   this when they submit a note with content.
            #   <br/>
            #   Length:  EDAM_HASH_LEN (exactly)
            #   </dd>
            # 
            # <dt>contentLength</dt>
            #   <dd>The number of Unicode characters in the content of
            #   the note.  This will always be set by the service, but clients may choose
            #   to omit this value when they submit a Note.
            #   </dd>
            # 
            # <dt>created</dt>
            #   <dd>The date and time when the note was created in one of the
            #   clients.  In most cases, this will match the user's sense of when
            #   the note was created, and ordering between notes will be based on
            #   ordering of this field.  However, this is not a "reliable" timestamp
            #   if a client has an incorrect clock, so it cannot provide a true absolute
            #   ordering between notes.  Notes created directly through the service
            #   (e.g. via the web GUI) will have an absolutely ordered "created" value.
            #   </dd>
            # 
            # <dt>updated</dt>
            #   <dd>The date and time when the note was last modified in one of
            #   the clients.  In most cases, this will match the user's sense of when
            #   the note was modified, but this field may not be absolutely reliable
            #   due to the possibility of client clock errors.
            #   </dd>
            # 
            # <dt>deleted</dt>
            #   <dd>If present, the note is considered "deleted", and this
            #   stores the date and time when the note was deleted by one of the clients.
            #   In most cases, this will match the user's sense of when the note was
            #   deleted, but this field may be unreliable due to the possibility of
            #   client clock errors.
            #   </dd>
            # 
            # <dt>active</dt>
            #   <dd>If the note is available for normal actions and viewing,
            #   this flag will be set to true.
            #   </dd>
            # 
            # <dt>updateSequenceNum</dt>
            #   <dd>A number identifying the last transaction to
            #   modify the state of this note (including changes to the note's attributes
            #   or resources).  The USN values are sequential within an account,
            #   and can be used to compare the order of modifications within the service.
            #   </dd>
            # 
            # <dt>notebookGuid</dt>
            #   <dd>The unique identifier of the notebook that contains
            #   this note.  If no notebookGuid is provided on a call to createNote(), the
            #   default notebook will be used instead.
            #   <br/>
            #   Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_GUID_REGEX
            #   </dd>
            # 
            # <dt>tagGuids</dt>
            #   <dd>A list of the GUID identifiers for tags that are applied to this note.
            #   This may be provided in a call to createNote() to unambiguously declare
            #   the tags that should be assigned to the new note.  Alternately, clients
            #   may pass the names of desired tags via the 'tagNames' field during
            #   note creation.
            #   If the list of tags are omitted on a call to createNote(), then
            #   the server will assume that no changes have been made to the resources.
            #   Maximum:  EDAM_NOTE_TAGS_MAX tags per note
            #   </dd>
            # 
            # <dt>resources</dt>
            #   <dd>The list of resources that are embedded within this note.
            #   If the list of resources are omitted on a call to updateNote(), then
            #   the server will assume that no changes have been made to the resources.
            #   The binary contents of the resources must be provided when the resource
            #   is first sent to the service, but it will be omitted by the service when
            #   the Note is returned in the future.
            #   Maximum:  EDAM_NOTE_RESOURCES_MAX resources per note
            #   </dd>
            # 
            # <dt>attributes</dt>
            #   <dd>A list of the attributes for this note.
            #   If the list of attributes are omitted on a call to updateNote(), then
            #   the server will assume that no changes have been made to the resources.
            #   </dd>
            # 
            # <dt>tagNames</dt>
            #   <dd>May be provided by clients during calls to createNote() as an
            #   alternative to providing the tagGuids of existing tags.  If any tagNames
            #   are provided during createNote(), these will be found, or created if they
            #   don't already exist.  Created tags will have no parent (they will be at
            #   the top level of the tag panel).
            #   </dd>
            # </dl>
            class Note
              include ::Thrift::Struct, ::Thrift::Struct_Union
              GUID = 1
              TITLE = 2
              CONTENT = 3
              CONTENTHASH = 4
              CONTENTLENGTH = 5
              CREATED = 6
              UPDATED = 7
              DELETED = 8
              ACTIVE = 9
              UPDATESEQUENCENUM = 10
              NOTEBOOKGUID = 11
              TAGGUIDS = 12
              RESOURCES = 13
              ATTRIBUTES = 14
              TAGNAMES = 15

              FIELDS = {
                GUID => {:type => ::Thrift::Types::STRING, :name => 'guid', :optional => true},
                TITLE => {:type => ::Thrift::Types::STRING, :name => 'title', :optional => true},
                CONTENT => {:type => ::Thrift::Types::STRING, :name => 'content', :optional => true},
                CONTENTHASH => {:type => ::Thrift::Types::STRING, :name => 'contentHash', :binary => true, :optional => true},
                CONTENTLENGTH => {:type => ::Thrift::Types::I32, :name => 'contentLength', :optional => true},
                CREATED => {:type => ::Thrift::Types::I64, :name => 'created', :optional => true},
                UPDATED => {:type => ::Thrift::Types::I64, :name => 'updated', :optional => true},
                DELETED => {:type => ::Thrift::Types::I64, :name => 'deleted', :optional => true},
                ACTIVE => {:type => ::Thrift::Types::BOOL, :name => 'active', :optional => true},
                UPDATESEQUENCENUM => {:type => ::Thrift::Types::I32, :name => 'updateSequenceNum', :optional => true},
                NOTEBOOKGUID => {:type => ::Thrift::Types::STRING, :name => 'notebookGuid', :optional => true},
                TAGGUIDS => {:type => ::Thrift::Types::LIST, :name => 'tagGuids', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                RESOURCES => {:type => ::Thrift::Types::LIST, :name => 'resources', :element => {:type => ::Thrift::Types::STRUCT, :class => Evernote::EDAM::Type::Resource}, :optional => true},
                ATTRIBUTES => {:type => ::Thrift::Types::STRUCT, :name => 'attributes', :class => Evernote::EDAM::Type::NoteAttributes, :optional => true},
                TAGNAMES => {:type => ::Thrift::Types::LIST, :name => 'tagNames', :element => {:type => ::Thrift::Types::STRING}, :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # If a Notebook has been opened to the public, the Notebook will have a
            # reference to one of these structures, which gives the location and optional
            # description of the externally-visible public Notebook.
            # <dl>
            # <dt>uri</dt>
            #   <dd>If this field is present, then the notebook is published for
            #   mass consumption on the Internet under the provided URI, which is
            #   relative to a defined base publishing URI defined by the service.
            #   This field can only be modified via the web service GUI ... publishing
            #   cannot be modified via an offline client.
            #   <br/>
            #   Length:  EDAM_PUBLISHING_URI_LEN_MIN - EDAM_PUBLISHING_URI_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_PUBLISHING_URI_REGEX
            #   </dd>
            # 
            # <dt>order</dt>
            #   <dd>When the notes are publicly displayed, they will be sorted
            #   based on the requested criteria.
            #   </dd>
            # 
            # <dt>ascending</dt>
            #   <dd>If this is set to true, then the public notes will be
            #   displayed in ascending order (e.g. from oldest to newest).  Otherwise,
            #   the notes will be displayed in descending order (e.g. newest to oldest).
            #   </dd>
            # 
            # <dt>publicDescription</dt>
            #   <dd>This field may be used to provide a short
            #   description of the notebook, which may be displayed when (e.g.) the
            #   notebook is shown in a public view.  Can't begin or end with a space.
            #   <br/>
            #   Length:  EDAM_PUBLISHING_DESCRIPTION_LEN_MIN -
            #            EDAM_PUBLISHING_DESCRIPTION_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_PUBLISHING_DESCRIPTION_REGEX
            #   </dd>
            # </dl>
            class Publishing
              include ::Thrift::Struct, ::Thrift::Struct_Union
              URI = 1
              ORDER = 2
              ASCENDING = 3
              PUBLICDESCRIPTION = 4

              FIELDS = {
                URI => {:type => ::Thrift::Types::STRING, :name => 'uri', :optional => true},
                ORDER => {:type => ::Thrift::Types::I32, :name => 'order', :optional => true, :enum_class => Evernote::EDAM::Type::NoteSortOrder},
                ASCENDING => {:type => ::Thrift::Types::BOOL, :name => 'ascending', :optional => true},
                PUBLICDESCRIPTION => {:type => ::Thrift::Types::STRING, :name => 'publicDescription', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
                unless @order.nil? || Evernote::EDAM::Type::NoteSortOrder::VALID_VALUES.include?(@order)
                  raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field order!')
                end
              end

              ::Thrift::Struct.generate_accessors self
            end

            # A unique container for a set of notes.
            # <dl>
            # <dt>guid</dt>
            #   <dd>The unique identifier of this notebook.
            #   <br/>
            #   Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_GUID_REGEX
            #   </dd>
            # 
            # <dt>name</dt>
            #   <dd>A sequence of characters representing the name of the
            #   notebook.  May be changed by clients, but the account may not contain two
            #   notebooks with names that are equal via a case-insensitive comparison.
            #   Can't begin or end with a space.
            #   <br/>
            #   Length:  EDAM_NOTEBOOK_NAME_LEN_MIN - EDAM_NOTEBOOK_NAME_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_NOTEBOOK_NAME_REGEX
            #   </dd>
            # 
            # <dt>updateSequenceNum</dt>
            #   <dd>A number identifying the last transaction to
            #   modify the state of this object.  The USN values are sequential within an
            #   account, and can be used to compare the order of modifications within the
            #   service.
            #   </dd>
            # 
            # <dt>defaultNotebook</dt>
            #   <dd>If true, this notebook should be used for new notes
            #   whenever the user has not (or cannot) specify a desired target notebook.
            #   For example, if a note is submitted via SMTP email.
            #   The service will maintain at most one defaultNotebook per account.
            #   If a second notebook is created or updated with defaultNotebook set to
            #   true, the service will automatically update the prior notebook's
            #   defaultNotebook field to false.  If the default notebook is deleted
            #   (i.e. "active" set to false), the "defaultNotebook" field will be
            #   set to false by the service.  If the account has no default notebook
            #   set, the service will use the most recent notebook as the default.
            #   </dd>
            # 
            # <dt>serviceCreated</dt>
            #   <dd>The time when this notebook was created on the
            #   service. This will be set on the service during creation, and the service
            #   will provide this value when it returns a Notebook to a client.
            #   The service will ignore this value if it is sent by clients.
            #   </dd>
            # 
            # <dt>serviceUpdated</dt>
            #   <dd>The time when this notebook was last modified on the
            #   service.  This will be set on the service during creation, and the service
            #   will provide this value when it returns a Notebook to a client.
            #   The service will ignore this value if it is sent by clients.
            #   </dd>
            # 
            # <dt>publishing</dt>
            #   <dd>If the Notebook has been opened for public access (i.e.
            #   if 'published' is set to true), then this will point to the set of
            #   publishing information for the Notebook (URI, description, etc.).  A
            #   Notebook cannot be published without providing this information, but it
            #   will persist for later use if publishing is ever disabled on the Notebook.
            #   Clients that do not wish to change the publishing behavior of a Notebook
            #   should not set this value when calling NoteStore.updateNotebook().
            #   </dd>
            # 
            # <dt>published</dt>
            #   <dd>If this is set to true, then the Notebook will be
            #   accessible to the public via the 'publishing' specification, which must
            #   also be set.  If this is set to false, the Notebook will not be available
            #   to the public.
            #   Clients that do not wish to change the publishing behavior of a Notebook
            #   should not set this value when calling NoteStore.updateNotebook().
            #   </dd>
            # 
            # <dt>stack</dt>
            #   <dd>If this is set, then the notebook is visually contained within a stack
            #   of notebooks with this name.  All notebooks in the same account with the
            #   same 'stack' field are considered to be in the same stack.
            #   Notebooks with no stack set are "top level" and not contained within a
            #   stack.
            #   </dd>
            # </dl>
            class Notebook
              include ::Thrift::Struct, ::Thrift::Struct_Union
              GUID = 1
              NAME = 2
              UPDATESEQUENCENUM = 5
              DEFAULTNOTEBOOK = 6
              SERVICECREATED = 7
              SERVICEUPDATED = 8
              PUBLISHING = 10
              PUBLISHED = 11
              STACK = 12

              FIELDS = {
                GUID => {:type => ::Thrift::Types::STRING, :name => 'guid', :optional => true},
                NAME => {:type => ::Thrift::Types::STRING, :name => 'name', :optional => true},
                UPDATESEQUENCENUM => {:type => ::Thrift::Types::I32, :name => 'updateSequenceNum', :optional => true},
                DEFAULTNOTEBOOK => {:type => ::Thrift::Types::BOOL, :name => 'defaultNotebook', :optional => true},
                SERVICECREATED => {:type => ::Thrift::Types::I64, :name => 'serviceCreated', :optional => true},
                SERVICEUPDATED => {:type => ::Thrift::Types::I64, :name => 'serviceUpdated', :optional => true},
                PUBLISHING => {:type => ::Thrift::Types::STRUCT, :name => 'publishing', :class => Evernote::EDAM::Type::Publishing, :optional => true},
                PUBLISHED => {:type => ::Thrift::Types::BOOL, :name => 'published', :optional => true},
                STACK => {:type => ::Thrift::Types::STRING, :name => 'stack', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # A named search associated with the account that can be quickly re-used.
            # <dl>
            # <dt>guid</dt>
            #   <dd>The unique identifier of this search.  Will be set by the
            #   service, so may be omitted by the client when creating.
            #   <br/>
            #   Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_GUID_REGEX
            #   </dd>
            # 
            # <dt>name</dt>
            #   <dd>The name of the saved search to display in the GUI.  The
            #   account may only contain one search with a given name (case-insensitive
            #   compare). Can't begin or end with a space.
            #   <br/>
            #   Length:  EDAM_SAVED_SEARCH_NAME_LEN_MIN - EDAM_SAVED_SEARCH_NAME_LEN_MAX
            #   <br/>
            #   Regex:  EDAM_SAVED_SEARCH_NAME_REGEX
            #   </dd>
            # 
            # <dt>query</dt>
            #   <dd>A string expressing the search to be performed.
            #   <br/>
            #   Length:  EDAM_SAVED_SEARCH_QUERY_LEN_MIN - EDAM_SAVED_SEARCH_QUERY_LEN_MAX
            #   </dd>
            # 
            # <dt>format</dt>
            #   <dd>The format of the query string, to determine how to parse
            #   and process it.
            #   </dd>
            # 
            # <dt>updateSequenceNum</dt>
            #   <dd>A number identifying the last transaction to
            #   modify the state of this object.  The USN values are sequential within an
            #   account, and can be used to compare the order of modifications within the
            #   service.
            #   </dd>
            # </dl>
            class SavedSearch
              include ::Thrift::Struct, ::Thrift::Struct_Union
              GUID = 1
              NAME = 2
              QUERY = 3
              FORMAT = 4
              UPDATESEQUENCENUM = 5

              FIELDS = {
                GUID => {:type => ::Thrift::Types::STRING, :name => 'guid', :optional => true},
                NAME => {:type => ::Thrift::Types::STRING, :name => 'name', :optional => true},
                QUERY => {:type => ::Thrift::Types::STRING, :name => 'query', :optional => true},
                FORMAT => {:type => ::Thrift::Types::I32, :name => 'format', :optional => true, :enum_class => Evernote::EDAM::Type::QueryFormat},
                UPDATESEQUENCENUM => {:type => ::Thrift::Types::I32, :name => 'updateSequenceNum', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
                unless @format.nil? || Evernote::EDAM::Type::QueryFormat::VALID_VALUES.include?(@format)
                  raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field format!')
                end
              end

              ::Thrift::Struct.generate_accessors self
            end

            # An advertisement that may be displayed within an Evernote client.
            # Advertisements are either a snippet of HTML or else they
            # are an image (of type: JPEG, GIF, PNG) with an associated destination URL.
            # 
            # <dl>
            #   <dt>id</dt>
            #   <dd>The unique identifier of this advertisement within Evernote's ad
            #   inventory.
            #   </dd>
            # 
            #   <dt>width</dt>
            #   <dd>This ad should be displayed within a rectangle that is this wide,
            #   in pixels.
            #   </dd>
            # 
            #   <dt>height</dt>
            #   <dd>This ad should be displayed within a rectangle that is this high,
            #   in pixels.
            #   </dd>
            # 
            #   <dt>advertiserName</dt>
            #   <dd>A string containing a readable version of the name of this advertiser.
            #   </dd>
            # 
            #   <dt>imageUrl</dt>
            #   <dd>The location of the image to display for this ad.</dd>
            # 
            #   <dt>destinationUrl</dt>
            #   <dd>When a user clicks on the ad, this is the destination they should be
            #   sent to in a browser.</dd>
            # 
            #   <dt>displaySeconds</dt>
            #   <dd>The number of seconds that the ad should be displayed before it is
            #   replaced with a different ad.</dd>
            # 
            #   <dt>score</dt>
            #   <dd>A numeric indicator of the relative value of this ad, which can be
            #   compared against other ads from the same day.
            #   </dd>
            # 
            #   <dt>image</dt>
            #   <dd>If present, this is the raw image bits of the image file to display
            #   for the ad.  If not present, the imageUrl should be retrieved directly.
            #   </dd>
            # 
            #   <dt>imageMime</dt>
            #   <dd>The MIME type of the 'image' bytes, if those are set.</dd>
            # 
            #   <dt>html</dt>
            #   <dd>The exact HTML to display for this ad, to support rich or external
            #   advertisements.</dd>
            # 
            #   <dt>displayFrequency</dt>
            #   <dd>If this value is set, this is the relatively frequency that this
            #   ad should be displayed in the daily set of ads, relative to a base
            #   frequency of 1.0.  I.e. an ad with a frequency of 3.0 should be displayed
            #   three times more frequently than an ad with a frequency of 1.0.</dd>
            # </dl>
            class Ad
              include ::Thrift::Struct, ::Thrift::Struct_Union
              ID = 1
              WIDTH = 2
              HEIGHT = 3
              ADVERTISERNAME = 4
              IMAGEURL = 5
              DESTINATIONURL = 6
              DISPLAYSECONDS = 7
              SCORE = 8
              IMAGE = 9
              IMAGEMIME = 10
              HTML = 11
              DISPLAYFREQUENCY = 12

              FIELDS = {
                ID => {:type => ::Thrift::Types::I32, :name => 'id', :optional => true},
                WIDTH => {:type => ::Thrift::Types::I16, :name => 'width', :optional => true},
                HEIGHT => {:type => ::Thrift::Types::I16, :name => 'height', :optional => true},
                ADVERTISERNAME => {:type => ::Thrift::Types::STRING, :name => 'advertiserName', :optional => true},
                IMAGEURL => {:type => ::Thrift::Types::STRING, :name => 'imageUrl', :optional => true},
                DESTINATIONURL => {:type => ::Thrift::Types::STRING, :name => 'destinationUrl', :optional => true},
                DISPLAYSECONDS => {:type => ::Thrift::Types::I16, :name => 'displaySeconds', :optional => true},
                SCORE => {:type => ::Thrift::Types::DOUBLE, :name => 'score', :optional => true},
                IMAGE => {:type => ::Thrift::Types::STRING, :name => 'image', :binary => true, :optional => true},
                IMAGEMIME => {:type => ::Thrift::Types::STRING, :name => 'imageMime', :optional => true},
                HTML => {:type => ::Thrift::Types::STRING, :name => 'html', :optional => true},
                DISPLAYFREQUENCY => {:type => ::Thrift::Types::DOUBLE, :name => 'displayFrequency', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # Shared notebooks represent a relationship between a notebook and a single
            # share invitation recipient.
            # <dl>
            # <dt>id</dt>
            # <dd>the primary identifier of the share</dd>
            # 
            # <dt>userId</dt>
            # <dd>the user id of the owner of the notebook</dd>
            # 
            # <dt>notebookGuid</dt>
            # <dd>the GUID of the associated notebook shared.</dd>
            # 
            # <dt>email</dt>
            # <dd>the email address of the recipient - used by the notebook
            # owner to identify who they shared with.</dd>
            # 
            # <dt>notebookModifiable</dt>
            # <dd>a flag indicating the share is read/write -otherwise it's read only</dd>
            # 
            # <dt>requireLogin</dt>
            # <dd>indicates that a user must login to access the share</dd>
            # 
            # <dt>serviceCreated</dt>
            # <dd>the date the owner first created the share with the specific email
            #   address</dd>
            # 
            # <dt>username</dt>
            # <dd>the username of the user who can access this share.
            #   Once it's assigned it cannot be changed.</dd>
            # </dl>
            class SharedNotebook
              include ::Thrift::Struct, ::Thrift::Struct_Union
              ID = 1
              USERID = 2
              NOTEBOOKGUID = 3
              EMAIL = 4
              NOTEBOOKMODIFIABLE = 5
              REQUIRELOGIN = 6
              SERVICECREATED = 7
              SHAREKEY = 8
              USERNAME = 9

              FIELDS = {
                ID => {:type => ::Thrift::Types::I64, :name => 'id', :optional => true},
                USERID => {:type => ::Thrift::Types::I32, :name => 'userId', :optional => true},
                NOTEBOOKGUID => {:type => ::Thrift::Types::STRING, :name => 'notebookGuid', :optional => true},
                EMAIL => {:type => ::Thrift::Types::STRING, :name => 'email', :optional => true},
                NOTEBOOKMODIFIABLE => {:type => ::Thrift::Types::BOOL, :name => 'notebookModifiable', :optional => true},
                REQUIRELOGIN => {:type => ::Thrift::Types::BOOL, :name => 'requireLogin', :optional => true},
                SERVICECREATED => {:type => ::Thrift::Types::I64, :name => 'serviceCreated', :optional => true},
                SHAREKEY => {:type => ::Thrift::Types::STRING, :name => 'shareKey', :optional => true},
                USERNAME => {:type => ::Thrift::Types::STRING, :name => 'username', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # A link in an users account that refers them to a public or individual share in
            # another user's account.
            # 
            # <dl>
            # <dt>id</dt>
            # <dd>the primary identifier of a linked notebook only used for deleting.</dd>
            # 
            # <dt>shareName</dt>
            # <dd>the display name of the shared notebook.
            #   The link owner can change this.</dd>
            # 
            # <dt>username</dt>
            # <dd>the username of the user who owns the shared or public notebook</dd>
            # 
            # <dt>shardId</dt>
            # <dd>the shard ID of the notebook if the notebook is not public</dt>
            # 
            # <dt>shareKey</dt>
            # <dd>the secret key that provides access to the shared notebook</dd>
            # 
            # <dt>uri</dt>
            # <dd>the identifier of the public notebook</dd>
            class LinkedNotebook
              include ::Thrift::Struct, ::Thrift::Struct_Union
              ID = 1
              SHARENAME = 2
              USERNAME = 3
              SHARDID = 4
              SHAREKEY = 5
              URI = 6

              FIELDS = {
                ID => {:type => ::Thrift::Types::I64, :name => 'id', :optional => true},
                SHARENAME => {:type => ::Thrift::Types::STRING, :name => 'shareName', :optional => true},
                USERNAME => {:type => ::Thrift::Types::STRING, :name => 'username', :optional => true},
                SHARDID => {:type => ::Thrift::Types::STRING, :name => 'shardId', :optional => true},
                SHAREKEY => {:type => ::Thrift::Types::STRING, :name => 'shareKey', :optional => true},
                URI => {:type => ::Thrift::Types::STRING, :name => 'uri', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

          end
        end
      end
