/* $Id: Location.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/Location.hpp"

namespace ast {

std::ostream& 
Location::put(std::ostream &out) const {
	if (this->filename != NULL) {
		out << *this->filename << ":" << this->line;
	} else {
		out << "BUILTIN [" << this->information << "]";
	}
	return out;
}

std::ostream&
operator <<(std::ostream& stream, const Location& loc)
{
	return loc.put(stream);
}

}; /* namespace ast */
