/* $Id: PhysicalTypeUnit.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PHYSICAL_TYPE_UNIT_HPP_INCLUDED
#define __PHYSICAL_TYPE_UNIT_HPP_INCLUDED

#include "frontend/ast/TypeDeclaration.hpp"
#include "frontend/ast/ConstInteger.hpp"
#include "frontend/ast/PhysicalType.hpp"
#include "frontend/ast/Types.hpp"

namespace ast {

//! Unit of a physical type. (primary/secondary unit)
/** This class represents a primary or secondary unit declaration of 
 *  a PhysicalType.
 *  It's no direct type declaration, but declares a symbol.
 */
class PhysicalTypeUnit : public SymbolDeclaration {
public:
	//! c'tor
	/** @param declName name of the declaration.
          * @param unit phyiscal unit that is being referred to with factor.
          * @param loc location of the declaration.
          */
	PhysicalTypeUnit(
		std::string *declName,
		ConstInteger *unit,
		Location loc
		) : 	SymbolDeclaration(declName, loc),
			physUnit(unit), parent(NULL) {
			if (unit != NULL) {
				factor = unit->value;
			} else {
				factor = 1;
			}
	}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << *this->name;

		if (this->physUnit) {
			stream << " = " << this->physUnit;
		}
	}

	
	/** reference physical unit and factor. */
	ConstInteger *physUnit;

	/** TypeDeclaration the unit belongs to
	 *  warning: not reference counted here due to cyclic nature. */
	const PhysicalType *parent;

	/** factor of base units */
	universal_integer factor;

protected:
	/** Destructor */
	virtual ~PhysicalTypeUnit() {
		util::MiscUtil::terminate(physUnit);
	}
};

}; /* namespace ast */

#endif /* __SECONDARY_TYPE_HPP_INCLUDED */
