/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CONST_REAL_HPP_INCLUDED
#define __CONST_REAL_HPP_INCLUDED

#include "frontend/ast/Expression.hpp"
#include "frontend/visitor/Visitor.hpp"
#include "frontend/ast/Types.hpp"

namespace ast {

//! One constant real.
/** This class represents once constant VHDL real.
 */
class ConstReal : public Expression {
public:
	//! c'tor
	/** @param val value of the VHDL real.
	 *  @param loc location of the definition.
         *  @param unit physical unit.
 	 */
	ConstReal(
		universal_real val,
		Location loc
		) : 	Expression(BASE_TYPE_REAL, loc), 
			value(val) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << this->value;
	}

	/** Value of the real. */
	universal_real value;
};

}; /* namespace ast */

#endif /* __CONST_REAL_HPP_INCLUDED */
