/*
 * Decompiled with CFR 0.152.
 */
package mspccs_spreadsheet_tester.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mspccs_spreadsheet_tester.utility.Directory;

public class FilePanel
extends JPanel {
    private Directory currentDir;
    private JButton fileDirButton;
    private JLabel fileLabel;
    private JTextField fileTextField;

    public FilePanel(String string, Directory directory) {
        this.currentDir = directory;
        this.initComponents();
        this.fileLabel.setText(string + ":");
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.fileDirButton = new JButton();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createLineBorder(new Color(0, 0, 0))));
        this.setMinimumSize(new Dimension(406, 64));
        this.setPreferredSize(new Dimension(406, 64));
        this.setLayout(new GridBagLayout());
        this.fileLabel.setText("File:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 1, 6);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        this.fileTextField.setToolTipText("Absolute path and file name.");
        this.fileTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.fileTextField.setMaximumSize(new Dimension(250, 20));
        this.fileTextField.setMinimumSize(new Dimension(250, 20));
        this.fileTextField.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 6, 1, 3);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileDirButton.setText("...");
        this.fileDirButton.setToolTipText("Select a file.");
        this.fileDirButton.setBorder(BorderFactory.createBevelBorder(0));
        this.fileDirButton.setMaximumSize(new Dimension(20, 20));
        this.fileDirButton.setMinimumSize(new Dimension(20, 20));
        this.fileDirButton.setPreferredSize(new Dimension(20, 20));
        this.fileDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilePanel.this.fileDirButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(1, 3, 1, 0);
        this.add((Component)this.fileDirButton, gridBagConstraints);
    }

    private void fileDirButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.currentDir.getDirectory());
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.currentDir.setDirectory(file.getParentFile().getAbsolutePath());
            this.fileTextField.setText(file.getAbsolutePath());
            this.fileTextField.setCaretPosition(0);
        }
    }

    public String getFileName() {
        return this.fileTextField.getText();
    }

    public Directory getCurrentDir() {
        return this.currentDir;
    }
}

